/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CDFDir
extends JFrame
implements ActionListener,
MouseListener,
FocusListener,
Runnable {
    static final long serialVersionUID = 1L;
    JFrame parentDriver;
    JDialog dialog = new JDialog();
    JFileChooser fileChooser = new JFileChooser();
    JPanel panelx = new JPanel(new BorderLayout(), true);
    JPanel panel1 = new JPanel(new GridBagLayout(), true);
    JPanel panel2 = new JPanel(new BorderLayout(), true);
    JPanel panel21 = new JPanel(new GridLayout(1, 3, 50, 20), true);
    JButton entrb = new JButton(" Enter ");
    JButton helpb = new JButton(" Help ");
    JButton quitb = new JButton(" Quit ");
    JButton slt = new JButton("Select");
    JTextArea info = new JTextArea(20, 60);
    JTextField cdf = new JTextField("", 40);
    JLabel CDF = new JLabel("CDF: ");
    JScrollPane scroller;
    String[] cdfs = new String[]{"cdf", "CDF"};
    SimpleFileFilter filter = new SimpleFileFilter(this.cdfs, " CDF files (*.cdf, *.CDF)");
    String command = "cdfdir ";
    String commandX;
    String currentdir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    String helpolh = "cdfdirj.olh";
    String cdfspec = "";
    Runtime runtime = Runtime.getRuntime();
    Process process = null;
    String[] cmds = new String[3];
    JTextField focused = null;
    JTextField prevfocused = null;
    JMenuBar menuBar = new JMenuBar();
    JMenu menuFile = new JMenu("File");
    JMenu menuEdit = new JMenu("Edit");
    JMenu menuHelp = new JMenu("Help");
    JMenuItem menuEditCopy = new JMenuItem("Copy");
    JMenuItem menuEditCut = new JMenuItem("Cut");
    JMenuItem menuEditPaste = new JMenuItem("Paste");
    JMenuItem menuFileExit = new JMenuItem("Exit");
    JMenuItem menuHelpHelp = new JMenuItem("Help");
    int istart = -1;
    int iend = -1;
    Dimension hpad5 = new Dimension(5, 1);
    Dimension hpad10 = new Dimension(10, 1);
    Dimension hpad20 = new Dimension(20, 1);
    Dimension hpad25 = new Dimension(25, 1);
    Dimension hpad30 = new Dimension(30, 1);
    Dimension hpad40 = new Dimension(40, 1);
    Dimension hpad80 = new Dimension(80, 1);
    Dimension vpad5 = new Dimension(1, 5);
    Dimension vpad10 = new Dimension(1, 10);
    Dimension vpad20 = new Dimension(1, 20);
    Dimension vpad25 = new Dimension(1, 25);
    Dimension vpad30 = new Dimension(1, 30);
    Dimension vpad40 = new Dimension(1, 40);
    Dimension vpad80 = new Dimension(1, 80);
    Font defaultFont = new Font("Dialog", 0, 12);
    Font boldFont = new Font("Dialog", 1, 12);
    Font bigFont = new Font("Dialog", 0, 18);
    Font bigboldFont = new Font("Dialog", 1, 18);
    static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    static int INITIAL_WIDTH = 600;
    static int INITIAL_HEIGHT = 400;
    static boolean defaultModal = false;
    boolean modal;
    int frommain = 0;

    CDFDir() {
        this(null, null, defaultModal);
    }

    CDFDir(JFrame jFrame) {
        this(jFrame, null, defaultModal);
    }

    CDFDir(JFrame jFrame, String string) {
        this(jFrame, string, defaultModal);
    }

    CDFDir(JFrame jFrame, String string, boolean bl) {
        if (string != null) {
            this.command = "\"" + string + this.separator + "bin" + this.separator + "cdfdir\" ";
            String string2 = CDFToolsUtil.getenv("CDF_HELP");
            if (string2 != null && string2.length() > 0) {
                int n;
                String string3 = System.getProperty("os.name");
                if (string3.toLowerCase().indexOf("windows") != -1 && (n = string2.indexOf(";")) != -1) {
                    string2 = string2.substring(0, n);
                }
                this.helpolh = string2 + this.separator + "cdfdirj.olh";
            } else {
                string2 = System.getProperty("CDF_HELP");
                if (string2 != null && string2.length() > 0) {
                    this.helpolh = string2 + this.separator + "cdfdirj.olh";
                }
            }
        }
        this.dialog = new JDialog((Frame)this, bl);
        this.parentDriver = jFrame;
        this.modal = bl;
    }

    private void buildGUI() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (CDFDir.this.frommain == 0) {
                    if (CDFDir.this.modal) {
                        CDFDir.this.dialog.dispose();
                    } else {
                        CDFDir.this.dialog.setVisible(false);
                    }
                    if (CDFDir.this.parentDriver != null) {
                        CDFDir.this.parentDriver.setVisible(true);
                    }
                } else {
                    System.exit(1);
                }
            }
        };
        this.dialog.addWindowListener(windowAdapter);
        this.dialog.setTitle("Enter   Parameters/qualifiers  for  CDFdir");
        this.dialog.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        this.dialog.setLocation(CDFDir.screenSize.width / 2 - INITIAL_WIDTH / 2, CDFDir.screenSize.height / 2 - INITIAL_HEIGHT / 2);
        this.dialog.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuFileExit);
        this.menuFileExit.addActionListener(this);
        this.menuBar.add(this.menuEdit);
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.add(this.menuEditCut);
        this.menuEdit.add(this.menuEditPaste);
        this.menuEditCopy.addActionListener(this);
        this.menuEditCut.addActionListener(this);
        this.menuEditPaste.addActionListener(this);
        this.menuBar.add(this.menuHelp);
        this.menuHelp.add(this.menuHelpHelp);
        this.menuHelpHelp.addActionListener(this);
        this.makeJButton(this.panel1, Box.createRigidArea(this.vpad10), 0, 0, 1, 1, 1.0, 1.0);
        this.makeJButton(this.panel1, this.CDF, 0, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.panel1, this.cdf, 1, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.panel1, this.slt, 2, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.panel1, Box.createRigidArea(this.vpad20), 0, 3, 1, 1, 1.0, 1.0);
        this.cdf.addActionListener(this);
        this.cdf.addFocusListener(this);
        this.cdf.addMouseListener(this);
        this.cdf.setToolTipText("Enter the CDF to list");
        this.slt.addActionListener(this);
        this.slt.addFocusListener(this);
        this.slt.addMouseListener(this);
        this.slt.setToolTipText("Use the file chooser to select a CDF");
        this.CDF.setFont(this.boldFont);
        this.cdf.setFont(this.boldFont);
        this.panelx.add((Component)this.panel1, "Center");
        this.panel21.add(this.entrb);
        this.panel21.add(this.helpb);
        this.panel21.add(this.quitb);
        this.panel2.add((Component)this.panel21, "North");
        this.panel2.add(Box.createRigidArea(this.vpad30), "Center");
        this.entrb.addActionListener(this);
        this.entrb.setToolTipText("Run CDFDir");
        this.helpb.addActionListener(this);
        this.helpb.setToolTipText("Get the complete help information");
        this.quitb.addActionListener(this);
        this.quitb.setToolTipText("Exit CDFDir");
        this.info.setEditable(false);
        this.scroller = new JScrollPane(){
            static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(80, 160);
            }

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.scroller.getViewport().add(this.info);
        this.info.setVisible(true);
        this.panelx.add((Component)this.panel2, "South");
        this.dialog.getContentPane().add((Component)this.panelx, "North");
        this.dialog.getContentPane().add((Component)this.scroller, "Center");
    }

    @Override
    public void run() {
        this.buildGUI();
        this.dialog.pack();
        this.fileChooser.setCurrentDirectory(new File(this.currentdir));
        this.dialog.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    public void reEnter() {
        this.dialog.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
        this.info.setText("");
        this.cdf.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.quitb || object == this.menuFileExit) {
            if (this.frommain == 0) {
                if (this.modal) {
                    this.dialog.dispose();
                } else {
                    this.dialog.setVisible(false);
                }
                if (this.parentDriver != null) {
                    this.parentDriver.setVisible(true);
                }
            } else {
                System.exit(1);
            }
        } else if (object == this.slt) {
            this.doFileChooser("Select/enter the CDF", this.cdf, 1, this.filter);
        } else if (object == this.helpb || object == this.menuHelpHelp) {
            this.info.setText("");
            try {
                FileReader fileReader = new FileReader(this.helpolh);
                this.info.read(fileReader, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.info.setText("Help file: " + this.helpolh + " not found");
                Toolkit.getDefaultToolkit().beep();
            }
            catch (IOException iOException) {
                this.info.setText("IOException occurred while accessing help file: " + this.helpolh);
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (object == this.entrb) {
            this.info.setText("");
            this.cdfspec = this.cdf.getText();
            if (this.cdfspec.equals("")) {
                this.info.setText("Error... missing CDF file name!");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.cdfspec = this.cdfspec.trim();
                String string = this.cdfspec.startsWith("'") ? " " : (this.cdfspec.startsWith("\"") ? " " : "\"");
                String string2 = System.getProperty("os.name").toLowerCase();
                if (string2.indexOf("windows") != -1) {
                    this.cmds[0] = "cmd /c dir " + string + this.cdfspec + string;
                } else if (string2.indexOf("vms") != -1) {
                    this.cdfspec = this.cdfspec.replace('-', '/');
                    this.cmds[0] = this.commandX = "spawn dir " + string + this.cdfspec + string;
                } else {
                    this.commandX = "ls -l " + string + this.cdfspec + string;
                    this.cmds[0] = "/bin/sh";
                    this.cmds[1] = "-c";
                    this.cmds[2] = this.commandX;
                }
                this.runit(this.cmds);
            }
        } else if (object == this.cdf) {
            this.cdfspec = this.cdf.getText();
        } else if (object == this.menuEditCopy) {
            if (this.istart == -1) {
                this.info.setText("Where to copy from?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.copy();
            }
        } else if (object == this.menuEditCut) {
            if (this.istart == -1) {
                this.info.setText("What to cut?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.cut();
            }
        } else if (object == this.menuEditPaste) {
            if (this.focused == null) {
                this.info.setText("Where to paste to?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                if (this.istart != -1) {
                    this.focused.setSelectionStart(this.istart);
                    this.focused.setSelectionEnd(this.iend);
                }
                try {
                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
                    if (string == null) {
                        this.info.setText("No current selection on clipboard");
                        this.scroller.getViewport().setView(this.info);
                        this.scroller.revalidate();
                        this.scroller.repaint();
                        Toolkit.getDefaultToolkit().beep();
                    } else if (string.indexOf("\n") != -1) {
                        this.info.setText("Multiple lines selection on clipboard - not allowed:");
                        this.info.append("\n\n");
                        this.info.append(string);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.focused.paste();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            this.focused = (JTextField)object;
            if (this.prevfocused != null) {
                this.prevfocused.setText(this.prevfocused.getText());
                if (this.iend != -1) {
                    if (this.iend < this.focused.getText().length()) {
                        this.prevfocused.setCaretPosition(this.iend);
                    } else {
                        this.focused.setCaretPosition(this.focused.getText().length());
                    }
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.istart != -1) {
            this.focused.setSelectionStart(this.istart);
            this.focused.setSelectionEnd(this.iend);
            this.prevfocused = this.focused;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.focused != null) {
            String string = this.focused.getSelectedText();
            if (string != null) {
                this.istart = this.focused.getSelectionStart();
                this.iend = this.focused.getSelectionEnd();
            } else {
                this.istart = -1;
                this.iend = -1;
            }
        }
    }

    private void makeJButton(Container container, Object object, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        Component component = object instanceof String ? new JButton((String)object) : (Component)object;
        container.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void runit(String[] stringArray) {
        try {
            this.process = stringArray[1] != null ? this.runtime.exec(stringArray) : this.runtime.exec(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()), 8192);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.info.append(string + "\n");
            }
            this.process.waitFor();
            this.info.setCaretPosition(0);
            this.scroller.getViewport().setView(this.info);
            this.scroller.revalidate();
            this.scroller.repaint();
            if (this.process.exitValue() == 1) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Exception exception) {
            this.info.setText("error executing: " + exception);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void doFileChooser(String string, JTextField jTextField, int n, SimpleFileFilter simpleFileFilter) {
        File file;
        ExampleFileView exampleFileView = new ExampleFileView();
        this.fileChooser.setDialogTitle(string);
        if (simpleFileFilter != null) {
            this.fileChooser.addChoosableFileFilter(simpleFileFilter);
            this.fileChooser.setFileFilter(simpleFileFilter);
        }
        try {
            exampleFileView.putIcon("cdf", new ImageIcon(CDFDir.class.getResource("CDF_Logo3.gif")));
            exampleFileView.putIcon("CDF", new ImageIcon(CDFDir.class.getResource("CDF_Logo3.gif")));
            this.fileChooser.setFileView(exampleFileView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.fileChooser.showDialog(this.dialog, "OK");
        if (n2 == 0 && (file = this.fileChooser.getSelectedFile()) != null) {
            String string2 = file.getAbsolutePath();
            this.fileChooser.setCurrentDirectory(file);
            jTextField.setText(string2);
        }
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("CDF_BASE");
        if (string == null) {
            string = CDFToolsUtil.getenv("CDF_BASE");
        }
        CDFDir cDFDir = new CDFDir(null, string);
        cDFDir.fileChooser.setCurrentDirectory(new File(cDFDir.currentdir));
        cDFDir.frommain = 1;
        cDFDir.run();
    }
}

