#!/usr/bin/perl -w
use strict;
use Math::BigInt;

BEGIN { unshift @INC,'/home/liu/PerlCDF38_0/blib/arch',
                     '/home/liu/PerlCDF38_0/blib/lib'; }
use CDF;

print "\nTesting EPOCH.....\n";

my $year = 1970;
my $month = 1;
my $day = 1;
my $hour = 0;
my $minute = 0;
my $second = 0;
my $msec = 987;
my $str;

my $epoch = CDF::computeEPOCH ($year, $month, $day, $hour, $minute,  
                               $second, $msec);
CDF::toEncodeEPOCH($epoch, 4, $str);
print "epoch=$str\n";

my $unixTime;
my @unixTimes;
my @epochs;
# print "ref of epoch = ref($epoch)\n";
print "epoch=$epoch\n";
CDF::EPOCHtoUnixTime ($epoch, $unixTime);
print  "unixtime=$unixTime\n";
my $u1;
CDF::UnixTimetoEPOCH ($unixTime, $u1);
print  "u1=$u1\n";
CDF::toEncodeEPOCH($u1, 4, $str);
print "$str\n";

$epochs[0] = $epoch;
$epochs[1] = $epoch+1000.0;

CDF::EPOCHtoUnixTime (\@epochs, \@unixTimes);
print  "epoch=$epochs[0] $epochs[1]\n";
print  "unixtime=$unixTimes[0] $unixTimes[1]\n";

my @newepochs;
my @strs;
CDF::UnixTimetoEPOCH (\@unixTimes, \@newepochs);
CDF::toEncodeEPOCH(\@newepochs, 4, \@strs);
print "0: $strs[0]\n";
print "1: $strs[1]\n";

print "\nTesting TT2000.....\n";
my $tt2000 = CDF::computeTT2000 ($year, $month, $day, $hour, $minute,  
                                 $second, $msec, 234, 567);
CDF::toEncodeTT2000($tt2000, 4, $str);
print "tt2000=$str\n";

my @tt2000s;
# print "ref of tt2000 = ref($tt2000)\n";
print "tt2000=$tt2000\n";
CDF::TT2000toUnixTime ($tt2000, $unixTime);
print  "unixtime=$unixTime\n";
CDF::UnixTimetoTT2000 ($unixTime, $u1);
print  "$tt2000 => $unixTime => $u1\n";
CDF::toEncodeTT2000($u1, 4, $str);
print "tt2000=$str\n";

$tt2000s[0] = $tt2000;
$tt2000s[1] = $tt2000+1000000000.0;

CDF::TT2000toUnixTime (\@tt2000s, \@unixTimes);
print  "tt2000=$tt2000s[0] $tt2000s[1]\n";
print  "unixtime=$unixTimes[0] $unixTimes[1]\n";
my @newtt2000s;
CDF::UnixTimetoTT2000 (\@unixTimes, \@newtt2000s);
print  "newtt2000=$newtt2000s[0] $newtt2000s[1]\n";
CDF::toEncodeTT2000(\@newtt2000s, 4, \@strs);
print "0: $strs[0]\n";
print "1: $strs[1]\n"; 

print "\nTesting EPOCH16.....\n";
my @ep16;
my $epoch16;
$epoch16 = CDF::computeEPOCH16 ($year, $month, $day, $hour, $minute,  
                                $second, $msec, 234, 567, 000, \@ep16);
print "$ep16[0] + $ep16[1] \n";
CDF::toEncodeEPOCH16(\@ep16, 4, $str);
print "epoch16=$str\n";

CDF::EPOCH16toUnixTime (\@ep16, \$unixTime);
print  "unixtime=$unixTime\n";
my @ep16o;
CDF::UnixTimetoEPOCH16 ($unixTime, \@ep16o);
print  "encoding $ep16o[0] $ep16o[1]\n";
CDF::toEncodeEPOCH16(\@ep16o, 4, \$str);
print "$str\n";

  exit;

