/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class DoubleArray
extends AArray {
    public DoubleArray(Object object) throws Throwable {
        super(object);
    }

    public DoubleArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (double[])this.o;
            }
            case 2: {
                return (double[][])this.o;
            }
            case 3: {
                return (double[][][])this.o;
            }
            case 4: {
                return (double[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != Double.TYPE && clazz != Float.TYPE) {
            throw new Throwable("Only float and double targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        int n2 = clazz == Float.TYPE ? 4 : 8;
        ByteBuffer byteBuffer = this.allocate(n2);
        if (clazz == Float.TYPE) {
            return this.doFloat(byteBuffer);
        }
        return this.doDouble(byteBuffer);
    }

    ByteBuffer doFloat(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        float[] fArray = null;
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        switch (this.dim) {
            case 1: {
                double[] dArray = (double[])this.o;
                fArray = new float[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    fArray[i] = (float)dArray[i];
                }
                floatBuffer.put(fArray);
                return byteBuffer;
            }
            case 2: {
                double[][] dArray = (double[][])this.o;
                fArray = new float[nArray[1]];
                for (int i = 0; i < nArray[0]; ++i) {
                    double[] dArray2 = dArray[i];
                    for (int j = 0; j < nArray[1]; ++j) {
                        fArray[j] = (float)dArray2[j];
                    }
                    floatBuffer.put(fArray);
                }
                return byteBuffer;
            }
            case 3: {
                double[][][] dArray = (double[][][])this.o;
                if (this.rowMajority) {
                    fArray = new float[nArray[2]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            double[] dArray3 = dArray[i][j];
                            for (int k = 0; k < nArray[2]; ++k) {
                                fArray[k] = (float)dArray3[k];
                            }
                            floatBuffer.put(fArray);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                floatBuffer.put((float)dArray[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                double[][][][] dArray = (double[][][][])this.o;
                if (this.rowMajority) {
                    fArray = new float[nArray[3]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                double[] dArray4 = dArray[i][j][k];
                                for (int i2 = 0; i2 < nArray[3]; ++i2) {
                                    fArray[i2] = (float)dArray4[i2];
                                }
                                floatBuffer.put(fArray);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i3 = 0; i3 < nArray[1]; ++i3) {
                                    floatBuffer.put((float)dArray[i][i3][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }

    ByteBuffer doDouble(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        switch (this.dim) {
            case 1: {
                double[] dArray = (double[])this.o;
                doubleBuffer.put(dArray);
                return byteBuffer;
            }
            case 2: {
                double[][] dArray = (double[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    doubleBuffer.put(dArray[i]);
                }
                return byteBuffer;
            }
            case 3: {
                double[][][] dArray = (double[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            doubleBuffer.put(dArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                doubleBuffer.put(dArray[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                double[][][][] dArray = (double[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                doubleBuffer.put(dArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    doubleBuffer.put(dArray[i][i2][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }
}

