/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.nio.ByteBuffer;
import java.util.Vector;

public class VXR {
    ByteBuffer record = ByteBuffer.allocate(28);
    long vXRNext = 0L;
    protected int position;
    protected int numEntries;
    ByteBuffer firstbuf;
    ByteBuffer lastbuf;
    ByteBuffer locbuf;

    public void setVXRNext(long l) {
        this.vXRNext = l;
    }

    public void setLocations(Vector<int[]> vector) {
        this.numEntries = vector.size();
        this.firstbuf = ByteBuffer.allocate(4 * this.numEntries);
        this.lastbuf = ByteBuffer.allocate(4 * this.numEntries);
        this.locbuf = ByteBuffer.allocate(8 * this.numEntries);
        for (int i = 0; i < this.numEntries; ++i) {
            int[] nArray = vector.get(i);
            this.firstbuf.putInt(nArray[0]);
            this.lastbuf.putInt(nArray[1]);
            this.locbuf.putLong(nArray[2]);
        }
        this.firstbuf.position(0);
        this.lastbuf.position(0);
        this.locbuf.position(0);
    }

    public ByteBuffer get() {
        int n = this.record.capacity() + 16 * this.numEntries;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.record.position(0);
        this.record.putLong(n);
        this.record.putInt(6);
        this.record.putLong(this.vXRNext);
        this.record.putInt(this.numEntries);
        this.record.putInt(this.numEntries);
        this.record.position(0);
        return this.record;
    }

    public int getSize() {
        int n = this.record.capacity() + 16 * this.numEntries;
        return n;
    }
}

