/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.GlobalAttribute;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.nio.ByteOrder;
import java.util.Vector;

public abstract class MetaData {
    CDFImpl thisCDF;

    public final ByteOrder getByteOrder() {
        return this.thisCDF.getByteOrder();
    }

    public final boolean rowMajority() {
        return this.thisCDF.rowMajority();
    }

    public final String[] getVariableNames() {
        return this.thisCDF.getVariableNames();
    }

    public final String[] getVariableNames(String string) {
        return this.thisCDF.getVariableNames(string);
    }

    public final String[] globalAttributeNames() {
        return this.thisCDF.globalAttributeNames();
    }

    public final String[] variableAttributeNames(String string) {
        return this.thisCDF.variableAttributeNames(string);
    }

    public final Object getAttribute(String string) {
        return this.thisCDF.getAttribute(string);
    }

    public final int globalAttributeEntryCount(String string) throws CDFException.ReaderError {
        return this.getGlobalAttribute(string).getEntryCount();
    }

    public final Object getAttribute(String string, String string2) throws CDFException.ReaderError {
        return this.thisCDF.getAttribute(string, string2);
    }

    public final Vector<AttributeEntry> getAttributeEntries(String string, String string2) throws CDFException.ReaderError {
        return this.thisCDF.getAttributeEntries(string, string2);
    }

    public final Vector<AttributeEntry> getAttributeEntries(String string) throws CDFException.ReaderError {
        try {
            return this.thisCDF.getAttributeEntries(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final GlobalAttribute getGlobalAttribute(String string) throws CDFException.ReaderError {
        try {
            return this.thisCDF.getGlobalAttribute(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final boolean recordVariance(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).recordVariance();
    }

    public final boolean isCompressed(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).isCompressed();
    }

    public final int getType(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getType();
    }

    public final int getDataItemSize(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getDataItemSize();
    }

    public final int getNumber(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getNumber();
    }

    public final int getNumberOfElements(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getNumberOfElements();
    }

    public final int getNumberOfValues(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getNumberOfValues();
    }

    public final Object getPadValue(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getPadValue();
    }

    public final Object getPadValue(String string, boolean bl) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        Variable variable = this.thisCDF.getVariable(string);
        return variable.getPadValue(bl);
    }

    public final int[] getDimensions(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getDimensions();
    }

    public final boolean[] getVarys(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getVarys();
    }

    public final int getEffectiveRank(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getEffectiveRank();
    }

    public final boolean isMissingRecords(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).isMissingRecords();
    }

    public final int[] getRecordRange(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getRecordRange();
    }

    public final boolean isCompatible(String string, Class clazz) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        try {
            return this.thisCDF.getVariable(string).isCompatible(clazz);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public final boolean isCompatible(String string, Class clazz, boolean bl) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        Variable variable = this.thisCDF.getVariable(string);
        return variable.isCompatible(clazz, bl);
    }

    public final boolean missingRecordValueIsPrevious(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        Variable variable = this.thisCDF.getVariable(string);
        return variable.missingRecordValueIsPrevious();
    }

    public final boolean missingRecordValueIsPad(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        Variable variable = this.thisCDF.getVariable(string);
        return variable.missingRecordValueIsPad();
    }

    public final Vector<Integer> getElementCount(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getElementCount();
    }

    public final int[] getEffectiveDimensions(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        Variable variable = this.thisCDF.getVariable(string);
        return variable.getEffectiveDimensions();
    }

    public final boolean isTimeType(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        Variable variable = this.thisCDF.getVariable(string);
        int n = variable.getType();
        boolean bl = CDFTimeType.EPOCH.getValue() == n;
        bl |= CDFTimeType.EPOCH16.getValue() == n;
        return bl |= CDFTimeType.TT2000.getValue() == n;
    }

    public final boolean existsVariable(String string) {
        if (string == null) {
            return false;
        }
        return this.thisCDF.getVariable(string) != null;
    }

    public abstract String userTimeVariableName(String var1) throws CDFException.ReaderError;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getTimeVariableName(String string) throws Throwable {
        if (!this.existsVariable(string)) {
            throw new Throwable("CDF does not hava a variable named " + string);
        }
        String string2 = this.userTimeVariableName(string);
        if (string2 != null) {
            return string2;
        }
        Variable variable = this.thisCDF.getVariable(string);
        String string3 = variable.getName();
        Vector vector = (Vector)this.thisCDF.getAttribute(string3, "DEPEND_0");
        if (vector.size() > 0) {
            string2 = (String)vector.elementAt(0);
        }
        if (string2 != null) return string2;
        if (string3.equals("Epoch")) throw new Throwable("Variable named Epoch has no DEPEND_0 attribute.");
        if (this.thisCDF.getVariable("Epoch") == null) throw new Throwable("Time variable not found for " + string3);
        string2 = "Epoch";
        System.out.println("Variable " + string3 + " has no DEPEND_0" + " attribute. Variable named Epoch " + "assumed to be the right time variable");
        return string2;
    }

    public final int getLastLeapSecondId() {
        return this.thisCDF.lastLeapSecondId;
    }

    public final int getBlockingFactor(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).getBlockingFactor();
    }

    public final boolean isTypeR(String string) throws CDFException.ReaderError {
        if (!this.existsVariable(string)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + string);
        }
        return this.thisCDF.getVariable(string).isTypeR();
    }
}

