/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public class Epoch
implements CDFConstants {
    private static double MAX_EPOCH_BINARY = 3.15569519999998E14;
    private static int MAX_ePART_LEN = 25;
    private static String[] _monthToken = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static double[] toParse(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Epoch.toParse(stringArray[i]);
        }
        return dArray;
    }

    public static double toParse(String string) throws CDFException {
        if (string == null) {
            return -1.0;
        }
        int n = (string = string.trim()).length();
        if ((long)n == 24L) {
            if (string.charAt(11) == ' ') {
                return Epoch.parse(string);
            }
            char c = string.charAt(10);
            if (c == 'T' || c == 't' || c == ' ' || c == '/') {
                return Epoch.parse3(string);
            }
            return -1.0;
        }
        if ((long)n == 23L) {
            char c = string.charAt(10);
            if (c == 'T' || c == 't' || c == ' ' || c == '/') {
                return Epoch.parse4(string);
            }
            return -1.0;
        }
        if ((long)n <= 16L && string.charAt(8) == '.' && string.matches("\\d+.\\d+")) {
            return Epoch.parse1(string);
        }
        if ((long)n == 14L && string.matches("\\d+")) {
            return Epoch.parse2(string);
        }
        if (string.charAt(11) == ' ') {
            return Epoch.parse(string);
        }
        if (string.charAt(10) == 'T' || string.charAt(10) == 't' || string.charAt(10) == ' ' || string.charAt(10) == '/') {
            if (string.endsWith("Z") || string.endsWith("z")) {
                return Epoch.parse3(string);
            }
            return Epoch.parse4(string);
        }
        return -1.0;
    }

    public static double parse(String string) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        if ((string = string.trim()).endsWith("Z") || string.endsWith("z")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string2, "-");
            l3 = Long.parseLong(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken();
            l = Long.parseLong(stringTokenizer.nextToken());
            for (int i = 1; i <= 12; ++i) {
                if (!string4.equalsIgnoreCase(_monthToken[i - 1])) continue;
                l2 = i;
                break;
            }
            if (l2 == 0L) {
                throw new CDFException(-2224L);
            }
            stringTokenizer = new StringTokenizer(string3, ":");
            l4 = Long.parseLong(stringTokenizer.nextToken());
            l5 = Long.parseLong(stringTokenizer.nextToken());
            String string5 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string5, ".");
            l6 = Long.parseLong(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                l7 = Long.parseLong(stringTokenizer.nextToken());
            }
            return Epoch.compute(l, l2, l3, l4, l5, l6, l7);
        }
        catch (Exception exception) {
            throw new CDFException(-2224L);
        }
    }

    public static double[] parse(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.parse(stringArray[i]);
        }
        return dArray;
    }

    public static double parse1(String string) throws CDFException {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            double d = 0.0;
            l = Long.parseLong(string2.substring(0, 4));
            l2 = Long.parseLong(string2.substring(4, 6));
            l3 = Long.parseLong(string2.substring(6));
            if (string3.length() < 7) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                for (int i = 0; i < 7 - string3.length(); ++i) {
                    stringBuffer = stringBuffer.append('0');
                }
                string3 = stringBuffer.toString();
            }
            l8 = Long.parseLong(string3);
            d = (double)l8 / 1.0E7;
            l4 = (long)(d * 24.0);
            l5 = (long)((d -= (double)l4 / 24.0) * 1440.0);
            l6 = (long)((d -= (double)l5 / 1440.0) * 86400.0);
            l7 = (long)((d -= (double)l6 / 86400.0) * 8.64E7);
            return Epoch.compute(l, l2, l3, l4, l5, l6, l7);
        }
        catch (Exception exception) {
            throw new CDFException(-2224L);
        }
    }

    public static double[] parse1(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.parse1(stringArray[i]);
        }
        return dArray;
    }

    public static double parse2(String string) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        string = string.trim();
        try {
            l = Long.parseLong(string.substring(0, 4));
            l2 = Long.parseLong(string.substring(4, 6));
            l3 = Long.parseLong(string.substring(6, 8));
            l4 = Long.parseLong(string.substring(8, 10));
            l5 = Long.parseLong(string.substring(10, 12));
            l6 = Long.parseLong(string.substring(12));
            return Epoch.compute(l, l2, l3, l4, l5, l6, 0L);
        }
        catch (Exception exception) {
            throw new CDFException(-2224L);
        }
    }

    public static double[] parse2(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.parse2(stringArray[i]);
        }
        return dArray;
    }

    public static double parse3(String string) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        string = string.trim();
        try {
            String string2 = new String(new char[]{string.charAt(10)});
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = string4.substring(0, string4.length() - 1);
            stringTokenizer = new StringTokenizer(string3, "-");
            l = Long.parseLong(stringTokenizer.nextToken());
            l2 = Long.parseLong(stringTokenizer.nextToken());
            l3 = Long.parseLong(stringTokenizer.nextToken());
            stringTokenizer = new StringTokenizer(string5, ":");
            l4 = Long.parseLong(stringTokenizer.nextToken());
            l5 = Long.parseLong(stringTokenizer.nextToken());
            String string6 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string6, ".");
            l6 = Long.parseLong(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                l7 = Long.parseLong(stringTokenizer.nextToken());
            }
            return Epoch.compute(l, l2, l3, l4, l5, l6, l7);
        }
        catch (Exception exception) {
            throw new CDFException(-2224L);
        }
    }

    public static double[] parse3(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.parse3(stringArray[i]);
        }
        return dArray;
    }

    public static double parse4(String string) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        string = string.trim();
        try {
            String string2 = new String(new char[]{string.charAt(10)});
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string3, "-");
            l = Long.parseLong(stringTokenizer.nextToken());
            l2 = Long.parseLong(stringTokenizer.nextToken());
            l3 = Long.parseLong(stringTokenizer.nextToken());
            stringTokenizer = new StringTokenizer(string4, ":");
            l4 = Long.parseLong(stringTokenizer.nextToken());
            l5 = Long.parseLong(stringTokenizer.nextToken());
            String string5 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string5, ".");
            l6 = Long.parseLong(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                l7 = Long.parseLong(stringTokenizer.nextToken());
            }
            return Epoch.compute(l, l2, l3, l4, l5, l6, l7);
        }
        catch (Exception exception) {
            throw new CDFException(-2224L);
        }
    }

    public static double[] parse4(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.parse4(stringArray[i]);
        }
        return dArray;
    }

    public static String toEncode(double d, int n) {
        if (n < 0 || n > 4) {
            n = 4;
        }
        if (n == 0) {
            return Epoch.encode(d);
        }
        if (n == 1) {
            return Epoch.encode1(d);
        }
        if (n == 2) {
            return Epoch.encode2(d);
        }
        if (n == 3) {
            return Epoch.encode3(d);
        }
        return Epoch.encode4(d);
    }

    public static String[] toEncode(double[] dArray, int n) {
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = Epoch.toEncode(dArray[i], n);
        }
        return stringArray;
    }

    public static String toEncode(double d) {
        return Epoch.toEncode(d, 4);
    }

    public static String[] toEncode(double[] dArray) {
        return Epoch.toEncode(dArray, 4);
    }

    public static double EpochtoUnixTime(double d) {
        try {
            return (d - 6.21672192E13) / 1000.0;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static double[] EpochtoUnixTime(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = (dArray[i] - 6.21672192E13) / 1000.0;
        }
        return dArray2;
    }

    public static double UnixTimetoEpoch(double d) {
        try {
            long l = (long)d;
            double d2 = (d - (double)l) * 1000.0;
            long l2 = (long)d2;
            if (d2 - (double)l2 > 0.5) {
                ++l2;
            }
            return (double)l * 1000.0 + (double)l2 + 6.21672192E13;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static double[] UnixTimetoEpoch(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Epoch.UnixTimetoEpoch(dArray[i]);
        }
        return dArray2;
    }

    public static String encode(double d) {
        if (d == -1.0E31 || d == -1.0) {
            return "31-Dec-9999 23:59:59.999";
        }
        return Epoch.encodex(d, "<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>");
    }

    public static String[] encode(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Epoch.encode(dArray[i]);
        }
        return stringArray;
    }

    public static String encode1(double d) {
        if (d == -1.0E31 || d == -1.0) {
            return "99991231.9999999";
        }
        return Epoch.encodex(d, "<year><mm.02><dom.02>.<fod.7>");
    }

    public static String[] encode1(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Epoch.encode1(dArray[i]);
        }
        return stringArray;
    }

    public static String encode2(double d) {
        if (d == -1.0E31 || d == -1.0) {
            return "99991231235959";
        }
        return Epoch.encodex(d, "<year><mm.02><dom.02><hour><min><sec>");
    }

    public static String[] encode2(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Epoch.encode2(dArray[i]);
        }
        return stringArray;
    }

    public static String encode3(double d) {
        if (d == -1.0E31 || d == -1.0) {
            return "9999-12-31T23:59:59.999Z";
        }
        return Epoch.encodex(d, "<year>-<mm.02>-<dom.02>T<hour>:<min>:<sec>.<fos>Z");
    }

    public static String[] encode3(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Epoch.encode3(dArray[i]);
        }
        return stringArray;
    }

    public static String encode4(double d) {
        if (d == -1.0E31 || d == -1.0) {
            return "9999-12-31T23:59:59.999";
        }
        return Epoch.encodex(d, "<year>-<mm.02>-<dom.02>T<hour>:<min>:<sec>.<fos>");
    }

    public static String[] encode4(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Epoch.encode4(dArray[i]);
        }
        return stringArray;
    }

    public static String encodex(double d, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = 0;
        long[] lArray = new long[7];
        if (string == null || string.equals("")) {
            return Epoch.encode(d);
        }
        char[] cArray = string.toCharArray();
        lArray = Epoch.breakdown(d);
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == '<') {
                int n2;
                if (cArray[n + 1] == '<') {
                    stringBuffer.append("<");
                    System.out.println("append a literal \"<\"");
                    continue;
                }
                int n3 = string.indexOf(62, n + 1);
                if (n3 == -1) {
                    stringBuffer.append("?");
                    System.out.println("appending ? (1)");
                    return stringBuffer.toString();
                }
                stringBuffer2.setLength(0);
                for (n2 = n + 1; n2 != n3; ++n2) {
                    stringBuffer2.append(cArray[n2]);
                }
                int n4 = string.indexOf(".", n + 1);
                stringBuffer3 = new StringBuffer();
                if (n4 != -1 && n4 < n3) {
                    for (n2 = n4 + 1; n2 != n3; ++n2) {
                        stringBuffer3.append(cArray[n2]);
                    }
                }
                n = n3;
                String string2 = stringBuffer2.toString();
                if (string2.indexOf("dom") == 0) {
                    Epoch.appendIntegerPart(stringBuffer, lArray[2], 0, false, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("doy") == 0) {
                    long l = Epoch.JulianDay(lArray[0], lArray[1], lArray[2]) - Epoch.JulianDay(lArray[0], 1L, 1L) + 1L;
                    Epoch.appendIntegerPart(stringBuffer, l, 3, true, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("month") == 0) {
                    stringBuffer.append(_monthToken[(int)lArray[1] - 1]);
                    continue;
                }
                if (string2.indexOf("mm") == 0) {
                    Epoch.appendIntegerPart(stringBuffer, lArray[1], 0, false, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("year") == 0) {
                    Epoch.appendIntegerPart(stringBuffer, lArray[0], 4, true, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("yr") == 0) {
                    long l = lArray[0] % 100L;
                    Epoch.appendIntegerPart(stringBuffer, l, 2, true, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("hour") == 0) {
                    Epoch.appendIntegerPart(stringBuffer, lArray[3], 2, true, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("min") == 0) {
                    Epoch.appendIntegerPart(stringBuffer, lArray[4], 2, true, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("sec") == 0) {
                    Epoch.appendIntegerPart(stringBuffer, lArray[5], 2, true, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("fos") == 0) {
                    double d2 = (double)lArray[6] / 1000.0;
                    Epoch.appendFractionPart(stringBuffer, d2, 3, stringBuffer3.toString());
                    continue;
                }
                if (string2.indexOf("fod") == 0) {
                    double d3 = (double)lArray[3] / 24.0 + (double)lArray[4] / 1440.0 + (double)lArray[5] / 86400.0 + (double)lArray[6] / 8.64E7;
                    Epoch.appendFractionPart(stringBuffer, d3, 8, stringBuffer3.toString());
                    continue;
                }
                stringBuffer.append("?");
                System.out.println("append ? (2)");
                continue;
            }
            if (n >= cArray.length) break;
            stringBuffer.append(cArray[n]);
        }
        return stringBuffer.toString();
    }

    private static void appendFractionPart(StringBuffer stringBuffer, double d, int n, String string) {
        int n2;
        int n3;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3;
        block8: {
            stringBuffer3 = new StringBuffer(MAX_ePART_LEN + 1);
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            stringBuffer2 = new StringBuffer();
            numberFormat.setParseIntegerOnly(true);
            if (!string.equals("")) {
                try {
                    n3 = numberFormat.parse(string).intValue();
                    if (n3 < 1) {
                        stringBuffer.append("?");
                        System.out.println("append ? (3)");
                        return;
                    }
                    break block8;
                }
                catch (ParseException parseException) {
                    stringBuffer.append("?");
                    System.out.println("append ? (4)");
                    return;
                }
            }
            n3 = n;
        }
        for (n2 = 0; n2 < n3 + 2; ++n2) {
            stringBuffer2.append("0");
        }
        stringBuffer2.append(".");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append("0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuffer2.toString());
        stringBuffer3.append(decimalFormat.format(d));
        if (stringBuffer3.charAt(0) == '1') {
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer3.setCharAt(n2 + 2, '9');
            }
        }
        String string2 = stringBuffer3.toString();
        char c = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        Epoch.appendPart(stringBuffer, string2.substring(string2.indexOf(c) + 1), n3, false);
    }

    private static void appendIntegerPart(StringBuffer stringBuffer, long l, int n, boolean bl, String string) {
        boolean bl2;
        int n2;
        StringBuffer stringBuffer2 = new StringBuffer(MAX_ePART_LEN + 1);
        char[] cArray = string.toCharArray();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setParseIntegerOnly(true);
        if (!string.equals("")) {
            try {
                n2 = numberFormat.parse(string).intValue();
                if (n2 < 0) {
                    stringBuffer.append("?");
                    System.out.println("append ? (5)");
                    return;
                }
                bl2 = cArray[0] == '0';
            }
            catch (ParseException parseException) {
                stringBuffer.append("?");
                System.out.println("append ? (6)");
                return;
            }
        } else {
            n2 = n;
            bl2 = bl;
        }
        stringBuffer2.append("" + l);
        Epoch.appendPart(stringBuffer, stringBuffer2.toString(), n2, bl2);
    }

    private static void appendPart(StringBuffer stringBuffer, String string, int n, boolean bl) {
        if (n == 0) {
            stringBuffer.append(string);
        } else {
            int n2 = string.length();
            if (n2 > n) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("*");
                }
            } else {
                int n3 = n - n2;
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer.append(bl ? "0" : " ");
                    }
                }
                stringBuffer.append(string);
            }
        }
    }

    public static double compute(long l, long l2, long l3, long l4, long l5, long l6, long l7) throws CDFException {
        if (l == 9999L && l2 == 12L && l3 == 31L && l4 == 23L && l5 == 59L && l6 == 59L && l7 == 999L) {
            return -1.0E31;
        }
        if (l < 0L) {
            throw new CDFException(-2224L);
        }
        if (l > 9999L || l2 < 0L || l2 > 12L || l4 < 0L || l4 > 23L || l5 < 0L || l5 > 59L || l6 < 0L || l6 > 59L || l7 < 0L || l7 > 999L) {
            return Epoch.computeEpoch(l, l2, l3, l4, l5, l6, l7);
        }
        if (l2 == 0L ? l3 < 1L || l3 > 366L : l3 < 1L || l3 > 31L) {
            return Epoch.computeEpoch(l, l2, l3, l4, l5, l6, l7);
        }
        if (l4 == 0L && l5 == 0L && l6 == 0L && (l7 < 0L || l7 > 86399999L)) {
            return Epoch.computeEpoch(l, l2, l3, l4, l5, l6, l7);
        }
        long l8 = l2 == 0L ? Epoch.JulianDay(l, 1L, 1L) + (l3 - 1L) - 1721060L : Epoch.JulianDay(l, l2, l3) - 1721060L;
        long l9 = l4 == 0L && l5 == 0L && l6 == 0L ? l7 : 3600000L * l4 + 60000L * l5 + 1000L * l6 + l7;
        return 8.64E7 * (double)l8 + (double)l9;
    }

    public static double[] compute(long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        if (n != lArray2.length || n != lArray3.length) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.compute(lArray[i], lArray2[i], lArray3[i], 0L, 0L, 0L, 0L);
        }
        return dArray;
    }

    public static double[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], 0L, 0L, 0L);
        }
        return dArray;
    }

    public static double[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], 0L, 0L);
        }
        return dArray;
    }

    public static double[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null || lArray6 == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length || n != lArray6.length) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], lArray6[i], 0L);
        }
        return dArray;
    }

    public static double[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6, long[] lArray7) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null || lArray6 == null || lArray7 == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length || n != lArray6.length || n != lArray7.length) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Epoch.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], lArray6[i], lArray7[i]);
        }
        return dArray;
    }

    public static long[] breakdown(double d) {
        long[] lArray = new long[7];
        if (d == -1.0E31) {
            lArray[0] = 9999L;
            lArray[1] = 12L;
            lArray[2] = 31L;
            lArray[3] = 23L;
            lArray[4] = 59L;
            lArray[5] = 59L;
            lArray[6] = 999L;
            return lArray;
        }
        if (d < 0.0) {
            d = -d;
        }
        d = MAX_EPOCH_BINARY < d ? MAX_EPOCH_BINARY : d;
        long l = (long)d;
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        long l6 = 1721060L + l5;
        long l7 = l6 + 68569L;
        long l8 = 4L * l7 / 146097L;
        long l9 = 4000L * ((l7 -= (146097L * l8 + 3L) / 4L) + 1L) / 1461001L;
        l7 = l7 - 1461L * l9 / 4L + 31L;
        long l10 = 80L * l7 / 2447L;
        long l11 = l7 - 2447L * l10 / 80L;
        l7 = l10 / 11L;
        l10 = l10 + 2L - 12L * l7;
        lArray[0] = l9 = 100L * (l8 - 49L) + l9 + l7;
        lArray[1] = l10;
        lArray[2] = l11;
        lArray[3] = (long)((double)l4 % 24.0);
        lArray[4] = (long)((double)l3 % 60.0);
        lArray[5] = (long)((double)l2 % 60.0);
        lArray[6] = (long)((double)l % 1000.0);
        return lArray;
    }

    public static long[][] breakdown(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        if (n <= 0) {
            return null;
        }
        long[][] lArray = new long[n][7];
        for (int i = 0; i < n; ++i) {
            lArray[i] = Epoch.breakdown(dArray[i]);
        }
        return lArray;
    }

    private static long JulianDay(long l, long l2, long l3) {
        return 367L * l - 7L * (l + (l2 + 9L) / 12L) / 4L - 3L * ((l + (l2 - 9L) / 7L) / 100L + 1L) / 4L + 275L * l2 / 9L + l3 + 1721029L;
    }

    private static double computeEpoch(long l, long l2, long l3, long l4, long l5, long l6, long l7) throws CDFException {
        long l8;
        if (l2 == 0L) {
            l8 = Epoch.JulianDay(l, 1L, 1L) + (l3 - 1L) - 1721060L;
        } else {
            if (l2 < 0L) {
                --l;
                l2 = 13L + l2;
            }
            l8 = Epoch.JulianDay(l, l2, l3) - 1721060L;
        }
        if (l8 < 1L) {
            throw new CDFException(-2224L);
        }
        double d = 3600000.0 * (double)l4 + 60000.0 * (double)l5 + 1000.0 * (double)l6 + (double)l7;
        double d2 = 8.64E7 * (double)l8 + d;
        if (d2 < 0.0) {
            return -1.0;
        }
        return d2;
    }
}

