import java.io.*;
import java.util.*;

/** CDFToolsUtil contains the utilities used by the CDF tools programs.
 */

public class CDFToolsUtil {

    /********************************************************************
     * Returns the value of the given system environment variable. <P>
     *
     * NOTE: The System.getenv() method was deprecated in JDK 1.3 and
     *       undeprecated in JDK 1.5.  This routine was developed to 
     *       work with virtuall all Java versions. <P>
     *
     * @param envVar the name of the environment variable to be resolved. <P>
     * @return Value of the specified environment variable.  Null is
     *         returned if the environment variable is not defined. <P>
     *********************************************************************/
    public static String getenv (String envVar) {
       String value = null;
       try {
          String line = null;
          Process process = null;
          BufferedReader inStream = null;
          String OS = System.getProperty("os.name").toLowerCase();

          if (OS.indexOf("windows") != -1) {
              String command = "cmd /c echo %" + envVar + "%";
              process = Runtime.getRuntime().exec(command);
              inStream = new BufferedReader
                              ( new InputStreamReader(process.getInputStream()) );
              process.waitFor();
              value = inStream.readLine();
          }
          else if (OS.indexOf("vms") == -1) {     /* not VMS = Unix */
              process = Runtime.getRuntime().exec("env");

              inStream = new BufferedReader(new
                                 InputStreamReader(process.getInputStream()));
              process.waitFor();
              while ((line = inStream.readLine()) != null) {
                 StringTokenizer st = new StringTokenizer(line, "=");
                 if (st.nextToken().equals(envVar)) {
                     value = st.nextToken(); 
                     break;
                 }
              }
          }
       } catch (InterruptedException ee) {
           value = null;
       } catch (IOException ex) {
           value = null;
       }

       return value;
    }


    /********************************************************************
     * Loads the 'cmds' array with appropriate shell command.
     *
     * @param cmds the array to be loaded. <P>
     * @return <I>cmds</I> loaded with appropriate operating system dependent
     *              commands. <P>
     *********************************************************************/
    public static void LoadCmds (String cmds[]) {
       String OS = System.getProperty("os.name");
       if (OS.toLowerCase().indexOf("windows") != -1) {
            cmds[0] = "cmd";
            cmds[1] = "/c";
        }
        else {
            cmds[0] = "/bin/sh";
            cmds[1] = "-c";
        }
    }
}

