import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.datatransfer.*;

/** Perform the file dump for a CDF file.
 */

public class CDFIRsDump extends JFrame 
		        implements ActionListener, ItemListener, 
			         MouseListener, FocusListener, Runnable {

    static final long serialVersionUID = 1L;

    JFrame parentFrame;
/** The dialog for user interface. */
    JDialog dialog;

/** The FileChooser for the file selection. */
    JFileChooser fileChooser = new JFileChooser();

/** The panel for text fields and selectable buttons which goes to dialog's 
    north portion. */
    JPanel panel1 = new JPanel(new GridBagLayout(), true);
/** The panel containing all checkboxes goes to dialog's center portion. */
    JPanel panel2 = new JPanel(new GridBagLayout(), true);
/** The panel containing panel31 and text area goes to dialog's south portion. */
    JPanel panel3 = new JPanel(new BorderLayout(), true);
/** The panel containing enter/help/quit buttons. */
    JPanel panel31 = new JPanel(new GridLayout(1, 3, 50, 20), true);
/** The temporary panel containing the dump radio box. */
    JPanel tpanel1 = new JPanel(new BorderLayout(), true);

/** "Page Output" check box. */
    JCheckBox pgc = new JCheckBox("Page Output", false);
/** "Show Summary" check box. */
    JCheckBox ssc = new JCheckBox("Show Summary");
/** "About" check box. */
    JCheckBox abc = new JCheckBox("About");
    int abcX = 0;
/** "Run it Batch" check box. */
    JCheckBox bac = new JCheckBox("Run it Batch");
/** A group radio buttons for Dump. */
    ButtonGroup dump = new ButtonGroup();
/** A group radio buttons for Dump. */
    JRadioButton dump1 = new JRadioButton("Brief");
    JRadioButton dump2 = new JRadioButton("Full");
/** A radio button panel for Dump. */
    JPanel dumpPanel = new JPanel(true);

/** "Enter" button. */
    JButton entrb = new JButton(" Enter ");
/** "Help" button. */
    JButton helpb = new JButton(" Help ");
/** "Quit" button. */
    JButton quitb = new JButton(" Quit ");
/** "Select1" button. */
    JButton slt1 = new JButton("Select");
/** "Select2" button. */
    JButton slt2 = new JButton("Select");

/** Text area for information. */
    JTextArea info = new JTextArea(20,60);

/** Text field for entering the mandatory CDF file name. */
    JTextField cdf = new JTextField("", 40);
/** Text field for entering the optional file name to hold dumped data. */
    JTextField outf = new JTextField("", 40);

/** A label of "CDF:" for the text field cdf. */
    JLabel CDF = new JLabel("CDF: ");
/** A label of "Output File:" for the text field outf. */
    JLabel OUTF = new JLabel("Output File: ");
/** A label of "Dump:" for the Dump radio button. */
    JLabel DUMP = new JLabel("Dump: ");

/** Scroll pane for the text area. */
    JScrollPane scroller;
/** Hold valid extensions for the CDF files for the file chooser. */
    String[] cdfs = {"cdf", "CDF"};
/** A file filter for the file chooser. */
    SimpleFileFilter filter = new SimpleFileFilter(cdfs,
                                                " CDF files (*.cdf, *.CDF)");
/** The command string. */
    String command = "cdfirsdump ";
    String commandX;
    String[] cmds = new String[3];

/** Environment variable for the current directory. */
    String currentdir = System.getProperty("user.dir");
/** The file separator. */
    String separator = System.getProperty("file.separator");
/** Valid items in a combo box. */
    String[] dumpx = {"brief", "full"};
    String strpo = "-nopage ";
    String strcs = " ";
    String strss = "-summary ";
    String strsi = " ";
    String strds = "-brief ";
    String report, temp;
    String cdfspec = " ";
    String filespec = "";
    String xxx = " ";
    String fileDelimiter, cdfDelimiter;
/** A platform-dependent Runtime object. */
    Runtime runtime = Runtime.getRuntime();
/** A separate process to run the command. */
    Process process = null;
    int hlp = 0;
    int iba = 0;

/** The text field is currently getting the focus. */
    JTextField focused = null;
/** The text field previously was focused. */
    JTextField prevfocused = null;
/** Menu bar. */
    JMenuBar menuBar = new JMenuBar();
/** A menu: File. */
    JMenu menuFile = new JMenu("File");
/** A menu: Edit. */
    JMenu menuEdit = new JMenu("Edit");
/** A menu: Help. */
    JMenu menuHelp = new JMenu("Help");
/** An Edit menu item: Copy. */
    JMenuItem menuEditCopy = new JMenuItem("Copy");
/** An Edit menu item: Cut. */
    JMenuItem menuEditCut = new JMenuItem("Cut");
/** An Edit menu item: Paste. */
    JMenuItem menuEditPaste = new JMenuItem("Paste");
/** A File menu item: Exit. */
    JMenuItem menuFileExit = new JMenuItem("Exit");
/** A Help menu item: Help. */
    JMenuItem menuHelpHelp = new JMenuItem("Help");
    int istart = -1;
    int iend = -1;

    Dimension hpad5 = new Dimension(5,1);
    Dimension hpad10 = new Dimension(10,1);
    Dimension hpad20 = new Dimension(20,1);
    Dimension hpad25 = new Dimension(25,1);
    Dimension hpad30 = new Dimension(30,1);
    Dimension hpad40 = new Dimension(40,1);
    Dimension hpad80 = new Dimension(80,1);
    Dimension vpad5 = new Dimension(1,5);
    Dimension vpad10 = new Dimension(1,10);
    Dimension vpad20 = new Dimension(1,20);
    Dimension vpad25 = new Dimension(1,25);
    Dimension vpad30 = new Dimension(1,30);
    Dimension vpad40 = new Dimension(1,40);
    Dimension vpad80 = new Dimension(1,80);

    Font  defaultFont = new Font("Dialog", Font.PLAIN, 12);
    Font  boldFont = new Font("Dialog", Font.BOLD, 12);
    Font  bigFont = new Font("Dialog", Font.PLAIN, 18);
    Font  bigboldFont = new Font("Dialog", Font.BOLD, 18);
    static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    static int INITIAL_WIDTH = 600;
    static int INITIAL_HEIGHT = 400;
/** The default dialog modal (is set to false). */
    static boolean defaultModal = false;
/** The current dialog modal. */
    boolean modal;
    int frommain = 0;

    CDFIRsDump() {
        this(null, null, defaultModal);
    }

    CDFIRsDump(JFrame parentFrame) {
        this(parentFrame, null, defaultModal);
    }

    CDFIRsDump(JFrame parentFrame, String cdfbase) {
        this(parentFrame, cdfbase, defaultModal);
    }

    CDFIRsDump(JFrame parentFrame, String cdfbase, boolean modal) {
        if (cdfbase != null) command = "\"" + cdfbase + separator + "bin" + 
				       separator + "cdfirsdump\" ";
        dialog = new JDialog(this, modal);
	this.parentFrame = parentFrame;
        this.modal = modal;
    }

/** Set up the GUI stuff for user selection.
 */

    private void buildGUI() {

        WindowListener l = new WindowAdapter() {
           public void windowClosing(WindowEvent e) {
              if (frommain == 0) {
		if (modal) dialog.dispose();
		else dialog.setVisible(false);
		if (parentFrame != null) parentFrame.setVisible(true);
              } else {System.exit(1);}
	   }
        };
        dialog.addWindowListener(l);
        dialog.setTitle("Enter   Parameters/qualifiers  for  CDFIRsDump");
        dialog.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        dialog.setLocation(screenSize.width/2 - INITIAL_WIDTH/2,
                          screenSize.height/2 - INITIAL_HEIGHT/2);
        dialog.getContentPane().setLayout(new BorderLayout());

        // set the menu bar
        dialog.setJMenuBar(menuBar);

        // add the file menu
        menuBar.add(menuFile);

        // add the menu items to file
        menuFile.add(menuFileExit);
        menuFileExit.addActionListener(this);

        // add the edit menu
        menuBar.add(menuEdit);

        // add the menu items to edit
        menuEdit.add(menuEditCopy);
        menuEdit.add(menuEditCut);
        menuEdit.add(menuEditPaste);
        menuEditCopy.addActionListener(this);
        menuEditCut.addActionListener(this);
        menuEditPaste.addActionListener(this);

        // add the help menu
        menuBar.add(menuHelp);

        // add the menu items to help
        menuHelp.add(menuHelpHelp);
        menuHelpHelp.addActionListener(this);

        // Panel 1

	makeJButton(panel1, Box.createRigidArea(vpad5), 0, 0, 1, 1, 0.0, 0.0);
	makeJButton(panel1, CDF, 0, 1, 1, 1, 0.0, 0.0);
        makeJButton(panel1, cdf, 1, 1, 1, 1, 0.0, 0.0);
        makeJButton(panel1, slt1, 2, 1, 1, 1, 0.0, 0.0);
        makeJButton(panel1, OUTF, 0, 2, 1, 1, 0.0, 0.0);
        makeJButton(panel1, outf, 1, 2, 1, 1, 0.0, 0.0);
        makeJButton(panel1, slt2, 2, 2, 1, 1, 0.0, 0.0);
	makeJButton(panel1, Box.createRigidArea(vpad20), 0, 3, 1, 1, 0.0, 0.0);
        cdf.addActionListener(this);
        cdf.addFocusListener(this);
        cdf.addMouseListener(this);
        cdf.setToolTipText("Enter the CDF (without extension) to dump");
        outf.addActionListener(this);
        outf.addFocusListener(this);
        outf.addMouseListener(this);
        outf.setToolTipText("Enter the output file (without extension) to hold the dump");
        slt1.addActionListener(this);
        slt1.addFocusListener(this);
        slt1.addMouseListener(this);
        slt1.setToolTipText("Use the file chooser to select the CDF file");

        slt2.addActionListener(this);
        slt2.addFocusListener(this);
        slt2.addMouseListener(this);
        slt2.setToolTipText("Use the file chooser to select the output file");
        CDF.setFont(boldFont);
        cdf.setFont(boldFont);
        OUTF.setFont(boldFont);
        outf.setFont(boldFont);
	dialog.getContentPane().add(panel1,BorderLayout.NORTH);
	
        // Panel 2

        // Initialize the dump radio button.

        DumpListener dumpListener = new DumpListener();
        dump1.setActionCommand("-brief ");
        dump2.setActionCommand("-full ");
        dump1.addActionListener(dumpListener);
        dump2.addActionListener(dumpListener);
        dump1.setSelected(true);
        dump.add(dump1);
        dump.add(dump2);
        dumpPanel.setLayout(new FlowLayout());
	dump1.setToolTipText("For a brief CDF dump");
        dump2.setToolTipText("For a complete CDF dump");
        dumpPanel.add(dump1);
        dumpPanel.add(dump2);

//	makeJButton(panel2, pgc, 0, 0, 1, 1, 0.0, 0.0);
        makeJButton(panel2, ssc, 0, 0, 1, 1, 0.0, 0.0);
	makeJButton(panel2, abc, 1, 0, 1, 1, 0.0, 0.0);
//        makeJButton(panel2, bac, 1, 1, 1, 1, 0.0, 0.0);
        tpanel1.add(DUMP,BorderLayout.WEST);
        tpanel1.add(dumpPanel, BorderLayout.CENTER);
        tpanel1.add(Box.createRigidArea(hpad20), BorderLayout.EAST);
        makeJButton(panel2, tpanel1, 0, 2, 1, 1, 0.0, 0.0);

	makeJButton(panel2, Box.createRigidArea(vpad20), 0, 3, 1, 1, 0.0, 0.0);

	pgc.addItemListener(this);
        pgc.setToolTipText("Select to display the output one page at a time -- not avaiable for Java");
        ssc.addItemListener(this);
        ssc.setToolTipText("Select to dump only summary information");
	abc.addItemListener(this);
        abc.setToolTipText("Display the current version");
	bac.addItemListener(this);
        bac.setToolTipText("Select to set up and run the dump by a batch job");

	ssc.setSelected(true);

        dialog.getContentPane().add(panel2,BorderLayout.CENTER);

        // Panel 3 (buttons and text area)

        panel31.add(entrb);
        panel31.add(helpb);
        panel31.add(quitb);
  	panel3.add(panel31, BorderLayout.NORTH);
	panel3.add(Box.createRigidArea(vpad30),BorderLayout.CENTER);

        // Listen for events on buttons
        entrb.addActionListener(this);
        entrb.setToolTipText("Run CDFIRsDump");
        helpb.addActionListener(this);
        helpb.setToolTipText("Get the complete help information");
        quitb.addActionListener(this);
        quitb.setToolTipText("Exit CDFIRsDump");

	// Text Area
  	info.setEditable(false);
        scroller = new JScrollPane() {
               static final long serialVersionUID = 1L;

                public Dimension getPreferredSize() {
                   return new Dimension(80, 160);
                }
                public float getAlignmentX() {
                   return LEFT_ALIGNMENT;
                }
        };
        scroller.getViewport().add(info);
        panel3.add(scroller, BorderLayout.SOUTH);
  	info.setVisible(true);

  	dialog.getContentPane().add(panel3, BorderLayout.SOUTH);
    }

/** Implement the run method for Runabout interface.
 */

    public void run() {
	buildGUI();	
	dialog.pack();
	fileChooser.setCurrentDirectory(new File(currentdir));
	dialog.setVisible(true);
	if (parentFrame != null) parentFrame.setVisible(false);
    }

/** Reenter from the main toolkit driver. Reset the dialog to visible.
 */

    public void reEnter() {
	dialog.setVisible(true);
	if (parentFrame != null) parentFrame.setVisible(false);
        info.setText("");
	cdf.setText("");
	outf.setText("");
    }

/** Action for the radio button for dump
 */

    class DumpListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
           strds = e.getActionCommand();
        }
    }

/** Actions for buttons or menu items selection
 */

    public void actionPerformed(ActionEvent evt) {
	Object obj = evt.getSource();
	if (obj == quitb || obj == menuFileExit) { // for "Quit" or "Exit"
             if (frommain == 0) {
		if (modal) dialog.dispose();
		else dialog.setVisible(false);
		if (parentFrame != null) parentFrame.setVisible(true);
             } else {System.exit(1);}
	}
	else if (obj == slt1 || obj == slt2) { // for "Select 1|2" button
             if (obj == slt1) { // for "Select1" button
		doFileChooser("Select/enter the CDF", cdf, 1, filter);
             } else { // for "Select2" button
		doFileChooser("Select/enter the output file", outf, 1, null);
             }
	} else if (obj == helpb || obj == menuHelpHelp) { // for "Help" 
		commandX = command + "-java";
		hlp = 1;
		iba = 0;
		info.setText("");
                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.indexOf("windows") != -1) {
                    cmds[0] = commandX;
                } else if (OS.indexOf("vms") != -1) {
                    cmds[0] = commandX;
                } else {
                    cmds[0] = "/bin/sh";
                    cmds[1] = "-c";
                    cmds[2] = commandX;
                }
                runit(cmds);
		hlp = 0;
	} else if (obj == entrb) { // for "Enter" button
                cdfspec = cdf.getText();
                filespec = outf.getText();
		if (cdfspec.equals("") || cdfspec.trim().equals("")) {
                  info.setText("");
                  info.append("Please enter a CDF...");
                  Toolkit.getDefaultToolkit().beep();
                  return;
		}
/*
                if (iba == 1) {
                if (!filespec.equals("") && !filespec.trim().equals("")) {
                    info.setText("");
                    info.append("Please enter the output file for a batch run..");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                  }
                }
*/
		xxx = " ";
		if (!filespec.equals("") && !filespec.trim().equals("")) {
                  iba = 1;
                  filespec = filespec.trim();
		  if (filespec.startsWith("'")) fileDelimiter = " ";
                  else if (filespec.startsWith("\"")) fileDelimiter = " ";
                  else fileDelimiter = "\"";
                  xxx = "-output " + fileDelimiter + filespec + fileDelimiter;
                } else
                  iba = 0;
  
                if (cdfspec.startsWith("'")) cdfDelimiter = " ";
                else if (cdfspec.startsWith("\"")) cdfDelimiter = " ";
                else cdfDelimiter = "\"";

		commandX = command + strpo + strcs + strss + strsi + strds + 
			   xxx + " " + cdfDelimiter + cdfspec + cdfDelimiter;
                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.indexOf("windows") != -1) {
                    cmds[0] = commandX;
                } else if (OS.indexOf("vms") != -1) {
                    commandX = commandX.replace('-', '/');
                    cmds[0] = commandX;
                } else {
                    cmds[0] = "/bin/sh";
                    cmds[1] = "-c";
                    cmds[2] = commandX;
                }
                runit(cmds);
	} else if (obj == cdf) {
		cdfspec = cdf.getText();
	} else if (obj == outf) {
                filespec = outf.getText();
	} else if (obj == menuEditCopy) {
                if (istart == -1) {
		    info.setText("Where to copy from?");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    focused.setSelectionStart(istart);
                    focused.setSelectionEnd(iend);
                    focused.copy();
                }
        } else if (obj == menuEditCut) {
                if (istart == -1) {
		    info.setText("What to cut?");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    focused.setSelectionStart(istart);
                    focused.setSelectionEnd(iend);
                    focused.cut();
                }
        } else if (obj == menuEditPaste) {
                if (focused == null) {
		    info.setText("Where to paste to?");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                  if (istart != -1) {
                    focused.setSelectionStart(istart);
                    focused.setSelectionEnd(iend);
                  }
                  String tempN;
                  try {
                    tempN = (String) Toolkit.getDefaultToolkit().
                                    getSystemClipboard().getContents(this).
                                    getTransferData(DataFlavor.stringFlavor);
                    if (tempN == null) { // no clipboard text
                        info.setText("No current selection on clipboard");
                        Toolkit.getDefaultToolkit().beep();
                    } else if (tempN.indexOf("\n") != -1) { // multiple lines
                        info.setText("Multiple lines selection on clipboard - not allowed:");
                        info.append("\n\n");
                        info.append(tempN);
                        Toolkit.getDefaultToolkit().beep();
                    } else { focused.paste();}
                  } catch (Exception e) {}
                }
        }
    }

/** Actions for checkboxs selection
 */
    public void itemStateChanged(ItemEvent evt) {
	Object obj = evt.getSource();
	if (obj == pgc) { // "Page Output" checkbox
	   if (pgc.isSelected()) {
		info.setText("");
		info.append("Page output is not allowed in Java");
		Toolkit.getDefaultToolkit().beep();
		pgc.setSelected(false);
	        strpo = "-nopage ";
	 	}
	} else if (obj == abc) { // "About" checkbox
	   if (abc.isSelected()) {
		abcX = 1;
		iba = 0;
                commandX = command + " -about";
                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.indexOf("windows") != -1) {
                    cmds[0] = commandX;
                } else if (OS.indexOf("vms") != -1) {
                    cmds[0] = commandX;
                } else {
                    cmds[0] = "/bin/sh";
                    cmds[1] = "-c";
                    cmds[2] = commandX;
                }
                runit(cmds);
                abc.setSelected(false);
		abcX = 0;
	   }
        } else if (obj == ssc) { // "Show Summary" checkbox
           if (ssc.isSelected())
                strss = "-summary ";
           else
                strss = "-nosummary ";
	} else if (obj == bac) { // "Run it Batch" checkbox
	   if (bac.isSelected()) {
		iba = 1;
		if (outf.getText().equals("")) {
		   info.setText("");
		   info.append("Please enter a CDF and an output file for a batch run...");
		   Toolkit.getDefaultToolkit().beep();
		}
	   } else
		iba = 0;
	}
    }

    public void focusGained(FocusEvent e) {
        Object focusedObj =  e.getSource();
        if (focusedObj instanceof JTextField) {
	  focused = (JTextField) focusedObj;
          if (prevfocused != null) {
            prevfocused.setText(prevfocused.getText());
            if (iend != -1)
                if (iend < focused.getText().length())
                             prevfocused.setCaretPosition(iend);
                else focused.setCaretPosition(focused.getText().length());
	    }
        }
    }

    public void focusLost(FocusEvent e) {
        if (istart != -1)     {
            focused.setSelectionStart(istart);
            focused.setSelectionEnd(iend);
            prevfocused = focused;
          }
        }
    public void mouseClicked(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {
        if (focused != null) {
          String selectedText = focused.getSelectedText();
          if (selectedText!=null) {
            istart = focused.getSelectionStart();
            iend = focused.getSelectionEnd();
          } else {
            istart = -1;
            iend = -1;
          }
        }
    }

/** Set up gridbaglayout.
 */

    private void makeJButton(Container cont, Object arg,
            int x, int y, int w, int h, double weightx, double weighty) {
        GridBagLayout gbl = (GridBagLayout)cont.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        Component comp;

        c.fill = GridBagConstraints.BOTH;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.gridheight = h;
        c.weightx = weightx;
        c.weighty = weighty;
        if (arg instanceof String) {
            comp = new JButton((String)arg);
        } else {
            comp = (Component)arg;
        }
        cont.add(comp);
        gbl.setConstraints(comp, c);
    }

/** Execute an command as a separate process for the user selection and returns
    the results in the text area.
 */

    private void runit(String[] command) {
	try {
              if (command[1] != null)
                process = runtime.exec(command);
              else
                process = runtime.exec(command[0]);
              if (iba == 1) {
                 info.setText("Program is submitted...\n\n");
              } else { 
                if (abcX == 0 && hlp == 0) {
                   info.setText("");
                   info.append("Program is running...\n");
                }
              }
              Dimension dialogSize = dialog.getSize();
              ((JComponent)(dialog.getContentPane())).paintImmediately(
                                                0, 0, dialogSize.width, dialogSize.height);
              String line = null;
              BufferedReader inStream = new BufferedReader(new
                                      InputStreamReader(process.getInputStream()), 8192);
	      info.setText("");
              while ((line = inStream.readLine()) != null)
                info.append(line+"\n");
              process.waitFor();
	      info.setCaretPosition(0);
              if (process.exitValue() == 1) {
		  if (!filespec.equals("")) info.append("Error detected...\n");
		  Toolkit.getDefaultToolkit().beep();
	      }
              if (iba == 1) {
                 if (info.getText().toLowerCase().indexOf("error") == -1) {
                   info.append("Done!\n\n");
		 } else
		   info.append("ERROR: dump file is not created.\n");
	      }
        } catch (Exception e) {
              info.setText("error executing: "+e);
              Toolkit.getDefaultToolkit().beep();
        }
    }

/** Initiate the file chooser and strip the extension for the selected file
    if necessary
 */

    private void doFileChooser (String title, JTextField textField, int theone, SimpleFileFilter filter) {
//        JFileChooser fileChooser = new JFileChooser();
	ExampleFileView fileView = new ExampleFileView();
//        fileChooser.setCurrentDirectory(new File(currentdir));
        fileChooser.setDialogTitle(title);
        if (filter != null) {
	   fileChooser.addChoosableFileFilter(filter);
	   fileChooser.setFileFilter(filter);
	}
        try {
           fileView.putIcon("cdf",
                            new ImageIcon(CDFIRsDump.class.getResource("CDF_Logo3.gif")));
           fileView.putIcon("CDF",
                            new ImageIcon(CDFIRsDump.class.getResource("CDF_Logo3.gif")));
           fileChooser.setFileView(fileView);
        } catch (Exception e) {}

        int returnValue = fileChooser.showDialog(dialog, "OK");
        if (returnValue == JFileChooser.APPROVE_OPTION) {
           File selectedFile = fileChooser.getSelectedFile();
           if (selectedFile != null) {
              int ind;
              String myfile = selectedFile.getAbsolutePath();
              if (theone == 1) { // for .cdf file
                  ind = myfile.lastIndexOf(".cdf");
                  if (ind != -1) myfile = myfile.substring(0, ind);
                  ind = myfile.lastIndexOf(".CDF");
                  if (ind != -1) myfile = myfile.substring(0, ind);
              }
	      fileChooser.setCurrentDirectory(selectedFile);
              textField.setText(myfile);
           }
        } else {
//                JOptionPane.showMessageDialog(dialog, "No file chosen");
        }
    }

/** This class can run as an application by its own.
 */

    static public void main(String[] args) {

/** Environment variable for CDF_BASE. */
        String cdfbase = System.getProperty("CDF_BASE");
        if (cdfbase == null) {
          try {
             Process process = Runtime.getRuntime().exec("printenv CDF_BASE");
             BufferedReader inStream = new BufferedReader(new
                                InputStreamReader(process.getInputStream()));
             cdfbase = inStream.readLine(); // get the $CDF_BASE environment variable
             try {                      // if defined
                process.waitFor();
             } catch (InterruptedException ee) {
                cdfbase = null;
             }
          } catch (IOException ex) {
              cdfbase = null;
          }
        }

        CDFIRsDump thispgm = new CDFIRsDump(null, cdfbase);
	thispgm.fileChooser.setCurrentDirectory(new File(thispgm.currentdir));
        thispgm.frommain = 1;
	thispgm.run();
    }

}

