// $Id: CDFNativeLibrary.java,v 1.1 2012/05/18 17:48:50 liu Exp $
package gsfc.nssdc.cdf;

import java.util.*;
import java.lang.*;

/**
 * This class implements the method that act as the gateway between the
 * CDF Java APIs and the CDF library.   
 *
 * @author Phil Williams, QSS Group Inc/RITSS
 * @version Version 1.0 
 */
public class CDFNativeLibrary implements CDFDelegate {
    
    private native void cdfNativeLib(CDF theCDF, 
                                     CDFObject cdfObject, 
                                     Vector cmds) 
	throws CDFException;
    /**
     * Calls the Java Native Interface (JNI) program, cdfNativeLibrary.c.  
     * This method is internal and called by various core CDF Java programs.<P>
     * 
     * End users should never call this method from their applications.
     *
     * @param theCDF the CDF being dealt with <P>
     * @param cdfObject the calling program/object (e.g. Variable.java, 
     *                  Attribute.java, etc.) <P>
     * @param cmds a vector that contains the CDFlib commands to be executed <P>
     *
     * @exception CDFException if a problem occurs while executing the
     *            requested CDFlib commands in cdfNativeLibrary.c.
     */
    public void cdflib(CDF theCDF, CDFObject cdfObject, Vector cmds)
	throws CDFException
    {
	//	System.out.println("Executing command: "+cmds+" on "+
        //                         cdfObject.getClass().getName()+ 
        //                         " in "+theCDF);
	//  cdfNativeLib is implemented in JNI as 
	//  CDFNativeLibrary_cdfNativeLib

	cdfNativeLib(theCDF, cdfObject, cmds);
    }

    static {
	System.loadLibrary("cdfNativeLibrary");
    }
}






