// $Id: JLabeledDataTable.java,v 1.1 2012/05/18 17:44:27 liu Exp $

// Swing Imports
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.*;
import javax.swing.table.*;

/**
 * A DataTable wrapped in a JScrollPane contained in  a JLabeledPanel.
 *
 *  <BR><BR><FONT SIZE=-1>
 *  1999, NASA/Goddard Space Flight Center
 *  This software may be used, copied, or redistributed as long as it is not
 *  sold or incorporated in any product meant for profit.  This copyright 
 *  notice must be reproduced on each copy made.  This routine is provided 
 *  as is without any express or implied warranties whatsoever.
 *  </FONT>
 *
 * @author Phil Williams
 * @version $Revision: 1.1 $
 *
 */
public class JLabeledDataTable extends JLabeledPanel {
    private JScrollPane sp;
    private DataTable table;
    
    static final long serialVersionUID = 1L;

    /**
     * Construct a JLabeledDataTable labeled with the label.
     *
     * @param label the label.
     */
    public JLabeledDataTable(String label) {
	super(label);
	table = new DataTable();
	table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
	ListSelectionModel rowSM = table.getSelectionModel();
	rowSM.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	sp = new JScrollPane(table);
	add(sp);
    }

    public JLabeledDataTable(String label, boolean cellEditable) {
        super(label);
        table = new DataTable(cellEditable);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        sp = new JScrollPane(table);
        add(sp);
    }

    /**
     * Wraps DataTable.setVisible.
     *
     * @see javax.swing.JTable#setVisible
     */
    public void setVisible(boolean v) {
	table.setVisible(v);
    }

    /**
     * Wraps DataTable.setModel.
     *
     * @see javax.swing.JTable#setModel
     */
    public void setModel(DefaultDataTableModel tm) {
	table.setModel(tm);
	sp.revalidate();
	sp.repaint();
    }

    /**
     * Wraps DataTable.getModel.
     *
     * @see javax.swing.JTable#getModel
     */
    public DefaultDataTableModel getModel() {
	return (DefaultDataTableModel)table.getModel();
    }

    /**
     * Get the scroll pane containing the table
     */
    public JScrollPane getScrollPane() {
	return sp;
    }

    /**
     * Get the table containing the table
     */
    public DataTable getDataTable() {
	return table;
    }

    public void setEnabled(boolean enable) {
	super.setEnabled(enable);
	table.setEnabled(enable);
    }
    
} 
