import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.datatransfer.*;
//import JLabeledPanel;

/** Panel for selecting filering for CDFExport
 */

public class ExportFilterOptions extends JDialog {

    static final long serialVersionUID = 1L;

    private static ExportFilterOptions dialog;
    private JLabeledPanel filterPanel;

    private JCheckBox uic;
    private JCheckBox uxc;
    private JCheckBox fic;

    private ButtonGroup filtergp;
    private JRadioButton noFilter;
    private JRadioButton yesFilter;

    private CDFExport cdfexport;
    static boolean defaultModal = true;

    private static final String ENTER = "Continue";
    private static final String CANCEL = "Cancel";
    private static final String RESET = "Reset";

    private ExportFilterOptions(JFrame parentFrame, boolean modal) {
        super(parentFrame, modal);
    }

    public static ExportFilterOptions createFilterOptions(JFrame parentFrame, 
							  CDFExport cdfexport,
							  boolean modal) {
	if (dialog == null) {
	  dialog = new ExportFilterOptions(parentFrame, modal);
	  dialog.getContentPane().setLayout(new BorderLayout());
          dialog.setTitle("Filtering Options");

          // Only way to close is to use the buttons
          dialog.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
          dialog.addWindowListener(new WindowAdapter() {
              public void windowClosing(WindowEvent we) {
              }
          });

          dialog.setSize(400,500);
	  dialog.buildCBUIs();
	  dialog.buildPanels();
	}
	dialog.cdfexport = cdfexport;
	dialog.pack();	
        Dimension ps = dialog.getSize();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();

        dialog.setLocation(ss.width/2 - ps.width/2,
                           ss.height/2 - ps.height/2);

//	dialog.setLocation(0, 0);
	return dialog;
    }

    void buildPanels() {

        JPanel mp = (JPanel) dialog.getContentPane();
        mp.setBorder(new EmptyBorder(10,10,10,10));

        filterPanel = new JLabeledPanel("Filtering");

        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        filterPanel.setLayout(gbl);
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        gbc.gridheight = 1;

        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout( jp, BoxLayout.Y_AXIS ));
        jp.setAlignmentY(Component.TOP_ALIGNMENT);

        jp.add(noFilter);
        jp.add(yesFilter);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(jp, gbc);
        filterPanel.add(jp);

        gbc.gridwidth = GridBagConstraints.RELATIVE;
        gbl.setConstraints(Box.createRigidArea(new Dimension(15,1)), gbc);
        filterPanel.add(Box.createRigidArea(new Dimension(15,1)));

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(uic, gbc);
        filterPanel.add(uic);

        gbc.gridwidth = GridBagConstraints.RELATIVE;
        gbl.setConstraints(Box.createRigidArea(new Dimension(15,1)), gbc);
        filterPanel.add(Box.createRigidArea(new Dimension(15,1)));
        
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(uxc, gbc);
        filterPanel.add(uxc);

        gbc.gridwidth = GridBagConstraints.RELATIVE;
        gbl.setConstraints(Box.createRigidArea(new Dimension(15,1)), gbc);
        filterPanel.add(Box.createRigidArea(new Dimension(15,1)));
        
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(fic, gbc);
        filterPanel.add(fic);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(Box.createVerticalStrut(20), gbc);
        filterPanel.add(Box.createVerticalStrut(20));

    	mp.add(filterPanel, BorderLayout.CENTER);

	createButtonPanel(mp);
    }

    public void displayFilterOptions() {

//	dialog.pack();
	dialog.setVisible(true);
    }

/** Build user Interface items
 */

    private void buildCBUIs() {

        uic = new JCheckBox("Use VALIDMIN - less than the value of VALIDMIN won't be extracted", false);
        uxc = new JCheckBox("Use VALIDMAX - greater than the value of VALIDMAX won't be extracted", false);
        fic = new JCheckBox("Use FILLVAL - use the fill value for any invalid data, if checked", false);

        filtergp = new ButtonGroup();
        noFilter = new JRadioButton("Extract data without filtering");
        yesFilter = new JRadioButton("Search/Extract criteria defined by the following attributes");

        // Initialize the filter radio buttons.

        FilterListener filterListener = new FilterListener();
        noFilter.setActionCommand("0");
        yesFilter.setActionCommand("1");
        noFilter.addActionListener(filterListener);
        yesFilter.addActionListener(filterListener);
        noFilter.setSelected(true);
        filtergp.add(noFilter);
        filtergp.add(yesFilter);
        noFilter.setToolTipText("All data will be extracted");
        yesFilter.setToolTipText("Data will be filtered");

        uic.setToolTipText("Data less than the value of VALIDMIN won't be extracted");
        uxc.setToolTipText("Data greater than the value of VALIDMAX won't be extracted");
        fic.setToolTipText("Filled value will be used for missing/invalid data");

    }
/** Action for radio buttons for filtering
 */

    private class FilterListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
           int filter = Integer.parseInt(e.getActionCommand());
	   if (filter == 1) { // Apply filtering
	     uic.setSelected(true);
             uxc.setSelected(true);
             fic.setSelected(true);
	   } else {
             uic.setSelected(false);
             uxc.setSelected(false);
             fic.setSelected(false);
	   }
        }
    }

/** Create selection buttons at the bottom of panel
 */

    private void createButtonPanel(JPanel jp) {

        JButton enterButton = new JButton(ENTER);
	JButton cancelButton = new JButton(CANCEL);
        JButton resetButton = new JButton(RESET);
        JPanel buttonPanel = new JPanel(true);

	SelectionListener selectionListener = new SelectionListener();
        enterButton.addActionListener(selectionListener);
	resetButton.addActionListener(selectionListener);
	cancelButton.addActionListener(selectionListener);

	buttonPanel.add(Box.createRigidArea(new Dimension(20,1)));
        buttonPanel.add(enterButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20,1)));
        buttonPanel.add(resetButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20,1)));
	buttonPanel.add(cancelButton);
	buttonPanel.add(Box.createRigidArea(new Dimension(20,1)));

        enterButton.setToolTipText("Save the options and return...");
        resetButton.setToolTipText("Reset the options to their defaults...");
	cancelButton.setToolTipText("Cancel the option selections...");

        jp.add(buttonPanel, BorderLayout.SOUTH);

    }

/**
 * Process button events.
 */
    private class SelectionListener implements ActionListener {
        public void actionPerformed(ActionEvent event) {
          Object source = event.getSource();

          if (source instanceof JButton) {
            String action = event.getActionCommand();
            if (action.equals(ENTER)) {        // Continue the operation
		set();
                dialog.setVisible(false);
		cdfexport.repaint();
            } else if (action.equals(RESET)) {        // Reset the selection
                reset();
	    } else { // Cancel the selection
		recover();
		dialog.setVisible(false);
            }
          }
        }
   }

/** Reset the selection to the defaults
 */

    public void reset() {

        noFilter.setSelected(true);
        uic.setSelected(false);
        uxc.setSelected(false);
        fic.setSelected(false);

        cdfexport.setFiltering(0);
        cdfexport.setValidMin(0);
        cdfexport.setValidMax(0);
        cdfexport.setFillVal(0);

    }

/** Set the selections to their selected values
 */

    public void set() {

        int outFil = cdfexport.getValidMin() * 4 + cdfexport.getValidMax() * 2 +
                     cdfexport.getFillVal();

        if (noFilter.isSelected()) {
          cdfexport.setFiltering(0);
          cdfexport.setValidMin(0);
          cdfexport.setValidMax(0);
          cdfexport.setFillVal(0);
        } else {
	  cdfexport.setFiltering(1);
          if (uic.isSelected()) cdfexport.setValidMin(1);
          else cdfexport.setValidMin(0);
          if (uxc.isSelected()) cdfexport.setValidMax(1);
          else cdfexport.setValidMax(0);
          if (fic.isSelected()) cdfexport.setFillVal(1);
          else cdfexport.setFillVal(0);
        }
        int newFil = cdfexport.getValidMin() * 4 + cdfexport.getValidMax() * 2 +
                     cdfexport.getFillVal();
	if (outFil == newFil) cdfexport.setFilterChanged(false);
	else cdfexport.setFilterChanged(true);
    }

/** Reset the selections back to their previous values
 */

    public void recover() {

        noFilter.setSelected(true);
        uic.setSelected(false);
        uxc.setSelected(false);
        fic.setSelected(false);

        if (cdfexport.getFiltering() == 0) {
	  noFilter.setSelected(true);
          uic.setSelected(false);
          uxc.setSelected(false);
          fic.setSelected(false);
	} else {
	  yesFilter.setSelected(true);
          if (cdfexport.getValidMin() == 0) uic.setSelected(false);
	  else uic.setSelected(true);
          if (cdfexport.getValidMax() == 0) uxc.setSelected(false);
          else uxc.setSelected(true);
	  if (cdfexport.getFillVal() == 0) fic.setSelected(false);
	  else fic.setSelected(true);
	}
    }

}
