import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URL;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

/** This is the driver program that can be used to run CDF tool programs.
    The tool programs, each running as an independent thread, can run 
    simultaneously.
    @version: 1.0. 1/7/99
    @auther: Michael Liu, Raytheon ITSS

 */

public class CDFToolsDriver extends JFrame implements ActionListener {

    static final long serialVersionUID = 1L;

    CDFToolsDriver theDriver;
/** Environment variable for CDF_BASE. */
    String cdfbase = System.getProperty("CDF_BASE");
/** The file separator. */
    String separator = System.getProperty("file.separator");
    String osName = System.getProperty("os.name");
    JRadioButton rb1, rb2, rb3, rb4, rb5, rb6, rb7, rb8, rb9, rba, rbb, rbc, qut, 
                 non;
/** The default file name at which the CDF logo file is located. */
//    String basegif = cdfbase + separator + "java" + separator + "cdf_banner.jpg";
/** The alternated file name for CDF logo if it is not at the default directory. */
//    String currentgif = System.getProperty("user.dir") + separator + 
//                        "cdf_banner.jpg";

/** The file object for the CDF logo file from its default location. */
//    File cdfgif = new File(basegif);

/** The frame. */

//  ToolsDriver available for selection 
/** The action command for selecting the SkeletonTable radiobutton. */
    String skeletontable = "SkeletonTable";
/** The action command for selecting the SkeletonCDF radiobutton. */
    String skeletoncdf = "SkeletonCDF";
/** The action command for selecting the CDFCompare radiobutton. */
    String cdfcompare = "CDFCompare";
/** The action command for selecting the CDFConvert radiobutton. */
    String cdfconvert = "CDFConvert";
/** The action command for selecting the CDFInquire radiobutton. */
    String cdfinquire = "CDFInquire";
/** The action command for selecting the CDFStats radiobutton. */
    String cdfstats = "CDFStats";
/** The action command for selecting the CDFDump radiobutton. */
    String cdfdump = "CDFDump";
/** The action command for selecting the CDFDir radiobutton. */
    String cdfdir = "CDFDir";
/** The action command for selecting the CDFMerge radiobutton. */
    String cdfmerge = "CDFMerge";
/** The action command for selecting the CDFValidate radiobutton. */
    String cdfvalidate = "CDFValidate";
/** The action command for selecting the CDFEdit radiobutton. */
    String cdfedit = "CDFEdit";
/** The action command for selecting the CDFExport radiobutton. */
    String cdfexport = "CDFExport";
/** The action command for selecting the Quit radiobutton. */
    String quit = "Quit";
/** The action command for selecting the invisible radiobutton. */
    String none = "None";

/** The panel holding the selection buttons. */
    JPanel panel1 = new JPanel(true);
/** The panel holding the text field tf for information. */
    JPanel panel2 = new JPanel(new GridLayout(1, 1), true);

/** The radio button group for selecting the toolkit programs to run. */
    ButtonGroup buttonGroup = new ButtonGroup();

/** The label holding the CDF logo picture. */
    JLabel picture;

/** The informational text field. */
    JTextField tf = new JTextField("",15);

//  each tool program will run as an independent thread
    Thread threadinquire, threadstats, threadcompare, threadconvert,
           threadskeletontable, threadskeletoncdf, threaddump, threaddir,
           threadmerge, threadvalidate, threadedit, threadexport;

//  Each tool as an object from its class 
/** A CDFInquire object is initiated when it is selected to run.*/ 
    CDFInquire pgminquire = null;
/** The CDFCompare object is initiated when it is selected to run.*/
    CDFCompare pgmcompare = null;
/** A CDFConvert object is initiated when it is selected to run.*/
    CDFConvert pgmconvert = null;
/** A CDFStats object is initiated when it is selected to run.*/
    CDFStats pgmstats = null;
/** A CDFDump object is initiated when it is selected to run.*/
    CDFDump pgmdump = null;
/** A CDFDir object is initiated when it is selected to run.*/
    CDFDir pgmdir = null;
/** A CDFMerge object is initiated when it is selected to run.*/
    CDFMerge pgmmerge = null;
/** A CDFValidate object is initiated when it is selected to run.*/
    CDFValidate pgmvalidate = null;
/** A SkeletonTable object is initiated when it is selected to run.*/
    SkeletonTable pgmskeletontable = null;
/** A SkeletonCDF object is initiated when it is selected to run.*/
    SkeletonCDF pgmskeletoncdf = null;
/** A CDFEdit object is initiated when it is selected to run.*/
    CDFEdit pgmcdfedit = null;
/** A CDFExport object is initiated when it is selected to run.*/
    CDFExport pgmcdfexport = null;

    Process process = null;
    String channelFile = null;
    BufferedReader inStream = null;
    Runtime runtime = Runtime.getRuntime();

    final Dimension hpad5 = new Dimension(5,1);
    final Dimension hpad10 = new Dimension(10,1);
    final Dimension hpad20 = new Dimension(20,1);
    final Dimension hpad25 = new Dimension(25,1);
    final Dimension hpad30 = new Dimension(30,1);
    final Dimension hpad40 = new Dimension(40,1);
    final Dimension hpad50 = new Dimension(50,1);
    final Dimension vpad5 = new Dimension(1,5);
    final Dimension vpad10 = new Dimension(1,10);
    final Dimension vpad20 = new Dimension(1,20);
    final Dimension vpad25 = new Dimension(1,25);
    final Dimension vpad30 = new Dimension(1,30);
    final Dimension vpad40 = new Dimension(1,40);
    final Dimension vpad50 = new Dimension(1,50);

    Font  defaultFont = new Font("Dialog", Font.PLAIN, 12);
    Font  boldFont = new Font("Dialog", Font.BOLD, 12);
    Font  bigFont = new Font("Dialog", Font.PLAIN, 18);
    Font  bigboldFont = new Font("Dialog", Font.BOLD, 18);
    static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    static int INITIAL_WIDTH  = 600;
    static int INITIAL_HEIGHT = 400;

    CDFToolsDriver() {
	theDriver = this;
	if (osName.toLowerCase().indexOf("windows") != -1) {
	  String osVersion = System.getProperty("os.version");
	  String javaVersion = System.getProperty("java.version");
          if (osVersion.compareTo("5.0") >= 0 &&   // Windows 2000 and beyond...
              javaVersion.compareTo("1.4") >= 0) { // Java 1.4
	    try {
	      process = runtime.exec("cmd /c assoc .cdf");
	      inStream = new BufferedReader(new
				InputStreamReader(process.getInputStream()), 8192);
	      try {
                process.waitFor();
              } catch (InterruptedException ee) {
	        System.err.println("Error with assoc... 1 "+ee);
	      }
              channelFile = inStream.readLine();
              if (channelFile != null && 
		  channelFile.toLowerCase().equals(".cdf=channelfile")) {
                process = runtime.exec("cmd /c assoc .cdf="); // dis-associate it
		inStream = new BufferedReader(new
                                InputStreamReader(process.getInputStream()), 8192);
		String dummy = inStream.readLine(); // clear the input buffer
                try {
                  process.waitFor();
		  runtime.addShutdownHook(new RestoreChannelDefinition(channelFile));
	        } catch (InterruptedException ee) {
	          System.err.println("Error with assoc... 2 "+ee);
	        }
	      }
              process = Runtime.getRuntime().exec("cmd /c echo %CDF_BASE%");
              inStream = new BufferedReader
                   ( new InputStreamReader( process.getInputStream() ) );
              try {
                process.waitFor();
              } catch (InterruptedException ee) {
                System.err.println("Error with echo... 3 "+ee);
              }
              cdfbase = inStream.readLine();
              if (cdfbase.toLowerCase().equals("%cdf_base%"))
                cdfbase = null;
              else {
                int sepindx = cdfbase.indexOf(";");
                if (sepindx != -1) cdfbase = cdfbase.substring(0, sepindx);
              }
	    } catch (IOException ex) { // No need to do anything if "cmd" file does not exist 
              cdfbase = null;
	    } 
	  } 
	}

        if (cdfbase == null) {
          if (osName.toLowerCase().indexOf("windows") == -1) {
            try {
               String line;
               process = runtime.exec("env"); // Use "env" instead of "printenv"
               inStream = new BufferedReader(new
                                  InputStreamReader(process.getInputStream()));
               process.waitFor();
               while ((line = inStream.readLine()) != null) {
                 StringTokenizer st = new StringTokenizer(line, "=");
                 if (st.nextToken().equals("CDF_BASE")) {
                   cdfbase = st.nextToken();
                   break;
                 }
               }
            } catch (InterruptedException ee) {
               cdfbase = null;
            } catch (IOException ex) {
               cdfbase = null;
            }
          }
        }

        setLocation(screenSize.width/2 - INITIAL_WIDTH/2,
                          screenSize.height/2 - INITIAL_HEIGHT/2);

        JPanel panelX = new JPanel(true);
        Image image;
        panelX.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panelX.setLayout(new BorderLayout());

/****************************************************************************/
/*   Added by David Han to load cdf_banner.jpg from a jar file, cdftools.jar.   */
/****************************************************************************/

        URL url = null;
        try {
            url = this.getClass().getResource("cdf_banner.jpg"); 
        } catch (Exception e) {
            System.out.println("URL/Image fetch error occurred...");
            e.printStackTrace();
            System.exit(1);
        };
        image = Toolkit.getDefaultToolkit().getImage(url);
	picture = new JLabel(new ImageIcon(image));
/****************************************************************************/

//	picture.setPreferredSize(new Dimension(image.getWidth(null),
//					       image.getHeight(null)));
	panelX.add(picture, "North");

	panel1.setLayout(new BoxLayout(panel1, BoxLayout.Y_AXIS));
	panel1.setPreferredSize(new Dimension(200, 375));
	panel1.setBorder(new TitledBorder(new EtchedBorder(), "Select a tool to run"));

	rb1 = new JRadioButton("SkeletonTable");
	rb1.setMnemonic('1');
	rb1.setToolTipText("<html><center>"+
			   "Run the command-line based SkeletonTable Tool Program."+
			   "<br>"+
			   "Need to define CDF_BASE environment variable."+
			   "</center></html>");
	rb1.setActionCommand(skeletontable);
	rb1.addActionListener(this);
	buttonGroup.add(rb1);

	rb2 = new JRadioButton("SkeletonCDF");
	rb2.setMnemonic('2');
	rb2.setToolTipText("<html><center>"+
                           "Run the command-line based SkeletonCDF Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
	rb2.setActionCommand(skeletoncdf);
	rb2.addActionListener(this);
	buttonGroup.add(rb2);

	rb3 = new JRadioButton("CDFConvert");
	rb3.setMnemonic('3');
	rb3.setToolTipText("<html><center>"+
                           "Run the command-line based CDFConvert Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
	rb3.setActionCommand(cdfconvert);
	rb3.addActionListener(this);
	buttonGroup.add(rb3);

	rb4 = new JRadioButton("CDFCompare");
	rb4.setMnemonic('4');
	rb4.setToolTipText("<html><center>"+
                           "Run the command-line based CDFCompare Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
	rb4.setActionCommand(cdfcompare);
	rb4.addActionListener(this);
	buttonGroup.add(rb4);

	rb5 = new JRadioButton("CDFInquire");
	rb5.setMnemonic('5');
	rb5.setToolTipText("<html><center>"+
                           "Run the command-line based CDFInquire Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
	rb5.setActionCommand(cdfinquire);
	rb5.addActionListener(this);
	buttonGroup.add(rb5);

        rb6 = new JRadioButton("CDFStats");
        rb6.setMnemonic('6');
        rb6.setToolTipText("<html><center>"+
                           "Run the command-line based CDFStats Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
        rb6.setActionCommand(cdfstats);
        rb6.addActionListener(this);
        buttonGroup.add(rb6);

        rb7 = new JRadioButton("CDFDump");
        rb7.setMnemonic('7');
        rb7.setToolTipText("<html><center>"+
                           "Run the command-line based CDFDump Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
        rb7.setActionCommand(cdfdump);
        rb7.addActionListener(this);
        buttonGroup.add(rb7);

        rb8 = new JRadioButton("CDFDir");
        rb8.setMnemonic('8');
        rb8.setToolTipText("<html><center>"+
                           "Run the command-line based CDFDir Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
        rb8.setActionCommand(cdfdir);
        rb8.addActionListener(this);
        buttonGroup.add(rb8);

        rbb = new JRadioButton("CDFMerge");
        rbb.setMnemonic('b');
        rbb.setToolTipText("<html><center>"+
                           "Run the command-line based CDFMerge Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
        rbb.setActionCommand(cdfmerge);
        rbb.addActionListener(this);
        buttonGroup.add(rbb);

        rbc = new JRadioButton("CDFValidate");
        rbc.setMnemonic('c');
        rbc.setToolTipText("<html><center>"+
                           "Run the command-line based CDFValidate Tool Program."+
                           "<br>"+
                           "Need to define CDF_BASE environment variable."+
                           "</center></html>");
        rbc.setActionCommand(cdfvalidate);
        rbc.addActionListener(this);
        buttonGroup.add(rbc);

        rb9 = new JRadioButton("CDFEdit");
        rb9.setMnemonic('9');
        rb9.setToolTipText("Run the CDFEdit Tool Program");
        rb9.setActionCommand(cdfedit);
        rb9.addActionListener(this);
        buttonGroup.add(rb9);

        rba = new JRadioButton("CDFExport");
        rba.setMnemonic('a');
        rba.setToolTipText("Run the CDFExport Tool Program");
        rba.setActionCommand(cdfexport);
        rba.addActionListener(this);
        buttonGroup.add(rba);

        qut = new JRadioButton("Quit");
        qut.setToolTipText("End the Session");
        qut.setActionCommand(quit);
        qut.addActionListener(this);
        buttonGroup.add(qut);

        non = new JRadioButton("None");
        buttonGroup.add(non);

	panel1.add(rb1);
	panel1.add(rb2);
	panel1.add(rb3);
	panel1.add(rb4);
	panel1.add(rb5);
	panel1.add(rb6);
	panel1.add(rb7);
        panel1.add(rb8);
        panel1.add(rbb);
	panel1.add(rbc);
	panel1.add(rb9);
	panel1.add(rba);
	panel1.add(Box.createRigidArea(vpad5));
	panel1.add(qut);

	if (image.getWidth(null) != -1) { // got the image
	  Box box1 = Box.createHorizontalBox();
	  box1.add(Box.createGlue());
	  box1.add(panel1);
	  box1.add(Box.createGlue());
	  panelX.add(box1, "Center");
	} else {
	  panelX.add(panel1, "Center");
	}

	tf.setFont(boldFont);
	tf.setEditable(false);
//	panel2.add(Box.createRigidArea(new Dimension(1,2)));
	panel2.add(tf);
	panelX.add(panel2, "South");

        WindowListener l = new WindowAdapter() {
           public void windowClosing(WindowEvent e) {
		System.exit(1);
	   }
        };

        addWindowListener(l);
        setTitle("  CDF ToolsDriver  ");
        getContentPane().add(panelX, BorderLayout.CENTER);
	pack();

	setVisible(true);

    }

/** Action for a selected radio button.
 */
 
    public void actionPerformed(ActionEvent evt) {
	if (evt.getActionCommand().equals("Quit")) {
	  System.exit(1);
	}

	String pgm = evt.getActionCommand();
	if (pgm.equals("CDFCompare")) {
	  if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
	    tf.setText("CDF_BASE environment variable has not been defined...");
	    Toolkit.getDefaultToolkit().beep();
	  } else {
	    if (threadcompare == null) {
	      tf.setText("Loading...");
	      new ClearInfo(tf).start();
	      pgmcompare = new CDFCompare(theDriver.getFrame(), cdfbase);
	      threadcompare = new Thread(pgmcompare);
	      threadcompare.start();
	    } else {
	      pgmcompare.reEnter();
	    }
	  }
	  new ResetButton().start(); 
	} else if (pgm.equals("CDFConvert")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threadconvert == null) {
	      tf.setText("Loading...");
	      new ClearInfo(tf).start();
              pgmconvert = new CDFConvert(theDriver.getFrame(), cdfbase);
              threadconvert = new Thread(pgmconvert);
              threadconvert.start();
            } else {
              pgmconvert.reEnter();
            }
	  }
          new ResetButton().start(); 
	} else if (pgm.equals("CDFInquire")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {

          if (threadinquire == null) {
	      tf.setText("Loading...");
	      new ClearInfo(tf).start();
	      pgminquire = new CDFInquire(theDriver.getFrame(), cdfbase);
	      threadinquire = new Thread(pgminquire);
              threadinquire.start();
            } else {
              pgminquire.reEnter();
            }
	  }
	  new ResetButton().start(); 
	} else if (pgm.equals("SkeletonCDF")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threadskeletoncdf == null) {
	      tf.setText("Loading...");
	      new ClearInfo(tf).start();
              pgmskeletoncdf = new SkeletonCDF(theDriver.getFrame(), cdfbase);
              threadskeletoncdf = new Thread(pgmskeletoncdf);
              threadskeletoncdf.start();
            } else {
              pgmskeletoncdf.reEnter();
            }
	  }
	  new ResetButton().start(); 
	} else if (pgm.equals("SkeletonTable")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threadskeletontable == null) {
	      tf.setText("Loading...");
	      new ClearInfo(tf).start();
              pgmskeletontable = new SkeletonTable(theDriver.getFrame(), cdfbase);
              threadskeletontable = new Thread(pgmskeletontable);
              threadskeletontable.start();
            } else {
              pgmskeletontable.reEnter();
            }
	  }
	  new ResetButton().start();
	} else if (pgm.equals("CDFStats")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threadstats == null) {
	      tf.setText("Loading...");
              new ClearInfo(tf).start();
              pgmstats = new CDFStats(theDriver.getFrame(), cdfbase);
              threadstats = new Thread(pgmstats);
              threadstats.start();
            } else {
              pgmstats.reEnter();
            }
	  }
	  new ResetButton().start();
        } else if (pgm.equals("CDFDump")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threaddump == null) {
              tf.setText("Loading...");
              new ClearInfo(tf).start();
              pgmdump = new CDFDump(theDriver.getFrame(), cdfbase);
              threaddump = new Thread(pgmdump);
              threaddump.start();
            } else {
              pgmdump.reEnter();
            }
          }
          new ResetButton().start();
	} else if (pgm.equals("CDFDir")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threaddir == null) {
     	      tf.setText("Loading...");
              new ClearInfo(tf).start();
              pgmdir = new CDFDir(theDriver.getFrame(), cdfbase);
              threaddir = new Thread(pgmdir);
              threaddir.start();
            } else {
              pgmdir.reEnter();
            }
	  }
	  new ResetButton().start();
        } else if (pgm.equals("CDFMerge")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threadmerge == null) {
              tf.setText("Loading...");
              new ClearInfo(tf).start();
              pgmmerge = new CDFMerge(theDriver.getFrame(), cdfbase);
              threadmerge = new Thread(pgmmerge);
              threadmerge.start();
            } else {
              pgmmerge.reEnter();
            }
          }
          new ResetButton().start();
        } else if (pgm.equals("CDFValidate")) {
          if (osName.toLowerCase().indexOf("windows") == -1 && cdfbase == null) {
            tf.setText("CDF_BASE environment variable has not been defined...");
            Toolkit.getDefaultToolkit().beep();
          } else {
            if (threadvalidate == null) {
              tf.setText("Loading...");
              new ClearInfo(tf).start();
              pgmvalidate = new CDFValidate(theDriver.getFrame(), cdfbase);
              threadvalidate = new Thread(pgmvalidate);
              threadvalidate.start();
            } else {
              pgmvalidate.reEnter();
            }
          }
          new ResetButton().start();
	} else if (pgm.equals("CDFEdit")) {
          if (threadedit == null) {
	    tf.setText("Loading...");
            new ClearInfo(tf).start();
            pgmcdfedit = new CDFEdit(theDriver.getFrame()); 
            threadedit = new Thread(pgmcdfedit);
            threadedit.start();
          } else {
            pgmcdfedit.reEnter();
          }
	  new ResetButton().start();
	} else if (pgm.equals("CDFExport")) {
          if (threadexport == null) {
	    tf.setText("Loading...");
            new ClearInfo(tf).start();
            pgmcdfexport = new CDFExport(theDriver.getFrame()); 
            threadexport = new Thread(pgmcdfexport);
            threadexport.start();
          } else {
            pgmcdfexport.reEnter();
          }
	  new ResetButton().start();
	}
    }

/** The frame
 */
    public JFrame getFrame() {
	return (JFrame) theDriver;

    }

/** The application to run the CDF Tool program driver. 
 */
    static public void main(String[] args) {
	
	JFrame myFrame = new CDFToolsDriver();
    }

/** A thread to clear the "Loading" message in the text field after a
    period of time. This message is shown when a tool program is selected.
 */
    private class ClearInfo extends Thread {

/** The text area to be cleared. */
        JTextField tf;

        ClearInfo(JTextField tf) {
    	    this.tf = tf;
        }

/** implement the run method of Runable class. Wait for a short time then
    clear the text field. 
 */

        public void run() {
	    try {
	       Thread.sleep(2000); // idle for second(s)
	    }  catch (InterruptedException e) { }
	    tf.setText(" "); // clear the text field
        }
    }

/** A thread to select the "invisible" button in the main menu
    after the originally selected program starts.
 */
    private class ResetButton extends Thread {

/** implement the run method of Runable class. 
 */

        public void run() {
            try {
               Thread.sleep(1500); // idle for second(s)
            }  catch (InterruptedException e) { }
            non.setSelected(true);
        } 
    }

/** A thread to restore the .cdf association for Windows 2000, etc.
 */
    class RestoreChannelDefinition extends Thread {

/** The original channel definiton information to be restored. */
        String channelDefinition;

        RestoreChannelDefinition(String channelDefinition) {
            this.channelDefinition = channelDefinition;
        }

/** implement the run method of Runable class. 
 */

        public void run() {
            try {
              Process process = Runtime.getRuntime().exec("cmd /c assoc "+
						      channelDefinition);
              try {
                process.waitFor();
              } catch (InterruptedException ee) {
                System.err.println("Error with assoc... 3 "+ee);
              }
            } catch (IOException ex) {
              System.err.println("Error running assoc on Windows...(3): "+ex);
            }
	}
    }
}



