import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.datatransfer.*;

/** CDFStats displays statistics about the variables in a CDF. These include 
    the minimum and maximum values and whether or not the variable is 
    monotonic.  It is also possible to have these properties updated in the 
    CDF (by creating and/or modifying the appropriate attribute entries).
 */

public class CDFStats extends JFrame 
		       implements ActionListener, ItemListener, 
				  MouseListener, FocusListener, Runnable {

    static final long serialVersionUID = 1L;

    JFrame parentDriver;
/** The dialog for user interface. */
    JDialog dialog;

/** The FileChooser for the file selection. */
    JFileChooser fileChooser = new JFileChooser();

/** The panel for text fields and selectable buttons which goes to dialog's
    north portion. */
    JPanel panel1 = new JPanel(new GridBagLayout(), true);
/** The panel containing all checkboxes goes to dialog's center portion. */
    JPanel panel2 = new JPanel(new BorderLayout(), true);
    JPanel panel2n = new JPanel(new GridBagLayout(), true);
    JPanel panel2s = new JPanel(new GridBagLayout(), true);
/** The panel containing panel31 and text area goes to dialog's south portion. */
    JPanel panel3 = new JPanel(new BorderLayout(), true);
/** The panel containing enter/help/quit buttons. */
    JPanel panel31 = new JPanel(new GridLayout(1, 3, 50, 20), true);
    JPanel tpanel1 = new JPanel(new BorderLayout(), true);

/** "Page Output" checkbox. */
    JCheckBox pgc = new JCheckBox("Page Output", false);
/** "Use Format" checkbox. */
    JCheckBox ufc = new JCheckBox("Use Format",true);
/** "Range Checking" checkbox. */
    JCheckBox rcc = new JCheckBox("Range Checking", true);
/** "Use FILLVAL" checkbox. */
    JCheckBox uic = new JCheckBox("Use FILLVAL", true);
/** "Report Info's" checkbox. */
    JCheckBox ric = new JCheckBox("Report Info's");
    int ricX = 0;
/** "Report Warnings" checkbox. */
    JCheckBox rwc = new JCheckBox("Report Warnings", true);
    int rwcX = 1;
/** "Report Errors" checkbox. */
    JCheckBox rec = new JCheckBox("Report Errors", true);
    int recX = 1;
/** "-0.0 to 0.0" checkbox. */
    JCheckBox zzc = new JCheckBox("-0.0 to 0.0");
/** "Display Statistics" checkbox. */
    JCheckBox dsc = new JCheckBox("Display Statistics");
    int dscX = 0;
/** "Update VALIDMIN/MAX" checkbox. */
    JCheckBox uvc = new JCheckBox("Update VALIDMIN/MAX");
/** "Update SCALEMIN/MAX" checkbox. */
    JCheckBox usc = new JCheckBox("Update SCALEMIN/MAX");
/** "Update MONOTONIC" checkbox. */
    JCheckBox umc = new JCheckBox("Update MONOTONIC");
/** "About" checkbox. */
    JCheckBox abc = new JCheckBox("About");
    int abcX = 0;
/** "Run it Batch" checkbox. */
    JCheckBox bac = new JCheckBox("Run it Batch");

/** A group radio buttons for zMode. */
    ButtonGroup zmode = new ButtonGroup();
/** A group radio buttons for zMode. */
    JRadioButton zmode0 = new JRadioButton("Off");
    JRadioButton zmode1 = new JRadioButton("On/1");
    JRadioButton zmode2 = new JRadioButton("On/2");
/** A radio button panel for zMode. */
    JPanel zmodePanel = new JPanel(true);

/** "Enter" button. */
    JButton entrb = new JButton(" Enter ");
/** "Help" button. */
    JButton helpb = new JButton(" Help ");
/** "Quit" button. */
    JButton quitb = new JButton(" Quit ");
/** "Select1" button for selecting the source CDF file. */
    JButton slt1 = new JButton("Select");
/** "Select2" button for selecting the output file. */
    JButton slt2 = new JButton("Select");

/** Text area for information. */
    JTextArea info = new JTextArea(20,60);

/** Text field for entering optional cache sizes. */
    JTextField cachesizes = new JTextField("",40);
/** Text field for entering the mandatory source CDF file name. */
    JTextField cdf = new JTextField("", 40);
/** Text field for entering the optional destination output file name. */
    JTextField outf = new JTextField("", 40);

/** A label of "CDF:" for the text field cdf (source CDF). */
    JLabel CDF = new JLabel("CDF: ");
/** A label of "Output File:" for the text field outf (output file). */
    JLabel OUTF = new JLabel("Output File: ");
/** A label of "Cache Sizes:" for the text field cachesizes. */
    JLabel CASS = new JLabel("Cache Sizes: ");
/** A label of "zMode:" for the radio button zmode1 (for zMode). */
    JLabel ZMODE = new JLabel("zMode:  ");

/** Scroll pane for the text area. */
    JScrollPane scroller;

/** Hold valid extensions for the CDF files for the file chooser. */
    String[] cdfs = {"cdf", "CDF"};
/** A file filter for the file chooser. */
    SimpleFileFilter filter = new SimpleFileFilter(cdfs,
                                                " CDF files (*.cdf, *.CDF)");
/** The command string. */
    String command = "cdfstats ";
    String commandX;
/** Environment variable for the current directory. */
    String currentdir = System.getProperty("user.dir");
/** The file separator. */
    String separator = System.getProperty("file.separator");
    String strpo = "-nopage ";
    String struf = "-format ";
    String strrc = "-range ";
    String strui = "-fill ";
    String strri = "";
    String strrw = "w";
    String strre = "e";
    String struv = " ";
    String strus = " ";
    String strum = " ";
    String strds = " ";
    String strcs = "";
    String strzm = "";
    String strzz = " ";
    String report, Zmode, caches, temp;
    String Caches = " ";
    String cdfspec = " ";
    String filespec = "";
    String xxx = " ";
    String cdfDelimiter = "";

/** A platform-dependent Runtime object. */
    Runtime runtime = Runtime.getRuntime();
/** A separate process to run the command. */
    Process process = null;
    int hlp = 0;
    int iba = 0;
    String[] cmds = new String[3];

/** The text field is currently getting the focus. */
    JTextField focused = null;
/** The text field previously was focused. */
    JTextField prevfocused = null;

/** Menu bar. */
    JMenuBar menuBar = new JMenuBar();
/** A menu: File. */
    JMenu menuFile = new JMenu("File");
/** A menu: Edit. */
    JMenu menuEdit = new JMenu("Edit");
/** A menu: Help. */
    JMenu menuHelp = new JMenu("Help");
/** An Edit menu item: Copy. */
    JMenuItem menuEditCopy = new JMenuItem("Copy");
/** An Edit menu item: Cut. */
    JMenuItem menuEditCut = new JMenuItem("Cut");
/** An Edit menu item: Paste. */
    JMenuItem menuEditPaste = new JMenuItem("Paste");
/** A File menu item: Exit. */
    JMenuItem menuFileExit = new JMenuItem("Exit");
/** A Help menu item: Help. */
    JMenuItem menuHelpHelp = new JMenuItem("Help");
    int istart = -1;
    int iend = -1;

    Dimension hpad5 = new Dimension(5,1);
    Dimension hpad10 = new Dimension(10,1);
    Dimension hpad20 = new Dimension(20,1);
    Dimension hpad25 = new Dimension(25,1);
    Dimension hpad30 = new Dimension(30,1);
    Dimension hpad40 = new Dimension(40,1);
    Dimension hpad80 = new Dimension(80,1);
    Dimension vpad5 = new Dimension(1,5);
    Dimension vpad10 = new Dimension(1,10);
    Dimension vpad20 = new Dimension(1,20);
    Dimension vpad25 = new Dimension(1,25);
    Dimension vpad30 = new Dimension(1,30);
    Dimension vpad40 = new Dimension(1,40);
    Dimension vpad80 = new Dimension(1,80);

    Font  defaultFont = new Font("Dialog", Font.PLAIN, 12);
    Font  boldFont = new Font("Dialog", Font.BOLD, 12);
    Font  bigFont = new Font("Dialog", Font.PLAIN, 18);
    Font  bigboldFont = new Font("Dialog", Font.BOLD, 18);
    static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    static int INITIAL_WIDTH = 600;
    static int INITIAL_HEIGHT = 400;
/** The default dialog modal (is set to false). */
    static boolean defaultModal = false;
/** The current dialog modal. */
    boolean modal;
    int frommain = 0;

    CDFStats() {
        this(null, null, defaultModal);
    }

    CDFStats(JFrame parentDriver) {
        this(parentDriver, null, defaultModal);
    }

    CDFStats(JFrame parentDriver, String cdfbase) {
        this(parentDriver, cdfbase, defaultModal);
    }

    CDFStats(JFrame parentDriver, String cdfbase, boolean modal) {
        if (cdfbase != null) command = "\"" + cdfbase + separator + "bin" + 
				       separator + "cdfstats\" ";
        dialog = new JDialog(this, modal);
	this.parentDriver = parentDriver;
        this.modal = modal;
    }

/** Set up the GUI stuff for user selection.
 */

    private void buildGUI() {

        WindowListener l = new WindowAdapter() {
           public void windowClosing(WindowEvent e) {
	      if (frommain == 0) {
                if (modal) dialog.dispose();
                else dialog.setVisible(false);
		if (parentDriver != null) parentDriver.setVisible(true);
	      } else {System.exit(1);}
	   }
        };
        dialog.addWindowListener(l);
        dialog.setTitle("Enter   Parameters/qualifiers  for  CDFstats");
        dialog.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        dialog.setLocation(screenSize.width/2 - INITIAL_WIDTH/2,
                          screenSize.height/2 - INITIAL_HEIGHT/2);
        dialog.getContentPane().setLayout(new BorderLayout());

	// set the menu bar
	dialog.setJMenuBar(menuBar);

        // add the file menu
        menuBar.add(menuFile);

        // add the menu items to file
        menuFile.add(menuFileExit);
        menuFileExit.addActionListener(this);

        // add the edit menu
        menuBar.add(menuEdit);

        // add the menu items to edit
        menuEdit.add(menuEditCopy);
        menuEdit.add(menuEditCut);
        menuEdit.add(menuEditPaste);
        menuEditCopy.addActionListener(this);
        menuEditCut.addActionListener(this);
        menuEditPaste.addActionListener(this);

        // add the help menu
        menuBar.add(menuHelp);

        // add the menu items to help
        menuHelp.add(menuHelpHelp);
        menuHelpHelp.addActionListener(this);

        // Panel 1

	makeJButton(panel1, Box.createRigidArea(vpad5), 0, 0, 1, 1, 1.0, 1.0);
	makeJButton(panel1, CDF, 0, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel1, cdf, 1, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel1, slt1, 2, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel1, OUTF, 0, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel1, outf, 1, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel1, slt2, 2, 2, 1, 1, 1.0, 1.0);
	makeJButton(panel1, Box.createRigidArea(vpad20), 0, 3, 1, 1, 1.0, 1.0);
        cdf.addActionListener(this);
        cdf.addFocusListener(this);
        cdf.addMouseListener(this);
        cdf.setToolTipText("Enter the source CDF (without extension) to display statistics");
        outf.addActionListener(this);
        outf.addFocusListener(this);
        outf.addMouseListener(this);
        outf.setToolTipText("Enter the output file (without extension) for statistics");
        slt1.addActionListener(this);
        slt1.setToolTipText("Use the file chooser to select the source CDF");
        slt2.addActionListener(this);
        slt2.setToolTipText("Use the file chooser to select the output file");
        CDF.setFont(boldFont);
        cdf.setFont(boldFont);
        OUTF.setFont(boldFont);
        outf.setFont(boldFont);
	dialog.getContentPane().add(panel1,BorderLayout.NORTH);
	
        // Panel 2

        // Initialize the zMode combobox.
	
        ZModeListener zModeListener = new ZModeListener();
        zmode0.setActionCommand("0");
        zmode1.setActionCommand("1");
        zmode2.setActionCommand("2");
        zmode0.addActionListener(zModeListener);
        zmode1.addActionListener(zModeListener);
        zmode2.addActionListener(zModeListener);
        zmode0.setSelected(true);
        zmode.add(zmode0);
        zmode.add(zmode1);
        zmode.add(zmode2);
        zmode0.setToolTipText("Use variables as-is from the source CDF");
        zmode1.setToolTipText("Use zMode/1 for variables in the source CDF");
        zmode2.setToolTipText("Use zMode/2 for variables in the source CDF");
        zmodePanel.setLayout(new FlowLayout());
        zmodePanel.add(zmode0);
        zmodePanel.add(zmode1);
        zmodePanel.add(zmode2);

	makeJButton(panel2n, pgc, 0, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 1, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, ric, 2, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 3, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, uvc, 4, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, ufc, 0, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 1, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, rwc, 2, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 3, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, usc, 4, 1, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, rcc, 0, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 1, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, rec, 2, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 3, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, umc, 4, 2, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, uic, 0, 3, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 1, 3, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, dsc, 2, 3, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, Box.createRigidArea(hpad40), 3, 3, 1, 1, 1.0, 1.0);
        makeJButton(panel2n, zzc, 4, 3, 1, 1, 1.0, 1.0);
	makeJButton(panel2n, abc, 0, 4, 1, 1, 1.0, 1.0);
	makeJButton(panel2n, Box.createRigidArea(hpad40), 1, 4, 1, 1, 1.0, 1.0);
//	makeJButton(panel2n, bac, 2, 4, 1, 1, 1.0, 1.0);	
        tpanel1.add(ZMODE,BorderLayout.WEST);
        tpanel1.add(zmodePanel, BorderLayout.CENTER);
        tpanel1.add(Box.createRigidArea(hpad20), BorderLayout.EAST);
        makeJButton(panel2n, tpanel1, 2, 4, 1, 1, 1.0, 1.0);
//        makeJButton(panel2n, Box.createRigidArea(hpad40), 1, 4, 1, 1, 1.0, 1.0);
//	makeJButton(panel2n, abc, 0, 4, 1, 1, 1.0, 1.0);
//        makeJButton(panel2n, Box.createRigidArea(hpad40), 3, 4, 1, 1, 1.0, 1.0);
//	makeJButton(panel2n, bac, 2, 4, 1, 1, 1.0, 1.0);
        makeJButton(panel2s, CASS, 0, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2s, Box.createRigidArea(hpad10), 1, 0, 1, 1, 1.0, 1.0);
        makeJButton(panel2s, cachesizes, 2, 0, 2, 1, 1.0, 1.0);
        makeJButton(panel2s, Box.createRigidArea(hpad80), 3, 0, 1, 1, 1.0, 1.0);
	makeJButton(panel2s, Box.createRigidArea(vpad20), 0, 1, 2, 1, 1.0, 1.0);
        panel2.add(panel2n, BorderLayout.NORTH);
        panel2.add(panel2s, BorderLayout.SOUTH);

	pgc.addItemListener(this);
	pgc.setToolTipText("Select to display the output one page at a time -- not avaiable for Java");
        ric.addItemListener(this);
	ric.setToolTipText("Select to report informational messages from the CDF library calls");
        uvc.addItemListener(this);
	uvc.setToolTipText("Select to update VALIDMIN/MAX attribute entry values for each variable");
        rwc.addItemListener(this);
        rwc.setToolTipText("Select to report warning messages from the CDF library calls");
        ufc.addItemListener(this);
	ufc.setToolTipText("Select to use FORMAT attribute when writing variable statistics");
        rec.addItemListener(this);
        rec.setToolTipText("Select to report error messages from the CDF library calls");
        uic.addItemListener(this);
	uic.setToolTipText("Select to use filled values when collecting statistics");
        umc.addItemListener(this);
	umc.setToolTipText("Select to update MONOTONIC attribute entry values for each variable");
        rcc.addItemListener(this);
	rcc.setToolTipText("Select to use VALIDMIN/MAX attribute for range checking");
        dsc.addItemListener(this);
        dsc.setToolTipText("Select to display caching statistics at the end of report");
        usc.addItemListener(this);
	usc.setToolTipText("Select to update SCALEMIN/MAX attribute entry values for each variable");
        zzc.addItemListener(this);
        zzc.setToolTipText("Select to convert -0.0 to 0.0");
	abc.addItemListener(this);
        abc.setToolTipText("Display the current version");
	bac.addItemListener(this);
        bac.setToolTipText("Select to set up and run the statistics reporting by a batch job");
        cachesizes.addActionListener(this);
        cachesizes.addFocusListener(this);
        cachesizes.addMouseListener(this);
	cachesizes.setToolTipText("Enter the cache sizes for dotCDF, staging and compression scratch files in 512 bytes buffer");
        CASS.setFont(boldFont);
        cachesizes.setFont(boldFont);


        dialog.getContentPane().add(panel2,BorderLayout.CENTER);

        // Panel 3 (buttons and text area)

        panel31.add(entrb);
        panel31.add(helpb);
        panel31.add(quitb);
  	panel3.add(panel31, BorderLayout.NORTH);
	panel3.add(Box.createRigidArea(vpad30),BorderLayout.CENTER);

        // Listen for events on buttons
        entrb.addActionListener(this);
        entrb.setToolTipText("Run CDFStats");
        helpb.addActionListener(this);
        helpb.setToolTipText("Get the complete help information");
        quitb.addActionListener(this);
        quitb.setToolTipText("Exit CDFStats");

	// Text Area
  	info.setEditable(false);
        scroller = new JScrollPane() {
               static final long serialVersionUID = 1L;

                public Dimension getPreferredSize() {
                   return new Dimension(80, 160);
                }
                public float getAlignmentX() {
                   return LEFT_ALIGNMENT;
                }
        };
        scroller.getViewport().add(info);
        panel3.add(scroller, BorderLayout.SOUTH);
  	info.setVisible(true);

  	dialog.getContentPane().add(panel3, BorderLayout.SOUTH);
    }

/** Implement the run method for Runabout interface.
 */

    public void run() {
	buildGUI();
        dialog.pack();
	fileChooser.setCurrentDirectory(new File(currentdir));
        dialog.setVisible(true);
	if (parentDriver != null) parentDriver.setVisible(false);

    }

/** Reenter from the main toolkit driver. Reset the dialog to visible.
 */

    public void reEnter() {
        dialog.setVisible(true);
	if (parentDriver != null) parentDriver.setVisible(false);
        info.setText("");
	cdf.setText("");
	outf.setText("");
	cachesizes.setText("");
    }


/** Action for buttons or menu items selection
 */

    public void actionPerformed(ActionEvent evt) {
	Object obj = evt.getSource();
	if (obj == quitb || obj == menuFileExit) { // for "Quit" or "Exit"
	     if (frommain == 0) {
                if (modal) dialog.dispose();
                else dialog.setVisible(false);
		if (parentDriver != null) parentDriver.setVisible(true);
	     } else {System.exit(1);}
	}
	else if (obj == slt1 || obj == slt2) { // for "Select 1|2" button
             if (obj == slt1) { // for "Select1" button
		doFileChooser("Select/enter the CDF", cdf, 1, filter);
             } else { // for "Select2" button
		doFileChooser("Select/enter the output file", outf, 1, null);
             }
	} else if (obj == helpb || obj == menuHelpHelp) { // for "Help" 
                 commandX = command + "-java";
                 hlp = 1;
                 String OS = System.getProperty("os.name").toLowerCase();
                 if (OS.indexOf("windows") != -1) {
                     cmds[0] = commandX;
                 } else if (OS.indexOf("vms") != -1) {
                     cmds[0] = commandX;
                 } else {
		     cmds[0] = "/bin/sh";
		     cmds[1] = "-c";
		     cmds[2] = commandX;
                }
		runit(cmds);
//		runit(commandX);
		hlp = 0;
	} else if (obj == entrb) { // for "Enter" button
                cdfspec = cdf.getText();
                filespec = outf.getText();
                if (cdfspec.equals("") || cdfspec.trim().equals("")) {
                  info.setText("");
                  info.append("Please enter a CDF file...");
                  Toolkit.getDefaultToolkit().beep();
                  return;
                } else
                  cdfspec = cdfspec.trim();
/*
                if (iba == 1) {
                  if (filespec.equals("") || filespec.trim().equals("")) {
                    info.setText("");
                    info.append("Please enter the output file for the batch run...");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                  }
                }
*/
		temp = strri + strrw + strre;
		if (temp.length() == 0) report = " ";
		else if (temp.length() == 3) report = "-report \"i,w,e\" ";
		else if (temp.length() == 1) {
		   if (strri.length() == 1) report = "-report \"i\" ";
		   if (strrw.length() == 1) report = "-report \"w\" ";
		   if (strre.length() == 1) report = "-report \"e\" ";
		} else {
		   if (strri.length() == 0) report = "-report \"w,e\" ";
		   if (strrw.length() == 0) report = "-report \"i,e\" ";
		   if (strre.length() == 0) report = "-report \"i,w\" ";
		}

		if (strzm.equals("")) Zmode = " ";
		else Zmode = "-zmode " + strzm + " ";

		xxx = " ";
		if (!filespec.equals("") && !filespec.trim().equals("")) {
                  filespec = filespec.trim();
		  String fileDelimiter;
                  if (filespec.startsWith("'")) fileDelimiter = " ";
                  else if (filespec.startsWith("\"")) fileDelimiter = " ";
                  else fileDelimiter = "\"";
                  xxx = "-output " + fileDelimiter + filespec +
                        fileDelimiter + " ";
                  iba = 1;
                } else
                  iba = 0;

                strcs = cachesizes.getText();
                if (strcs.equals("") || strcs.trim().equals("")) Caches = " ";
                  else if (caches.startsWith("\"") || caches.startsWith("\'"))
                         Caches = "-cache " + caches.substring(1,caches.length()-2) + " ";
                       else Caches = "-cache " + caches + " ";

		if (cdfspec.startsWith("'")) cdfDelimiter = " ";
		else if (cdfspec.startsWith("\"")) cdfDelimiter = " ";
		else cdfDelimiter = "\"";
		
                commandX = command + strpo + struf + strrc + strui +
                           struv   + strus + strum + strzz + strds + 
			   report + Zmode + Caches + xxx + cdfDelimiter +
			   cdfspec + cdfDelimiter;
               
//		commandX = command + strpo + struf + strrc + strui +
//                           struv   + strus + strum + strzz + strds + 
//			   report + Zmode + Caches + xxx + " " + cdfspec;

                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.indexOf("windows") != -1) {
                    cmds[0] = commandX;
                } else if (OS.indexOf("vms") != -1) {
                    commandX = commandX.replace('-', '/');
                    cmds[0] = commandX;
                } else {
		    cmds[0] = "/bin/sh";
		    cmds[1] = "-c";
		    cmds[2] = commandX;
		}
		runit(cmds);
//		runit(commandX);
	} else if (obj == cdf) {
		cdfspec = cdf.getText();
	} else if (obj == outf) {
                filespec = outf.getText();
	} else if (obj == cachesizes) {
		strcs = cachesizes.getText();
	} else if (obj == menuEditCopy) {
                if (istart == -1) {
		    info.setText("Where to copy from?");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    focused.setSelectionStart(istart);
                    focused.setSelectionEnd(iend);
                    focused.copy();
                }
        } else if (obj == menuEditCut) {
                if (istart == -1) {
		    info.setText("What to cut?");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    focused.setSelectionStart(istart);
                    focused.setSelectionEnd(iend);
                    focused.cut();
                }
        } else if (obj == menuEditPaste) {
                if (focused == null) {
		    info.setText("Where to paste to?");
                    Toolkit.getDefaultToolkit().beep();
                } else {
                  if (istart != -1) {
                    focused.setSelectionStart(istart);
                    focused.setSelectionEnd(iend);
                  }
                  String tempN;
                  try {
                    tempN = (String) Toolkit.getDefaultToolkit().
                                    getSystemClipboard().getContents(this).
                                    getTransferData(DataFlavor.stringFlavor);
                    if (tempN == null) { // no clipboard text
                        info.setText("No current selection on clipboard");
                        Toolkit.getDefaultToolkit().beep();
                    } else if (tempN.indexOf("\n") != -1) { // multiple lines
                        info.setText("Multiple lines selection on clipboard - not allowed:");
                        info.append("\n\n");
                        info.append(tempN);
                        Toolkit.getDefaultToolkit().beep();
                    } else { focused.paste();}
                  } catch (Exception e) {}
                }
        }
    }

/** Action for radio buttons for zMode
 */

    class ZModeListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
           strzm = e.getActionCommand();
        }
    }

/** Action for checkboxs selection
 */

    public void itemStateChanged(ItemEvent evt) {
	Object obj = evt.getSource();
	if (obj == pgc) { // "Page Output" checkbox
	   if (pgc.isSelected()) {
		info.setText("");
		info.append("Page output is not allowed in Java");
		Toolkit.getDefaultToolkit().beep();
		pgc.setSelected(false);
	        strpo = "-nopage ";
	 	}
	} else if (obj == abc) { // "About" checkbox
	   if (abc.isSelected()) {
		abcX = 1;
                commandX = command + " -about";
                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.indexOf("windows") != -1) {
                    cmds[0] = commandX;
                } else if (OS.indexOf("vms") != -1) {
                    cmds[0] = commandX;
                } else {
		    cmds[0] = "/bin/sh";
		    cmds[1] = "-c";
		    cmds[2] = commandX;
		}
		runit(cmds);
//		runit(commandX);
                abc.setSelected(false);
		abcX = 0;
	   }
	} else if (obj == ric) { // "Report Info's" checkbox
           if (ric.isSelected()) {
		strri = "i";
		ricX = 1;
	   } else {
		strri = "";
		ricX = 0;
	   }
        } else if (obj == rwc) { // "Report Warnings" checkbox 
           if (rwc.isSelected()) {
                strrw = "w";
		rwcX = 1;
           } else {
                strrw = "";
		rwcX = 0;
	   }
        } else if (obj == rec) { // "Report Errors" checkbox
           if (rec.isSelected()) {
                strre = "e";
		recX = 1;
           } else {
                strre = "";
		recX = 0;
	   }
        } else if (obj == ufc) { // "Use Format" checkbox
           if (ufc.isSelected())
                struf = "-format ";
           else
                struf = "-noformat ";
        } else if (obj == uic) { // "Use FILLVAL" checkbox
           if (uic.isSelected())
                strui = "-fill ";
           else
                strui = "-nofill ";
        } else if (obj == rcc) { // "Range Checking" checkbox
           if (rcc.isSelected())
                strrc = "-range ";
           else
                strrc = "-norange ";
	} else if (obj == zzc) { // "-0.0 to 0.0" checkbox
           if (zzc.isSelected())
                strzz = "-neg2posfp0 ";
           else
                strzz = "-noneg2posfp0 ";
	} else if (obj == dsc) { // "Display Statistics" checkbox
           if (dsc.isSelected()) {
                strds = "-statistics ";
		dscX = 1;
           } else {
                strds = "-nostatistics ";
		dscX = 0;
	   }
        } else if (obj == uvc) { // "Update VALIDMIN/MAX" checkbox
           if (uvc.isSelected())
                struv = "-update_valids ";
           else
                struv = "-noupdate_valids ";
        } else if (obj == usc) { // "Update SCALEMIN/MAX" checkbox
           if (usc.isSelected())
                strus = "-update_scales ";
            else
                strus = "-noupdate_scales ";
        } else if (obj == umc) { // "Update MONOTONIC" checkbox
           if (umc.isSelected())
                strum = "-update_monotonic ";
           else
                strum = "-noupdate_monotonic ";
	} else if (obj == bac) { // "Run it Batch" checkbox
	   if (bac.isSelected()) {
		iba = 1;
		if (cdf.getText().equals("")) {
		   info.setText("");
		   info.append("Please enter a CDF file for a batch run...");
                   Toolkit.getDefaultToolkit().beep();
		}
	   } else
		iba = 0;
	}
    }

    public void focusGained(FocusEvent e) {
        focused = (JTextField)e.getSource();
        if (prevfocused != null) {
            prevfocused.setText(prevfocused.getText());
            if (iend != -1)
                if (iend < focused.getText().length())
                             prevfocused.setCaretPosition(iend);
                else focused.setCaretPosition(focused.getText().length());
        }
    }

    public void focusLost(FocusEvent e) {
        if (istart != -1)     {
            focused.setSelectionStart(istart);
            focused.setSelectionEnd(iend);
            prevfocused = focused;
          }
        }
    public void mouseClicked(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {
        if (focused != null) {
          String selectedText = focused.getSelectedText();
          if (selectedText!=null) {
            istart = focused.getSelectionStart();
            iend = focused.getSelectionEnd();
          } else {
            istart = -1;
            iend = -1;
          }
        }
    }

/** Set up gridbaglayout
 */

    private void makeJButton(Container cont, Object arg,
            int x, int y, int w, int h, double weightx, double weighty) {
        GridBagLayout gbl = (GridBagLayout)cont.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        Component comp;

        c.fill = GridBagConstraints.BOTH;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.gridheight = h;
        c.weightx = weightx;
        c.weighty = weighty;
        if (arg instanceof String) {
            comp = new JButton((String)arg);
        } else {
            comp = (Component)arg;
        }
        cont.add(comp);
        gbl.setConstraints(comp, c);
    }

/** Execute a command as a separate process for the user selection and returns
    the results in the text area.
 */

     private void runit(String[] command) {
//    private void runit(String command) {
	try {
              if (command[1] != null) 
                process = runtime.exec(command);
              else
                process = runtime.exec(command[0]);
/*
              if (iba == 1 && hlp == 0 && abcX == 0) {
                 info.setText("Program is submitted...\n\n");
                 int idx = filespec.indexOf('.');
		 info.append("A statistics file: " + filespec + 
				(idx != -1 ? "" : ".sts") + " will/may be created.");
              } else {
                if (abcX == 0 && hlp == 0) {
                   info.setText("");
                   info.append("Program is running...\n");
                }
              }
*/
              Dimension dialogSize = dialog.getSize();
              ((JComponent)(dialog.getContentPane())).paintImmediately(
                                              0, 0, dialogSize.width, dialogSize.height);
              BufferedReader inStream = null;
              String line = null;
              inStream = new BufferedReader(new
                                      InputStreamReader(process.getInputStream()), 8192);
	      boolean first = true;	
//              if (hlp == 1 || abcX == 1 || ricX == 1 || rwcX == 1 || recX == 1 ||
//                    dscX == 1) {
                while ((line = inStream.readLine()) != null) {
		    if (first) {
			info.setText("");
			first =false;
		    }
                    info.append(line+"\n");
		}
//              }
              process.waitFor();
	      info.setCaretPosition(0);
              if (process.exitValue() == 1) {
		  Toolkit.getDefaultToolkit().beep();
		  info.append("ERROR: error is detected... job failed\n");
	      } else { 
                scroller.getViewport().setView(info);
                scroller.revalidate();
                scroller.repaint();
		if (iba == 1) {
                     if (info.getText().toLowerCase().indexOf("error") == -1) {
                       info.append("Done!\n\n");
//                       info.append("A statistics file: "+myString+"   is created.");
		     } else {
		       info.append("ERROR: check the statistics file for error information.");
		     }
		}
              }
        } catch (Exception e) {
              info.setText("error executing: "+e);
	      Toolkit.getDefaultToolkit().beep();
        }
    }

/** Initiate the file chooser and strip the extension for the selected file
    if necessary
 */

    private void doFileChooser (String title, JTextField textField, int theone, SimpleFileFilter filter) {
//        JFileChooser fileChooser = new JFileChooser();
	ExampleFileView fileView = new ExampleFileView();
//        fileChooser.setCurrentDirectory(new File(currentdir));
        fileChooser.setDialogTitle(title);
        if (filter != null) {
	   fileChooser.addChoosableFileFilter(filter);
	   fileChooser.setFileFilter(filter);
	}
        try {
           fileView.putIcon("cdf",
                            new ImageIcon(CDFStats.class.getResource("CDF_Logo3.gif")));
           fileView.putIcon("CDF",
                            new ImageIcon(CDFStats.class.getResource("CDF_Logo3.gif")));
           fileChooser.setFileView(fileView);
        } catch (Exception e) {}

        int returnValue = fileChooser.showDialog(dialog, "OK");
        if (returnValue == JFileChooser.APPROVE_OPTION) {
           File selectedFile = fileChooser.getSelectedFile();
           if (selectedFile != null) {
              int ind;
              String myfile = selectedFile.getAbsolutePath();
              if (theone == 1) { // for .cdf file
                  ind = myfile.lastIndexOf(".cdf");
                  if (ind != -1) myfile = myfile.substring(0, ind);
                  ind = myfile.lastIndexOf(".CDF");
                  if (ind != -1) myfile = myfile.substring(0, ind);
              } else { // for .skt file
                  ind = myfile.lastIndexOf(".skt");
                  if (ind != -1) myfile = myfile.substring(0, ind);
                  ind = myfile.lastIndexOf(".SKT");
                  if (ind != -1) myfile = myfile.substring(0, ind);
              }
	      fileChooser.setCurrentDirectory(selectedFile);
              textField.setText(myfile);
           }
        } else {
//                JOptionPane.showMessageDialog(dialog, "No file chosen");
        }
    }

/** This class can run as an application by its own.
 */

    static public void main(String[] args) {

        String cdfbase = System.getProperty("CDF_BASE");
        if (cdfbase == null)
            cdfbase = CDFToolsUtil.getenv("CDF_BASE");

	CDFStats thispgm = new CDFStats(null, cdfbase);
	thispgm.fileChooser.setCurrentDirectory(new File(thispgm.currentdir));
	thispgm.frommain = 1;
	thispgm.run();
    }

}

