//$Id: EpochNative.java,v 1.1.1.1 2009/01/20 16:27:22 liu Exp $

package gsfc.nssdc.cdf.util;

import java.util.*;

/**
 * The Epoch class is a Java wrapper to the CDF epoch handling routines.  See
 * Chapter 8 of the CDF C Reference Manual Version 2.6 for details
 *
 * <B>Example:</B>
 * <PRE> 
 * // Get the milliseconds to Aug 5, 1990 at 5:00
 * double ep = Epoch.compute(1990, 8, 5, 5, 0, 0, 0);
 * //Get the year, month, day, hour, minutes, seconds, milliseconds for ep
 * long times[] = Epoch.breakdown(ep);
 * for (int i=0;i<times.length;i++)
 *     System.out.print(times[i]+" ");
 * System.out.println();
 * // Printout the epoch in various formats
 * System.out.println(Epoch.encode(ep));
 * System.out.println(Epoch.encode1(ep));
 * System.out.println(Epoch.encode2(ep));
 * System.out.println(Epoch.encode3(ep));
 * // Print out the date using format
 * String format = "<month> <dom.02>, <year> at <hour>:<min>";
 * System.out.println(Epoch.encodex(ep,format));
 * </PRE>
 */
public class EpochNative {

    /**
     * Mirrors computeEPOCH from the CDF library. See Section 8.1 of the 
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static double compute(long year, 
					long month, 
					long day, 
					long hour,
					long minute,
					long second,
					long msec);

    /**
     * Mirrors EPOCHbreakdown from the CDF library. See Section 8.2 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static long[] breakdown(double epoch);

    /**
     * Mirrors encodeEPOCH from the CDF library. See Section 8.3 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static String encode(double epoch);

    /**
     * Mirrors encodeEPOCH1 from the CDF library. See Section 8.4 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static String encode1(double epoch);

    /**
     * Mirrors encodeEPOCH2 from the CDF library. See Section 8.5 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static String encode2(double epoch);

    /**
     * Mirrors encodeEPOCH3 from the CDF library. See Section 8.6 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static String encode3(double epoch);

    /**
     * Mirrors encodeEPOCHx from the CDF library. See Section 8.7 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static String encodex(double epoch, String format);

    /**
     * Mirrors parseEPOCH from CDF library.  See Section 8.8 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static double parse(String sEpoch);

    /**
     * Mirrors parseEPOCH from CDF library.  See Section 8.9 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static double parse1(String sEpoch);

    /**
     * Mirrors parseEPOCH from CDF library.  See Section 8.10 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static double parse2(String sEpoch);

    /**
     * Mirrors parseEPOCH from CDF library.  See Section 8.11 of the
     * CDF C Reference Manual Version 2.6 for details
     */
    public native static double parse3(String sEpoch);

    static {
	System.loadLibrary("cdfNativeLibrary");
    }
}
