// $Id: CDFObject.java,v 1.1.1.1 2009/01/20 16:27:22 liu Exp $
package gsfc.nssdc.cdf;

import java.lang.String;

/**
 *
 * CDFObject provides the base interface for all CDF objects.
 * CDF objects mean the CDF, Attribute, Entry and Variable objects.
 * All these objects need to implement this interface.
 *
 * @author Phil Williams, QSS Group Inc/RITSS
 * @version 1.0  
 */
public interface CDFObject {
    
    /**
     * Returns the name of the current object.
     * @return the name of the current object
     */
    public String getName();

    /**
     * Renames the current object.
     *
     * @param name the new object name 
     * @exception CDFException if an error occurs renaming the current object
     */
    public void   rename(String name) throws CDFException;

    /**
     * Deletes the current object.
     *
     * @exception CDFException if an error occurs deleting the current object
     */
    public void   delete() throws CDFException;
}

