/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.Variable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class NewVariableAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "New Variable";
    private MYEditor myEditor;

    public NewVariableAction(MYEditor mYEditor) {
        this(mYEditor, DEFAULT_NAME);
    }

    public NewVariableAction(MYEditor mYEditor, String string) {
        super(string);
        this.myEditor = mYEditor;
    }

    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        if (this.myEditor.theCDF == null) {
            JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "Must open a CDF before creating variables.", "MYEditor: Error", 0);
        } else {
            Variable variable = NewVariableDialog.createVariable(this.myEditor.getFrame(), this.myEditor.theCDF);
            if (variable != null) {
                this.myEditor.variablePanel.addToListOfVariables(variable);
                this.myEditor.variablePanel.updateVarPanel(variable);
                this.myEditor.variablePanel.reselectCurrentVariable();
                if (this.myEditor.vAttrPanel.getSelectedAttr() != null) {
                    Attribute attribute = this.myEditor.vAttrPanel.getSelectedAttr();
                    this.myEditor.vAttrPanel.getvDisplay().buildTable(attribute);
                    JScrollPane jScrollPane = new JScrollPane(this.myEditor.vAttrPanel.getvDisplay().getTable());
                    this.myEditor.vAttrPanel.getRightPanel().add((Component)jScrollPane, "Center");
                }
                this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                this.myEditor.vAttrPanel.getRightPanel().revalidate();
                this.myEditor.vAttrPanel.getRightPanel().repaint();
                this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                this.myEditor.gAttrPanel.getRightPanel().revalidate();
                this.myEditor.gAttrPanel.getRightPanel().repaint();
            }
        }
        this.myEditor.setDefaultCursor();
    }
}

