/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FloatNumberField
extends NumberField {
    static final long serialVersionUID = 1L;

    public FloatNumberField(float f, int n) {
        super(n);
        this.formatter = NumberFormat.getNumberInstance(Locale.US);
        this.formatter.setParseIntegerOnly(false);
        this.formatter.setMaximumIntegerDigits(5);
        this.formatter.setMaximumFractionDigits(2);
        this.setText(new Float(f).toString());
    }

    public Document createDefaultModel() {
        return new PlainDocument(){
            static final long serialVersionUID = 1L;

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                String string2 = this.getText(0, this.getLength());
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n, string2.length());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                stringBuffer.append(string);
                stringBuffer.append(string4);
                try {
                    FloatNumberField.this.formatter.parse(stringBuffer.toString());
                    super.insertString(n, string, attributeSet);
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
    }

    public Document createDefaultModelOLD() {
        return new PlainDocument(){
            static final long serialVersionUID = 1L;

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                int n2;
                int n3;
                char[] cArray = this.getText(0, this.getEndPosition().getOffset()).toCharArray();
                char[] cArray2 = string.toCharArray();
                char[] cArray3 = new char[cArray2.length];
                int n4 = 0;
                boolean bl = false;
                for (n3 = 0; n3 < cArray.length; ++n3) {
                    if (cArray[n3] != '.') continue;
                    bl = true;
                    break;
                }
                n3 = 0;
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (cArray[n2] != 'E') continue;
                    n3 = 1;
                    break;
                }
                for (n2 = 0; n2 < cArray3.length; ++n2) {
                    if (Character.isDigit(cArray2[n2]) || cArray2[n2] == '.' && !bl || n != 0 && n3 == 0 && cArray2[n2] == 'E' || n == 0 && cArray2[n2] == '-') {
                        cArray3[n4++] = cArray2[n2];
                        continue;
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
                super.insertString(n, new String(cArray3, 0, n4), attributeSet);
            }
        };
    }

    public Integer getInteger() {
        try {
            return new Integer(this.formatter.parse(this.getText()).intValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Long getLong() {
        try {
            return new Long(this.formatter.parse(this.getText()).longValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Float getFloat() {
        try {
            return new Float(this.formatter.parse(this.getText()).floatValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Double getDouble() {
        try {
            return new Double(this.formatter.parse(this.getText()).doubleValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

