/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class DeleteVariableAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "Delete Variable";
    private MYEditor myEditor;

    public DeleteVariableAction(MYEditor mYEditor) {
        this(mYEditor, DEFAULT_NAME);
    }

    public DeleteVariableAction(MYEditor mYEditor, String string) {
        super(string);
        this.myEditor = mYEditor;
    }

    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        Variable variable = this.myEditor.variablePanel.getSelectedVar();
        if (variable == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, "No variable selected", "MYEditor: Error", 0);
        } else {
            int n = JOptionPane.showConfirmDialog(this.myEditor, "Do you want to delete Variable: " + variable.toString(), "Delete zVariable", 0);
            if (n == 0) {
                this.myEditor.setWaitCursor();
                try {
                    this.myEditor.variablePanel.deleteSelectedVar();
                    this.myEditor.variablePanel.updateVarPanel(null);
                    if (this.myEditor.vAttrPanel.getSelectedAttr() != null) {
                        this.myEditor.vAttrPanel.updateAttrPanel(this.myEditor.vAttrPanel.getSelectedAttr(), true);
                    }
                    int n2 = CDFToolUtils.getMaxRecNum(this.myEditor.theCDF);
                    this.myEditor.gAttrPanel.setMaxWritten(n2);
                    this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    this.myEditor.vAttrPanel.getRightPanel().revalidate();
                    this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    this.myEditor.gAttrPanel.getRightPanel().revalidate();
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor, "CDF Error:\n" + CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
                }
            }
        }
        this.myEditor.setDefaultCursor();
    }
}

