/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Array;

public class DefaultDataTableModel
extends AbstractDataTableModel {
    static final long serialVersionUID = 1L;
    public static final int ROW_MAJOR = 1;
    public static final int COLUMN_MAJOR = 2;
    private int _rows;
    private int _cols;
    protected String[] columnNames = new String[0];
    private Object _data;
    private boolean cellEditable;
    private int majority;

    public int getMajority() {
        return this.majority;
    }

    public void setMajority(int n) {
        this.majority = n;
    }

    public DefaultDataTableModel() {
        this._data = null;
        this._rows = 0;
        this._cols = 0;
        this.majority = 1;
        this.cellEditable = true;
    }

    public DefaultDataTableModel(boolean bl) {
        this._data = null;
        this._rows = 0;
        this._cols = 0;
        this.majority = 1;
        this.cellEditable = bl;
    }

    public DefaultDataTableModel(Object object, int n) throws IllegalArgumentException {
        this.majority = n;
        this.cellEditable = true;
        this.setData(object);
    }

    public DefaultDataTableModel(Object object, int n, boolean bl) throws IllegalArgumentException {
        this.majority = n;
        this.setData(object);
        this.cellEditable = bl;
    }

    public DefaultDataTableModel(Object object) throws IllegalArgumentException {
        this(object, 1);
    }

    public DefaultDataTableModel(Object object, boolean bl) throws IllegalArgumentException {
        this(object, 1, bl);
    }

    public void setCellEditable(boolean bl) {
        this.cellEditable = bl;
    }

    public String getColumnName(int n) {
        if (this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return " ";
    }

    public Class getColumnClass(int n) {
        switch (this._type) {
            case 'B': {
                return Byte.class;
            }
            case 'S': {
                return Short.class;
            }
            case 'I': {
                return Integer.class;
            }
            case 'J': {
                return Long.class;
            }
            case 'F': {
                return Float.class;
            }
            case 'D': {
                return Double.class;
            }
            case 'L': {
                return String.class;
            }
            case 'Z': {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.cellEditable) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        if (this.majority == 1) {
            n3 = n;
            n4 = n2;
        } else {
            n3 = n2;
            n4 = n;
        }
        return n4 < Array.getLength(Array.get(this._data, n3));
    }

    public int getColumnCount() {
        return this._cols;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getValueAt(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.majority == 1) {
            n3 = n;
            n4 = n2;
        } else {
            n3 = n2;
            n4 = n;
        }
        switch (this._type) {
            case 'B': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Byte(((byte[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'S': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Short(((short[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'I': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Integer(((int[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'J': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Long(((long[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'F': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Float(((float[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'D': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Double(((double[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'Z': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return new Boolean(((boolean[][])this._data)[n3][n4]);
                }
                return null;
            }
            case 'L': {
                if (n4 < Array.getLength(Array.get(this._data, n3))) {
                    return Array.get(Array.get(this._data, n3), n4);
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object != null) {
            int n3 = 0;
            int n4 = 0;
            if (this.majority == 1) {
                n3 = n;
                n4 = n2;
            } else {
                n3 = n2;
                n4 = n;
            }
            switch (this._type) {
                case 'B': {
                    if (object instanceof String) {
                        try {
                            ((byte[][])this._data)[n3][n4] = new Byte((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((byte[][])this._data)[n3][n4] = 0;
                        }
                        break;
                    }
                    if (object instanceof Byte) {
                        ((byte[][])this._data)[n3][n4] = (Byte)object;
                        break;
                    }
                    ((byte[][])this._data)[n3][n4] = 0;
                    break;
                }
                case 'S': {
                    if (object instanceof String) {
                        try {
                            ((short[][])this._data)[n3][n4] = new Short((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((short[][])this._data)[n3][n4] = 0;
                        }
                        break;
                    }
                    if (object instanceof Short) {
                        ((short[][])this._data)[n3][n4] = (Short)object;
                        break;
                    }
                    ((short[][])this._data)[n3][n4] = 0;
                    break;
                }
                case 'I': {
                    if (object instanceof String) {
                        try {
                            ((int[][])this._data)[n3][n4] = new Integer((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((int[][])this._data)[n3][n4] = 0;
                        }
                        break;
                    }
                    if (object instanceof Integer) {
                        ((int[][])this._data)[n3][n4] = (Integer)object;
                        break;
                    }
                    ((int[][])this._data)[n3][n4] = 0;
                    break;
                }
                case 'J': {
                    if (object instanceof String) {
                        try {
                            ((long[][])this._data)[n3][n4] = new Long((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((long[][])this._data)[n3][n4] = 0L;
                        }
                        break;
                    }
                    if (object instanceof Long) {
                        ((long[][])this._data)[n3][n4] = (Long)object;
                        break;
                    }
                    ((long[][])this._data)[n3][n4] = 0L;
                    break;
                }
                case 'F': {
                    if (object instanceof String) {
                        try {
                            ((float[][])this._data)[n3][n4] = new Float((String)object).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((float[][])this._data)[n3][n4] = 0.0f;
                        }
                        break;
                    }
                    if (object instanceof Float) {
                        ((float[][])this._data)[n3][n4] = ((Float)object).floatValue();
                        break;
                    }
                    ((float[][])this._data)[n3][n4] = 0.0f;
                    break;
                }
                case 'D': {
                    if (object instanceof String) {
                        try {
                            ((double[][])this._data)[n3][n4] = new Double((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((double[][])this._data)[n3][n4] = 0.0;
                        }
                        break;
                    }
                    if (object instanceof Double) {
                        ((double[][])this._data)[n3][n4] = (Double)object;
                        break;
                    }
                    ((double[][])this._data)[n3][n4] = 0.0;
                    break;
                }
                case 'Z': {
                    if (object instanceof String) {
                        ((boolean[][])this._data)[n3][n4] = new Boolean((String)object);
                        break;
                    }
                    if (object instanceof Boolean) {
                        ((boolean[][])this._data)[n3][n4] = (Boolean)object;
                        break;
                    }
                    ((boolean[][])this._data)[n3][n4] = false;
                    break;
                }
                case 'L': {
                    Array.set(Array.get(this._data, n3), n4, object);
                }
            }
        }
    }

    public void setData(Object object) throws IllegalArgumentException {
        int n;
        if (object != null) {
            n = 0;
            n = object.getClass().getName().lastIndexOf("[") + 1;
            if (n > 2) {
                throw new IllegalArgumentException("Data must be < 2D");
            }
            String string = object.getClass().getName();
            if (string.indexOf("L") > 0) {
                if (!(object instanceof Number) && string.indexOf("String") < 0) {
                    throw new IllegalArgumentException("Bad data value");
                }
                this._type = (char)76;
            } else {
                this._type = string.toCharArray()[string.length() - 1];
            }
            switch (n) {
                case 0: {
                    this._rows = 1;
                    this._cols = 1;
                    if (object instanceof Byte) {
                        this._data = new byte[1][1];
                        ((byte[][])this._data)[0][0] = (Byte)object;
                        this._type = (char)66;
                        break;
                    }
                    if (object instanceof Boolean) {
                        this._data = new boolean[1][1];
                        ((boolean[][])this._data)[0][0] = (Boolean)object;
                        this._type = (char)90;
                        break;
                    }
                    if (object instanceof Character) {
                        this._data = new char[1][1];
                        ((char[][])this._data)[0][0] = ((Character)object).charValue();
                        this._type = (char)67;
                        break;
                    }
                    if (object instanceof Short) {
                        this._data = new short[1][1];
                        ((short[][])this._data)[0][0] = (Short)object;
                        this._type = (char)83;
                        break;
                    }
                    if (object instanceof Integer) {
                        this._data = new int[1][1];
                        ((int[][])this._data)[0][0] = (Integer)object;
                        this._type = (char)73;
                        break;
                    }
                    if (object instanceof Long) {
                        this._data = new long[1][1];
                        ((long[][])this._data)[0][0] = (Long)object;
                        this._type = (char)74;
                        break;
                    }
                    if (object instanceof Float) {
                        this._data = new float[1][1];
                        ((float[][])this._data)[0][0] = ((Float)object).floatValue();
                        this._type = (char)70;
                        break;
                    }
                    if (object instanceof Double) {
                        this._data = new double[1][1];
                        ((double[][])this._data)[0][0] = (Double)object;
                        this._type = (char)68;
                        break;
                    }
                    this._data = new String[1][1];
                    ((String[][])this._data)[0][0] = object.toString();
                    this._type = (char)76;
                    break;
                }
                case 1: {
                    if (this.majority == 1) {
                        this._rows = 1;
                        this._cols = Array.getLength(object);
                    } else {
                        this._rows = Array.getLength(object);
                        this._cols = 1;
                    }
                    this._data = this.newDataObject(this._rows, this._cols);
                    Array.set(this._data, 0, object);
                    break;
                }
                case 2: {
                    int n2;
                    if (this.majority == 1) {
                        this._rows = Array.getLength(object);
                        this._cols = 0;
                        for (n2 = 0; n2 < this._rows; ++n2) {
                            if (Array.getLength(Array.get(object, n2)) <= this._cols) continue;
                            this._cols = Array.getLength(Array.get(object, n2));
                        }
                    } else {
                        this._cols = Array.getLength(object);
                        this._rows = 0;
                        for (n2 = 0; n2 < this._cols; ++n2) {
                            if (Array.getLength(Array.get(object, n2)) <= this._rows) continue;
                            this._rows = Array.getLength(Array.get(object, n2));
                        }
                    }
                    this._data = object;
                }
            }
        } else {
            this._rows = 0;
            this._cols = 0;
            this._data = null;
        }
        this.columnNames = new String[this._cols];
        for (n = 0; n < this._cols; ++n) {
            this.columnNames[n] = "Col " + (n + 1);
        }
        this.fireTableChanged(null);
    }

    public Object getData() {
        if (this._data == null) {
            return null;
        }
        if (Array.getLength(this._data) == 1) {
            Object object = Array.get(this._data, 0);
            if (Array.getLength(object) == 1) {
                return Array.get(object, 0);
            }
            return object;
        }
        return this._data;
    }

    public void setNumRows(int n) {
        if (n < 1 || n == this.getRowCount()) {
            return;
        }
        Object object = null;
        if (this.majority == 1) {
            int n2;
            object = this.newDataObject(n, this.getColumnCount());
            for (n2 = 0; n2 < (n > this.getRowCount() ? this.getRowCount() : n); ++n2) {
                Array.set(object, n2, Array.get(this._data, n2));
            }
            for (n2 = this.getRowCount(); n2 < (n > this.getRowCount() ? n : 0); ++n2) {
                Array.set(object, n2, this.newArray(this.getColumnCount()));
            }
        } else {
            object = this.newDataObject(this.getColumnCount(), n);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Object object2 = Array.get(this._data, i);
                int n3 = Array.getLength(object2);
                Object object3 = this.newArray(n);
                System.arraycopy(object2, 0, object3, 0, n > n3 ? n3 : n);
                Array.set(object, i, object3);
            }
        }
        this.setData(object);
    }

    public void setNumColumns(int n) {
        if (n < 1 || n == this.getColumnCount()) {
            return;
        }
        Object object = null;
        if (this.majority == 2) {
            int n2;
            object = this.newDataObject(n, this.getRowCount());
            for (n2 = 0; n2 < (n > this.getColumnCount() ? this.getColumnCount() : n); ++n2) {
                Array.set(object, n2, Array.get(this._data, n2));
            }
            for (n2 = this.getColumnCount(); n2 < (n > this.getColumnCount() ? n : 0); ++n2) {
                Array.set(object, n2, this.newArray(this.getRowCount()));
            }
        } else {
            object = this.newDataObject(this.getRowCount(), n);
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object object2 = Array.get(this._data, i);
                int n3 = Array.getLength(object2);
                Object object3 = this.newArray(n);
                System.arraycopy(object2, 0, object3, 0, n > n3 ? n3 : n);
                Array.set(object, i, object3);
            }
        }
        this.setData(object);
    }

    public void createEmptyTable(int n, int n2, Class clazz) {
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == Byte.TYPE) {
            this._type = (char)66;
        } else if (clazz == Boolean.TYPE) {
            this._type = (char)90;
        } else if (clazz == Character.TYPE) {
            this._type = (char)67;
        } else if (clazz == Short.TYPE) {
            this._type = (char)83;
        } else if (clazz == Integer.TYPE) {
            this._type = (char)73;
        } else if (clazz == Long.TYPE) {
            this._type = (char)74;
        } else if (clazz == Float.TYPE) {
            this._type = (char)70;
        } else if (clazz == Double.TYPE) {
            this._type = (char)68;
        } else if (clazz.isAssignableFrom(clazz2)) {
            this._type = (char)76;
        } else {
            throw new IllegalArgumentException("Data tables may only be Number or Strings.");
        }
        int n3 = 0;
        int n4 = 0;
        if (this.majority == 1) {
            n3 = n;
            n4 = n2;
        } else {
            n3 = n2;
            n4 = n;
        }
        this.setData(this.newDataObject(n3, n4));
    }
}

