/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.CompoundBorder;

public class VariablePanel
extends JSplitPane
implements CDFConstants {
    private MYEditor myEditor;
    private CDF cdf;
    private Variable selectedVar = null;
    private VarListListener vll;
    private JPanel genericAttributePanel;
    private Hashtable controls = new Hashtable();
    private Hashtable currentAttributes = new Hashtable();
    private VariableSpecPanel variableSpecs;
    private EditvVarEntryTableScrollPane display;
    private VariableValuePanel value;
    private JPanel rightPanel;
    private JScrollPane variableScrollPane;
    static final long serialVersionUID = 1L;

    public VariablePanel(MYEditor mYEditor) {
        super(1);
        this.setOneTouchExpandable(true);
        this.myEditor = mYEditor;
        this.cdf = mYEditor.theCDF;
        this.vll = new VarListListener(this);
        this.setBorder(new CompoundBorder(MYEditor.loweredBorder, MYEditor.emptyBorder5));
        this.variableSpecs = new VariableSpecPanel();
        this.display = new EditvVarEntryTableScrollPane(this);
        this.value = new VariableValuePanel(this);
        Vector vector = new Vector();
        JList jList = new JList(vector);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(this.vll);
        this.variableScrollPane = new JScrollPane(jList);
        this.controls.put("listOfVariables", jList);
        this.controls.put("variableScrollPane", this.variableScrollPane);
        this.controls.put("variableVector", vector);
        JViewport jViewport = new JViewport();
        jViewport.setView(new JLabel("zVariable"));
        this.variableScrollPane.setColumnHeader(jViewport);
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add((Component)this.variableSpecs, "North");
        this.rightPanel.add((Component)this.display, "Center");
        this.rightPanel.add((Component)this.value, "South");
        this.setLeftComponent(this.variableScrollPane);
        this.setRightComponent(this.rightPanel);
        this.updateListOfVariables();
        this.variableScrollPane.setPreferredSize(new Dimension(120, 620));
        this.setDividerLocation(120);
        this.setDividerSize(5);
        this.setPreferredSize(new Dimension(MYEditor.Width, MYEditor.Height));
        this.resetPanel(false);
    }

    public void updateVarPanel(Variable variable) {
        String string = this.selectedVar == null ? "null" : this.selectedVar.toString();
        this.selectedVar = variable;
        this.resetPanel(false);
        if (variable != null) {
            this.variableSpecs.set(this.selectedVar);
            this.display.buildTable(this.selectedVar);
            this.value.set(this.selectedVar);
            this.myEditor.enableVarMenu();
        } else {
            this.myEditor.disableVarMenu();
            this.variableSpecs.reset();
            this.display.reset();
            this.value.reset();
        }
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
        System.gc();
    }

    public void reselectCurrentVariable() {
        JList jList = (JList)this.controls.get("listOfVariables");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("variableScrollPane");
        jList.removeListSelectionListener(this.vll);
        jList.setSelectedValue(this.selectedVar.toString(), true);
        jList.addListSelectionListener(this.vll);
        this.myEditor.enableVarMenu();
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
    }

    public void resetPanel(boolean bl) {
        this.variableSpecs.reset();
        this.display.reset();
        this.value.reset();
        if (bl) {
            this.updateListOfVariables();
            this.selectedVar = null;
        }
    }

    private void updateListOfVariables() {
        Vector<String> vector = new Vector<String>();
        JList jList = (JList)this.controls.get("listOfVariables");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("variableScrollPane");
        if (this.cdf != null) {
            Enumeration enumeration = this.cdf.getVariables().elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement().toString());
            }
        }
        this.controls.put("variableVector", vector);
        jList.setListData(vector);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
    }

    public void addToListOfVariables(Object object) {
        Vector vector = (Vector)this.controls.get("variableVector");
        JList jList = (JList)this.controls.get("listOfVariables");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("variableScrollPane");
        vector.addElement(object.toString());
        this.controls.put("variableVector", vector);
        jList.setListData(vector);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
    }

    public void removeFromListOfVariables(Object object) {
        Vector vector = (Vector)this.controls.get("variableVector");
        JList jList = (JList)this.controls.get("listOfVariables");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("variableScrollPane");
        vector.removeElement(object.toString());
        this.controls.put("variableVector", vector);
        jList.setListData(vector);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
    }

    public void saveVariableChanges() {
        if (this.selectedVar != null) {
            // empty if block
        }
    }

    public void renameSelectedVar(String string) throws CDFException {
        String string2 = this.selectedVar.toString();
        this.selectedVar.rename(string);
        Vector vector = (Vector)this.controls.get("variableVector");
        JList jList = (JList)this.controls.get("listOfVariables");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("variableScrollPane");
        jList.removeListSelectionListener(this.vll);
        int n = vector.indexOf(string2);
        vector.removeElementAt(n);
        vector.insertElementAt(this.selectedVar.toString(), n);
        this.controls.put("variableVector", vector);
        jList.setListData(vector);
        jList.setSelectedValue(string, true);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
        jList.addListSelectionListener(this.vll);
    }

    public void deleteSelectedVar() throws CDFException {
        Vector vector = (Vector)this.controls.get("variableVector");
        JList jList = (JList)this.controls.get("listOfVariables");
        jList.removeListSelectionListener(this.vll);
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("variableScrollPane");
        vector.removeElementAt(vector.indexOf(this.selectedVar.toString()));
        this.controls.put("variableVector", vector);
        jList.setListData(vector);
        jList.setSelectedIndex(-1);
        jList.addListSelectionListener(this.vll);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        this.resetPanel(false);
        System.gc();
        this.selectedVar.delete();
        this.selectedVar = null;
        this.myEditor.disableVarMenu();
    }

    public Variable getSelectedVar() {
        return this.selectedVar;
    }

    public Hashtable getControls() {
        return this.controls;
    }

    public Object getControl(String string) {
        return this.controls.get(string);
    }

    public Object getAttribute(String string) {
        return this.currentAttributes.get(string);
    }

    private void putAttribute(String string, Object object) {
        this.currentAttributes.put(string, object);
    }

    public EditvVarEntryTableScrollPane getDisplay() {
        return this.display;
    }

    public MYEditor getMyEditor() {
        return this.myEditor;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public VariableValuePanel getValuePanel() {
        return this.value;
    }

    public VariableSpecPanel getVarSpecPanel() {
        return this.variableSpecs;
    }

    public EditvVarEntryTableScrollPane getvVarEntryTableScrollPane() {
        return this.display;
    }
}

