/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.border.EmptyBorder;

public class ExportToText
extends JDialog
implements CDFConstants,
KeyListener,
FocusListener {
    static final long serialVersionUID = 1L;
    private int[] eleIndex;
    private int currentVar;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JPanel pagePanel = new JPanel();
    private JLabel pageLabel = new JLabel("Page: ");
    private JLabel recordLabel = new JLabel("Record: ");
    private JLabel pageTotal = new JLabel();
    private JLabel recordTotal = new JLabel();
    private JTextField pageField = new JTextField(5);
    private JTextField recordField = new JTextField(5);
    private JButton enterButton;
    private JButton cancelButton;
    private JButton backButton;
    private Object focusedObj = null;
    private SelectionListener aSelection;
    private PageRecListener aPageRecListener;
    private CDFSpecPanel cdfspec;
    private JPanel center = new JPanel(new BorderLayout(), true);
    private ExportCDFTable aCDFTable;
    private CDFExport myCDFExport;
    private static ExportToText exportToText;
    private BuildProgressPanel progressPanel;
    private JTabbedPane jtp;
    private JScrollPane[] scrollPane = null;
    private ExportVarDisplayTable[] aToScreenTable = null;
    private String[][] columnNames = null;
    private Object[][][] recordObject = null;
    private static String headcol1;
    private static String headcol2;
    private Vector vars;
    private int[] varsHor;
    private int groups;
    private int outVars;
    private int COLUMNS;
    private int ROWS;
    private int recHeading;
    private int indexHeading;
    private int totalColumns;
    private int numColumns;
    private int totalElementsPerRec;
    private int totalWritten;
    private boolean indiceOut;
    private long[] indiceSizes;
    private int indiceDim;
    private int elementNum;
    private int lastPageToDisplay;
    private long majority;
    private int istart;
    private int totalElements;
    private Object aRecord = null;
    private Hashtable formatHash;
    private boolean toScreen;
    private Cursor curCursor = Cursor.getPredefinedCursor(0);
    private Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private Object newMin;
    private Object newMax;
    private Object newFil;
    private Object minObj = null;
    private Object maxObj = null;
    private Object filObj = null;
    private int irec;
    private int filterElementsNum;
    private int minLen;
    private int maxLen;
    private int filLen;
    private long[] elementBase;
    private int[] varWidth;
    private int[] varDataType;
    static boolean defaultModal;
    private int currentProgressValue;
    private int totalItems;
    private Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
    private static final String ENTER = "Next";
    private static final String BACK = "Back";
    private static final String CANCEL = "Cancel";

    private ExportToText(JFrame jFrame) {
        super((Frame)jFrame, defaultModal);
    }

    public static ExportToText createToText(JFrame jFrame, CDFExport cDFExport, ExportCDFTable exportCDFTable, boolean bl) {
        if (exportToText == null) {
            exportToText = new ExportToText(jFrame);
            ExportToText.exportToText.myCDFExport = cDFExport;
            ExportToText.exportToText.aCDFTable = exportCDFTable;
        }
        ExportToText.exportToText.toScreen = bl;
        if (bl) {
            if (ExportToText.exportToText.mainPanel == null) {
                ExportToText.exportToText.mainPanel = (JPanel)exportToText.getContentPane();
                ExportToText.exportToText.mainPanel.setLayout(new BorderLayout());
                ExportToText.exportToText.mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
                ExportToText.exportToText.pageField.setHorizontalAlignment(0);
                ExportToText.exportToText.pageField.addKeyListener(exportToText);
                ExportToText.exportToText.pageField.addFocusListener(exportToText);
                ExportToText.exportToText.recordField.setHorizontalAlignment(0);
                ExportToText.exportToText.recordField.addKeyListener(exportToText);
                ExportToText.exportToText.recordField.addFocusListener(exportToText);
                exportToText.setDefaultCloseOperation(0);
                exportToText.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                    }
                });
                exportToText.setSize(800, 800);
                ExportToText.exportToText.cdfspec = new CDFSpecPanel();
                ExportToText.exportToText.bottomPanel = new JPanel(new BorderLayout(), true);
                ExportToText.exportToText.aPageRecListener = exportToText.new PageRecListener();
            }
            exportToText.buildPanel();
            RepaintManager.currentManager(null).setDoubleBufferingEnabled(true);
        }
        ExportToText.exportToText.ROWS = cDFExport.ROWS;
        ExportToText.exportToText.COLUMNS = cDFExport.COLUMNS;
        exportToText.setupDataTable();
        exportToText.displayDataTable();
        return exportToText;
    }

    public void displayDataTable() {
        int n;
        if (this.myCDFExport.orientation == 0) {
            n = this.totalElementsPerRec * (this.totalWritten + 1);
            this.lastPageToDisplay = n / this.ROWS;
            if (n % this.ROWS == 0) {
                --this.lastPageToDisplay;
            }
        } else {
            n = this.totalWritten + 1;
            this.lastPageToDisplay = n / this.ROWS;
            if (n % this.ROWS == 0) {
                --this.lastPageToDisplay;
            }
        }
        if (this.toScreen) {
            if (this.outVars > 0) {
                this.elementNum = 0;
                this.fillVarRecsToTable(this.elementNum);
                this.displayTable(this.mainPanel);
                exportToText.pack();
                Dimension dimension = exportToText.getSize();
                exportToText.setLocation((this.ss.width - dimension.width) / 2, (this.ss.height - dimension.height) / 2);
                exportToText.setVisible(true);
            }
        } else {
            this.myCDFExport.info.setText("Start writing output to: " + this.myCDFExport.cdfspec2 + "\n\n");
            OutToFile outToFile = new OutToFile();
            outToFile.start();
        }
    }

    void setupDataTable() {
        int n;
        int n2;
        String string;
        this.majority = this.myCDFExport.majority;
        this.recHeading = 1;
        if (this.myCDFExport.recordNum == 0 || !((Boolean)this.aCDFTable.getDataObject()[0][5]).booleanValue()) {
            this.recHeading = 0;
        }
        this.indexHeading = 1;
        this.indiceOut = true;
        if (this.myCDFExport.indiceNum == 0 || !((Boolean)this.aCDFTable.getDataObject()[this.myCDFExport.recordNum][5]).booleanValue()) {
            this.indiceOut = false;
            this.indexHeading = 0;
        }
        this.vars = new Vector();
        this.outVars = 0;
        for (int i = this.aCDFTable.istart; i < this.aCDFTable.numRows; ++i) {
            if (!((Boolean)this.aCDFTable.getDataObject()[i][5]).booleanValue()) continue;
            ++this.outVars;
            string = (String)this.aCDFTable.getDataObject()[i][0];
            this.vars.addElement(string);
        }
        if (this.outVars == 0) {
            return;
        }
        long[] lArray = null;
        long l = 0L;
        this.varWidth = new int[this.vars.size()];
        this.varDataType = new int[this.vars.size()];
        this.totalElements = 0;
        this.varsHor = new int[this.vars.size()];
        this.eleIndex = new int[this.vars.size()];
        this.formatHash = new Hashtable();
        for (n2 = 0; n2 < this.vars.size(); ++n2) {
            int n3;
            int n4;
            long[] lArray2;
            long l2;
            string = (String)this.vars.elementAt(n2);
            this.varsHor[n2] = this.totalElements;
            try {
                Variable variable = this.myCDFExport.sourceCDF.getVariable(string);
                l2 = variable.getNumDims();
                lArray2 = variable.getDimSizes();
                this.eleIndex[n2] = this.totalElements;
                n4 = (int)variable.getMaxWrittenRecord();
                String string2 = CDFToolUtils.getCFormat(variable);
                if (string2 != null) {
                    this.formatHash.put(variable, string2);
                }
                long l3 = variable.getDataType();
                this.varWidth[n2] = CDFToolUtils.VariableWidth(this.myCDFExport.epoch, variable, l3, string2);
                this.varDataType[n2] = (int)l3;
                n3 = 1;
                if (l2 > 0L) {
                    n = 0;
                    while ((long)n < l2) {
                        n3 = (int)((long)n3 * lArray2[n]);
                        ++n;
                    }
                }
                this.totalElements += n3;
            }
            catch (CDFException cDFException) {
                System.err.println("ERROR!  " + (Object)((Object)cDFException));
                return;
            }
            if (l2 == 0L) {
                this.indiceOut = false;
            }
            if (n2 == 0) {
                l = l2;
                this.totalWritten = n4;
                this.totalElementsPerRec = n3;
                if ((int)l2 == 0) {
                    lArray = null;
                    this.indiceSizes = null;
                } else {
                    lArray = new long[(int)l2];
                    this.indiceSizes = new long[(int)l2];
                    System.arraycopy(lArray2, 0, lArray, 0, (int)l2);
                    System.arraycopy(lArray2, 0, this.indiceSizes, 0, (int)l2);
                }
                this.indiceDim = (int)l2;
                continue;
            }
            if (this.totalWritten < n4) {
                this.totalWritten = n4;
            }
            if (this.indiceOut) {
                if (this.totalElementsPerRec != n3 || l != l2) {
                    this.indiceOut = false;
                } else {
                    n = 0;
                    while ((long)n < l2) {
                        if (lArray == null) {
                            this.indiceOut = false;
                            break;
                        }
                        if (lArray2[n] != lArray[n]) {
                            this.indiceOut = false;
                            break;
                        }
                        ++n;
                    }
                }
            }
            if (this.totalElementsPerRec >= n3) continue;
            this.totalElementsPerRec = n3;
            this.indiceDim = (int)l2;
            this.indiceSizes = new long[(int)l2];
            System.arraycopy(lArray2, 0, this.indiceSizes, 0, (int)l2);
        }
        if (this.COLUMNS == 0) {
            this.COLUMNS = this.myCDFExport.orientation == 0 ? this.outVars : this.totalElements;
        }
        if (this.ROWS == 0) {
            this.ROWS = this.myCDFExport.orientation == 1 ? this.totalWritten + 1 : (this.totalWritten + 1) * this.totalElementsPerRec;
        }
        if (this.myCDFExport.orientation == 0) {
            if (this.outVars > this.COLUMNS) {
                this.numColumns = this.COLUMNS;
                this.groups = this.outVars / this.COLUMNS;
                if (this.outVars % this.COLUMNS != 0) {
                    ++this.groups;
                }
            } else {
                this.numColumns = this.outVars;
                this.groups = 1;
            }
        } else if (this.totalElements > this.COLUMNS) {
            this.numColumns = this.COLUMNS;
            this.groups = this.totalElements / this.COLUMNS;
            if (this.totalElements % this.COLUMNS != 0) {
                ++this.groups;
            }
        } else {
            this.numColumns = this.totalElements;
            this.groups = 1;
        }
        this.indexHeading = this.indiceOut ? 1 : 0;
        this.istart = this.recHeading + this.indexHeading;
        this.totalColumns = this.numColumns + this.istart;
        this.columnNames = new String[this.groups][this.totalColumns];
        this.recordObject = new Object[this.groups][this.ROWS][this.totalColumns];
        this.cleanColumns();
        this.cleanTableObjects();
        n2 = 0;
        block6: for (n = 0; n < this.groups; ++n) {
            if (this.recHeading == 1) {
                this.columnNames[n][0] = headcol1;
            }
            if (this.indexHeading == 1) {
                this.columnNames[n][this.recHeading] = headcol2;
            }
            for (int i = 0; i < this.numColumns; ++i) {
                if (this.myCDFExport.orientation == 0) {
                    if (n2 >= this.vars.size()) continue block6;
                    this.columnNames[n][i + this.istart] = (String)this.vars.elementAt(n2++);
                    continue;
                }
                if (n2 >= this.totalElements) continue block6;
                for (int j = 0; j < this.vars.size(); ++j) {
                    if (n2 == this.varsHor[j]) {
                        this.columnNames[n][i + this.istart] = (String)this.vars.elementAt(j);
                        break;
                    }
                    if (n2 >= this.varsHor[j] && j != this.vars.size() - 1) continue;
                    this.columnNames[n][i + this.istart] = " ";
                    break;
                }
                ++n2;
            }
        }
    }

    private void buildPanel() {
        exportToText.setTitle("CDF: " + this.myCDFExport.cdfspec1);
        this.cdfspec.set(this.myCDFExport.sourceCDF);
        this.mainPanel.add((Component)this.cdfspec, "North");
        this.createButton(this.bottomPanel);
        this.mainPanel.add((Component)this.bottomPanel, "South");
    }

    private void fillVarRecsToTable(int n) {
        if (this.recHeading == 1 || this.indexHeading == 1) {
            this.doRecIndexColumn(n);
        }
        boolean bl = false;
        for (int i = 0; i < this.vars.size(); ++i) {
            int n2;
            int n3;
            Variable variable;
            this.currentVar = i;
            String string = (String)this.vars.elementAt(i);
            try {
                variable = this.myCDFExport.sourceCDF.getVariable(string);
            }
            catch (CDFException cDFException) {
                System.err.println("error getting variable");
                return;
            }
            if (this.myCDFExport.orientation == 0) {
                n3 = i / this.COLUMNS;
                n2 = i % this.COLUMNS + this.istart;
            } else {
                n3 = this.eleIndex[i] / this.COLUMNS;
                n2 = this.eleIndex[i] % this.COLUMNS + this.istart;
            }
            this.loadVarRecords(variable, n, n3, n2);
        }
    }

    void doRecIndexColumn(int n) {
        int n2 = n;
        int n3 = this.myCDFExport.orientation == 0 ? n2 / this.totalElementsPerRec : n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.indexHeading == 1) {
            this.dimensionBase();
        }
        for (int i = 0; i < this.ROWS; ++i) {
            int n4;
            if (this.indexHeading == 1) {
                long[] lArray = this.currentIndex(n2);
                if (stringBuffer.capacity() > 0) {
                    stringBuffer.setLength(0);
                }
                stringBuffer.append("[");
                for (n4 = 0; n4 < this.indiceDim; ++n4) {
                    if (n4 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(lArray[n4] + 1L);
                }
                stringBuffer.append("]");
            }
            for (n4 = 0; n4 < this.groups; ++n4) {
                if (this.myCDFExport.orientation == 0) {
                    if (this.recHeading == 1) {
                        this.recordObject[n4][i][0] = Integer.toString(n3 + 1);
                    }
                    if (this.indexHeading != 1) continue;
                    this.recordObject[n4][i][this.recHeading] = stringBuffer.toString();
                    continue;
                }
                this.recordObject[n4][i][0] = Integer.toString(n3 + 1);
            }
            n3 = this.myCDFExport.orientation == 0 ? n2 / this.totalElementsPerRec : ++n2;
            if (n3 > this.totalWritten) break;
        }
    }

    void displayTable(JPanel jPanel) {
        int n = this.elementNum % this.ROWS == 0 ? this.elementNum / this.ROWS + 1 : Math.round((float)this.elementNum / (float)this.ROWS) + 1;
        if (n > this.lastPageToDisplay + 1) {
            n = this.lastPageToDisplay + 1;
        }
        int n2 = this.myCDFExport.orientation == 0 ? this.elementNum / this.totalElementsPerRec + 1 : this.elementNum + 1;
        this.pageField.setText("" + n);
        this.recordField.setText("" + n2);
        if (this.scrollPane == null) {
            int n3;
            jPanel.add((Component)this.center, "Center");
            this.scrollPane = new JScrollPane[this.groups];
            this.aToScreenTable = new ExportVarDisplayTable[this.groups];
            for (n3 = 0; n3 < this.groups; ++n3) {
                Object[][] objectArray = (Object[][])Array.get(this.recordObject, n3);
                String[] stringArray = (String[])Array.get(this.columnNames, n3);
                this.aToScreenTable[n3] = new ExportVarDisplayTable(objectArray, stringArray);
                this.scrollPane[n3] = new JScrollPane(this.aToScreenTable[n3].getTable(), 20, 30);
            }
            if (this.groups == 1) {
                if (this.COLUMNS > 9) {
                    this.aToScreenTable[0].getTable().setAutoResizeMode(0);
                }
                this.center.add((Component)this.scrollPane[0], "Center");
            } else {
                if (this.jtp == null) {
                    this.jtp = new JTabbedPane();
                }
                for (n3 = 0; n3 < this.groups; ++n3) {
                    this.jtp.addTab("Group " + (n3 + 1), null, this.scrollPane[n3]);
                }
                this.center.add((Component)this.jtp, "Center");
            }
            this.pageTotal.setText(" / " + (this.lastPageToDisplay + 1));
            this.recordTotal.setText(" / " + (this.totalWritten + 1));
            this.pagePanel.add(this.pageLabel);
            this.pagePanel.add(this.pageField);
            this.pagePanel.add(this.pageTotal);
            this.pagePanel.add(Box.createRigidArea(new Dimension(10, 1)));
            this.pagePanel.add(this.recordLabel);
            this.pagePanel.add(this.recordField);
            this.pagePanel.add(this.recordTotal);
            this.pageField.addActionListener(this.aPageRecListener);
            this.recordField.addActionListener(this.aPageRecListener);
            this.pageField.setToolTipText("Enter a page number and hit Return or Up/Down arrow keys to display a new page.");
            this.recordField.setToolTipText("Enter a record number and hit Return or Up/Down arrow keys to display a new page. ");
            this.center.add((Component)this.pagePanel, "South");
        } else {
            for (int i = 0; i < this.groups; ++i) {
                Object[][] objectArray = (Object[][])Array.get(this.recordObject, i);
                this.aToScreenTable[i].setDataTable(objectArray);
            }
        }
    }

    void dimensionBase() {
        if (this.indiceDim <= 1) {
            this.elementBase = new long[]{1L};
        } else {
            this.elementBase = new long[this.indiceDim];
            if (this.majority == 1L) {
                for (int i = 0; i < this.indiceDim; ++i) {
                    this.elementBase[i] = 1L;
                    for (int j = i + 1; j < this.indiceDim; ++j) {
                        int n = i;
                        this.elementBase[n] = this.elementBase[n] * this.indiceSizes[j];
                    }
                }
            } else {
                for (int i = 0; i < this.indiceDim; ++i) {
                    this.elementBase[i] = 1L;
                    for (int j = 0; j <= i; ++j) {
                        int n = i;
                        this.elementBase[n] = this.elementBase[n] * this.indiceSizes[j];
                    }
                }
            }
        }
    }

    long[] currentIndex(int n) {
        int n2 = n % this.totalElementsPerRec;
        long[] lArray = new long[this.indiceDim];
        if (this.indiceDim <= 1) {
            lArray[0] = n2;
        } else if (this.majority == 1L) {
            for (int i = 0; i < this.indiceDim; ++i) {
                lArray[i] = (long)n2 / this.elementBase[i];
                n2 = (int)((long)n2 % this.elementBase[i]);
            }
        } else {
            for (int i = 0; i < this.indiceDim; ++i) {
                lArray[i] = (long)n2 % this.elementBase[i];
                n2 = (int)((long)n2 / this.elementBase[i]);
            }
        }
        return lArray;
    }

    private void loadVarRecords(Variable variable, int n, int n2, int n3) {
        int n4;
        long[] lArray;
        long[] lArray2;
        int n5;
        int n6;
        long l;
        long l2 = variable.getDataType();
        long[] lArray3 = null;
        long[] lArray4 = null;
        long l3 = variable.getNumDims();
        String string = variable.getName();
        int n7 = 1;
        try {
            l = variable.getMaxWrittenRecord();
        }
        catch (CDFException cDFException) {
            l = -1L;
        }
        if (l == -1L) {
            return;
        }
        if (l3 > 0L) {
            lArray3 = variable.getDimSizes();
            lArray4 = variable.getDimVariances();
            int n8 = 0;
            while ((long)n8 < l3) {
                n7 = (int)((long)n7 * lArray3[n8]);
                ++n8;
            }
        }
        this.filObj = null;
        this.maxObj = null;
        this.minObj = null;
        if (this.myCDFExport.getFiltering() == 1) {
            this.checkFiltering(variable, string, l2);
        }
        int n9 = n;
        int n10 = n + this.ROWS - 1;
        if (this.myCDFExport.orientation == 0) {
            n6 = n9 / this.totalElementsPerRec;
            n5 = n10 / this.totalElementsPerRec;
        } else {
            n6 = n9;
            n5 = n10;
        }
        if ((long)n6 > l) {
            return;
        }
        String string2 = null;
        if (this.formatHash.containsKey(variable)) {
            string2 = (String)this.formatHash.get(variable);
        }
        long l4 = variable.getSparseRecords();
        Object object = null;
        if ((long)n5 > l) {
            n5 = (int)l;
        }
        long l5 = n5 - n6 + 1;
        long l6 = 1L;
        if (l3 > 0L) {
            lArray2 = new long[(int)l3];
            lArray = new long[(int)l3];
            for (n4 = 0; n4 < (int)l3; ++n4) {
                lArray2[n4] = 1L;
                lArray[n4] = 0L;
            }
        } else {
            lArray3 = new long[1];
            lArray2 = new long[1];
            lArray = new long[1];
            lArray3[0] = 0L;
            lArray2[0] = 1L;
            lArray[0] = 0L;
        }
        try {
            object = variable.getHyperData((long)n6, l5, l6, lArray, lArray3, lArray2);
        }
        catch (CDFException cDFException) {
            System.err.println("error hyperget records: " + (Object)((Object)cDFException));
            return;
        }
        n4 = 0;
        if (l2 == 32L) {
            n4 = 2;
        }
        for (int i = n6; i <= n5; ++i) {
            if ((long)i > l) continue;
            this.aRecord = l5 <= 1L ? object : (l3 > 0L && n7 > 1 ? ((Object[])object)[i - n6] : CDFToolUtils.retrieveData(object, i - n6, n4));
            this.fillScreenTable(this.aRecord, variable, l2, (int)l3, lArray3, n2, n3, n, i, n10, string2);
        }
    }

    void checkFiltering(Variable variable, String string, long l) {
        Object object;
        int n = (Integer)this.aCDFTable.myHash.get(string);
        int n2 = 0;
        if (this.myCDFExport.getValidMin() == 1) {
            this.newMin = this.aCDFTable.getFilterObject()[n][++n2];
            if (this.newMin != null && ((String)this.newMin).trim().length() != 0) {
                object = new StringTokenizer((String)this.newMin, ",");
                this.minLen = ((StringTokenizer)object).countTokens();
                this.minObj = this.minLen == -1 ? null : CDFToolUtils.parseContents((String)this.newMin, l);
            }
        }
        if (this.myCDFExport.getValidMax() == 1) {
            this.newMax = this.aCDFTable.getFilterObject()[n][++n2];
            if (this.newMax != null && ((String)this.newMax).trim().length() != 0) {
                object = new StringTokenizer((String)this.newMax, ",");
                this.maxLen = ((StringTokenizer)object).countTokens();
                this.maxObj = this.maxLen == -1 ? null : CDFToolUtils.parseContents((String)this.newMax, l);
            }
        }
        if (this.myCDFExport.getFillVal() == 1) {
            this.newFil = this.aCDFTable.getFilterObject()[n][++n2];
            if (this.newFil != null && ((String)this.newFil).trim().length() != 0) {
                object = new StringTokenizer((String)this.newFil, ",");
                this.filLen = ((StringTokenizer)object).countTokens();
                this.filObj = this.filLen == -1 ? null : CDFToolUtils.parseContents((String)this.newFil, l);
            }
        } else if (this.myCDFExport.getValidMin() == 1 || this.myCDFExport.getValidMax() == 1) {
            try {
                object = this.myCDFExport.sourceCDF.getAttribute("FILLVAL");
                if (object == null) {
                    this.filObj = null;
                } else {
                    Entry entry = object.getEntry(variable);
                    long l2 = entry.getDataType();
                    if (l2 != l) {
                        this.filObj = null;
                    } else {
                        Object object2 = entry.getData();
                        String string2 = l == 31L ? Epoch.encode((double)((Double)object2)) : (l == 32L ? Epoch16.encode((Object)((double[])object2)) : CDFUtils.getStringData((Object)object2, (String)","));
                        StringTokenizer stringTokenizer = new StringTokenizer((String)this.newFil, ",");
                        this.filLen = stringTokenizer.countTokens();
                        this.filObj = this.filLen == -1 ? null : CDFToolUtils.parseContents(string2, l);
                    }
                }
            }
            catch (CDFException cDFException) {
                this.filObj = null;
            }
        }
    }

    private Object fillScreenTable(Object object, Variable variable, long l, int n, long[] lArray, int n2, int n3, int n4, int n5, int n6, String string) {
        block467: {
            int n7;
            int n8;
            block468: {
                block483: {
                    block482: {
                        block481: {
                            block480: {
                                block479: {
                                    block478: {
                                        block477: {
                                            block469: {
                                                boolean bl;
                                                block476: {
                                                    block475: {
                                                        block474: {
                                                            block473: {
                                                                block472: {
                                                                    block471: {
                                                                        block470: {
                                                                            n8 = this.myCDFExport.orientation == 0 ? n5 * this.totalElementsPerRec - n4 : n5 - n4;
                                                                            if (n > 1) break block468;
                                                                            if (n != 0) break block469;
                                                                            int n9 = n8;
                                                                            bl = true;
                                                                            if (n9 < 0 || n9 >= this.ROWS) {
                                                                                return this.recordObject;
                                                                            }
                                                                            if (l != 51L && l != 52L) break block470;
                                                                            int n10 = (int)variable.getNumElements();
                                                                            byte[] byArray = new byte[n10];
                                                                            String string2 = new String((byte[])object);
                                                                            this.recordObject[n2][n9][n3] = string2;
                                                                            break block467;
                                                                        }
                                                                        if (l != 41L && l != 1L) break block471;
                                                                        byte by = (Byte)object;
                                                                        byte by2 = 0;
                                                                        byte by3 = 0;
                                                                        byte by4 = 0;
                                                                        if (this.filObj != null) {
                                                                            by2 = ((byte[])this.filObj)[0];
                                                                        }
                                                                        if (this.minObj != null) {
                                                                            by4 = ((byte[])this.minObj)[0];
                                                                        }
                                                                        if (this.maxObj != null) {
                                                                            by3 = ((byte[])this.maxObj)[0];
                                                                        }
                                                                        if (this.minObj != null && by < by4) {
                                                                            bl = false;
                                                                            by = this.filObj != null ? by2 : (byte)0;
                                                                        }
                                                                        if (bl && this.maxObj != null && by > by3) {
                                                                            by = this.filObj != null ? by2 : (byte)0;
                                                                        }
                                                                        this.recordObject[n2][n9][n3] = string == null ? new Byte(by) : Cformat.getInstance(string).form(by);
                                                                        break block467;
                                                                    }
                                                                    if (l != 2L && l != 11L) break block472;
                                                                    short s = (Short)object;
                                                                    short s2 = 0;
                                                                    short s3 = 0;
                                                                    short s4 = 0;
                                                                    if (this.filObj != null) {
                                                                        s2 = ((short[])this.filObj)[0];
                                                                    }
                                                                    if (this.minObj != null) {
                                                                        s4 = ((short[])this.minObj)[0];
                                                                    }
                                                                    if (this.maxObj != null) {
                                                                        s3 = ((short[])this.maxObj)[0];
                                                                    }
                                                                    if (l == 11L) {
                                                                        if (s2 < 0) {
                                                                            s2 = (short)(s2 + 256);
                                                                        }
                                                                        if (s < 0) {
                                                                            s = (short)(s + 256);
                                                                        }
                                                                        if (s4 < 0) {
                                                                            s4 = (short)(s4 + 256);
                                                                        }
                                                                        if (s3 < 0) {
                                                                            s3 = (short)(s3 + 256);
                                                                        }
                                                                    }
                                                                    if (this.minObj != null && s < s4) {
                                                                        bl = false;
                                                                        s = this.filObj != null ? s2 : (short)0;
                                                                    }
                                                                    if (bl && this.maxObj != null && s > s3) {
                                                                        s = this.filObj != null ? s2 : (short)0;
                                                                    }
                                                                    this.recordObject[n2][n9][n3] = string == null ? new Short(s) : Cformat.getInstance(string).form(s);
                                                                    break block467;
                                                                }
                                                                if (l != 4L && l != 12L) break block473;
                                                                int n11 = (Integer)object;
                                                                int n12 = 0;
                                                                int n13 = 0;
                                                                int n14 = 0;
                                                                if (this.filObj != null) {
                                                                    n12 = ((int[])this.filObj)[0];
                                                                }
                                                                if (this.minObj != null) {
                                                                    n14 = ((int[])this.minObj)[0];
                                                                }
                                                                if (this.maxObj != null) {
                                                                    n13 = ((int[])this.maxObj)[0];
                                                                }
                                                                if (l == 12L) {
                                                                    if (n12 < 0) {
                                                                        n12 += 65536;
                                                                    }
                                                                    if (n11 < 0) {
                                                                        n11 += 65536;
                                                                    }
                                                                    if (n14 < 0) {
                                                                        n14 += 65536;
                                                                    }
                                                                    if (n13 < 0) {
                                                                        n13 += 65536;
                                                                    }
                                                                }
                                                                if (this.minObj != null && n11 < n14) {
                                                                    bl = false;
                                                                    n11 = this.filObj != null ? n12 : 0;
                                                                }
                                                                if (bl && this.maxObj != null && n11 > n13) {
                                                                    n11 = this.filObj != null ? n12 : 0;
                                                                }
                                                                this.recordObject[n2][n9][n3] = string == null ? new Integer(n11) : Cformat.getInstance(string).form(n11);
                                                                break block467;
                                                            }
                                                            if (l != 14L) break block474;
                                                            long l2 = (Long)object;
                                                            long l3 = 0L;
                                                            long l4 = 0L;
                                                            long l5 = 0L;
                                                            if (this.filObj != null) {
                                                                l3 = ((long[])this.filObj)[0];
                                                            }
                                                            if (this.minObj != null) {
                                                                l5 = ((long[])this.minObj)[0];
                                                            }
                                                            if (this.maxObj != null) {
                                                                l4 = ((long[])this.maxObj)[0];
                                                            }
                                                            if (l == 14L) {
                                                                if (l3 < 0L) {
                                                                    l3 -= -4294967296L;
                                                                }
                                                                if (l2 < 0L) {
                                                                    l2 -= -4294967296L;
                                                                }
                                                                if (l5 < 0L) {
                                                                    l5 -= -4294967296L;
                                                                }
                                                                if (l4 < 0L) {
                                                                    l4 -= -4294967296L;
                                                                }
                                                            }
                                                            if (this.minObj != null && l2 < l5) {
                                                                bl = false;
                                                                l2 = this.filObj != null ? l3 : 0L;
                                                            }
                                                            if (bl && this.maxObj != null && l2 > l4) {
                                                                l2 = this.filObj != null ? l3 : 0L;
                                                            }
                                                            this.recordObject[n2][n9][n3] = string == null ? new Long(l2) : Cformat.getInstance(string).form(l2);
                                                            break block467;
                                                        }
                                                        if (l != 21L && l != 44L) break block475;
                                                        float f = ((Float)object).floatValue();
                                                        float f2 = 0.0f;
                                                        float f3 = 0.0f;
                                                        float f4 = 0.0f;
                                                        if (this.filObj != null) {
                                                            f2 = ((float[])this.filObj)[0];
                                                        }
                                                        if (this.minObj != null) {
                                                            f4 = ((float[])this.minObj)[0];
                                                        }
                                                        if (this.maxObj != null) {
                                                            f3 = ((float[])this.maxObj)[0];
                                                        }
                                                        if (this.minObj != null && f < f4) {
                                                            bl = false;
                                                            f = this.filObj != null ? f2 : 0.0f;
                                                        }
                                                        if (bl && this.maxObj != null && f > f3) {
                                                            f = this.filObj != null ? f2 : 0.0f;
                                                        }
                                                        this.recordObject[n2][n9][n3] = string == null ? new Float(f) : Cformat.getInstance(string).form(f);
                                                        break block467;
                                                    }
                                                    if (l != 22L && l != 45L && l != 31L) break block476;
                                                    double d = (Double)object;
                                                    double d2 = 0.0;
                                                    double d3 = 0.0;
                                                    double d4 = 0.0;
                                                    if (this.filObj != null) {
                                                        d2 = ((double[])this.filObj)[0];
                                                    }
                                                    if (this.minObj != null) {
                                                        d4 = ((double[])this.minObj)[0];
                                                    }
                                                    if (this.maxObj != null) {
                                                        d3 = ((double[])this.maxObj)[0];
                                                    }
                                                    if (this.minObj != null && d < d4) {
                                                        bl = false;
                                                        d = this.filObj != null ? d2 : 0.0;
                                                    }
                                                    if (bl && this.maxObj != null && d > d3) {
                                                        d = this.filObj != null ? d2 : 0.0;
                                                    }
                                                    if (l != 31L) {
                                                        this.recordObject[n2][n9][n3] = string == null ? new Double(d) : Cformat.getInstance(string).form(d);
                                                    } else {
                                                        String string3 = null;
                                                        if (this.myCDFExport.epoch == 0) {
                                                            string3 = Epoch.encode((double)d);
                                                        } else if (this.myCDFExport.epoch == 1) {
                                                            string3 = Epoch.encode1((double)d);
                                                        } else if (this.myCDFExport.epoch == 2) {
                                                            string3 = Epoch.encode2((double)d);
                                                        } else if (this.myCDFExport.epoch == 3) {
                                                            string3 = Epoch.encode3((double)d);
                                                        } else if (this.myCDFExport.epoch == 5) {
                                                            try {
                                                                String string4 = (String)variable.getEntryData("FORMAT");
                                                                string3 = string4 == null || string4.trim().length() == 0 ? Epoch.encode((double)d) : Epoch.encodex((double)d, (String)string4);
                                                            }
                                                            catch (CDFException cDFException) {
                                                                string3 = Epoch.encode((double)d);
                                                            }
                                                        }
                                                        this.recordObject[n2][n9][n3] = string3;
                                                    }
                                                    break block467;
                                                }
                                                if (l != 32L) break block467;
                                                double[] dArray = new double[]{((double[])object)[0], ((double[])object)[1]};
                                                double[] dArray2 = new double[]{0.0, 0.0};
                                                double[] dArray3 = new double[]{0.0, 0.0};
                                                double[] dArray4 = new double[]{0.0, 0.0};
                                                if (this.filObj != null) {
                                                    dArray2[0] = ((double[])this.filObj)[0];
                                                    dArray2[1] = ((double[])this.filObj)[1];
                                                }
                                                if (this.minObj != null) {
                                                    dArray4[0] = ((double[])this.minObj)[0];
                                                    dArray4[1] = ((double[])this.minObj)[1];
                                                }
                                                if (this.maxObj != null) {
                                                    dArray3[0] = ((double[])this.maxObj)[0];
                                                    dArray3[1] = ((double[])this.maxObj)[1];
                                                }
                                                if (this.minObj != null && (dArray[0] < dArray4[0] || dArray[0] == dArray4[0] && dArray[1] < dArray4[1])) {
                                                    bl = false;
                                                    if (this.filObj != null) {
                                                        dArray[0] = dArray2[0];
                                                        dArray[1] = dArray2[1];
                                                    } else {
                                                        dArray[0] = 0.0;
                                                        dArray[1] = 0.0;
                                                    }
                                                }
                                                if (bl && this.maxObj != null && (dArray[0] > dArray3[0] || dArray[0] == dArray3[0] && dArray[1] > dArray3[1])) {
                                                    if (this.filObj != null) {
                                                        dArray[0] = dArray2[0];
                                                        dArray[1] = dArray2[1];
                                                    } else {
                                                        dArray[0] = 0.0;
                                                        dArray[1] = 0.0;
                                                    }
                                                }
                                                String string5 = null;
                                                if (this.myCDFExport.epoch == 0) {
                                                    string5 = Epoch16.encode((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 1) {
                                                    string5 = Epoch16.encode1((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 2) {
                                                    string5 = Epoch16.encode2((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 3) {
                                                    string5 = Epoch16.encode3((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 5) {
                                                    try {
                                                        String string6 = (String)variable.getEntryData("FORMAT");
                                                        string5 = string6 == null || string6.trim().length() == 0 ? Epoch16.encode((Object)dArray) : Epoch16.encodex((Object)dArray, (String)string6);
                                                    }
                                                    catch (CDFException cDFException) {
                                                        string5 = Epoch16.encode((Object)dArray);
                                                    }
                                                }
                                                this.recordObject[n2][n9][n3] = string5;
                                                break block467;
                                            }
                                            if (l != 51L && l != 52L) break block477;
                                            int n15 = (int)variable.getNumElements();
                                            byte[] byArray = new byte[n15];
                                            for (int i = 0; i < (int)lArray[0]; ++i) {
                                                int n16;
                                                if (this.myCDFExport.orientation == 0) {
                                                    n16 = i + n8;
                                                    if (n16 < 0) continue;
                                                    if (n16 >= this.ROWS) {
                                                        break block467;
                                                    }
                                                } else {
                                                    n16 = n8;
                                                    n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                                                    n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                                                }
                                                System.arraycopy(((String[])object)[i].getBytes(), 0, byArray, 0, n15);
                                                String string7 = new String(byArray);
                                                this.recordObject[n2][n16][n3] = string7;
                                            }
                                            break block467;
                                        }
                                        if (l != 41L && l != 1L) break block478;
                                        byte by = 0;
                                        byte by5 = 0;
                                        byte by6 = 0;
                                        byte by7 = 0;
                                        if (this.minObj != null && this.minLen == 1) {
                                            by5 = ((byte[])this.minObj)[0];
                                        }
                                        if (this.maxObj != null && this.maxLen == 1) {
                                            by6 = ((byte[])this.maxObj)[0];
                                        }
                                        if (this.filObj != null) {
                                            by7 = ((byte[])this.filObj)[0];
                                        }
                                        for (int i = 0; i < (int)lArray[0]; ++i) {
                                            int n17;
                                            if (this.myCDFExport.orientation == 0) {
                                                n17 = i + n8;
                                                if (n17 < 0) continue;
                                                if (n17 >= this.ROWS) {
                                                    break block467;
                                                }
                                            } else {
                                                n17 = n8;
                                                n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                                                n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                                            }
                                            by = lArray[0] > 1L ? ((byte[])object)[i] : (Byte)object;
                                            boolean bl = true;
                                            if (this.minObj != null) {
                                                if (this.minLen == 1) {
                                                    if (by < by5) {
                                                        bl = false;
                                                        by = this.filObj != null ? by7 : (byte)0;
                                                    }
                                                } else if (((byte[])this.minObj).length > i && by < ((byte[])this.minObj)[i]) {
                                                    bl = false;
                                                    by = this.filObj != null ? by7 : (byte)0;
                                                }
                                            }
                                            if (bl && this.maxObj != null) {
                                                if (this.maxLen == 1) {
                                                    if (by > by6) {
                                                        by = this.filObj != null ? by7 : (byte)0;
                                                    }
                                                } else if (((byte[])this.maxObj).length > i && by > ((byte[])this.maxObj)[i]) {
                                                    by = this.filObj != null ? by7 : (byte)0;
                                                }
                                            }
                                            this.recordObject[n2][n17][n3] = string == null ? new Byte(by) : Cformat.getInstance(string).form(by);
                                        }
                                        break block467;
                                    }
                                    if (l != 2L && l != 11L) break block479;
                                    short s = 0;
                                    short s5 = 0;
                                    short s6 = 0;
                                    short s7 = 0;
                                    if (this.minObj != null) {
                                        s5 = ((short[])this.minObj)[0];
                                    }
                                    if (this.maxObj != null) {
                                        s6 = ((short[])this.maxObj)[0];
                                    }
                                    if (this.filObj != null) {
                                        s7 = ((short[])this.filObj)[0];
                                    }
                                    if (l == 11L) {
                                        if (s5 < 0) {
                                            s5 = (short)(s5 + 256);
                                        }
                                        if (s6 < 0) {
                                            s6 = (short)(s6 + 256);
                                        }
                                        if (s7 < 0) {
                                            s7 = (short)(s7 + 256);
                                        }
                                    }
                                    for (int i = 0; i < (int)lArray[0]; ++i) {
                                        short s8;
                                        int n18;
                                        if (this.myCDFExport.orientation == 0) {
                                            n18 = i + n8;
                                            if (n18 < 0) continue;
                                            if (n18 >= this.ROWS) {
                                                break block467;
                                            }
                                        } else {
                                            n18 = n8;
                                            n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                                            n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                                        }
                                        s = lArray[0] > 1L ? ((short[])object)[i] : (Short)object;
                                        if (l == 11L && s < 0) {
                                            s = (short)(s + 256);
                                        }
                                        boolean bl = true;
                                        if (this.minObj != null) {
                                            if (this.minLen == 1) {
                                                if (s < s5) {
                                                    bl = false;
                                                    s = this.filObj != null ? s7 : (short)0;
                                                }
                                            } else if (((short[])this.minObj).length > i) {
                                                s8 = ((short[])this.minObj)[i];
                                                if (l == 11L && s8 < 0) {
                                                    s8 = (short)(s8 + 256);
                                                }
                                                if (s < s8) {
                                                    bl = false;
                                                    s = this.filObj != null ? s7 : (short)0;
                                                }
                                            }
                                        }
                                        if (bl && this.maxObj != null) {
                                            if (this.maxLen == 1) {
                                                if (s > s6) {
                                                    s = this.filObj != null ? s7 : (short)0;
                                                }
                                            } else if (((short[])this.maxObj).length > i) {
                                                s8 = ((short[])this.maxObj)[i];
                                                if (l == 11L && s8 < 0) {
                                                    s8 = (short)(s8 + 256);
                                                }
                                                if (s > s8) {
                                                    s = this.filObj != null ? s7 : (short)0;
                                                }
                                            }
                                        }
                                        this.recordObject[n2][n18][n3] = string == null ? new Short(s) : Cformat.getInstance(string).form(s);
                                    }
                                    break block467;
                                }
                                if (l != 4L && l != 12L) break block480;
                                int n19 = 0;
                                int n20 = 0;
                                int n21 = 0;
                                int n22 = 0;
                                if (this.minObj != null) {
                                    n20 = ((int[])this.minObj)[0];
                                }
                                if (this.maxObj != null) {
                                    n21 = ((int[])this.maxObj)[0];
                                }
                                if (this.filObj != null) {
                                    n22 = ((int[])this.filObj)[0];
                                }
                                if (l == 12L) {
                                    if (n20 < 0) {
                                        n20 += 65536;
                                    }
                                    if (n21 < 0) {
                                        n21 += 65536;
                                    }
                                    if (n22 < 0) {
                                        n22 += 65536;
                                    }
                                }
                                for (int i = 0; i < (int)lArray[0]; ++i) {
                                    int n23;
                                    int n24;
                                    if (this.myCDFExport.orientation == 0) {
                                        n24 = i + n8;
                                        if (n24 < 0) continue;
                                        if (n24 >= this.ROWS) {
                                            break block467;
                                        }
                                    } else {
                                        n24 = n8;
                                        n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                                        n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                                    }
                                    n19 = lArray[0] > 1L ? ((int[])object)[i] : (Integer)object;
                                    if (l == 12L && n19 < 0) {
                                        n19 += 65536;
                                    }
                                    boolean bl = true;
                                    if (this.minObj != null) {
                                        if (this.minLen == 1) {
                                            if (n19 < n20) {
                                                bl = false;
                                                n19 = this.filObj != null ? n22 : 0;
                                            }
                                        } else if (((int[])this.minObj).length > i) {
                                            n23 = ((int[])this.minObj)[i];
                                            if (l == 12L && n23 < 0) {
                                                n23 += 65536;
                                            }
                                            if (n19 < n23) {
                                                bl = false;
                                                n19 = this.filObj != null ? n22 : 0;
                                            }
                                        }
                                    }
                                    if (bl && this.maxObj != null) {
                                        if (this.maxLen == 1) {
                                            if (n19 > n21) {
                                                n19 = this.filObj != null ? n22 : 0;
                                            }
                                        } else if (((int[])this.maxObj).length > i) {
                                            n23 = ((int[])this.maxObj)[i];
                                            if (l == 12L && n23 < 0) {
                                                n23 += 65536;
                                            }
                                            if (n19 > n23) {
                                                n19 = this.filObj != null ? n22 : 0;
                                            }
                                        }
                                    }
                                    this.recordObject[n2][n24][n3] = string == null ? new Integer(n19) : Cformat.getInstance(string).form(n19);
                                }
                                break block467;
                            }
                            if (l != 14L) break block481;
                            long l6 = 0L;
                            long l7 = 0L;
                            long l8 = 0L;
                            long l9 = 0L;
                            if (this.minObj != null) {
                                l7 = ((long[])this.minObj)[0];
                            }
                            if (this.maxObj != null) {
                                l8 = ((long[])this.maxObj)[0];
                            }
                            if (this.filObj != null) {
                                l9 = ((long[])this.filObj)[0];
                            }
                            if (l7 < 0L) {
                                l7 -= -4294967296L;
                            }
                            if (l8 < 0L) {
                                l8 -= -4294967296L;
                            }
                            if (l9 < 0L) {
                                l9 -= -4294967296L;
                            }
                            for (int i = 0; i < (int)lArray[0]; ++i) {
                                long l10;
                                int n25;
                                if (this.myCDFExport.orientation == 0) {
                                    n25 = i + n8;
                                    if (n25 < 0) continue;
                                    if (n25 >= this.ROWS) {
                                        break block467;
                                    }
                                } else {
                                    n25 = n8;
                                    n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                                    n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                                }
                                if ((l6 = lArray[0] > 1L ? ((long[])object)[i] : (Long)object) < 0L) {
                                    l6 -= -4294967296L;
                                }
                                boolean bl = true;
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (l6 < l7) {
                                            bl = false;
                                            l6 = this.filObj != null ? l9 : 0L;
                                        }
                                    } else if (((long[])this.minObj).length > i) {
                                        l10 = ((long[])this.minObj)[i];
                                        if (l10 < 0L) {
                                            l10 -= -4294967296L;
                                        }
                                        if (l6 < l10) {
                                            bl = false;
                                            l6 = this.filObj != null ? l9 : 0L;
                                        }
                                    }
                                }
                                if (bl && this.maxObj != null) {
                                    if (this.maxLen == 1) {
                                        if (l6 > l8) {
                                            l6 = this.filObj != null ? l9 : 0L;
                                        }
                                    } else if (((long[])this.maxObj).length > i) {
                                        l10 = ((long[])this.maxObj)[i];
                                        if (l10 < 0L) {
                                            l10 -= -4294967296L;
                                        }
                                        if (l6 > l10) {
                                            l6 = this.filObj != null ? l9 : 0L;
                                        }
                                    }
                                }
                                this.recordObject[n2][n25][n3] = string == null ? new Long(l6) : Cformat.getInstance(string).form(l6);
                            }
                            break block467;
                        }
                        if (l != 21L && l != 44L) break block482;
                        float f = 0.0f;
                        float f5 = 0.0f;
                        float f6 = 0.0f;
                        float f7 = 0.0f;
                        if (this.minObj != null && this.minLen == 1) {
                            f5 = ((float[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            f6 = ((float[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            f7 = ((float[])this.filObj)[0];
                        }
                        for (int i = 0; i < (int)lArray[0]; ++i) {
                            int n26;
                            if (this.myCDFExport.orientation == 0) {
                                n26 = i + n8;
                                if (n26 < 0) continue;
                                if (n26 >= this.ROWS) {
                                    break block467;
                                }
                            } else {
                                n26 = n8;
                                n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                                n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                            }
                            f = lArray[0] > 1L ? ((float[])object)[i] : ((Float)object).floatValue();
                            boolean bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (f < f5) {
                                        bl = false;
                                        f = this.filObj != null ? f7 : 0.0f;
                                    }
                                } else if (((float[])this.minObj).length > i && f < ((float[])this.minObj)[i]) {
                                    bl = false;
                                    f = this.filObj != null ? f7 : 0.0f;
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (f > f6) {
                                        f = this.filObj != null ? f7 : 0.0f;
                                    }
                                } else if (((float[])this.maxObj).length > i && f > ((float[])this.maxObj)[i]) {
                                    f = this.filObj != null ? f7 : 0.0f;
                                }
                            }
                            this.recordObject[n2][n26][n3] = string == null ? new Float(f) : Cformat.getInstance(string).form(f);
                        }
                        break block467;
                    }
                    if (l != 22L && l != 45L && l != 31L) break block483;
                    double d = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    if (this.minObj != null && this.minLen == 1) {
                        d5 = ((double[])this.minObj)[0];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        d6 = ((double[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        d7 = ((double[])this.filObj)[0];
                    }
                    for (int i = 0; i < (int)lArray[0]; ++i) {
                        int n27;
                        if (this.myCDFExport.orientation == 0) {
                            n27 = i + n8;
                            if (n27 < 0) continue;
                            if (n27 >= this.ROWS) {
                                break block467;
                            }
                        } else {
                            n27 = n8;
                            n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                            n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                        }
                        d = lArray[0] > 1L ? ((double[])object)[i] : (Double)object;
                        boolean bl = true;
                        if (this.minObj != null) {
                            if (this.minLen == 1) {
                                if (d < d5) {
                                    bl = false;
                                    d = this.filObj != null ? d7 : 0.0;
                                }
                            } else if (((double[])this.minObj).length > i && d < ((double[])this.minObj)[i]) {
                                bl = false;
                                d = this.filObj != null ? d7 : 0.0;
                            }
                        }
                        if (bl && this.maxObj != null) {
                            if (this.maxLen == 1) {
                                if (d > d6) {
                                    d = this.filObj != null ? d7 : 0.0;
                                }
                            } else if (((double[])this.maxObj).length > i && d > ((double[])this.maxObj)[i]) {
                                d = this.filObj != null ? d7 : 0.0;
                            }
                        }
                        if (l != 31L) {
                            if (string == null) {
                                this.recordObject[n2][n27][n3] = new Double(d);
                                continue;
                            }
                            this.recordObject[n2][n27][n3] = Cformat.getInstance(string).form(d);
                            continue;
                        }
                        String string8 = null;
                        if (this.myCDFExport.epoch == 0) {
                            string8 = Epoch.encode((double)d);
                        } else if (this.myCDFExport.epoch == 1) {
                            string8 = Epoch.encode1((double)d);
                        } else if (this.myCDFExport.epoch == 2) {
                            string8 = Epoch.encode2((double)d);
                        } else if (this.myCDFExport.epoch == 3) {
                            string8 = Epoch.encode3((double)d);
                        } else if (this.myCDFExport.epoch == 5) {
                            try {
                                String string9 = (String)variable.getEntryData("FORMAT");
                                string8 = string9 == null || string9.trim().length() == 0 ? Epoch.encode((double)d) : Epoch.encodex((double)d, (String)string9);
                            }
                            catch (CDFException cDFException) {
                                string8 = Epoch.encode((double)d);
                            }
                        }
                        this.recordObject[n2][n27][n3] = string8;
                    }
                    break block467;
                }
                if (l != 32L) break block467;
                double[] dArray = new double[]{0.0, 0.0};
                double[] dArray5 = new double[]{0.0, 0.0};
                double[] dArray6 = new double[]{0.0, 0.0};
                double[] dArray7 = new double[]{0.0, 0.0};
                if (this.minObj != null && this.minLen == 1) {
                    dArray5[0] = ((double[])this.minObj)[0];
                    dArray5[0] = ((double[])this.minObj)[0];
                }
                if (this.maxObj != null && this.maxLen == 1) {
                    dArray6[0] = ((double[])this.maxObj)[0];
                    dArray6[0] = ((double[])this.maxObj)[0];
                }
                if (this.filObj != null) {
                    dArray7[0] = ((double[])this.filObj)[0];
                    dArray7[0] = ((double[])this.filObj)[0];
                }
                for (int i = 0; i < (int)lArray[0]; ++i) {
                    int n28;
                    if (this.myCDFExport.orientation == 0) {
                        n28 = i + n8;
                        if (n28 < 0) continue;
                        if (n28 >= this.ROWS) {
                            break block467;
                        }
                    } else {
                        n28 = n8;
                        n2 = (this.eleIndex[this.currentVar] + i) / this.COLUMNS;
                        n3 = (this.eleIndex[this.currentVar] + i) % this.COLUMNS + this.istart;
                    }
                    if (lArray[0] > 1L) {
                        dArray[0] = ((double[])object)[2 * i];
                        dArray[1] = ((double[])object)[2 * i + 1];
                    } else {
                        dArray[0] = ((double[])object)[0];
                        dArray[1] = ((double[])object)[1];
                    }
                    boolean bl = true;
                    if (this.minObj != null) {
                        if (this.minLen == 1) {
                            if (dArray[0] < dArray5[0] || dArray[0] == dArray5[0] && dArray[1] < dArray5[1]) {
                                bl = false;
                                if (this.filObj != null) {
                                    dArray[0] = dArray7[0];
                                    dArray[1] = dArray7[1];
                                } else {
                                    dArray[0] = 0.0;
                                    dArray[0] = 0.0;
                                }
                            }
                        } else if (((double[])this.minObj).length > i && (dArray[0] < ((double[])this.minObj)[2 * i] || dArray[0] == ((double[])this.minObj)[2 * i] && dArray[1] < ((double[])this.minObj)[2 * i + 1])) {
                            bl = false;
                            if (this.filObj != null) {
                                dArray[0] = dArray7[0];
                                dArray[1] = dArray7[1];
                            } else {
                                dArray[1] = 0.0;
                                dArray[0] = 0.0;
                            }
                        }
                    }
                    if (bl && this.maxObj != null) {
                        if (this.maxLen == 1) {
                            if (dArray[0] > dArray6[0] || dArray[0] == dArray6[0] && dArray[1] > dArray6[1]) {
                                if (this.filObj != null) {
                                    dArray[0] = dArray7[0];
                                    dArray[1] = dArray7[1];
                                } else {
                                    dArray[1] = 0.0;
                                    dArray[0] = 0.0;
                                }
                            }
                        } else if (((double[])this.maxObj).length > i && (dArray[0] > ((double[])this.maxObj)[2 * i] || dArray[0] == ((double[])this.maxObj)[2 * i] && dArray[1] > ((double[])this.maxObj)[2 * i + 1])) {
                            if (this.filObj != null) {
                                dArray[0] = dArray7[0];
                                dArray[1] = dArray7[1];
                            } else {
                                dArray[1] = 0.0;
                                dArray[0] = 0.0;
                            }
                        }
                    }
                    String string10 = null;
                    if (this.myCDFExport.epoch == 0) {
                        string10 = Epoch16.encode((Object)dArray);
                    } else if (this.myCDFExport.epoch == 1) {
                        string10 = Epoch16.encode1((Object)dArray);
                    } else if (this.myCDFExport.epoch == 2) {
                        string10 = Epoch16.encode2((Object)dArray);
                    } else if (this.myCDFExport.epoch == 3) {
                        string10 = Epoch16.encode3((Object)dArray);
                    } else if (this.myCDFExport.epoch == 5) {
                        try {
                            String string11 = (String)variable.getEntryData("FORMAT");
                            string10 = string11 == null || string11.trim().length() == 0 ? Epoch16.encode((Object)dArray) : Epoch16.encodex((Object)dArray, (String)string11);
                        }
                        catch (CDFException cDFException) {
                            string10 = Epoch16.encode((Object)dArray);
                        }
                    }
                    this.recordObject[n2][n28][n3] = string10;
                }
                break block467;
            }
            int n29 = this.eleIndex[this.currentVar];
            int n30 = (int)lArray[n - 1];
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[n - 1];
            int[] nArray = new int[n - 1];
            long[] lArray2 = new long[n - 1];
            nArray[0] = 0;
            lArray2[0] = this.product(lArray, 0, n);
            objectArray2[0] = object;
            for (n7 = 1; n7 < n - 1; ++n7) {
                objectArray2[n7] = Array.get(objectArray2[n7 - 1], 0);
                lArray2[n7] = this.product(lArray, n7, n);
                nArray[n7] = 0;
            }
            n7 = 0;
            Object object2 = object;
            while ((long)n7 < lArray2[0]) {
                int n31;
                int n32;
                boolean bl;
                int n33;
                int n34;
                if (n7 != 0) {
                    for (int i = 0; i < n - 1; ++i) {
                        boolean bl2;
                        boolean bl3 = bl2 = (long)n7 % lArray2[i] == 0L;
                        if (bl2) {
                            int n35 = i;
                            nArray[n35] = nArray[n35] + 1;
                            objectArray2[i] = object2 = Array.get(object2, nArray[i]);
                            for (int j = i + 1; j < n - 1; ++j) {
                                nArray[j] = 0;
                                objectArray2[j] = Array.get(objectArray2[j - 1], nArray[j]);
                            }
                            break;
                        }
                        object2 = objectArray2[i];
                    }
                }
                if (l == 51L || l == 52L) {
                    int n36 = (int)variable.getNumElements();
                    byte[] byArray = new byte[n36];
                    block24: for (int i = 0; i < (int)lArray[n - 2]; ++i) {
                        objectArray = (String[])Array.get(objectArray2[n - 2], i);
                        for (int j = 0; j < n30; ++j) {
                            if (this.myCDFExport.orientation == 0) {
                                n34 = j + n8 + i * n30;
                                if (n34 < 0) continue;
                                if (n34 > n6) {
                                    continue block24;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            System.arraycopy(objectArray[i].getBytes(), 0, byArray, 0, n36);
                            String string12 = new String(byArray);
                            this.recordObject[n2][n34][n3] = string12;
                        }
                    }
                } else if (l == 41L || l == 1L) {
                    byte by = 0;
                    byte by8 = 0;
                    byte by9 = 0;
                    byte by10 = 0;
                    if (this.minObj != null && this.minLen == 1) {
                        by8 = ((byte[])this.minObj)[0];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        by9 = ((byte[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        by10 = ((byte[])this.filObj)[0];
                    }
                    block26: for (int i = 0; i < (int)lArray[n - 2]; ++i) {
                        objectArray = (byte[])Array.get(objectArray2[n - 2], i);
                        for (n33 = 0; n33 < n30; ++n33) {
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n33 + n8 + i * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block26;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            by = ((byte[])objectArray)[n33];
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (by < by8) {
                                        bl = false;
                                        by = this.filObj != null ? by10 : (byte)0;
                                    }
                                } else if (((byte[])this.minObj).length > n33 && by < ((byte[])this.minObj)[n33]) {
                                    bl = false;
                                    by = this.filObj != null ? by10 : (byte)0;
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (by > by9) {
                                        by = this.filObj != null ? by10 : (byte)0;
                                    }
                                } else if (((byte[])this.maxObj).length > n33 && by > ((byte[])this.maxObj)[n33]) {
                                    by = this.filObj != null ? by10 : (byte)0;
                                }
                            }
                            this.recordObject[n2][n34][n3] = string == null ? new Byte(by) : Cformat.getInstance(string).form(by);
                        }
                    }
                } else if (l == 2L || l == 11L) {
                    short s = 0;
                    short s9 = 0;
                    short s10 = 0;
                    short s11 = 0;
                    if (this.minObj != null) {
                        s9 = ((short[])this.minObj)[0];
                    }
                    if (this.maxObj != null) {
                        s10 = ((short[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        s11 = ((short[])this.filObj)[0];
                    }
                    if (l == 11L) {
                        if (s9 < 0) {
                            s9 = (short)(s9 + 256);
                        }
                        if (s10 < 0) {
                            s10 = (short)(s10 + 256);
                        }
                        if (s11 < 0) {
                            s11 = (short)(s11 + 256);
                        }
                    }
                    block28: for (int i = 0; i < (int)lArray[n - 2]; ++i) {
                        objectArray = (short[])Array.get(objectArray2[n - 2], i);
                        for (n33 = 0; n33 < n30; ++n33) {
                            short s12;
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n33 + n8 + i * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block28;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            s = ((short[])objectArray)[n33];
                            if (l == 11L && s < 0) {
                                s = (short)(s + 256);
                            }
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (s < s9) {
                                        bl = false;
                                        s = this.filObj != null ? s11 : (short)0;
                                    }
                                } else if (((short[])this.minObj).length > n33) {
                                    s12 = ((short[])this.minObj)[n33];
                                    if (l == 11L && s12 < 0) {
                                        s12 = (short)(s12 + 256);
                                    }
                                    if (s < s12) {
                                        bl = false;
                                        s = this.filObj != null ? s11 : (short)0;
                                    }
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (s > s10) {
                                        s = this.filObj != null ? s11 : (short)0;
                                    }
                                } else if (((short[])this.maxObj).length > n33) {
                                    s12 = ((short[])this.maxObj)[n33];
                                    if (l == 11L && s12 < 0) {
                                        s12 = (short)(s12 + 256);
                                    }
                                    if (s > s12) {
                                        s = this.filObj != null ? s11 : (short)0;
                                    }
                                }
                            }
                            this.recordObject[n2][n34][n3] = string == null ? new Short(s) : Cformat.getInstance(string).form(s);
                        }
                    }
                } else if (l == 4L || l == 12L) {
                    int n37 = 0;
                    int n38 = 0;
                    int n39 = 0;
                    int n40 = 0;
                    if (this.minObj != null) {
                        n38 = ((int[])this.minObj)[0];
                    }
                    if (this.maxObj != null) {
                        n39 = ((int[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        n40 = ((int[])this.filObj)[0];
                    }
                    if (l == 12L) {
                        if (n38 < 0) {
                            n38 += 65536;
                        }
                        if (n39 < 0) {
                            n39 += 65536;
                        }
                        if (n40 < 0) {
                            n40 += 65536;
                        }
                    }
                    block30: for (int i = 0; i < (int)lArray[n - 2]; ++i) {
                        objectArray = (int[])Array.get(objectArray2[n - 2], i);
                        for (n33 = 0; n33 < n30; ++n33) {
                            int n41;
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n33 + n8 + i * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block30;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            n37 = ((int[])objectArray)[n33];
                            if (l == 12L && n37 < 0) {
                                n37 += 65536;
                            }
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (n37 < n38) {
                                        bl = false;
                                        n37 = this.filObj != null ? n40 : 0;
                                    }
                                } else if (((int[])this.minObj).length > n33) {
                                    n41 = ((int[])this.minObj)[n33];
                                    if (l == 12L && n41 < 0) {
                                        n41 += 65536;
                                    }
                                    if (n37 < n41) {
                                        bl = false;
                                        n37 = this.filObj != null ? n40 : 0;
                                    }
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (n37 > n38) {
                                        n37 = this.filObj != null ? n40 : 0;
                                    }
                                } else if (((int[])this.maxObj).length > n33) {
                                    n41 = ((int[])this.maxObj)[n33];
                                    if (l == 12L && n41 < 0) {
                                        n41 += 65536;
                                    }
                                    if (n37 > n41) {
                                        n37 = this.filObj != null ? n40 : 0;
                                    }
                                }
                            }
                            this.recordObject[n2][n34][n3] = string == null ? new Integer(n37) : Cformat.getInstance(string).form(n37);
                        }
                    }
                } else if (l == 14L) {
                    long l11 = 0L;
                    long l12 = 0L;
                    long l13 = 0L;
                    long l14 = 0L;
                    if (this.minObj != null) {
                        l12 = ((long[])this.minObj)[0];
                    }
                    if (this.maxObj != null) {
                        l13 = ((long[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        l14 = ((long[])this.filObj)[0];
                    }
                    if (l12 < 0L) {
                        l12 -= -4294967296L;
                    }
                    if (l13 < 0L) {
                        l13 -= -4294967296L;
                    }
                    if (l14 < 0L) {
                        l14 -= -4294967296L;
                    }
                    block32: for (n32 = 0; n32 < (int)lArray[n - 2]; ++n32) {
                        objectArray = (long[])Array.get(objectArray2[n - 2], n32);
                        for (n31 = 0; n31 < n30; ++n31) {
                            long l15;
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n31 + n8 + n32 * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block32;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            if ((l11 = ((long[])objectArray)[n31]) < 0L) {
                                l11 -= -4294967296L;
                            }
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (l11 < l12) {
                                        bl = false;
                                        l11 = this.filObj != null ? l14 : 0L;
                                    }
                                } else if (((long[])this.minObj).length > n31) {
                                    l15 = ((long[])this.minObj)[n31];
                                    if (l15 < 0L) {
                                        l15 -= -4294967296L;
                                    }
                                    if (l11 < l15) {
                                        bl = false;
                                        l11 = this.filObj != null ? l14 : 0L;
                                    }
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (l11 > l13) {
                                        l11 = this.filObj != null ? l14 : 0L;
                                    }
                                } else if (((long[])this.maxObj).length > n31) {
                                    l15 = ((long[])this.maxObj)[n31];
                                    if (l15 < 0L) {
                                        l15 -= -4294967296L;
                                    }
                                    if (l11 > l15) {
                                        l11 = this.filObj != null ? l14 : 0L;
                                    }
                                }
                            }
                            this.recordObject[n2][n34][n3] = string == null ? new Long(l11) : Cformat.getInstance(string).form(l11);
                        }
                    }
                } else if (l == 21L || l == 44L) {
                    float f = 0.0f;
                    float f8 = 0.0f;
                    float f9 = 0.0f;
                    float f10 = 0.0f;
                    if (this.minObj != null && this.minLen == 1) {
                        f8 = ((float[])this.minObj)[0];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        f9 = ((float[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        f10 = ((float[])this.filObj)[0];
                    }
                    block34: for (int i = 0; i < (int)lArray[n - 2]; ++i) {
                        objectArray = (float[])Array.get(objectArray2[n - 2], i);
                        for (n33 = 0; n33 < n30; ++n33) {
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n33 + n8 + i * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block34;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            f = ((float[])objectArray)[n33];
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (f < f8) {
                                        bl = false;
                                        f = this.filObj != null ? f10 : 0.0f;
                                    }
                                } else if (((float[])this.minObj).length > n33 && f < ((float[])this.minObj)[n33]) {
                                    bl = false;
                                    f = this.filObj != null ? f10 : 0.0f;
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (f > f9) {
                                        f = this.filObj != null ? f10 : 0.0f;
                                    }
                                } else if (((float[])this.maxObj).length > n33 && f > ((float[])this.maxObj)[n33]) {
                                    f = this.filObj != null ? f10 : 0.0f;
                                }
                            }
                            this.recordObject[n2][n34][n3] = string == null ? new Float(f) : Cformat.getInstance(string).form(f);
                        }
                    }
                } else if (l == 22L || l == 45L || l == 31L) {
                    double d = 0.0;
                    double d8 = 0.0;
                    double d9 = 0.0;
                    double d10 = 0.0;
                    if (this.minObj != null && this.minLen == 1) {
                        d8 = ((double[])this.minObj)[0];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        d9 = ((double[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        d10 = ((double[])this.filObj)[0];
                    }
                    block36: for (n32 = 0; n32 < (int)lArray[n - 2]; ++n32) {
                        objectArray = (double[])Array.get(objectArray2[n - 2], n32);
                        for (n31 = 0; n31 < n30; ++n31) {
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n31 + n8 + n32 * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block36;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            d = ((double[])objectArray)[n31];
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (d < d8) {
                                        bl = false;
                                        d = this.filObj != null ? d10 : 0.0;
                                    }
                                } else if (((double[])this.minObj).length > n31 && d < ((double[])this.minObj)[n31]) {
                                    bl = false;
                                    d = this.filObj != null ? d10 : 0.0;
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (d > d9) {
                                        d = this.filObj != null ? d10 : 0.0;
                                    }
                                } else if (((double[])this.maxObj).length > n31 && d > ((double[])this.maxObj)[n31]) {
                                    d = this.filObj != null ? d10 : 0.0;
                                }
                            }
                            if (l != 31L) {
                                if (string == null) {
                                    this.recordObject[n2][n34][n3] = new Double(d);
                                    continue;
                                }
                                this.recordObject[n2][n34][n3] = Cformat.getInstance(string).form(d);
                                continue;
                            }
                            String string13 = null;
                            if (this.myCDFExport.epoch == 0) {
                                string13 = Epoch.encode((double)d);
                            } else if (this.myCDFExport.epoch == 1) {
                                string13 = Epoch.encode1((double)d);
                            } else if (this.myCDFExport.epoch == 2) {
                                string13 = Epoch.encode2((double)d);
                            } else if (this.myCDFExport.epoch == 3) {
                                string13 = Epoch.encode3((double)d);
                            } else if (this.myCDFExport.epoch == 5) {
                                try {
                                    String string14 = (String)variable.getEntryData("FORMAT");
                                    string13 = string14 == null || string14.trim().length() == 0 ? Epoch.encode((double)d) : Epoch.encodex((double)d, (String)string14);
                                }
                                catch (CDFException cDFException) {
                                    string13 = Epoch.encode((double)d);
                                }
                            }
                            this.recordObject[n2][n34][n3] = string13;
                        }
                    }
                } else if (l == 32L) {
                    double[] dArray = new double[]{0.0, 0.0};
                    double[] dArray8 = new double[]{0.0, 0.0};
                    double[] dArray9 = new double[]{0.0, 0.0};
                    double[] dArray10 = new double[]{0.0, 0.0};
                    if (this.minObj != null && this.minLen == 1) {
                        dArray8[0] = ((double[])this.minObj)[0];
                        dArray8[1] = ((double[])this.minObj)[1];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        dArray9[0] = ((double[])this.maxObj)[0];
                        dArray9[1] = ((double[])this.maxObj)[1];
                    }
                    if (this.filObj != null) {
                        dArray10[0] = ((double[])this.filObj)[0];
                        dArray10[1] = ((double[])this.filObj)[1];
                    }
                    block38: for (int i = 0; i < (int)lArray[n - 2]; ++i) {
                        objectArray = (double[])Array.get(objectArray2[n - 2], i);
                        for (n33 = 0; n33 < n30; ++n33) {
                            if (this.myCDFExport.orientation == 0) {
                                n34 = n33 + n8 + i * n30;
                                if (n34 < 0) continue;
                                if (n34 >= this.ROWS) {
                                    continue block38;
                                }
                            } else {
                                n34 = n8;
                                n2 = n29 / this.COLUMNS;
                                n3 = n29 % this.COLUMNS + this.istart;
                                ++n29;
                            }
                            dArray[0] = ((double[])objectArray)[2 * n33];
                            dArray[1] = ((double[])objectArray)[2 * n33 + 1];
                            bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (dArray[0] < dArray8[0] || dArray[0] < dArray8[0] && dArray[1] < dArray8[1]) {
                                        bl = false;
                                        if (this.filObj != null) {
                                            dArray[0] = dArray10[0];
                                            dArray[1] = dArray10[1];
                                        } else {
                                            dArray[1] = 0.0;
                                            dArray[0] = 0.0;
                                        }
                                    }
                                } else if (((double[])this.minObj).length > n33 && (dArray[0] < ((double[])this.minObj)[2 * n33] || dArray[0] == ((double[])this.minObj)[2 * n33] && dArray[1] < ((double[])this.minObj)[2 * n33 + 1])) {
                                    bl = false;
                                    if (this.filObj != null) {
                                        dArray[0] = dArray10[0];
                                        dArray[1] = dArray10[1];
                                    } else {
                                        dArray[1] = 0.0;
                                        dArray[0] = 0.0;
                                    }
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (dArray[0] > dArray9[0] || dArray[0] == dArray9[0] && dArray[1] > dArray9[1]) {
                                        if (this.filObj != null) {
                                            dArray[0] = dArray10[0];
                                            dArray[1] = dArray10[1];
                                        } else {
                                            dArray[1] = 0.0;
                                            dArray[0] = 0.0;
                                        }
                                    }
                                } else if (((double[])this.maxObj).length > n33 && (dArray[0] > ((double[])this.maxObj)[2 * n33] || dArray[0] == ((double[])this.maxObj)[2 * n33] && dArray[1] > ((double[])this.maxObj)[2 * n33 + 1])) {
                                    if (this.filObj != null) {
                                        dArray[0] = dArray10[0];
                                        dArray[1] = dArray10[1];
                                    } else {
                                        dArray[1] = 0.0;
                                        dArray[0] = 0.0;
                                    }
                                }
                            }
                            String string15 = null;
                            if (this.myCDFExport.epoch == 0) {
                                string15 = Epoch16.encode((Object)dArray);
                                continue;
                            }
                            if (this.myCDFExport.epoch == 1) {
                                string15 = Epoch16.encode1((Object)dArray);
                                continue;
                            }
                            if (this.myCDFExport.epoch == 2) {
                                string15 = Epoch16.encode2((Object)dArray);
                                continue;
                            }
                            if (this.myCDFExport.epoch == 3) {
                                string15 = Epoch16.encode3((Object)dArray);
                                continue;
                            }
                            if (this.myCDFExport.epoch != 5) continue;
                            try {
                                String string16 = (String)variable.getEntryData("FORMAT");
                                string15 = string16 == null || string16.trim().length() == 0 ? Epoch16.encode((Object)dArray) : Epoch16.encodex((Object)dArray, (String)string16);
                            }
                            catch (CDFException cDFException) {
                                string15 = Epoch16.encode((Object)dArray);
                            }
                            this.recordObject[n2][n34][n3] = string15;
                        }
                    }
                }
                n7 = (int)((long)n7 + lArray2[n - 2]);
            }
        }
        return object;
    }

    private long product(long[] lArray, int n, int n2) {
        long l = 1L;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] <= 1L) continue;
            l *= lArray[i];
        }
        return l;
    }

    private void createButton(JPanel jPanel) {
        if (this.enterButton == null) {
            this.enterButton = new JButton(ENTER);
            this.backButton = new JButton(BACK);
            this.cancelButton = new JButton(CANCEL);
            this.buttonPanel = new JPanel(true);
            this.buttonPanel.add(this.enterButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(30, 1)));
            this.buttonPanel.add(this.backButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(30, 1)));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(30, 1)));
            this.aSelection = new SelectionListener();
            this.enterButton.addActionListener(this.aSelection);
            this.backButton.addActionListener(this.aSelection);
            this.cancelButton.addActionListener(this.aSelection);
            this.enterButton.setToolTipText("Continue to the next page...");
            this.backButton.setToolTipText("Back to the previous page...");
            this.cancelButton.setToolTipText("Stop and retrun...");
            jPanel.add((Component)this.buttonPanel, "South");
        }
    }

    void cleanTableObjects() {
        for (int i = 0; i < this.groups; ++i) {
            for (int j = 0; j < this.ROWS; ++j) {
                for (int k = 0; k < this.totalColumns; ++k) {
                    this.recordObject[i][j][k] = " ";
                }
            }
        }
    }

    void cleanColumns() {
        for (int i = 0; i < this.groups; ++i) {
            for (int j = 0; j < this.totalColumns; ++j) {
                this.columnNames[i][j] = " ";
            }
        }
    }

    void metaToFile(BufferedWriter bufferedWriter) {
        Vector vector = this.myCDFExport.sourceCDF.getGlobalAttributes();
        try {
            bufferedWriter.write("Global Attributes:");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                bufferedWriter.write("  " + attribute.getName());
                bufferedWriter.newLine();
                Vector vector2 = attribute.getEntries();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    Entry entry = (Entry)enumeration2.nextElement();
                    if (entry == null) continue;
                    long l = entry.getDataType();
                    int n = 0;
                    if (l == 31L) {
                        n = 1;
                    } else if (l == 32L) {
                        n = 2;
                    }
                    bufferedWriter.write("    \"" + CDFUtils.getStringData((Object)entry.getData(), (String)" ", (int)n) + "\" ");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            System.err.println("error writing meta data");
        }
    }

    protected BuildProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            if (this.focusedObj == this.pageField) {
                this.enterButton.doClick();
            } else {
                int n2 = Integer.parseInt(this.recordField.getText());
                int n3 = this.elementNum / this.totalElementsPerRec + 1;
                if (++n2 < 1 || n2 > this.totalWritten + 1) {
                    this.recordField.setText("" + n3);
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.elementNum = this.myCDFExport.orientation == 0 ? (n2 - 1) * this.totalElementsPerRec : n2 - 1;
                    this.recordField.setText("" + n2);
                    this.cleanTableObjects();
                    this.fillVarRecsToTable(this.elementNum);
                    this.displayTable(this.mainPanel);
                }
            }
        } else if (n == 40) {
            if (this.focusedObj == this.pageField) {
                this.backButton.doClick();
            } else {
                int n4 = Integer.parseInt(this.recordField.getText());
                int n5 = this.elementNum / this.totalElementsPerRec + 1;
                if (--n4 < 1 || n4 > this.totalWritten + 1) {
                    this.recordField.setText("" + n5);
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.elementNum = this.myCDFExport.orientation == 0 ? (n4 - 1) * this.totalElementsPerRec : n4 - 1;
                    this.recordField.setText("" + n4);
                    this.cleanTableObjects();
                    this.fillVarRecsToTable(this.elementNum);
                    this.displayTable(this.mainPanel);
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focusedObj = focusEvent.getSource();
        boolean bl = false;
        if (this.focusedObj == this.pageField) {
            this.pageField.setNextFocusableComponent(this.recordField);
        } else if (this.focusedObj == this.recordField) {
            this.recordField.setNextFocusableComponent(this.pageField);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isManagingFocus() {
        return true;
    }

    static /* synthetic */ ExportVarDisplayTable[] access$102(ExportToText exportToText, ExportVarDisplayTable[] exportVarDisplayTableArray) {
        exportToText.aToScreenTable = exportVarDisplayTableArray;
        return exportVarDisplayTableArray;
    }

    static /* synthetic */ JScrollPane[] access$402(ExportToText exportToText, JScrollPane[] jScrollPaneArray) {
        exportToText.scrollPane = jScrollPaneArray;
        return jScrollPaneArray;
    }

    static /* synthetic */ Object[][][] access$602(ExportToText exportToText, Object[][][] objectArray) {
        exportToText.recordObject = objectArray;
        return objectArray;
    }

    static {
        headcol1 = "Record #";
        headcol2 = "Indices";
        defaultModal = true;
    }

    class CleanProgress
    extends Thread {
        CleanProgress() {
        }

        public void run() {
            ExportToText.this.progressPanel.dispose();
            ExportToText.this.progressPanel = null;
            if (((ExportToText)ExportToText.this).myCDFExport.MacOS) {
                System.gc();
            }
        }
    }

    class OutToFile
    extends Thread {
        OutToFile() {
        }

        public void run() {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                FileWriter fileWriter = new FileWriter(((ExportToText)ExportToText.this).myCDFExport.cdfspec2);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter, 8192);
                Vector vector = ((ExportToText)ExportToText.this).myCDFExport.sourceCDF.getGlobalAttributes();
                int n5 = ((ExportToText)ExportToText.this).myCDFExport.headings == 1 ? (vector == null ? 0 : vector.size()) : 0;
                ExportToText.this.totalItems = (ExportToText.this.lastPageToDisplay + 1) * ExportToText.this.ROWS * ExportToText.this.groups * ExportToText.this.totalColumns + ExportToText.this.groups * ExportToText.this.totalColumns + n5;
                ExportToText.this.progressPanel = new BuildProgressPanel((Object)exportToText, ExportToText.this.totalItems);
                int n6 = 0;
                StringBuffer stringBuffer = new StringBuffer("");
                int n7 = 0;
                int n8 = 0;
                if (((ExportToText)ExportToText.this).myCDFExport.headings == 1) {
                    ExportToText.this.metaToFile(bufferedWriter);
                    if (ExportToText.this.vars.size() > 0) {
                        bufferedWriter.write("Variables:");
                        bufferedWriter.newLine();
                        bufferedWriter.newLine();
                        ExportToText.this.currentProgressValue = n5;
                        new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                    }
                    for (int i = 0; i < ExportToText.this.groups; ++i) {
                        for (n4 = 0; n4 < ExportToText.this.totalColumns; ++n4) {
                            if (i > 0 && n4 < ExportToText.this.istart) continue;
                            if (((ExportToText)ExportToText.this).myCDFExport.orientation != 0 ? n7 == ExportToText.this.totalElements : ExportToText.this.columnNames[i][n4].equals(null) || ExportToText.this.columnNames[i][n4].trim().length() == 0) break;
                            if (ExportToText.this.columnNames[i][n4].equals(headcol1)) {
                                stringBuffer = CDFToolUtils.CatToString(stringBuffer, "Record", 6, 1, "*");
                            } else if (ExportToText.this.columnNames[i][n4].equals(headcol2)) {
                                stringBuffer = CDFToolUtils.CatToString(stringBuffer, "Indices", 11, 1, "*");
                            } else {
                                if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                                    n3 = ExportToText.this.varWidth[n6++];
                                } else {
                                    n2 = 0;
                                    for (n = 0; n < ExportToText.this.vars.size(); ++n) {
                                        if (n7 == ExportToText.this.varsHor[n]) {
                                            n2 = 1;
                                            break;
                                        }
                                        if (n7 < ExportToText.this.varsHor[n]) break;
                                    }
                                    ++n7;
                                    if (n2 != 0) {
                                        n8 = n3 = ExportToText.this.varWidth[n6++];
                                    } else {
                                        n3 = n8;
                                    }
                                }
                                stringBuffer = CDFToolUtils.CatToString(stringBuffer, ExportToText.this.columnNames[i][n4], n3, 2, "*");
                            }
                            stringBuffer.append(" ");
                        }
                        ExportToText.this.currentProgressValue += ExportToText.this.totalColumns;
                    }
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                    new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                }
                if (ExportToText.this.vars.size() > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    n2 = 0;
                    for (n = 0; n <= ExportToText.this.lastPageToDisplay; ++n) {
                        ExportToText.this.progressPanel.getProgressLabel().setText("Load data! Please Wait...");
                        ExportToText.this.elementNum = n * ExportToText.this.ROWS;
                        ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                        ExportToText.this.progressPanel.getProgressLabel().setText("Output data! Please Wait...");
                        for (int i = 0; i < ExportToText.this.ROWS; ++i) {
                            n6 = 0;
                            n7 = 0;
                            stringBuffer.setLength(0);
                            for (int j = 0; j < ExportToText.this.groups; ++j) {
                                for (int k = 0; k < ExportToText.this.totalColumns; ++k) {
                                    if (j != 0 && k < ExportToText.this.istart) continue;
                                    if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0 ? ExportToText.this.columnNames[j][k].equals(null) || ExportToText.this.columnNames[j][k].trim().length() == 0 : n7 == ExportToText.this.totalElements) break;
                                    stringBuffer2.setLength(0);
                                    if (ExportToText.this.columnNames[j][k].equals(headcol1)) {
                                        stringBuffer2.append((String)ExportToText.this.recordObject[j][i][k]);
                                        stringBuffer2 = CDFToolUtils.Justify(stringBuffer2, -6);
                                    } else if (ExportToText.this.columnNames[j][k].equals(headcol2)) {
                                        stringBuffer2.append((String)ExportToText.this.recordObject[j][i][k]);
                                        stringBuffer2 = CDFToolUtils.Justify(stringBuffer2, -11);
                                    } else {
                                        int n9;
                                        n4 = 0;
                                        if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                                            n3 = ExportToText.this.varWidth[n6];
                                            if ((long)ExportToText.this.varDataType[n6] == 51L || (long)ExportToText.this.varDataType[n6] == 52L) {
                                                n4 = 1;
                                                n3 -= 2;
                                            }
                                            ++n6;
                                        } else {
                                            boolean bl = false;
                                            for (n9 = 0; n9 < ExportToText.this.vars.size(); ++n9) {
                                                if (n7 == ExportToText.this.varsHor[n9]) {
                                                    bl = true;
                                                    break;
                                                }
                                                if (n7 < ExportToText.this.varsHor[n9]) break;
                                            }
                                            ++n7;
                                            if (bl) {
                                                n3 = ExportToText.this.varWidth[n6];
                                                if ((long)ExportToText.this.varDataType[n6] == 51L || (long)ExportToText.this.varDataType[n6] == 52L) {
                                                    n4 = 1;
                                                    n3 -= 2;
                                                }
                                                n8 = n3;
                                                n2 = n4;
                                                ++n6;
                                            } else {
                                                n3 = n8;
                                            }
                                            n4 = n2;
                                        }
                                        stringBuffer2 = CDFToolUtils.CatToString(stringBuffer2, ExportToText.this.recordObject[j][i][k].toString(), n3, 2, "*");
                                        if (n4 != 0) {
                                            if (stringBuffer2 != null && stringBuffer2.toString().trim().length() != 0) {
                                                if (stringBuffer2.toString().trim().length() == n3 || stringBuffer2.charAt(0) != ' ') {
                                                    stringBuffer2.insert(0, '\"');
                                                    stringBuffer2.append('\"');
                                                } else {
                                                    String string = stringBuffer2.toString().trim();
                                                    n9 = stringBuffer2.toString().indexOf(string);
                                                    stringBuffer2.insert(n9, '\"');
                                                    stringBuffer2.insert(n9 + string.length() + 1, '\"');
                                                }
                                            } else {
                                                stringBuffer2.append("  ");
                                            }
                                        }
                                    }
                                    stringBuffer.append(stringBuffer2).append(" ");
                                }
                                ExportToText.this.currentProgressValue += ExportToText.this.totalColumns;
                            }
                            if (stringBuffer.toString().trim().length() == 0) break;
                            bufferedWriter.write(stringBuffer.toString());
                            bufferedWriter.newLine();
                            if (ExportToText.this.lastPageToDisplay != 0) continue;
                            new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                        }
                        if (ExportToText.this.lastPageToDisplay != 0) {
                            new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                        }
                        ExportToText.this.cleanTableObjects();
                    }
                }
                bufferedWriter.close();
                ((ExportToText)ExportToText.this).myCDFExport.info.append("Done!");
                new CleanProgress().start();
            }
            catch (IOException iOException) {
                System.err.println("** error writing output to file");
            }
        }
    }

    class PageRecListener
    implements ActionListener {
        PageRecListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block14: {
                Object object = actionEvent.getSource();
                if (object.equals(ExportToText.this.pageField)) {
                    int n = ExportToText.this.elementNum / ExportToText.this.ROWS + 1;
                    try {
                        int n2 = Integer.parseInt(ExportToText.this.pageField.getText());
                        if (n2 < 1 || n2 > ExportToText.this.lastPageToDisplay + 1) {
                            ExportToText.this.pageField.setText("" + n);
                            Toolkit.getDefaultToolkit().beep();
                            break block14;
                        }
                        if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                            ExportToText.this.elementNum = (n2 - 1) * ExportToText.this.ROWS;
                        } else {
                            ExportToText.this.elementNum = n2 - 1;
                        }
                        ExportToText.this.cleanTableObjects();
                        ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                        ExportToText.this.displayTable(ExportToText.this.mainPanel);
                    }
                    catch (Exception exception) {
                        ExportToText.this.pageField.setText("" + n);
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (object.equals(ExportToText.this.recordField)) {
                    int n = ExportToText.this.elementNum / ExportToText.this.totalElementsPerRec + 1;
                    try {
                        int n3 = Integer.parseInt(ExportToText.this.recordField.getText());
                        if (n3 < 1 || n3 > ExportToText.this.totalWritten + 1) {
                            ExportToText.this.recordField.setText("" + n);
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                                ExportToText.this.elementNum = (n3 - 1) * ExportToText.this.totalElementsPerRec;
                            } else {
                                ExportToText.this.elementNum = n3 - 1;
                            }
                            ExportToText.this.cleanTableObjects();
                            ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                            ExportToText.this.displayTable(ExportToText.this.mainPanel);
                        }
                    }
                    catch (Exception exception) {
                        ExportToText.this.recordField.setText("" + n);
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }
    }

    class SelectionListener
    implements ActionListener {
        SelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                int n;
                String string = actionEvent.getActionCommand();
                if (string.equals(ExportToText.CANCEL)) {
                    exportToText.setVisible(false);
                    ExportToText.access$102(ExportToText.this, null);
                    ExportToText.this.center.removeAll();
                    if (ExportToText.this.jtp != null && ExportToText.this.jtp.getTabCount() > 0) {
                        for (int i = ExportToText.this.jtp.getTabCount() - 1; i > -1; --i) {
                            ExportToText.this.jtp.removeTabAt(i);
                            ((ExportToText)ExportToText.this).scrollPane[i] = null;
                        }
                    }
                    ExportToText.access$402(ExportToText.this, null);
                    ExportToText.this.mainPanel.removeAll();
                    ExportToText.access$602(ExportToText.this, null);
                    if (((ExportToText)ExportToText.this).myCDFExport.MacOS) {
                        System.gc();
                    }
                    ExportToText.this.myCDFExport.setVisible(true);
                } else if (string.equals(ExportToText.ENTER)) {
                    boolean bl = false;
                    if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                        if (ExportToText.this.elementNum + ExportToText.this.ROWS < (ExportToText.this.totalWritten + 1) * ExportToText.this.totalElementsPerRec) {
                            bl = true;
                        }
                    } else if (ExportToText.this.elementNum + ExportToText.this.ROWS < ExportToText.this.totalWritten + 1) {
                        bl = true;
                    }
                    if (bl) {
                        ExportToText.this.cleanTableObjects();
                        ExportToText.this.elementNum += ExportToText.this.ROWS;
                        ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                        ExportToText.this.displayTable(ExportToText.this.mainPanel);
                    }
                } else if (string.equals(ExportToText.BACK) && ((n = ((ExportToText)ExportToText.this).myCDFExport.orientation == 0 ? ExportToText.this.elementNum / ExportToText.this.ROWS : ExportToText.this.elementNum) != 0 || ExportToText.this.elementNum != 0)) {
                    ExportToText.this.cleanTableObjects();
                    ExportToText.this.elementNum -= ExportToText.this.ROWS;
                    if (ExportToText.this.elementNum < 0) {
                        ExportToText.this.elementNum = 0;
                    }
                    ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                    ExportToText.this.displayTable(ExportToText.this.mainPanel);
                }
            }
        }
    }
}

