/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditgAttributeTableScrollPane
extends JScrollPane
implements CDFConstants {
    private CDF cdf;
    private EditgAttributeTableScrollPane aTableScrollPane = this;
    private MYEditor myEditor;
    private CDFEdit cdfedit;
    private JTable table;
    private MyTableModel myModel;
    private JLabeledPanel aPanel;
    private Object[][] dataObject = null;
    private static String[] headcol = new String[]{"Name", "Entry", "Data Type", "Value"};
    private static String na = "N/A";
    static final long serialVersionUID = 1L;

    EditgAttributeTableScrollPane(AttributePanel attributePanel) {
        super(20, 30);
        this.myEditor = attributePanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.buildTable();
    }

    public void setTable(Object[][] objectArray) {
        if (objectArray != null) {
            this.dataObject = objectArray;
            this.myModel.fireTableChanged(new TableModelEvent(this.myModel));
        }
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setColumnNames(String[] stringArray) {
        headcol = stringArray;
    }

    public String[] getColumnNames() {
        return headcol;
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("CDF_BYTE");
        jComboBox.addItem("CDF_INT1");
        jComboBox.addItem("CDF_UINT1");
        jComboBox.addItem("CDF_INT2");
        jComboBox.addItem("CDF_UINT2");
        jComboBox.addItem("CDF_INT4");
        jComboBox.addItem("CDF_UINT4");
        jComboBox.addItem("CDF_REAL4");
        jComboBox.addItem("CDF_FLOAT");
        jComboBox.addItem("CDF_REAL8");
        jComboBox.addItem("CDF_DOUBLE");
        jComboBox.addItem("CDF_EPOCH");
        jComboBox.addItem("CDF_EPOCH16");
        jComboBox.addItem("CDF_CHAR");
        jComboBox.addItem("CDF_UCHAR");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for valid data types");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Click the dataType to see a list of choices");
        }
    }

    protected void buildTable() {
        this.dataObject = null;
        this.table = null;
        Vector vector = this.cdf.getAttributes();
        int n = vector.size();
        int n2 = 0;
        if (n < 1) {
            return;
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            Attribute attribute = (Attribute)object.nextElement();
            if (attribute.getScope() != 1L) continue;
            n2 += (int)attribute.getNumEntries();
        }
        if (n2 == 0) {
            return;
        }
        this.dataObject = new Object[n2][headcol.length];
        int n3 = 0;
        Attribute attribute = null;
        Entry entry = null;
        Object object2 = null;
        Object object3 = vector.elements();
        while (object3.hasMoreElements()) {
            attribute = (Attribute)object3.nextElement();
            if (attribute.getScope() != 1L) continue;
            object = attribute.getName();
            Vector vector2 = attribute.getEntries();
            if (vector2.size() == 0) continue;
            if (n3 == n2) break;
            this.dataObject[n3][0] = object;
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                StringBuffer stringBuffer;
                entry = (Entry)enumeration.nextElement();
                if (entry == null) continue;
                long l = entry.getID();
                long l2 = entry.getDataType();
                object2 = entry.getData();
                long l3 = entry.getNumElements();
                this.dataObject[n3][1] = "" + (l + 1L);
                this.dataObject[n3][2] = CDFUtils.getStringDataType((long)l2) + "/" + l3;
                if (l2 == 31L) {
                    if (object2.getClass().getName().indexOf(91) == 0) {
                        stringBuffer = new StringBuffer();
                        for (int i = 0; i < ((double[])object2).length; ++i) {
                            String string = Epoch.encode((double)((double[])object2)[i]);
                            stringBuffer.append(string).append(", ");
                        }
                        stringBuffer.setLength(stringBuffer.length() - 2);
                        this.dataObject[n3][3] = stringBuffer.toString();
                    } else {
                        this.dataObject[n3][3] = Epoch.encode((double)((Double)object2));
                    }
                } else if (l2 == 32L) {
                    if (object2.getClass().getName().indexOf(91) == 0) {
                        stringBuffer = new StringBuffer();
                        double[] dArray = new double[2];
                        for (int i = 0; i < ((double[])object2).length; i += 2) {
                            dArray[0] = ((double[])object2)[i];
                            dArray[1] = ((double[])object2)[i + 1];
                            String string = Epoch16.encode((Object)dArray);
                            stringBuffer.append(string).append(", ");
                        }
                        stringBuffer.setLength(stringBuffer.length() - 2);
                        this.dataObject[n3][3] = stringBuffer.toString();
                    }
                } else {
                    this.dataObject[n3][3] = CDFUtils.getStringData((Object)object2, (String)", ");
                }
                ++n3;
            }
        }
        this.table = null;
        if (this.dataObject != null) {
            this.myModel = new MyTableModel();
            this.table = new JTable(this.myModel);
            this.table.setRowSelectionAllowed(false);
            this.table.sizeColumnsToFit(4);
            object3 = null;
            for (int i = 0; i < headcol.length; ++i) {
                object3 = this.table.getColumnModel().getColumn(i);
                ((TableColumn)object3).setResizable(true);
                if (i == 0) {
                    ((TableColumn)object3).setPreferredWidth(100);
                }
                if (i == 1) {
                    ((TableColumn)object3).setPreferredWidth(35);
                }
                if (i == 2) {
                    ((TableColumn)object3).setPreferredWidth(105);
                }
                if (i != 3) continue;
                ((TableColumn)object3).setPreferredWidth(420);
            }
            this.table.setPreferredScrollableViewportSize(new Dimension(660, 500));
            this.table.setSelectionMode(0);
            this.aTableScrollPane.setViewportView(this.table);
            this.aTableScrollPane.setVisible(true);
        } else {
            this.aTableScrollPane.setVisible(false);
            this.aTableScrollPane.revalidate();
            this.aTableScrollPane.repaint();
        }
    }

    public void reset() {
        this.aTableScrollPane.setVisible(true);
        this.setTable(this.dataObject);
    }

    class MyTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        public int getColumnCount() {
            return headcol.length;
        }

        public int getRowCount() {
            if (EditgAttributeTableScrollPane.this.dataObject != null) {
                return EditgAttributeTableScrollPane.this.dataObject.length;
            }
            return 0;
        }

        public String getColumnName(int n) {
            return headcol[n];
        }

        public Object getValueAt(int n, int n2) {
            if (EditgAttributeTableScrollPane.this.dataObject != null) {
                return EditgAttributeTableScrollPane.this.dataObject[n][n2];
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            long l = 1L;
            return n2 > 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Integer) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = new Integer((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only integer values.");
                }
            } else if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Float) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = new Float((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only float values.");
                }
            } else if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Byte) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = new Byte((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only yyte values.");
                }
            } else if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Long) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = new Long((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only long values.");
                }
            } else if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Short) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = new Short((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only short values.");
                }
            } else if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Double) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = new Double((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only double values.");
                }
            } else if (EditgAttributeTableScrollPane.this.dataObject[0][n2] instanceof Boolean) {
                try {
                    if (n2 == 2) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 4) {
                        object = this.checkValue(object, n);
                    }
                    ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = (Boolean)object;
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only boolean values.");
                }
            } else {
                if (n2 == 2) {
                    this.applyValue(object2, object, n, n2);
                }
                if (n2 == 3) {
                    this.checkNumElem(object, n);
                }
                if (n2 == 4) {
                    object = this.checkValue(object, n);
                }
                ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        void applyValue(Object object, Object object2, int n, int n2) {
            if (!((String)object).equals((String)object2) && (((String)object2).equals("CDF_CHAR") || ((String)object2).equals("CDF_UCHAR"))) {
                JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The data type changed from " + object + " to " + object2 + ". Please change entry value accordingly.");
            }
        }

        void checkNumElem(Object object, int n) {
            String string = (String)this.getValueAt(n, 1);
            ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][3] = string.equals("CDF_CHAR") || string.equals("CDF_UCHAR") ? "" + ((String)object).length() : "1";
            this.fireTableCellUpdated(n, 3);
        }

        Object checkValue(Object object, int n) {
            String string = (String)this.getValueAt(n, 1);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (string.equals("CDF_BYTE") || string.equals("CDF_INT1")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Byte) {
                        return new Byte(numberFormat.parse(((Byte)object).toString()).byteValue());
                    }
                    return "" + numberFormat.parse((String)object).byteValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT1") || string.equals("CDF_INT2")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Short) {
                        return new Short(numberFormat.parse(((Short)object).toString()).shortValue());
                    }
                    return "" + numberFormat.parse((String)object).shortValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT2") || string.equals("CDF_INT4")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Integer) {
                        return new Long(numberFormat.parse(((Integer)object).toString()).intValue());
                    }
                    return "" + numberFormat.parse((String)object).intValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_REAL4") || string.equals("CDF_FLOAT")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    if (object instanceof Float) {
                        return new Float(numberFormat.parse(((Float)object).toString()).floatValue());
                    }
                    return "" + numberFormat.parse((String)object).floatValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_REAL8") || string.equals("CDF_EPOCH")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    if (object instanceof Double) {
                        return new Double(numberFormat.parse(((Double)object).toString()).doubleValue());
                    }
                    return "" + numberFormat.parse((String)object).doubleValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_CHAR") || string.equals("CDF_UCHAR")) {
                return object;
            }
            return null;
        }
    }
}

