/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class DeleteEntryAction
extends AbstractAction
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "Delete Entry";
    private MYEditor myEditor;
    private EditAttrEntryPanel myPanel;

    public DeleteEntryAction(EditAttrEntryPanel editAttrEntryPanel) {
        this(editAttrEntryPanel, DEFAULT_NAME);
    }

    public DeleteEntryAction(EditAttrEntryPanel editAttrEntryPanel, String string) {
        super(string);
        this.myPanel = editAttrEntryPanel;
        this.myEditor = editAttrEntryPanel.getMyEditor();
    }

    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        Entry entry = this.myPanel.getSelectedEntry();
        if (entry == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, "No entry selected", "MYEditor: Error", 0);
        } else {
            char c;
            String string = null;
            if (this.myPanel.getScope() == 1L) {
                string = "" + (entry.getID() + 1L);
            } else {
                try {
                    string = this.myEditor.theCDF.getVariable(entry.getID()).getName();
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
            }
            StringBuffer stringBuffer = new StringBuffer("Delete ");
            if (this.myPanel.getScope() == 1L) {
                stringBuffer.append("gEntry");
                c = 'g';
            } else {
                stringBuffer.append("zEntry");
                c = 'z';
            }
            int n = JOptionPane.showConfirmDialog(this.myEditor, "Do you want to delete Entry: " + string + " from " + c + "Attribute:" + this.myPanel.getSelectedAttr(), stringBuffer.toString(), 0);
            if (n == 0) {
                this.myEditor.setWaitCursor();
                try {
                    this.myPanel.deleteSelectedEntry();
                    this.myPanel.updateAttrEntryPanel(null, true);
                    if (this.myPanel.getScope() == 1L) {
                        this.myEditor.gAttrPanel.updateAttrPanel(this.myPanel.getSelectedAttr(), true);
                    } else {
                        this.myEditor.vAttrPanel.updateAttrPanel(this.myPanel.getSelectedAttr(), false);
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor, "CDF Error:\n" + CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
                }
            }
        }
        this.myEditor.setDefaultCursor();
    }
}

