/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.CompoundBorder;

public class EditAttrEntryPanel
extends JDialog
implements CDFConstants,
EntryEventListener {
    static final long serialVersionUID = 1L;
    private MYEditor myEditor;
    private Attribute selectedAttr;
    private AttributePanel attrPanel;
    private Entry selectedEntry = null;
    private String selectedVariable = null;
    private EntryListListener vll;
    protected Hashtable controls = new Hashtable();
    private Hashtable currentEntries = new Hashtable();
    private JMenu entryMenu;
    private JScrollBar sb1;
    private JScrollBar sb2;
    private ScrollBarSynchronizer scrollBarSync;
    private JSplitPane spane;
    private EditgEntryTablePanel gDisplay;
    private EditvEntryTablePanel vDisplay;
    private JPanel rightPanel;
    private EditAttrEntryAction editAttrEntry;
    private JScrollPane entryScrollPane;
    private long scope;

    public EditAttrEntryPanel(AttributePanel attributePanel) {
        super((Dialog)attributePanel.getMyEditor().frame, true);
        int n;
        int n2;
        this.attrPanel = attributePanel;
        this.scope = attributePanel.getScope();
        this.myEditor = attributePanel.getMyEditor();
        this.selectedAttr = attributePanel.getSelectedAttr();
        this.setSize(650, 250);
        char c = this.scope == 1L ? (char)'g' : 'v';
        this.setTitle("Edit " + c + "Attribute: " + this.selectedAttr);
        this.setJMenuBar(this.buildMenuBar());
        this.spane = new JSplitPane(1);
        this.spane.setOneTouchExpandable(true);
        this.vll = new EntryListListener(this, this.scope);
        this.spane.setBorder(new CompoundBorder(MYEditor.loweredBorder, MYEditor.emptyBorder5));
        if (this.scope == 1L) {
            this.gDisplay = new EditgEntryTablePanel(this);
            this.gDisplay.buildTable(this.selectedAttr);
        } else {
            this.vDisplay = new EditvEntryTablePanel(this);
            this.vDisplay.buildTable(this.selectedAttr);
        }
        Vector vector = new Vector();
        JList jList = new JList(vector);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(this.vll);
        this.entryScrollPane = new JScrollPane(jList);
        this.controls.put("listOfEntries", jList);
        this.controls.put("entryScrollPane", this.entryScrollPane);
        this.controls.put("entryVector", vector);
        JViewport jViewport = new JViewport();
        if (this.scope == 1L) {
            jViewport.setView(new JLabel("Entry"));
        } else {
            jViewport.setView(new JLabel("zVariable"));
        }
        this.entryScrollPane.setColumnHeader(jViewport);
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout());
        if (this.scope == 1L) {
            this.rightPanel.add(this.gDisplay);
        } else {
            this.rightPanel.add(this.vDisplay);
        }
        this.spane.setLeftComponent(this.entryScrollPane);
        this.spane.setRightComponent(this.rightPanel);
        this.updateListOfEntries();
        if (this.scope == 1L) {
            n2 = 60;
            n = 555;
        } else {
            n2 = 110;
            n = 505;
        }
        this.entryScrollPane.setPreferredSize(new Dimension(n2, 250));
        this.rightPanel.setPreferredSize(new Dimension(n, 250));
        this.spane.setDividerLocation(n2);
        this.spane.setDividerSize(5);
        this.spane.setPreferredSize(new Dimension(620, 250));
        this.sb1 = this.entryScrollPane.getVerticalScrollBar();
        this.sb2 = this.scope == 1L ? this.gDisplay.getScrollPane().getVerticalScrollBar() : this.vDisplay.getScrollPane().getVerticalScrollBar();
        this.scrollBarSync = new ScrollBarSynchronizer(this.sb2);
        this.sb1.getModel().addChangeListener(this.scrollBarSync);
        this.resetPanel(false);
        this.getContentPane().add((Component)this.spane, "Center");
        this.validate();
        this.pack();
        this.setVisible(true);
    }

    JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.entryMenu = jMenuBar.add(new JMenu("Edit"));
        this.entryMenu.setMnemonic('E');
        JMenuItem jMenuItem = this.entryMenu.add(new NewEntryAction(this));
        jMenuItem.setToolTipText("Create a new attribute entry");
        jMenuItem.setMnemonic('N');
        if (this.scope == 1L) {
            jMenuItem.setEnabled(true);
        } else {
            jMenuItem.setEnabled(false);
        }
        jMenuItem = this.entryMenu.add(new DeleteEntryAction(this));
        jMenuItem.setToolTipText("Delete the selected attribute entry");
        jMenuItem.setMnemonic('D');
        jMenuItem.setEnabled(false);
        this.entryMenu.add(new JSeparator());
        this.editAttrEntry = new EditAttrEntryAction(this);
        jMenuItem = this.entryMenu.add(this.editAttrEntry);
        jMenuItem.setToolTipText("Modify the selected attribute entry");
        jMenuItem.setMnemonic('M');
        jMenuItem.setEnabled(false);
        this.entryMenu.add(new JSeparator());
        jMenuItem = this.entryMenu.add(new ExitEntryEdit(this));
        jMenuItem.setMnemonic('X');
        jMenuItem.setEnabled(true);
        return jMenuBar;
    }

    public void performEntryAction(EntryEvent entryEvent) {
        int n = entryEvent.getID();
        switch (n) {
            case 2009: {
                this.addToListOfEntries(entryEvent.getEntry());
                this.reselectCurrentEntry();
                break;
            }
            case 2019: {
                this.removeFromListOfEntries(entryEvent.getEntry());
                this.resetPanel(true);
                break;
            }
            case 2029: {
                this.removeFromListOfEntries(entryEvent.getEntry());
                this.resetPanel(true);
                break;
            }
        }
    }

    public void updateAttrEntryPanel(Entry entry, boolean bl) {
        if (entry != null) {
            if (this.scope == 1L) {
                if (this.selectedEntry == null) {
                    this.enableEntryMenu();
                }
            } else {
                this.enableSelectedEntryMenu(entry);
            }
        } else {
            JList jList = (JList)this.controls.get("listOfEntries");
            this.selectedVariable = (String)jList.getSelectedValue();
            this.enableSelectedEntryMenu(this.selectedVariable);
        }
        this.selectedEntry = entry;
        this.resetPanel(false);
        if (this.scope == 1L) {
            if (bl) {
                this.gDisplay.buildTable(this.selectedAttr);
            }
        } else if (bl) {
            this.vDisplay.buildTable(this.selectedAttr);
            this.sb1.getModel().setValue(this.sb1.getModel().getValue());
        }
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    public void reselectCurrentEntry() {
        JList jList = (JList)this.controls.get("listOfEntries");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("entryScrollPane");
        jList.removeListSelectionListener(this.vll);
        String string = this.scope == 1L ? "" + (this.selectedEntry.getID() + 1L) : (String)jList.getSelectedValue();
        jList.setSelectedValue(string, true);
        jList.addListSelectionListener(this.vll);
        jScrollPane.revalidate();
        jScrollPane.repaint();
    }

    public void resetPanel(boolean bl) {
        if (this.scope == 1L) {
            this.gDisplay.reset();
        } else {
            this.vDisplay.reset();
        }
        if (bl) {
            this.updateListOfEntries();
            this.selectedEntry = null;
        }
    }

    private void updateListOfEntries() {
        Vector<String> vector = new Vector<String>();
        JList jList = (JList)this.controls.get("listOfEntries");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("entryScrollPane");
        if (this.selectedAttr != null) {
            if (this.scope == 1L) {
                Enumeration enumeration = this.selectedAttr.getEntries().elements();
                while (enumeration.hasMoreElements()) {
                    Entry entry = (Entry)enumeration.nextElement();
                    if (entry == null) continue;
                    String string = "" + (entry.getID() + 1L);
                    vector.addElement(string);
                }
            } else {
                Enumeration enumeration = this.myEditor.theCDF.getVariables().elements();
                while (enumeration.hasMoreElements()) {
                    Variable variable = (Variable)enumeration.nextElement();
                    if (variable == null) continue;
                    String string = variable.getName();
                    vector.addElement(string);
                }
            }
        }
        this.controls.put("entryVector", vector);
        jList.setListData(vector);
        jScrollPane.revalidate();
        jScrollPane.repaint();
    }

    public void addToListOfEntries(Object object) {
        Vector vector = (Vector)this.controls.get("entryVector");
        Vector vector2 = new Vector();
        JList jList = (JList)this.controls.get("listOfEntries");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("entryScrollPane");
        if (this.scope == 1L) {
            int n = (int)((Entry)object).getID();
            int n2 = vector.size();
            if (n2 == 0) {
                vector2.addElement("" + (n + 1));
            } else {
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    int n3 = Integer.parseInt((String)vector.elementAt(i)) - 1;
                    if (bl && n < n3) {
                        vector2.addElement("" + (n + 1));
                        bl = false;
                    }
                    vector2.addElement("" + (n3 + 1));
                }
                if (bl) {
                    vector2.addElement("" + (n + 1));
                }
            }
        } else {
            vector2 = vector;
        }
        this.controls.put("entryVector", vector2);
        jList.setListData(vector2);
        jScrollPane.revalidate();
        jScrollPane.repaint();
    }

    public void removeFromListOfEntries(Object object) {
        Vector vector = (Vector)this.controls.get("entryVector");
        JList jList = (JList)this.controls.get("listOfEntries");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("entryScrollPane");
        String string = this.scope == 1L ? "" + (((Entry)object).getID() + 1L) : ((Variable)object).getName();
        vector.removeElement(string);
        this.controls.put("entryVector", vector);
        jList.setListData(vector);
        jScrollPane.revalidate();
        jScrollPane.repaint();
    }

    public void saveEntryChanges() {
    }

    public void renameSelectedEntry(String string) throws CDFException {
        Vector vector = (Vector)this.controls.get("entryVector");
        JList jList = (JList)this.controls.get("listOfEntries");
        String string2 = this.scope == 1L ? "" + (this.selectedEntry.getID() + 1L) : (String)jList.getSelectedValue();
        this.selectedEntry.rename(string);
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("entryScrollPane");
        jList.removeListSelectionListener(this.vll);
        int n = vector.indexOf(string2);
        vector.removeElementAt(n);
        if (this.scope == 1L) {
            String string3 = "" + (this.selectedEntry.getID() + 1L);
            vector.insertElementAt("" + (this.selectedEntry.getID() + 1L), n);
        } else {
            String string4 = (String)jList.getSelectedValue();
            vector.insertElementAt(string4, n);
        }
        this.controls.put("entryVector", vector);
        jList.setListData(vector);
        jList.setSelectedValue(string, true);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        jList.addListSelectionListener(this.vll);
    }

    public void deleteSelectedEntry() throws CDFException {
        Vector vector = (Vector)this.controls.get("entryVector");
        JList jList = (JList)this.controls.get("listOfEntries");
        jList.removeListSelectionListener(this.vll);
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("entryScrollPane");
        String string = this.scope == 1L ? "" + (this.selectedEntry.getID() + 1L) : (String)jList.getSelectedValue();
        vector.removeElementAt(vector.indexOf(string));
        this.controls.put("entryVector", vector);
        jList.setListData(vector);
        jList.setSelectedIndex(-1);
        jList.addListSelectionListener(this.vll);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        this.selectedEntry.delete();
        this.selectedEntry = null;
    }

    public void enableEntryMenu() {
        Component[] componentArray = this.entryMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(true);
        }
    }

    public void enableSelectedEntryMenu(Object object) {
        Component[] componentArray = this.entryMenu.getMenuComponents();
        componentArray[5].setEnabled(true);
        for (int i = 0; i < componentArray.length - 2; ++i) {
            componentArray[i].setEnabled(false);
            if ((this.scope == 1L || object == null) && i == 0) {
                componentArray[i].setEnabled(true);
            }
            if (object instanceof String && i == 0) {
                componentArray[i].setEnabled(true);
            }
            if (!(object instanceof Entry) || i != 1 && i != 3) continue;
            componentArray[i].setEnabled(true);
        }
    }

    public void disableEntryMenu() {
        Component[] componentArray = this.entryMenu.getMenuComponents();
        for (int i = 1; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(false);
        }
    }

    public Attribute getSelectedAttr() {
        return this.selectedAttr;
    }

    public Entry getSelectedEntry() {
        return this.selectedEntry;
    }

    public long getScope() {
        return this.scope;
    }

    public Hashtable getControls() {
        return this.controls;
    }

    public Object getControl(String string) {
        return this.controls.get(string);
    }

    public Object getEntry(String string) {
        return this.currentEntries.get(string);
    }

    private void putEntry(String string, Object object) {
        this.currentEntries.put(string, object);
    }

    public EditgEntryTablePanel getgDisplay() {
        return this.gDisplay;
    }

    public EditvEntryTablePanel getvDisplay() {
        return this.vDisplay;
    }

    public MYEditor getMyEditor() {
        return this.myEditor;
    }

    public JScrollBar getAttrScrollBar() {
        return this.sb1;
    }

    public JScrollBar getEntryScrollBar() {
        return this.sb2;
    }

    public ScrollBarSynchronizer getScrollBarSync() {
        return this.scrollBarSync;
    }

    public JScrollPane getScrollPane() {
        return this.entryScrollPane;
    }

    public JMenu getEntryMenu() {
        return this.entryMenu;
    }

    class ExitEntryEdit
    extends AbstractAction {
        static final long serialVersionUID = 1L;
        private MYEditor myEditor;
        private EditAttrEntryPanel myPanel;

        ExitEntryEdit(EditAttrEntryPanel editAttrEntryPanel2) {
            this(editAttrEntryPanel2, new String("Exit Edit"));
        }

        ExitEntryEdit(EditAttrEntryPanel editAttrEntryPanel2, String string) {
            super(string);
            this.myPanel = editAttrEntryPanel2;
            this.myEditor = editAttrEntryPanel2.myEditor;
        }

        public void putValue(String string, Object object) {
            if (object != null) {
                super.putValue(string, object);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.myEditor.setWaitCursor();
            this.myPanel.setVisible(false);
            this.myPanel.dispose();
        }
    }
}

