import java.io.*;
import java.util.*;

/** GetSystem returns system related information.
 */

public class SystemInfo {

    /********************************************************************
     * Returns the value of the given system environment variable. <P>
     *
     * NOTE: The System.getenv() method was deprecated in JDK 1.3 and
     *       undeprecated in JDK 1.5.  This routine was developed to 
     *       work with virtuall all Java versions. <P>
     *
     * @param env the name of the environment variable to be resolved. <P>
     * @return Value of the specified environment variable.  Null is
     *         returned if the environment variable is not defined. <P>
     *********************************************************************/
    public static String getenv (String env) {
       String value = null;
       try {
          String line;
          Process process;
          if (System.getProperty("os.name").indexOf("windows") != -1)
              process = Runtime.getRuntime().exec("set");
          else
              process = Runtime.getRuntime().exec("env");
          BufferedReader inStream = new BufferedReader(new
                             InputStreamReader(process.getInputStream()));
          process.waitFor();
          while ((line = inStream.readLine()) != null) {
             StringTokenizer st = new StringTokenizer(line, "=");
             if (st.nextToken().equals("CDF_BASE")) {
                 value = st.nextToken(); 
                 break;
             }
          }
       } catch (InterruptedException ee) {
           value = null;
       } catch (IOException ex) {
           value = null;
       }
       return value;
    }
}

