import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;

public class ExportVarFilterTable {

    private JFrame myFrame;
    private JTable table;
    private MyTableModel myModel;
    private ExportCDFTable exportCDFTable;
    private Object[][] data;
    private String[] columnNames;
    private int startColtoUpdate;

    public ExportVarFilterTable(JFrame myFrame, Object[][] data, 
			        String[] columnNames, ExportCDFTable exportCDFTable) {

	this.myFrame = myFrame;
	this.exportCDFTable = exportCDFTable;
	this.data = data;
	this.columnNames = columnNames;
	this.startColtoUpdate = exportCDFTable.istart;

        myModel = new MyTableModel();
        table = new JTable(myModel);
        table.setPreferredScrollableViewportSize(new Dimension(800, 450));
//	table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	TableColumn column = null;
	for (int i = 0; i < columnNames.length; i++) {
	   column = table.getColumnModel().getColumn(i);
	   column.setResizable(true);
	   if (i == 0) column.setPreferredWidth(50);
           if (i == 1) column.setPreferredWidth(60);
           if (i == 2) column.setPreferredWidth(60);
           if (i == 3) column.setPreferredWidth(40);
	}
	table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	table.setRowSelectionAllowed(false);

    }

    public void setDataTable(Object[][] data) {

	this.data = data;

    }

    public Object[][] getDataTable() {

        return (Object[][]) data;

    }

    public void setColumnNames(String[] columnNames) {

        this.columnNames = columnNames;

    }

    public String[] getColumnNames() {

        return (String[]) columnNames;

    }

    public JTable getTable() {

        return table;

    }

    public MyTableModel getModel() {

        return myModel;

    }

    class MyTableModel extends AbstractTableModel {

        static final long serialVersionUID = 1L;

        public int getColumnCount() {
            return columnNames.length;
        }
        
        public int getRowCount() {
            return data.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return data[row][col];
        }

        /*
         * JTable uses this method to determine the default renderer/
         * editor for each cell.  If we didn't implement this method,
         * then a Boolean column would contain text ("true"/"false"),
         * rather than a check box.
         */
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }

        /*
         * Don't need to implement this method unless your table's
         * editable.
         */
        public boolean isCellEditable(int row, int col) {
            //Note that the data/cell address is constant,
            //no matter where the cell appears onscreen.
            if (col == 0) { 
                return false;
            } else {
                if (row < startColtoUpdate) 
		  return false;
		else
                  return true;
            }
        }

        /*
         * Don't need to implement this method unless your table's
         * data can change.
         */
        public void setValueAt(Object value, int row, int col) {

            if (data[0][col] instanceof Integer) {
                //If we don't do something like this, the column
                //switches to contain Strings.
                //XXX: See TableEditDemo.java for a better solution!!!
                try {
                    data[row][col] = new Integer((String)value);
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only integer values.");
                }
            } else if (data[0][col] instanceof Float) {
                try {
                    data[row][col] = new Float((String)value);
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only float values.");
                }
            } else if (data[0][col] instanceof Byte) {
                try {
                    data[row][col] = new Byte((String)value);
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only yyte values.");
                }
            } else if (data[0][col] instanceof Long) {
                try {
                    data[row][col] = new Long((String)value);
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only long values.");
                }
            } else if (data[0][col] instanceof Short) {
                try {
                    data[row][col] = new Short((String)value);
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only short values.");
                }
            } else if (data[0][col] instanceof Double) {
                try {
                    data[row][col] = new Double((String)value);
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only double values.");
                }
            } else if (data[0][col] instanceof Boolean) {
                try {
                    data[row][col] = (Boolean)value;
//		    exportCDFTable.updateTable[row][col] = true;
                    fireTableCellUpdated(row, col);
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(myFrame,
                        "The \"" + getColumnName(col)
                        + "\" column accepts only boolean values.");
                }

            } else {
                data[row][col] = value;
//		exportCDFTable.updateTable[row][col] = true;
                fireTableCellUpdated(row, col);
	    }

        }

    }

}

