import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.lang.reflect.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import gsfc.nssdc.cdf.*;
import gsfc.nssdc.cdf.util.*;

/**
 *  This class create a table dialog for a CDF allowing user to make
 *  selection how the CDF is exported.
 */

public class ExportToText extends JDialog implements CDFConstants, 
						     KeyListener, FocusListener {
    static final long serialVersionUID = 1L;

    private int[] eleIndex;
    private int currentVar;
    private JPanel mainPanel;
    private JPanel bottomPanel, buttonPanel;
    private JPanel pagePanel = new JPanel();
    private JLabel pageLabel = new JLabel("Page: ");
    private JLabel recordLabel = new JLabel("Record: ");
    private JLabel pageTotal = new JLabel();
    private JLabel recordTotal = new JLabel();
    private JTextField pageField = new JTextField(5);
    private JTextField recordField = new JTextField(5);
    private JButton enterButton, cancelButton, backButton;
    private Object focusedObj = null;
    private SelectionListener aSelection;
    private PageRecListener aPageRecListener;
    private CDFSpecPanel cdfspec;

    private JPanel center = new JPanel(new BorderLayout(), true);
    private ExportCDFTable aCDFTable;
    private CDFExport myCDFExport;
    private static ExportToText exportToText;
    private BuildProgressPanel progressPanel;

    private JTabbedPane jtp;
    private JScrollPane[] scrollPane = null;
    private ExportVarDisplayTable[] aToScreenTable = null;
    private String[][] columnNames = null;
    private Object[][][] recordObject = null;

    private static String headcol1 = "Record #",
			  headcol2 = "Indices";

    private Vector vars; /* output variables */
    private int[] varsHor;
    private int groups;
    private int outVars;
    private int COLUMNS;
    private int ROWS;
    private int recHeading, indexHeading, totalColumns, numColumns;
    private int totalElementsPerRec;
    private int totalWritten;
    private boolean indiceOut;
    private long[] indiceSizes;
    private int indiceDim;
    private int elementNum;
    private int lastPageToDisplay;
    private long majority;
    private int istart;
    private int totalElements;
    private Object aRecord = null;
    private Hashtable formatHash;
    private boolean toScreen;
    private Cursor curCursor = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
    private Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);

    private Object newMin;
    private Object newMax;
    private Object newFil;

    private Object minObj = null;
    private Object maxObj = null;
    private Object filObj = null;

    private int irec;
    private int filterElementsNum;
    private int minLen;
    private int maxLen;
    private int filLen;
    private long[] elementBase;
    private int[] varWidth;
    private int[] varDataType;

    static boolean defaultModal = true;

    // Track build progress
    private int currentProgressValue;
    private int totalItems;
    private Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();

    private static final String ENTER = "Next";
    private static final String BACK = "Back";
    private static final String CANCEL = "Cancel";

    private ExportToText(JFrame frame) {
        super(frame, defaultModal);
    }

    public static ExportToText createToText(JFrame myFrame, CDFExport myCDFExport,
					    ExportCDFTable aCDFTable, 
					    boolean toScreen) {
	if (exportToText == null) {
	  exportToText = new ExportToText(myFrame);
	  exportToText.myCDFExport = myCDFExport;
	  exportToText.aCDFTable = aCDFTable;
	}

        exportToText.toScreen = toScreen;

	if (toScreen) {
	  if (exportToText.mainPanel == null) {
            exportToText.mainPanel = (JPanel) exportToText.getContentPane();
	    exportToText.mainPanel.setLayout(new BorderLayout());
            exportToText.mainPanel.setBorder(new EmptyBorder(10,10,10,10));

            exportToText.pageField.setHorizontalAlignment(JTextField.CENTER);
            exportToText.pageField.addKeyListener(exportToText);
            exportToText.pageField.addFocusListener(exportToText);
            exportToText.recordField.setHorizontalAlignment(JTextField.CENTER);
            exportToText.recordField.addKeyListener(exportToText);
            exportToText.recordField.addFocusListener(exportToText);
            // Only way to close is to use the buttons
            exportToText.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
            exportToText.addWindowListener(new WindowAdapter() {
               public void windowClosing(WindowEvent we) {
               }
            });
//          exportToText.setResizable(false);
            exportToText.setSize(800,800);

            exportToText.cdfspec = new CDFSpecPanel();
	    exportToText.bottomPanel = new JPanel(new BorderLayout(), true);
	    exportToText.aPageRecListener = exportToText.new PageRecListener();
	  }
	  exportToText.buildPanel();
//	  exportToText.aPageRecListener = exportToText.new PageRecListener();
	  RepaintManager.currentManager(null).setDoubleBufferingEnabled(true);
	}
	exportToText.ROWS = myCDFExport.ROWS;
	exportToText.COLUMNS = myCDFExport.COLUMNS;

	exportToText.setupDataTable();
	exportToText.displayDataTable();
       
	return exportToText;
    }
   
/**
  * The method for creating a table to display the variables data.
  */

    public void displayDataTable() {

	if (myCDFExport.orientation == 0) {
	  int total = totalElementsPerRec * (totalWritten + 1);
	  lastPageToDisplay = total / ROWS;
	  if ((total % ROWS) == 0) lastPageToDisplay--;
	} else {
	  int total = totalWritten + 1;
	  lastPageToDisplay = total / ROWS;
	  if ((total % ROWS) == 0) lastPageToDisplay--;
	}
	if (toScreen) { // output to screen
          if (outVars > 0) {
	    elementNum = 0;
	    fillVarRecsToTable(elementNum);
	    displayTable(mainPanel);

            exportToText.pack();

            Dimension ps = exportToText.getSize();
            exportToText.setLocation((ss.width - ps.width)/2,
                                     (ss.height - ps.height)/2);
	    // Deprecated - exportToText.show();
	    exportToText.setVisible(true);
	  }
	} else { // output to a text file
	  myCDFExport.info.setText("Start writing output to: "+myCDFExport.cdfspec2+"\n\n"); 
	  OutToFile aFile = new OutToFile();
	  // Initiate a thread to create the output
	  aFile.start();
	}

    }

/**
  * Get the variables along with their attributes that will be displayed for selection.
  */

    void setupDataTable() {

	majority = myCDFExport.majority;

	recHeading = 1;
        if (myCDFExport.recordNum == 0 || 
	    !((Boolean) ((Object[][])aCDFTable.getDataObject())[0][5]).booleanValue())
	  recHeading = 0;

	indexHeading = 1;
	indiceOut = true;
	if (myCDFExport.indiceNum == 0 ||
	    !((Boolean) ((Object[][])aCDFTable.getDataObject())[myCDFExport.recordNum][5]).booleanValue()) {
	  indiceOut = false;
	  indexHeading = 0;
	} 

	vars = new Vector();
	String varName;
	outVars = 0;
        for (int i = aCDFTable.istart; i < aCDFTable.numRows; i++) {
          if (((Boolean) ((Object[][])aCDFTable.getDataObject())[i][5]).booleanValue()) {
            outVars++;
	    varName = (String) ((Object[][])aCDFTable.getDataObject())[i][0];
	    vars.addElement(varName);
	  }
        }
	if (outVars == 0) return;

	long numDim;
	long[] dimSizes;
	int numElements;
	long[] oldSizes = null;
	long oldDim = 0;
	int maxWritten;
	String format;
	varWidth = new int[vars.size()];
	varDataType = new int[vars.size()];
	long dataType;
	Variable var;
	totalElements = 0;
	varsHor = new int[vars.size()];
	eleIndex = new int[vars.size()];
	formatHash = new Hashtable();
	for (int i = 0; i < vars.size(); i++) {
	  varName = (String) vars.elementAt(i);
	  varsHor[i] = totalElements;
	  try {
	     var = myCDFExport.sourceCDF.getVariable(varName);
	     numDim = var.getNumDims();
	     dimSizes = var.getDimSizes();
	     eleIndex[i] = totalElements;
	     maxWritten = (int) var.getMaxWrittenRecord();
	     format = CDFToolUtils.getCFormat(var);
	     if (format != null) formatHash.put(var, (Object) format);
	     dataType = var.getDataType();
	     varWidth[i] = CDFToolUtils.VariableWidth(myCDFExport.epoch, var, dataType, 
						      format);
	     varDataType[i] = (int) dataType;
//	     varsHor.addElement(varName);
	     numElements = 1;
             if (numDim > 0) {
               for (int ii = 0; ii < numDim; ii++) 
		 numElements *= ((long []) dimSizes)[ii];
//               for (int ii = 1; ii < numElements; ii++) varsHor.addElement(" ");
             }
	     totalElements += numElements;
	  } catch (CDFException e) {
	     System.err.println("ERROR!  "+e);
	     return;
	  }
	  if (numDim == 0) indiceOut = false;
	  if (i == 0) {
            oldDim = numDim;
            totalWritten = maxWritten;
            totalElementsPerRec = numElements;
            if ((int) numDim == 0) {
	      oldSizes = null;
	      indiceSizes = null;
	    } else {
//	      oldSizes = (long[]) dimSizes.clone();
//	      indiceSizes = (long[]) dimSizes.clone();
	      oldSizes = new long[(int)numDim];
	      indiceSizes = new long[(int)numDim];
	      System.arraycopy(dimSizes, 0, oldSizes, 0, (int)numDim);
	      System.arraycopy(dimSizes, 0, indiceSizes, 0, (int)numDim);
	    }
            indiceDim = (int) numDim;
	  } else {
	    if (totalWritten < maxWritten) totalWritten = maxWritten;
	    if (indiceOut) {
	      if (totalElementsPerRec != numElements || oldDim != numDim)
				indiceOut = false;
	      else {
		for (int k = 0; k < numDim; k++) {
		  if (oldSizes == null ) {
		    indiceOut = false;
		    break;
		  } else {
		    if (((long[])dimSizes)[k] != ((long[])oldSizes)[k]) {
		      indiceOut = false;
		      break;
		    }
		  }
		}
	      }
	    }
            if (totalElementsPerRec < numElements) {
              totalElementsPerRec = numElements;
              indiceDim = (int) numDim;
	      indiceSizes = new long[(int)numDim];
//              indiceSizes = (long []) dimSizes.clone();
	      System.arraycopy(dimSizes, 0, indiceSizes, 0, (int)numDim);
            }
	  }
	}
	if (COLUMNS == 0) { 
	  if (myCDFExport.orientation == 0) COLUMNS = outVars;
	  else COLUMNS = totalElements;
	}
	if (ROWS == 0) {
          if (myCDFExport.orientation == 1) ROWS = totalWritten + 1; 
	  else ROWS = (totalWritten + 1) * totalElementsPerRec;
	}

        if (myCDFExport.orientation == 0) { // vertical orientation
	  if (outVars > COLUMNS) {
            numColumns = COLUMNS;
            groups = outVars / COLUMNS;
            if ((outVars % COLUMNS) != 0) groups++;
          } else {
            numColumns = outVars;
            groups = 1;
	  }
	} else { // horizontal orientation
          if (totalElements > COLUMNS) {
            numColumns = COLUMNS;
            groups = totalElements / COLUMNS; 
            if ((totalElements % COLUMNS) != 0) groups++;     
          } else {      
            numColumns = totalElements;
            groups = 1; 
	  }
        }

	if (indiceOut) indexHeading = 1;
	else indexHeading = 0;

	istart = recHeading + indexHeading;
	totalColumns = numColumns + istart;
        columnNames = new String[groups][totalColumns];
        recordObject = new Object[groups][ROWS][totalColumns];
	cleanColumns();
	cleanTableObjects();

        int k = 0;

        for (int i = 0; i < groups; i++) {
           if (recHeading == 1) columnNames[i][0] = headcol1;
           if (indexHeading == 1) columnNames[i][recHeading] = headcol2;
           for (int j = 0; j < numColumns; j++) {
             if (myCDFExport.orientation == 0) { // vertical display
		if (k < vars.size()) columnNames[i][j+istart] = (String) vars.elementAt(k++);
		else break;
		
	     } else { // horizontal display
//		if (k < varsHor.size()) columnNames[i][j+istart] = (String) varsHor.elementAt(k++);
		if (k < totalElements) {
		  for (int ll = 0; ll < vars.size(); ll++) {
		    if (k == varsHor[ll]) { 
		      columnNames[i][j+istart] = (String) vars.elementAt(ll);
		      break;
		    } else {
		      if (k < varsHor[ll] || ll == vars.size()-1) {
		        columnNames[i][j+istart] = " ";
		        break;
		      }
		    }
		  }
		  k++;
		} else break;
	     }
	   }
        }
    }

/** Build the panel that shows the variable list for selection for output.
  */

    private void buildPanel() {

        exportToText.setTitle("CDF: "+myCDFExport.cdfspec1);

        cdfspec.set(myCDFExport.sourceCDF);
        mainPanel.add(cdfspec, BorderLayout.NORTH);

        createButton(bottomPanel);
        mainPanel.add(bottomPanel, BorderLayout.SOUTH);

    }

/** fill variable record(s) into the table for a page.
  */

    private void fillVarRecsToTable(int startN) {

	if (recHeading == 1 || indexHeading == 1) doRecIndexColumn(startN);
	int ii = 0;
	String varName;
	Variable aVar;

        for (int i = 0; i < vars.size(); i++) {
	   currentVar = i;
           varName = (String) vars.elementAt(i);
           try {
              aVar = myCDFExport.sourceCDF.getVariable(varName);
           } catch (CDFException e) {
              System.err.println("error getting variable");
              return;
           }
	   int group, col;
	   if (myCDFExport.orientation == 0) {
	     group = i / COLUMNS;
	     col = i % COLUMNS + istart;
	   } else {
	     group = eleIndex[i] / COLUMNS;
	     col = eleIndex[i] % COLUMNS + istart;
	   }
           loadVarRecords(aVar, startN, group, col);
        } 

    }

/** fill record number and indices into the tables if they are requested.
  */

    void doRecIndexColumn(int startN) {

      /* for record # & index */
      int element; 
      int recCount;
      element = startN;
      if (myCDFExport.orientation == 0) recCount = element / totalElementsPerRec;
      else recCount = element;

      long[] currentDim;
      StringBuffer nd = new StringBuffer();

      if (indexHeading == 1) dimensionBase();

      for (int ij = 0; ij < ROWS; ij++) {
        if (indexHeading == 1) {
	  currentDim = currentIndex(element);
          if (nd.capacity() > 0) nd.setLength(0);
          nd.append("[");
          for (int i = 0; i < indiceDim; i++) {
             if (i > 0) nd.append(",");
             nd.append(currentDim[i]+1);
          }
          nd.append("]");
        }
        for (int i = 0; i < groups; i++) {
	  if (myCDFExport.orientation == 0) {
            if (recHeading == 1)
              recordObject[i][ij][0] = Integer.toString(recCount+1);
            if (indexHeading == 1)
              recordObject[i][ij][recHeading] = nd.toString();
	  } else {
	      recordObject[i][ij][0] = Integer.toString(recCount+1);
	  }
        }
        element++;
        if (myCDFExport.orientation == 0) recCount = element / totalElementsPerRec;
	else recCount = element;
        if (recCount > totalWritten) break;
      }
    }

/** Display the table(s)
  */

    void displayTable(JPanel mp) {

        Object [][] record;
	int pageNum;
	if ((elementNum % ROWS) == 0) pageNum = elementNum / ROWS + 1;
	else pageNum = Math.round(((float)elementNum)/ROWS) + 1;
	if (pageNum > lastPageToDisplay+1) pageNum = lastPageToDisplay + 1;
	int recordNum;
	if (myCDFExport.orientation == 0)
	  recordNum = elementNum /totalElementsPerRec + 1;
	else
	  recordNum = elementNum + 1;
        pageField.setText(""+pageNum);
        recordField.setText(""+recordNum);

        // Create the scroll pane(s) and add the table to each.
        if (scrollPane == null) {
	  mp.add(center, BorderLayout.CENTER);
	  String [] column;
	  scrollPane = new JScrollPane[groups];
          aToScreenTable = new ExportVarDisplayTable[groups];

          for (int i = 0; i < groups; i++ ) {
	    record = (Object [][]) Array.get(recordObject, i);
	    column = (String []) Array.get(columnNames, i);
	    aToScreenTable[i] = new ExportVarDisplayTable(record, column);
	    scrollPane[i] = new JScrollPane(aToScreenTable[i].getTable(),
					    ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
					    ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
          }
          if (groups == 1) { // only one group
	    if (COLUMNS > 9) 
		aToScreenTable[0].getTable().setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
            center.add(scrollPane[0], BorderLayout.CENTER);
          } else {
            if (jtp == null) jtp = new JTabbedPane();
            for (int ik = 0; ik < groups; ik++)
                jtp.addTab("Group "+(ik+1), null, scrollPane[ik]);
            center.add(jtp, BorderLayout.CENTER);
          }

	  pageTotal.setText(" / "+(lastPageToDisplay+1));
	  recordTotal.setText(" / "+(totalWritten+1));

	  pagePanel.add(pageLabel);
	  pagePanel.add(pageField);
	  pagePanel.add(pageTotal);
	  pagePanel.add(Box.createRigidArea(new Dimension(10,1)));
	  pagePanel.add(recordLabel);
	  pagePanel.add(recordField);
	  pagePanel.add(recordTotal);

	  pageField.addActionListener(aPageRecListener);
	  recordField.addActionListener(aPageRecListener);
	  pageField.setToolTipText("Enter a page number and hit Return or Up/Down arrow keys to display a new page.");
	  recordField.setToolTipText("Enter a record number and hit Return or Up/Down arrow keys to display a new page. ");

	  center.add(pagePanel,  BorderLayout.SOUTH);

	} else { // Must be a new (up/down) page/record number from the previous table 
          for (int i = 0; i < groups; i++ ) {
            record = (Object [][]) Array.get(recordObject, i);
            aToScreenTable[i].setDataTable(record);
          }
	}
    }

/** Return the index base for each dimension.
  */

    void dimensionBase() {

	if (indiceDim <= 1) {
	  elementBase = new long[] {1};
	} else {
	  elementBase = new long[indiceDim];

          if (majority == ROW_MAJOR) { // row majority
	    for (int i = 0; i < indiceDim; i ++) {
	       elementBase[i] = 1;
	       for (int j = i + 1; j < indiceDim; j++)
		  elementBase[i] *= indiceSizes[j];
	    }
	  } else { // column majority
            for (int i = 0; i < indiceDim; i ++) {
	       elementBase[i] = 1;
               for (int j = 0; j <= i; j++)
                  elementBase[i] *= indiceSizes[j];
            }
	  }
	}
    }

/** Return the current index of the element.
  */

    long[] currentIndex(int currentElement) {

        int current = currentElement % totalElementsPerRec;
        long[] index = new long[indiceDim];

	if (indiceDim <= 1) index[0] = current;
        else {
	  if (majority == ROW_MAJOR) { // row majority
            for (int i = 0; i < indiceDim; i++) {
	      index[i] = current / elementBase[i];
	      current = (int) (current % elementBase[i]);
	    }
          } else { // column majority
            for (int i = 0; i < indiceDim; i++) {
              index[i] = current % elementBase[i];
              current = (int) (current / elementBase[i]);
            }
	  }
        }
        return index;
    }

/**
  * load the records from the source CDF's variable
  */

   private void loadVarRecords(Variable var, int startN, int inGroup, int atColumn) {

	long dataType = var.getDataType();
	long[] dimSizes = null;
	long[] dimVariances = null;
	long numDim = var.getNumDims();
	String varName = var.getName();
	long lastRec;
	int noElements = 1;

	try {
	  lastRec = var.getMaxWrittenRecord();
	} catch (CDFException e) {
	  lastRec = -1;
	}

	if (lastRec == -1) return; // no written records

	if (numDim > 0) {
	  dimSizes = var.getDimSizes();
	  dimVariances = var.getDimVariances();
	  for (int i = 0; i < numDim; i++)
		noElements *= dimSizes[i];
	} 

	minObj = maxObj = filObj = null;

	if (myCDFExport.getFiltering() == 1) checkFiltering(var, varName, dataType);

	int element;
	int elementStop;
	int recStart;
	int recStop;
	element = startN;
	elementStop = startN + ROWS - 1;
	if (myCDFExport.orientation == 0) {
	  recStart = element / totalElementsPerRec;
	  recStop = elementStop / totalElementsPerRec;
	} else {
	  recStart = element;
	  recStop = elementStop;
	}

	if (recStart > lastRec) return;

	String format = null;
	if (formatHash.containsKey(var)) format = (String) formatHash.get(var);

	long sparse = var.getSparseRecords();

	Object allRecords = null;
	if (recStop > lastRec) recStop = (int) lastRec;
	long recCount = recStop - recStart + 1;
	long recInterval = 1L;
	long[] dimIntervals;
	long[] dimIndices;

	if (numDim > 0) {
	  dimIntervals = new long[(int)numDim];
	  dimIndices = new long[(int)numDim];
	  for (int ii = 0; ii < (int)numDim; ii++) {
	    dimIntervals[ii] = 1;
	    dimIndices[ii] = 0;
	  }
	} else {
	  dimSizes = new long[1];
	  dimIntervals = new long[1];
	  dimIndices = new long[1];
	  dimSizes[0] = 0;
	  dimIntervals[0] = 1;
	  dimIndices[0] = 0;
	}
	try {
	  allRecords = var.getHyperData(recStart, recCount, recInterval, 
					dimIndices, dimSizes, dimIntervals);
	} catch (CDFException ee) {
	  System.err.println("error hyperget records: "+ee);
	  return;
	}
	int which = 0;
	if (dataType == CDF_EPOCH16) which = 2;
	for (int vin = recStart; vin <= recStop; vin++) {
	   if (vin <= lastRec) {
	     if (recCount <= 1) aRecord = allRecords;
	     else {
	      if (numDim > 0 && noElements > 1) 
		aRecord = ((Object[]) allRecords)[vin-recStart];
	      else 
		aRecord = CDFToolUtils.retrieveData(allRecords, vin-recStart, which);
	     }
             fillScreenTable(aRecord, var, dataType, (int) numDim, dimSizes,
                             inGroup, atColumn, startN, vin, elementStop,
			     format);
	   }
	}

    }

/**
  Check whether a new filtering is to apply for a variable.
 */

    void checkFiltering(Variable var, String varName, long dataType) {

	// filtering is selected -- try to get the new value(s)
	int ind = ((Integer)aCDFTable.myHash.get(varName)).intValue();
	int ifil = 0;
	if (myCDFExport.getValidMin() == 1) {
	  ifil ++;
	  newMin = ((Object[][])aCDFTable.getFilterObject())[ind][ifil];
	  if (newMin != null && ((String)newMin).trim().length() != 0) {
	      StringTokenizer st = new StringTokenizer((String) newMin, ",");
	      minLen = st.countTokens();
	      if (minLen == -1) minObj = null;
	      else minObj = CDFToolUtils.parseContents((String) newMin, dataType);
	  }
	}

	if (myCDFExport.getValidMax() == 1) {
	  ifil ++;
          newMax = ((Object[][])aCDFTable.getFilterObject())[ind][ifil];
	  if (newMax != null && ((String)newMax).trim().length() != 0) {
	     StringTokenizer st = new StringTokenizer((String) newMax, ",");
	     maxLen = st.countTokens();
	     if (maxLen == -1) maxObj = null;
	     else maxObj = CDFToolUtils.parseContents((String) newMax, dataType);
          }
        }

	if (myCDFExport.getFillVal() == 1) {
	  ifil ++;
          newFil = ((Object[][])aCDFTable.getFilterObject())[ind][ifil];
	  if (newFil != null && ((String)newFil).trim().length() != 0) {
	      StringTokenizer st = new StringTokenizer((String) newFil, ",");
	      filLen = st.countTokens();
	      if (filLen == -1) filObj = null;
	      else filObj = CDFToolUtils.parseContents((String) newFil, dataType);
	  } 
        } else {
	  if (myCDFExport.getValidMin() == 1 || myCDFExport.getValidMax() == 1) {
		try {
		  Attribute attr = myCDFExport.sourceCDF.getAttribute("FILLVAL");
		  if (attr == null) {
		    filObj = null;
		  } else {
		    Entry entry = attr.getEntry(var);
		    long myType = entry.getDataType();
		    if (myType != dataType) { // they don't match
		      filObj = null;
		    } else {
			Object obj = entry.getData();
			String ttt;
			if (dataType == CDF_EPOCH) 
			  ttt = Epoch.encode(((Double)obj).doubleValue());
			else if (dataType == CDF_EPOCH16) 
			  ttt = Epoch16.encode((double[])obj);
			else 
			  ttt = CDFUtils.getStringData(obj, ",");
			StringTokenizer st = new StringTokenizer((String) newFil, ",");
			filLen = st.countTokens();
			if (filLen == -1) filObj = null;
			else filObj = CDFToolUtils.parseContents(ttt, dataType);
		    }
		  }
		} catch (CDFException ex) { filObj = null; }
	  }
	}

    }

/**
 * Fill the cells of the table.
  */

    private Object fillScreenTable(Object _dataArray, Variable var, long dataType,
				   int nDims, long[] dimSizes, int inGroup,
				   int atColumn, int startN, int recNo,
				   int elementStop, String format) {

	int page, row;
	int recElements;
	int rowCount;
	if (myCDFExport.orientation == 0) 
	  recElements = recNo * totalElementsPerRec - startN;
	else
	  recElements = recNo - startN;
	boolean goon;

        /////////////////////////////////////////////////////////////
        //                                                         //
        //                    For <= 1D Array                      //
        //                                                         //
        /////////////////////////////////////////////////////////////

        if (nDims <= 1) {
             if (nDims == 0) {
		row = recElements;
		goon = true;
		if (row < 0 || row >= ROWS) return recordObject;

		if (dataType == CDF_CHAR || dataType == CDF_UCHAR) {
		    int numElements = (int) var.getNumElements();
		    byte[] abytes = new byte[numElements];
		    String myTmp = new String((byte[])_dataArray);
                    recordObject[inGroup][row][atColumn] = myTmp;
		} else if (dataType == CDF_BYTE || dataType == CDF_INT1) {
		    byte abyte = ((Byte)_dataArray).byteValue();
                    byte afill = 0;
                    byte amax = 0;
                    byte amin = 0;
                    if (filObj != null) afill = ((byte[])filObj)[0];
                    if (minObj != null) amin = ((byte[])minObj)[0];
                    if (maxObj != null) amax = ((byte[])maxObj)[0];

                    if (minObj != null) {
			if (abyte < amin) {
			  goon = false;
			  if (filObj != null) abyte = afill;
			  else abyte = 0;
			}
		    }
                    if (goon && maxObj != null) {
                        if (abyte > amax) {
			  if (filObj != null) abyte = afill;
			  else abyte = 0;
			}
                    }
		    if (format == null)
		      recordObject[inGroup][row][atColumn] = // String.valueOf((int)abyte);
							     new Byte(abyte);
		    else
		      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)abyte);
		} else if (dataType == CDF_INT2 || dataType == CDF_UINT1) {
                    short ashort = ((Short)_dataArray).shortValue();
		    short afill = 0;
		    short amax = 0;
		    short amin = 0;
		    if (filObj != null) afill = ((short[])filObj)[0];
		    if (minObj != null) amin = ((short[])minObj)[0];
		    if (maxObj != null) amax = ((short[])maxObj)[0];
		    if (dataType == CDF_UINT1) {
		      if (afill < 0) afill -= (short) 2*Byte.MIN_VALUE;
		      if (ashort < 0) ashort -= (short) 2*Byte.MIN_VALUE;
		      if (amin < 0) amin -= (short) 2*Byte.MIN_VALUE;
		      if (amax < 0) amax -= (short) 2*Byte.MIN_VALUE;
		    }

                    if (minObj != null) {
                        if (ashort < amin) {
                          goon = false;
                          if (filObj != null) ashort = afill;
			  else ashort = 0;
			}
                    }
                    if (goon && maxObj != null) {
                        if (ashort > amax) {
                          if (filObj != null) ashort = afill;
			  else ashort = 0;
			}
                    }
		    if (format == null)
		      recordObject[inGroup][row][atColumn] = // String.valueOf((int)ashort);
							     new Short(ashort);
		    else
		      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)ashort);
		} else if (dataType == CDF_INT4 || dataType == CDF_UINT2) {
                    int aint = ((Integer)_dataArray).intValue();
                    int afill = 0;
                    int amax = 0;
                    int amin = 0;
                    if (filObj != null) afill = ((int[])filObj)[0];
                    if (minObj != null) amin = ((int[])minObj)[0];
                    if (maxObj != null) amax = ((int[])maxObj)[0];
                    if (dataType == CDF_UINT2) { 
                      if (afill < 0) afill -= (int) 2*Short.MIN_VALUE;
                      if (aint < 0) aint -= (int) 2*Short.MIN_VALUE;
                      if (amin < 0) amin -= (int) 2*Short.MIN_VALUE;
                      if (amax < 0) amax -= (int) 2*Short.MIN_VALUE;
                    }

                    if (minObj != null) {
                        if (aint < amin) {
			  goon = false;
			  if (filObj != null) aint = afill;
			  else aint = 0;
			}
                    }
                    if (goon && maxObj != null) {
                        if (aint > amax) {
                          if (filObj != null) aint = afill;
                          else aint = 0;
                        }
                    }
		    if (format == null)
		      recordObject[inGroup][row][atColumn] = //String.valueOf(aint);
							     new Integer(aint);
		    else
		      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)aint);
		} else if (dataType == CDF_UINT4) {
                    long along = ((Long)_dataArray).longValue();
                    long afill = 0L;
                    long amax = 0L;
                    long amin = 0L;
                    if (filObj != null) afill = ((long[])filObj)[0];
                    if (minObj != null) amin = ((long[])minObj)[0];
                    if (maxObj != null) amax = ((long[])maxObj)[0];
                    if (dataType == CDF_UINT4) {
                      if (afill < 0) afill -= (long) 2*Integer.MIN_VALUE;
                      if (along < 0) along -= (long) 2*Integer.MIN_VALUE;
                      if (amin < 0) amin -= (long) 2*Integer.MIN_VALUE;
                      if (amax < 0) amax -= (long) 2*Integer.MIN_VALUE;
                    }

                    if (minObj != null) {
                        if (along < amin) {
                          goon = false;
                          if (filObj != null) along = afill;
                          else along = 0L;
                        }
                    }
                    if (goon && maxObj != null) {
                        if (along > amax) {
                          if (filObj != null) along = afill;                    
                          else along = 0L;                    
                        }                    
                    }
                    
		    if (format == null)
		      recordObject[inGroup][row][atColumn] = // String.valueOf(along);
							     new Long(along);
		    else
		      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form(along);
		} else if (dataType == CDF_REAL4 || dataType == CDF_FLOAT) {
                    float afloat = ((Float)_dataArray).floatValue();
                    float afill = 0.0F;
                    float amax = 0.0F;
                    float amin = 0.0F;
                    if (filObj != null) afill = ((float[])filObj)[0];
                    if (minObj != null) amin = ((float[])minObj)[0];
                    if (maxObj != null) amax = ((float[])maxObj)[0];

                    if (minObj != null) {
                        if (afloat < amin) {
			  goon = false; 
			  if (filObj != null) afloat = afill;
  			  else afloat = 0.0F;
			}
                    }
                    if (goon && maxObj != null) {
                        if (afloat > amax) {
			  if (filObj != null) afloat = afill;
			  else afloat = 0.0F;
			}
                    }
		    if (format == null)
		      recordObject[inGroup][row][atColumn] = // String.valueOf(afloat);
							     new Float(afloat);
		    else
		      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((double)afloat);
		} else if (dataType == CDF_REAL8 || dataType == CDF_DOUBLE ||
			   dataType == CDF_EPOCH) {
                    double adouble = ((Double)_dataArray).doubleValue();
                    double afill = 0.0;
                    double amax = 0.0;
                    double amin = 0.0;
                    if (filObj != null) afill = ((double[])filObj)[0];
                    if (minObj != null) amin = ((double[])minObj)[0];
                    if (maxObj != null) amax = ((double[])maxObj)[0];

                    if (minObj != null) {
                        if (adouble < amin) {
			  goon = false;
			  if (filObj != null) adouble = afill;
			  else adouble = 0.0;
			}
                    }
                    if (goon && maxObj != null) {
                      	if (adouble > amax) {
			  if (filObj != null) adouble = afill;
			  else adouble = 0.0;
			}
                    }
                    if (dataType != CDF_EPOCH) {
		      if (format == null)
		        recordObject[inGroup][row][atColumn] = // String.valueOf(adouble);
							       new Double(adouble);
		      else
		        recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form(adouble);
		    } else {
                      String epoch = null;
                      if (myCDFExport.epoch == 0) epoch = Epoch.encode(adouble);
                      else if (myCDFExport.epoch == 1) epoch = Epoch.encode1(adouble);
                      else if (myCDFExport.epoch == 2) epoch = Epoch.encode2(adouble);
                      else if (myCDFExport.epoch == 3) epoch = Epoch.encode3(adouble);
                      else if (myCDFExport.epoch == 5) {
		        try {
                          String formatString = (String) var.getEntryData("FORMAT");
		          if (formatString == null || formatString.trim().length() == 0) 
			    epoch = Epoch.encode(adouble);
		          else
                            epoch = Epoch.encodex(adouble, formatString);
		        } catch (CDFException es) {
			  epoch = Epoch.encode(adouble);
		        }
                      }
                      recordObject[inGroup][row][atColumn] = epoch;
                    }
                } else if (dataType == CDF_EPOCH16) {
                    double[] adouble = new double[2];
		    adouble[0] = ((double[])_dataArray)[0];
		    adouble[1] = ((double[])_dataArray)[1];
                    double[] afill = new double[] {0.0, 0.0};
                    double[] amax = new double[] {0.0, 0.0};
                    double[] amin = new double[] {0.0, 0.0};
                    if (filObj != null) {
			afill[0] = ((double[])filObj)[0];
			afill[1] = ((double[])filObj)[1];
		    }
                    if (minObj != null) {
			amin[0] = ((double[])minObj)[0];
			amin[1] = ((double[])minObj)[1];
		    }
                    if (maxObj != null) {
			amax[0] = ((double[])maxObj)[0];
			amax[1] = ((double[])maxObj)[1];
		    }

                    if (minObj != null) {
                        if (adouble[0] < amin[0] || 
			    (adouble[0] == amin[0] &&
			     adouble[1] < amin[1] )) {
                          goon = false;
                          if (filObj != null) {
			    adouble[0] = afill[0];
			    adouble[1] = afill[1];
                          } else {
			    adouble[0] = 0.0;
			    adouble[1] = 0.0;
			  }
                        }
                    }
                    if (goon && maxObj != null) {
                        if (adouble[0] > amax[0] ||
			    (adouble[0] == amax[0] &&
			     adouble[1] > amax[1] )) {
                          if (filObj != null) {
			    adouble[0] = afill[0];
			    adouble[1] = afill[1];
			  } else {
                            adouble[0] = 0.0;
			    adouble[1] = 0.0;
			  }
                        }
                    }
                    String epoch = null;
                    if (myCDFExport.epoch == 0) epoch = Epoch16.encode(adouble);
                    else if (myCDFExport.epoch == 1) epoch = Epoch16.encode1(adouble);
                    else if (myCDFExport.epoch == 2) epoch = Epoch16.encode2(adouble);
                    else if (myCDFExport.epoch == 3) epoch = Epoch16.encode3(adouble);
                    else if (myCDFExport.epoch == 5) {
                      try {
                         String formatString = (String) var.getEntryData("FORMAT");
                         if (formatString == null || 
			     formatString.trim().length() == 0)
                           epoch = Epoch16.encode(adouble);
                         else
                           epoch = Epoch16.encodex(adouble, formatString);
                      } catch (CDFException es) {
                        epoch = Epoch16.encode(adouble);
                      }
                    }
                    recordObject[inGroup][row][atColumn] = epoch;
		}
             } else { // for 1-D array
                if (dataType == CDF_CHAR || dataType == CDF_UCHAR) {
                    int numElements = (int) var.getNumElements();
		    byte[] abytes = new byte[numElements];
		    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
			  if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
                    	System.arraycopy(((String [])_dataArray)[j].getBytes(),
			  		      0, abytes, 0, numElements);
                  	String myTmp = new String(abytes);
                    	recordObject[inGroup][row][atColumn] = myTmp;
		    }
		} else if (dataType == CDF_BYTE || dataType == CDF_INT1) {
		    byte abyte = 0;
		    byte tmpMin = 0, tmpMax = 0, tmpFil = 0;
		    if (minObj != null && minLen == 1)
			tmpMin = ((byte[])minObj)[0];
                    if (maxObj != null && maxLen == 1)
                        tmpMax = ((byte[])maxObj)[0];
                    if (filObj != null)
                        tmpFil = ((byte[])filObj)[0];

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
			if (myCDFExport.orientation == 0) {
			  row = j + recElements;
                          if (row < 0) continue;
			  if (row >= ROWS) break;
			} else {
			  row = recElements;
			  inGroup = (eleIndex[currentVar] + j) / COLUMNS;
			  atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
			}
			if (dimSizes[0] > 1) abyte = ((byte [])_dataArray)[j];
			else abyte = ((Byte) _dataArray).byteValue();
                        goon = true;
			if (minObj != null) {
                          if (minLen == 1) {
			    if (abyte < tmpMin) {
                                goon = false;
				if (filObj != null) abyte = tmpFil;
				else abyte = 0;
			    }
			  } else {
			    if (((byte [])minObj).length > j) {
			      if (abyte < ((byte [])minObj)[j]) {
                                goon = false;
				if (filObj != null) abyte = tmpFil;
				else abyte = 0;
			      }
			    }
			  }
			}
                        if (goon && maxObj != null) {
                          if (maxLen == 1) {
                            if (abyte > tmpMax) {
				if (filObj != null) abyte = tmpFil;
				else abyte = 0;
			    }
                          } else {
			    if (((byte [])maxObj).length > j) {
                              if (abyte > ((byte [])maxObj)[j]) {
                                if (filObj != null) abyte = tmpFil;
				else abyte = 0;
			      }
			    }
			  }
                        }
			if (format == null)
			    recordObject[inGroup][row][atColumn] = //String.valueOf((int)abyte);
								   new Byte(abyte);
			else
			    recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)abyte);
                    }
		} else if (dataType == CDF_INT2 || dataType == CDF_UINT1) {
		    short ashort = 0;
		    short tmpMin = 0, tmpMax = 0, tmpFil = 0;
		    if (minObj != null) tmpMin = ((short[])minObj)[0];
		    if (maxObj != null) tmpMax = ((short[])maxObj)[0];
		    if (filObj != null) tmpFil = ((short[])filObj)[0];
		    if (dataType == CDF_UINT1) {
		      if (tmpMin < 0) tmpMin -= (short) 2*Byte.MIN_VALUE;
		      if (tmpMax < 0) tmpMax -= (short) 2*Byte.MIN_VALUE;
		      if (tmpFil < 0) tmpFil -= (short) 2*Byte.MIN_VALUE;
		    }

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
                          if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
			if (dimSizes[0] > 1) ashort = ((short [])_dataArray)[j];
			else ashort = ((Short)_dataArray).shortValue();
			if (dataType == CDF_UINT1 && ashort < 0) ashort -= (short) 2*Byte.MIN_VALUE;
			
                        goon = true;
                        if (minObj != null) {
                            if (minLen == 1) {
                              if (ashort < tmpMin) { 
                                  goon = false;
				  if (filObj != null) ashort = tmpFil;
				  else ashort = 0;
			      }
                            } else {
			      if (((short [])minObj).length > j) {
			        short avalue = ((short [])minObj)[j];
			        if (dataType == CDF_UINT1 && avalue < 0) 
				  avalue -= (short) 2*Byte.MIN_VALUE;
                                if (ashort < avalue) {
                                  goon = false;
				  if (filObj != null) ashort = tmpFil;
				  else ashort = 0;
				}
			      }
			    }
                        }
                        if (goon && maxObj != null) {
			    if (maxLen == 1) {
                                if (ashort > tmpMax) {
				  if (filObj != null) ashort = tmpFil;
				  else ashort = 0;
				}
                            } else {
				if (((short [])maxObj).length > j) {
				  short avalue = ((short [])maxObj)[j];
				  if (dataType == CDF_UINT1 && avalue < 0) 
				    avalue -= (short) 2*Byte.MIN_VALUE;
                                  if (ashort > avalue) {
				    if (filObj != null) ashort = tmpFil;
				    else ashort = 0;
				  }
				}
			    }
                        }
			if (format == null)
			    recordObject[inGroup][row][atColumn] = // String.valueOf((int)ashort);
								   new Short(ashort);
			else
			    recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)ashort);
                    }
		} else if (dataType == CDF_INT4 || dataType == CDF_UINT2) {
		    int aint = 0;
		    int tmpMin = 0, tmpMax = 0, tmpFil = 0;
                    if (minObj != null) tmpMin = ((int[])minObj)[0];
                    if (maxObj != null) tmpMax = ((int[])maxObj)[0];
                    if (filObj != null) tmpFil = ((int[])filObj)[0];
                    if (dataType == CDF_UINT2) {
                      if (tmpMin < 0) tmpMin -= (int) 2*Short.MIN_VALUE;
                      if (tmpMax < 0) tmpMax -= (int) 2*Short.MIN_VALUE;
                      if (tmpFil < 0) tmpFil -= (int) 2*Short.MIN_VALUE;
                    }

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
                          if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
			if (dimSizes[0] > 1) aint = ((int [])_dataArray)[j];
			else aint = ((Integer) _dataArray).intValue();
			if (dataType == CDF_UINT2 && aint < 0) 
			  aint -= (int) 2*Short.MIN_VALUE;

                        goon = true;                    
                        if (minObj != null) {
                            if (minLen == 1) {
                              if (aint < tmpMin) {
                                  goon = false;
 				  if (filObj != null) aint = tmpFil;
				  else aint = 0;
		   	      }
                            } else {
			      if (((int [])minObj).length > j) {
			        int avalue = ((int [])minObj)[j];
			        if (dataType == CDF_UINT2 && avalue < 0) 
				  avalue -= (int) 2*Short.MIN_VALUE;
                                if (aint < avalue) {
                                  goon = false;
				  if (filObj != null) aint = tmpFil;
				  else aint = 0;
				}
			      }
			    }
                        }
                        if (goon && maxObj != null) {
                            if (maxLen == 1) {
                              if (aint > tmpMax) {
				  if (filObj != null) aint = tmpFil;
				  else aint = 0;
			      }
                            } else {
			      if (((int [])maxObj).length > j) {
                                int avalue = ((int [])maxObj)[j];
                                if (dataType == CDF_UINT2 && avalue < 0) 
				  avalue -= (int) 2*Short.MIN_VALUE;
                                if (aint > avalue) {
				  if (filObj != null) aint = tmpFil;
				  else aint = 0;
				}
			      }
			    }
                        }

			if (format == null)
			    recordObject[inGroup][row][atColumn] = // String.valueOf(aint);
								   new Integer(aint);
			else
			    recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)aint);
                    }
		} else if (dataType == CDF_UINT4) {
		    long along = 0;
		    long tmpMin = 0L, tmpMax = 0L, tmpFil = 0L;
                    if (minObj != null) tmpMin = ((long[])minObj)[0];
                    if (maxObj != null) tmpMax = ((long[])maxObj)[0];
                    if (filObj != null) tmpFil = ((long[])filObj)[0];
                    if (tmpMin < 0) tmpMin -= (long) 2*Integer.MIN_VALUE;
                    if (tmpMax < 0) tmpMax -= (long) 2*Integer.MIN_VALUE;
                    if (tmpFil < 0) tmpFil -= (long) 2*Integer.MIN_VALUE;

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
                          if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
			if (dimSizes[0] > 1) along = ((long [])_dataArray)[j];
			else along = ((Long) _dataArray).longValue();
			if (along < 0) along -= (long) 2*Integer.MIN_VALUE;

                        goon = true;                    
                        if (minObj != null) {
                            if (minLen == 1) {
                              if (along < tmpMin) {
                                goon = false;
				if (filObj != null) along = tmpFil;
				else along = 0;
			      }
                            } else {
			      if (((long [])minObj).length > j) {
			        long avalue = ((long [])minObj)[j];
			        if (avalue < 0) avalue -= (long) 2*Integer.MIN_VALUE;
                                if (along < avalue) {
                                  goon = false;
				  if (filObj != null) along = tmpFil;
				  else along = 0;
				}
			      }
			    }
                        }
                        if (goon && maxObj != null) {
                            if (maxLen == 1) {
                              if (along > tmpMax) {
				if (filObj != null) along = tmpFil;
				else along = 0;
			      }
                            } else {
			      if (((long [])maxObj).length > j) {
                                long avalue = ((long [])maxObj)[j];
                                if (avalue < 0) avalue -= (long) 2*Integer.MIN_VALUE;
                                if (along > avalue) {
				  if (filObj != null) along = tmpFil;
				  else along = 0;
				}
			      }
			    }
                        }

			if (format == null)
			    recordObject[inGroup][row][atColumn] = // String.valueOf(along);
								   new Long(along);
			else
			    recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form(along);
                    }
		} else if (dataType == CDF_REAL4 || dataType == CDF_FLOAT) {
		    float afloat = 0.0F;
		    float tmpMin = 0.0F, tmpMax = 0.0F, tmpFil = 0.0F;
                    if (minObj != null && minLen == 1)
                        tmpMin = ((float[])minObj)[0];
                    if (maxObj != null && maxLen == 1)
                        tmpMax = ((float[])maxObj)[0];
                    if (filObj != null)
                        tmpFil = ((float[])filObj)[0];

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
                          if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
			if (dimSizes[0] > 1) afloat = ((float [])_dataArray)[j];
			else afloat = ((Float) _dataArray).floatValue();
                        goon = true;                    
                        if (minObj != null) {
                          if (minLen == 1) {
                            if (afloat < tmpMin) {
                                goon = false;
				if (filObj != null) afloat = tmpFil;
				else afloat = 0.0F;
			    }
                          } else {
			    if (((float [])minObj).length > j) {
                              if (afloat < ((float [])minObj)[j]) {
                                goon = false;
                                if (filObj != null) afloat = tmpFil;
                                else afloat = 0.0F;
			      }
                            }
			  }
                        }
                        if (goon && maxObj != null) {
                          if (maxLen == 1) {
                            if (afloat > tmpMax) {
				if (filObj != null) afloat = tmpFil;
                                else afloat = 0.0F;
                            }
                          } else {
			    if (((float [])maxObj).length > j) {
                              if (afloat > ((float [])maxObj)[j]) {
                                if (filObj != null) afloat = tmpFil;
                                else afloat = 0.0F;
			      }
                            }
			  }
                        }
			if (format == null)
			    recordObject[inGroup][row][atColumn] = // String.valueOf(afloat);
								   new Float(afloat);
			else
			    recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((double)afloat);
                    }
		} else if (dataType == CDF_REAL8 || dataType == CDF_DOUBLE ||
			   dataType == CDF_EPOCH) {
		    double adouble = 0.0;
		    double tmpMin = 0.0D, tmpMax = 0.0D, tmpFil = 0.0D;
                    if (minObj != null && minLen == 1)
                        tmpMin = ((double[])minObj)[0];
                    if (maxObj != null && maxLen == 1)
                        tmpMax = ((double[])maxObj)[0];
                    if (filObj != null)
                        tmpFil = ((double[])filObj)[0];

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
                          if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
			if (dimSizes[0] > 1) adouble = ((double [])_dataArray)[j];
			else adouble = ((Double) _dataArray).doubleValue();
                        goon = true;                    
                        if (minObj != null) {
                          if (minLen == 1) {
                            if (adouble < tmpMin) {
				goon = false;
				if (filObj != null) adouble = tmpFil;
				else adouble = 0.0;
			    }
                          } else {
			    if (((double [])minObj).length > j) {
                              if (adouble < ((double [])minObj)[j]) {
				goon = false;
                                if (filObj != null) adouble = tmpFil;
                                else adouble = 0.0;
			      }
                            }
			  }
                        }
                        if (goon && maxObj != null) {
                          if (maxLen == 1) {
                            if (adouble > tmpMax) {
				if (filObj != null) adouble = tmpFil;
                                else adouble = 0.0;
                            }
                          } else {
			    if (((double [])maxObj).length > j) {
                              if (adouble > ((double [])maxObj)[j]) {
                                if (filObj != null) adouble = tmpFil;
                                else adouble = 0.0;
			      }
                            }
			  }
                        }
			if (dataType != CDF_EPOCH) {
			  if (format == null)
			    recordObject[inGroup][row][atColumn] = // String.valueOf(adouble);
								   new Double(adouble);
			  else
			    recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form(adouble);
			} else {
                          String epoch = null;
                          if (myCDFExport.epoch == 0) epoch = Epoch.encode(adouble);
                          else if (myCDFExport.epoch == 1) epoch = Epoch.encode1(adouble);
                          else if (myCDFExport.epoch == 2) epoch = Epoch.encode2(adouble);
                          else if (myCDFExport.epoch == 3) epoch = Epoch.encode3(adouble);
                          else if (myCDFExport.epoch == 5) {
			    try {
                              String formatString = (String) var.getEntryData("FORMAT");
                              if (formatString == null || formatString.trim().length() == 0) 
                                epoch = Epoch.encode(adouble);
                              else
                                epoch = Epoch.encodex(adouble, formatString);
			    } catch(CDFException es) {
			      epoch = Epoch.encode(adouble);
			    }
                          }     
                          recordObject[inGroup][row][atColumn] = epoch;
			}
                    }
                } else if (dataType == CDF_EPOCH16) {
                    double[] adouble = new double[] {0.0D, 0.0D};
                    double[] tmpMin = new double[] {0.0D, 0.0D},
			     tmpMax = new double[] {0.0D, 0.0D}, 
			     tmpFil = new double[] {0.0D, 0.0D};
                    if (minObj != null && minLen == 1) {
                        tmpMin[0] = ((double[])minObj)[0];
			tmpMin[0] = ((double[])minObj)[0];
                    }
		    if (maxObj != null && maxLen == 1){
                        tmpMax[0] = ((double[])maxObj)[0];
			tmpMax[0] = ((double[])maxObj)[0];
                    }
		    if (filObj != null) {
                        tmpFil[0] = ((double[])filObj)[0];
			tmpFil[0] = ((double[])filObj)[0];
		    }

                    for (int j = 0; j < (int) dimSizes[0]; j++) {
                        if (myCDFExport.orientation == 0) {
                          row = j + recElements;
                          if (row < 0) continue;
                          if (row >= ROWS) break;
                        } else {
                          row = recElements;
                          inGroup = (eleIndex[currentVar] + j) / COLUMNS;
                          atColumn = (eleIndex[currentVar] + j) % COLUMNS + istart;
                        }
                        if (dimSizes[0] > 1) {
			  adouble[0] = ((double [])_dataArray)[2*j];
			  adouble[1] = ((double [])_dataArray)[2*j+1];
                        } else {
			  adouble[0] = ((double []) _dataArray)[0];
			  adouble[1] = ((double []) _dataArray)[1];
			}
                        goon = true;
                        if (minObj != null) {
                          if (minLen == 1) {
                            if (adouble[0] < tmpMin[0] ||
				(adouble[0] == tmpMin[0] &&
				 adouble[1] < tmpMin[1] )) {
                                goon = false;
                                if (filObj != null) {
				  adouble[0] = tmpFil[0];
				  adouble[1] = tmpFil[1];
                                } else {
				  adouble[0] = 0.0;
				  adouble[0] = 0.0;
				}
                            }
                          } else {
                            if (((double [])minObj).length > j) {
                              if (adouble[0] < ((double [])minObj)[2*j] ||
				  (adouble[0] == ((double [])minObj)[2*j] &&
				   adouble[1] < ((double [])minObj)[2*j+1] )) {
                                goon = false;
                                if (filObj != null) {
				  adouble[0] = tmpFil[0];
				  adouble[1] = tmpFil[1];
				} else {
                                  adouble[0] = adouble[1] = 0.0;
				}
                              }
                            }
                          }
                        }
                        if (goon && maxObj != null) {
                          if (maxLen == 1) {
                            if (adouble[0] > tmpMax[0] ||
				(adouble[0] == tmpMax[0] &&
				 adouble[1] > tmpMax[1] )) {
                                if (filObj != null) {
				  adouble[0] = tmpFil[0];
				  adouble[1] = tmpFil[1];
                                } else {
				  adouble[0] = adouble[1] = 0.0;
				}
                            }
                          } else {
                            if (((double [])maxObj).length > j) {
                              if (adouble[0] > ((double [])maxObj)[2*j] ||
				  (adouble[0] == ((double [])maxObj)[2*j] &&
				   adouble[1] > ((double [])maxObj)[2*j+1] )) {
                                if (filObj != null) {
				  adouble[0] = tmpFil[0];
				  adouble[1] = tmpFil[1];
                                } else {
				  adouble[0] = adouble[1] = 0.0;
				}
                              }
                            }
                          }
                        }
                        String epoch = null;
                        if (myCDFExport.epoch == 0) 
			  epoch = Epoch16.encode(adouble);
                        else if (myCDFExport.epoch == 1) 
			  epoch = Epoch16.encode1(adouble);
                        else if (myCDFExport.epoch == 2) 
			  epoch = Epoch16.encode2(adouble);
                        else if (myCDFExport.epoch == 3) 
			  epoch = Epoch16.encode3(adouble);
                        else if (myCDFExport.epoch == 5) {
                          try {
                            String formatString = (String) var.getEntryData("FORMAT");
                            if (formatString == null || formatString.trim().length() == 0)
                              epoch = Epoch16.encode(adouble);
                            else
                              epoch = Epoch16.encodex(adouble, formatString);
                          } catch(CDFException es) {
                            epoch = Epoch16.encode(adouble);
                          }
                        }
                        recordObject[inGroup][row][atColumn] = epoch;
                    }
                }
            }

        ////////////////////////////////////////////////////////
        //                                                    //
        //              Multidimensional Arrays               //
        //                                                    //
        ////////////////////////////////////////////////////////

          } else {
	    int inTable = eleIndex[currentVar];
	    int lastDim = (int) dimSizes[nDims - 1];
            /*
             * Setup the subArrays array
             * cIndex is the holds the index for the current subarray
             * boundary is the # of values in the subarray
             */
            Object aRow = null;
            Object [] subArrays = new Object[(int)nDims-1];
            int [] cIndex   = new int[(int)nDims-1];
            long [] boundary = new long[(int)nDims-1];

            cIndex[0] = 0;
	    boundary[0] = product(dimSizes, 0, (int)nDims);

	    subArrays[0] = _dataArray;
            for (int i = 1; i < (int)nDims-1; i++) {
              subArrays[i] = Array.get(subArrays[i-1], 0);
              boundary[i] = product(dimSizes,i,(int)nDims);
              cIndex[i] = 0;
            }

            int n = 0; // The current element in the _data
            Object cObject = _dataArray;  // A temp object to hold a subarray
            boolean boundaryCrossed;

            while (n < boundary[0]) {
                // Get the correct 2D subarray to print
                if (n != 0) {
                    for (int i = 0; i < (int)nDims-1; i++) {
                        boundaryCrossed = ((n % boundary[i]) == 0);
                        if (boundaryCrossed) {
                            // Get the next sub array
                            cIndex[i]++;
                            cObject = Array.get(cObject, cIndex[i]);
                            subArrays[i] = cObject;

                            // Get the first element of each
                            // subsequent subarray
                            for (int j=i+1;j<(int)nDims-1;j++) {
                                cIndex[j] = 0;
                                subArrays[j] = Array.get(subArrays[j-1],cIndex[j]);
                            }
                            break;

                        } else {
                            cObject = subArrays[i];
                        }
                    }
                }

                // Fill the correct elements of _data
                if (dataType == CDF_CHAR || dataType == CDF_UCHAR) {
                    int numElements = (int) var.getNumElements();
                    byte[] abytes = new byte[numElements];
                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (String [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row > elementStop) break;
                          } else {
                            row = recElements;
                            inGroup =  inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
                          System.arraycopy(((String[])aRow)[i].getBytes(),
                                 	    0, abytes, 0, numElements);
	                  String myTmp = new String(abytes);
        	          recordObject[inGroup][row][atColumn] = myTmp;
			}
		    }
		} else if (dataType == CDF_BYTE || dataType == CDF_INT1) {
		    byte abyte = 0;
		    byte tmpMin = 0, tmpMax = 0, tmpFil = 0;
		    if (minObj != null && minLen == 1)
			tmpMin = ((byte[])minObj)[0];
		    if (maxObj != null && maxLen == 1)
			tmpMax = ((byte[])maxObj)[0];
		    if (filObj != null)
			tmpFil = ((byte[])filObj)[0];

		    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (byte [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  abyte = ((byte [])aRow)[j];
			  goon = true;
                          if (minObj != null) {
                             if (minLen == 1) {
                               if (abyte < tmpMin) {
				 goon = false;
                                 if (filObj != null) abyte = tmpFil;
                                 else abyte = 0;
                               }
                             } else {
			       if (((byte [])minObj).length > j) {
                                 if (abyte < ((byte [])minObj)[j]) {
				   goon = false;
                                   if (filObj != null) abyte = tmpFil;
                                   else abyte = 0;
				 }
                               }
			     }
                          }
                          if (goon && maxObj != null) {
                             if (maxLen == 1) {
                               if (abyte > tmpMax) {
				 if (filObj != null) abyte = tmpFil;
				 else abyte = 0;
			       }
                             } else {
			       if (((byte [])maxObj).length > j) {
                                 if (abyte > ((byte [])maxObj)[j]) {
                                   if (filObj != null) abyte = tmpFil;
                                   else abyte = 0;
				 }
                               }
			     }
                          }
			  if (format == null)
			      recordObject[inGroup][row][atColumn] = // String.valueOf((int)abyte);
								     new Byte(abyte);
			  else
			      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)abyte);
			}
		    }
		} else if (dataType == CDF_INT2 || dataType == CDF_UINT1) {
		    short ashort = 0;
		    short tmpMin = 0, tmpMax = 0, tmpFil = 0;
                    if (minObj != null) tmpMin = ((short[])minObj)[0];
                    if (maxObj != null) tmpMax = ((short[])maxObj)[0];
                    if (filObj != null) tmpFil = ((short[])filObj)[0];
                    if (dataType == CDF_UINT1) {
                      if (tmpMin < 0) tmpMin -= (short) 2*Byte.MIN_VALUE;
                      if (tmpMax < 0) tmpMax -= (short) 2*Byte.MIN_VALUE;
                      if (tmpFil < 0) tmpFil -= (short) 2*Byte.MIN_VALUE;
                    }

                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (short [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  ashort = ((short [])aRow)[j];
			  if (dataType == CDF_UINT1 && ashort < 0) 
			    ashort -= (short) 2*Byte.MIN_VALUE;
			  
			  goon = true;
                          if (minObj != null) {
                              if (minLen == 1) {
                                if (ashort < tmpMin) {
				  goon = false;
				  if (filObj != null) ashort = tmpFil;
				  else ashort = 0;
				}
                              } else {
				if (((short [])minObj).length > j) {
                                  short avalue = ((short [])minObj)[j];
                                  if (dataType == CDF_UINT1 && avalue < 0) 
				    avalue -= (short) 2*Byte.MIN_VALUE;
                                  if (ashort < avalue) {
				    goon = false;
                                    if (filObj != null) ashort = tmpFil;
                                    else ashort = 0;
				  }
				}
			      }
                          }
                          if (goon && maxObj != null) {
                              if (maxLen == 1) {
                                if (ashort > tmpMax) {
				  if (filObj != null) ashort = tmpFil;
				  else ashort = 0;
				}
                              } else {
				if (((short [])maxObj).length > j) {
                                  short avalue = ((short [])maxObj)[j];
                                  if (dataType == CDF_UINT1 && avalue < 0) 
				    avalue -= (short) 2*Byte.MIN_VALUE;
                                  if (ashort > avalue) {
                                    if (filObj != null) ashort = tmpFil;
                                    else ashort = 0;
				  }
				}
			      }
                          }
			  if (format == null)
			      recordObject[inGroup][row][atColumn] = // String.valueOf((int)ashort);
								     new Short(ashort);
			  else
			      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)ashort);
			}
		    }
		} else if (dataType == CDF_INT4 || dataType == CDF_UINT2) {
		    int aint = 0;
		    int tmpMin = 0, tmpMax = 0, tmpFil = 0;
                    if (minObj != null) tmpMin = ((int[])minObj)[0];
                    if (maxObj != null) tmpMax = ((int[])maxObj)[0];
                    if (filObj != null) tmpFil = ((int[])filObj)[0];
                    if (dataType == CDF_UINT2) {
                      if (tmpMin < 0) tmpMin -= (int) 2*Short.MIN_VALUE;
                      if (tmpMax < 0) tmpMax -= (int) 2*Short.MIN_VALUE;
                      if (tmpFil < 0) tmpFil -= (int) 2*Short.MIN_VALUE;
		    }

                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (int [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  aint = ((int [])aRow)[j];
			  if (dataType == CDF_UINT2 && aint < 0) 
			    aint -= (int) 2*Short.MIN_VALUE;
			  
			  goon = true;
                          if (minObj != null) {
                              if (minLen == 1) {
                                if (aint < tmpMin) {
				  goon = false;
				  if (filObj != null) aint = tmpFil;
				  else aint = 0;
				}
                              } else {
				if (((int [])minObj).length > j) {
                                  int avalue = ((int [])minObj)[j];
                                  if (dataType == CDF_UINT2 && avalue < 0) 
				    avalue -= (int) 2*Short.MIN_VALUE;
                                  if (aint < avalue) {
				    goon = false;
                                    if (filObj != null) aint = tmpFil;
                                    else aint = 0;
				  }
                                }
			      }
                          }
                          if (goon && maxObj != null) {
                              if (maxLen == 1) {
                                if (aint > tmpMin) {
				  if (filObj != null) aint = tmpFil;
				  else aint = 0; 
				}
                              } else {
				if (((int [])maxObj).length > j) {
                                  int avalue = ((int [])maxObj)[j];
                                  if (dataType == CDF_UINT2 && avalue < 0) 
				    avalue -= (int) 2*Short.MIN_VALUE;
                                  if (aint > avalue) {
                                    if (filObj != null) aint = tmpFil;
                                    else aint = 0;
				  }
                                }
			      }
                          }

			  if (format == null)
			      recordObject[inGroup][row][atColumn] = // String.valueOf(aint);
								     new Integer(aint);
			  else
			      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((long)aint);
			}
		    }
		} else if (dataType == CDF_UINT4) {
		    long along = 0;
		    long tmpMin = 0L, tmpMax = 0L, tmpFil = 0L;
                    if (minObj != null) tmpMin = ((long[])minObj)[0];
                    if (maxObj != null) tmpMax = ((long[])maxObj)[0];
                    if (filObj != null) tmpFil = ((long[])filObj)[0];
                    if (tmpMin < 0) tmpMin -= (long) 2*Integer.MIN_VALUE;
                    if (tmpMax < 0) tmpMax -= (long) 2*Integer.MIN_VALUE;
                    if (tmpFil < 0) tmpFil -= (long) 2*Integer.MIN_VALUE;

                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (long [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  along = ((long [])aRow)[j];
			  if (along < 0) along -= (long) 2*Integer.MIN_VALUE;
			  
			  goon = true;
                          if (minObj != null) {
                              if (minLen == 1) {
                                if (along < tmpMin) {
				  goon = false;
				  if (filObj != null) along = tmpFil;
				  else along = 0;
				}
                              } else {
				if (((long [])minObj).length > j) {
                                  long avalue = ((long [])minObj)[j];
                                  if (avalue < 0) avalue -= (long) 2*Integer.MIN_VALUE;
                                  if (along < avalue) {
				    goon = false;
                                    if (filObj != null) along = tmpFil;
                                    else along = 0;
				  }
                                }
			      }
                          }
                          if (goon && maxObj != null) {
                              if (maxLen == 1) {
                                if (along > tmpMax) {
			 	  if (filObj != null) along = tmpFil;
				  else along = 0; 
				}
                              } else {
				if (((long [])maxObj).length > j) {
                                  long avalue = ((long [])maxObj)[j];
                                  if (avalue < 0) avalue -= (long) 2*Integer.MIN_VALUE;
                                  if (along > avalue) {
                                    if (filObj != null) along = tmpFil;
                                    else along = 0;
				  }
                                }
			      }
                          }

			  if (format == null)
			      recordObject[inGroup][row][atColumn] = // String.valueOf(along);
								     new Long(along);
			    else
			      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form(along);
			}
		    }
		} else if (dataType == CDF_REAL4 || dataType == CDF_FLOAT) {
		    float afloat = 0.0F;
		    float tmpMin = 0.0F, tmpMax = 0.0F, tmpFil = 0.0F;
                    if (minObj != null && minLen == 1)
                        tmpMin = ((float[])minObj)[0];
                    if (maxObj != null && maxLen == 1)
                        tmpMax = ((float[])maxObj)[0];
                    if (filObj != null)
                        tmpFil = ((float[])filObj)[0];

                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (float [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  afloat = ((float [])aRow)[j];
			  goon = true;
                          if (minObj != null) {
                             if (minLen == 1) {
                               if (afloat < tmpMin) {
				   goon = false;
                                   if (filObj != null) afloat = tmpFil;
                                   else afloat = 0.0F;
                               }
                             } else {
			       if (((float [])minObj).length > j) {
                                 if (afloat < ((float [])minObj)[j]) {
				   goon = false;
                                   if (filObj != null) afloat = tmpFil;
                                   else afloat = 0.0F;
				 }
                               }                             
			     }
                          }
                          if (goon && maxObj != null) {
                             if (maxLen == 1) {
                               if (afloat > tmpMax) {
                                   if (filObj != null) afloat = tmpFil;
                                   else afloat = 0.0F;
                               }                             
                             } else {
			       if (((float [])maxObj).length > j) {
                                 if (afloat > ((float [])maxObj)[j]) {
                                   if (filObj != null) afloat = tmpFil;
                                   else afloat = 0.0F;
				 }
                               }                             
			     }
                          }

			  if (format == null)
			      recordObject[inGroup][row][atColumn] = // String.valueOf(afloat);
								     new Float(afloat);
			    else
			      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form((double)afloat);
			}
		    }
		} else if (dataType == CDF_REAL8 || dataType == CDF_DOUBLE ||
			   dataType == CDF_EPOCH) {
		    double adouble = 0.0D;
		    double tmpMin = 0.0D, tmpMax = 0.0D, tmpFil = 0.0D;
                    if (minObj != null && minLen == 1)
                        tmpMin = ((double[])minObj)[0];
                    if (maxObj != null && maxLen == 1)
                        tmpMax = ((double[])maxObj)[0];
                    if (filObj != null)
                        tmpFil = ((double[])filObj)[0];

                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (double [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  adouble = ((double [])aRow)[j];
			  goon = true;
                          if (minObj != null) {
                             if (minLen == 1) {
                               if (adouble < tmpMin) {
				   goon = false;
                                   if (filObj != null) adouble = tmpFil;
                                   else adouble = 0.0;
                               }
                             } else {
			       if (((double [])minObj).length > j) {
                                 if (adouble < ((double [])minObj)[j]) {
				   goon = false;
                                   if (filObj != null) adouble = tmpFil;
                                   else adouble = 0.0;
				 }
                               }
			     }
                          }
                          if (goon && maxObj != null) {
                             if (maxLen == 1) {
                               if (adouble > tmpMax) {
                                   if (filObj != null) adouble = tmpFil;
                                   else adouble = 0.0;
                               }
                             } else {
			       if (((double [])maxObj).length > j) {
                                 if (adouble > ((double [])maxObj)[j]) {
                                   if (filObj != null) adouble = tmpFil;
                                   else adouble = 0.0;
				 }
                               }
			     }
                          }
			  if (dataType != CDF_EPOCH) {
			    if (format == null)
			      recordObject[inGroup][row][atColumn] = // String.valueOf(adouble);
								     new Double(adouble);
			    else
			      recordObject[inGroup][row][atColumn] =
					Cformat.getInstance(format).form(adouble);
			  } else {
                            String epoch = null;
                            if (myCDFExport.epoch == 0) epoch = Epoch.encode(adouble);
                            else if (myCDFExport.epoch == 1) epoch = Epoch.encode1(adouble);
                            else if (myCDFExport.epoch == 2) epoch = Epoch.encode2(adouble);
                            else if (myCDFExport.epoch == 3) epoch = Epoch.encode3(adouble);
                            else if (myCDFExport.epoch == 5) {
			      try {
                                 String formatString = (String) var.getEntryData("FORMAT");
                                 if (formatString == null || formatString.trim().length() == 0) 
                                   epoch = Epoch.encode(adouble);
                                 else
                                   epoch = Epoch.encodex(adouble, formatString);
			      } catch (CDFException es) {
				 epoch = Epoch.encode(adouble);
			      }	
                            }     
                            recordObject[inGroup][row][atColumn] = epoch;
			  }
                        }
                    }
		} else if (dataType == CDF_EPOCH16) {
		    double[] adouble = new double[] {0.0D, 0.0D};
		    double[] tmpMin = new double[] {0.0D, 0.0D}, 
			     tmpMax = new double[] {0.0D, 0.0D}, 
			     tmpFil = new double[] {0.0D, 0.0D};
                    if (minObj != null && minLen == 1) {
                        tmpMin[0] = ((double[])minObj)[0];
			tmpMin[1] = ((double[])minObj)[1];
                    } 
		    if (maxObj != null && maxLen == 1) {
                        tmpMax[0] = ((double[])maxObj)[0];
			tmpMax[1] = ((double[])maxObj)[1];
                    } 
		    if (filObj != null) {
                        tmpFil[0] = ((double[])filObj)[0];
			tmpFil[1] = ((double[])filObj)[1];
		    }

                    for (int i = 0; i < (int) dimSizes[(int)nDims-2]; i++) {
			aRow = (double [])Array.get(subArrays[(int)nDims - 2], i);
                        for (int j = 0; j < lastDim; j++) {
                          if (myCDFExport.orientation == 0) {
                            row = j + recElements + i * lastDim;
			    if (row < 0) continue;
                            if (row >= ROWS) break;
                          } else {
                            row = recElements;
                            inGroup = inTable / COLUMNS;
                            atColumn = inTable % COLUMNS + istart;
			    inTable++;
                          }
			  adouble[0] = ((double [])aRow)[2*j];
			  adouble[1] = ((double [])aRow)[2*j+1];
			  goon = true;
                          if (minObj != null) {
                             if (minLen == 1) {
                               if (adouble[0] < tmpMin[0] ||
				   (adouble[0] < tmpMin[0] &&
				    adouble[1] < tmpMin[1] )) {
				   goon = false;
                                   if (filObj != null) {
				     adouble[0] = tmpFil[0];
				     adouble[1] = tmpFil[1];
                                   } else {
				     adouble[0] = adouble[1] = 0.0;
				   }
                               }
                             } else {
			       if (((double [])minObj).length > j) {
                                 if (adouble[0] < ((double [])minObj)[2*j] ||
				     (adouble[0] == ((double [])minObj)[2*j] &&
				      adouble[1] < ((double [])minObj)[2*j+1] )) {
				   goon = false;
                                   if (filObj != null) {
				     adouble[0] = tmpFil[0];
				     adouble[1] = tmpFil[1];
                                   } else {
				     adouble[0] = adouble[1] = 0.0;
				   }
				 }
                               }
			     }
                          }
                          if (goon && maxObj != null) {
                             if (maxLen == 1) {
                               if (adouble[0] > tmpMax[0] ||
				   (adouble[0] == tmpMax[0] &&
				    adouble[1] > tmpMax[1] )) {
                                   if (filObj != null) {
				     adouble[0] = tmpFil[0];
				     adouble[1] = tmpFil[1];
                                   } else {
				     adouble[0] = adouble[1] = 0.0;
				   }
                               }
                             } else {
			       if (((double [])maxObj).length > j) {
                                 if (adouble[0] > ((double [])maxObj)[2*j] ||
				     (adouble[0] == ((double [])maxObj)[2*j] &&
				      adouble[1] > ((double [])maxObj)[2*j+1] )) {
                                   if (filObj != null) {
				     adouble[0] = tmpFil[0];
				     adouble[1] = tmpFil[1];
                                   } else {
				     adouble[0] = adouble[1] = 0.0;
				   }
				 }
                               }
			     }
                          }
                          String epoch = null;
                          if (myCDFExport.epoch == 0) 
			    epoch = Epoch16.encode(adouble);
                          else if (myCDFExport.epoch == 1) 
			    epoch = Epoch16.encode1(adouble);
                          else if (myCDFExport.epoch == 2) 
			    epoch = Epoch16.encode2(adouble);
                          else if (myCDFExport.epoch == 3) 
			    epoch = Epoch16.encode3(adouble);
                          else if (myCDFExport.epoch == 5) {
			    try {
                               String formatString = (String) var.getEntryData("FORMAT");
                               if (formatString == null || formatString.trim().length() == 0) 
                                 epoch = Epoch16.encode(adouble);
                               else
                                 epoch = Epoch16.encodex(adouble, formatString);
			    } catch (CDFException es) {
			      epoch = Epoch16.encode(adouble);
			    }	
                            recordObject[inGroup][row][atColumn] = epoch;
			  }
                        }
                    }
		}
                n += boundary[nDims - 2];
            }
	}
	 return _dataArray;
    }

/** Used to determine the boundaries
  */

    private long product(long [] array, int start, int stop) {

        long product = 1;
        for (int i = start; i < stop; i++)
            if (array[i] > 1) product *= array[i];

        return product;
    }

/** Create selection buttons at the bottom of panel
 */

    private void createButton(JPanel jp) {

      if (enterButton == null) {
        enterButton = new JButton(ENTER);
	backButton = new JButton(BACK);
        cancelButton = new JButton(CANCEL);
        buttonPanel = new JPanel(true);

	buttonPanel.add(enterButton);
	buttonPanel.add(Box.createRigidArea(new Dimension(30,1)));
	buttonPanel.add(backButton);
	buttonPanel.add(Box.createRigidArea(new Dimension(30,1)));
	buttonPanel.add(cancelButton);
	buttonPanel.add(Box.createRigidArea(new Dimension(30,1)));

	aSelection = new SelectionListener();
	enterButton.addActionListener(aSelection);
        backButton.addActionListener(aSelection);
        cancelButton.addActionListener(aSelection);

        enterButton.setToolTipText("Continue to the next page...");
	backButton.setToolTipText("Back to the previous page...");
        cancelButton.setToolTipText("Stop and retrun...");
	jp.add(buttonPanel, BorderLayout.SOUTH);
      }
//      jp.add(buttonPanel, BorderLayout.SOUTH);

    }

/**
 * Process button events.
 */

    class SelectionListener implements ActionListener {

        public void actionPerformed(ActionEvent event) {
          Object source = event.getSource();

          if (source instanceof JButton) {
            String action = event.getActionCommand();

            if (action.equals(CANCEL)) {              // Cancel the operation
                exportToText.setVisible(false);
		aToScreenTable = null;
		center.removeAll();
		if (jtp != null && jtp.getTabCount() > 0) {
		  for (int i=jtp.getTabCount()-1; i > -1; i--) {
		    jtp.removeTabAt(i);
		    scrollPane[i] = null;
		  }
		}
		scrollPane = null;
		mainPanel.removeAll();
		recordObject = null;
		if (myCDFExport.MacOS) System.gc();
		myCDFExport.setVisible(true);
            } else if (action.equals(ENTER)) {        // Continue to the next page
		boolean nextPage = false;
		if (myCDFExport.orientation == 0) {
		  if ((elementNum + ROWS) < (totalWritten+1) * totalElementsPerRec) 
			nextPage = true;
		} else {
		  if ((elementNum + ROWS) < (totalWritten + 1)) nextPage = true;
		}
		if (nextPage) {
		  cleanTableObjects();
		  elementNum += ROWS;
		  fillVarRecsToTable(elementNum);
	          displayTable(mainPanel);
		}
            } else if (action.equals(BACK)) {        // Back to the previous page
		int pageNum;
		if (myCDFExport.orientation == 0) 
		  pageNum = elementNum / ROWS;
                else
                  pageNum = elementNum;
		if (pageNum != 0 || elementNum != 0) {
		  cleanTableObjects();
		  elementNum -= ROWS;
		  if (elementNum < 0) elementNum = 0;
		  fillVarRecsToTable(elementNum);
	          displayTable(mainPanel);
		}
	    }
          }
        }
   }

/**
 * Process text field event as a new page or record number is entered.
 */

    class PageRecListener implements ActionListener {

        public void actionPerformed(ActionEvent event) {
          Object source = event.getSource();

            if (source.equals(pageField)) {           // a page number is entered
		int tmp;
		int pageNum = elementNum / ROWS + 1;
		try {
		  tmp = Integer.parseInt(pageField.getText());
		  if (tmp < 1 || tmp > lastPageToDisplay+1) {
		    pageField.setText(""+pageNum);
		    Toolkit.getDefaultToolkit().beep();
		  } else {
		    if (myCDFExport.orientation == 0) 
		      elementNum = (tmp - 1) * ROWS;
		    else
		      elementNum = tmp - 1;
		    cleanTableObjects();
		    fillVarRecsToTable(elementNum);
		    displayTable(mainPanel);		    
		  }
		} catch (Exception ex) {
		  pageField.setText(""+pageNum);
		  Toolkit.getDefaultToolkit().beep();
		}
            } else if (source.equals(recordField)) {  // a record number is entered 
                int tmp;
		int recordNum = elementNum / totalElementsPerRec + 1;
                try {
                  tmp = Integer.parseInt(recordField.getText());
                  if (tmp < 1 || tmp > totalWritten+1) {
                    recordField.setText(""+recordNum);
                    Toolkit.getDefaultToolkit().beep();
                  } else {
		    if (myCDFExport.orientation == 0) 
                      elementNum = (tmp - 1) * totalElementsPerRec;
		    else 
		      elementNum = tmp - 1;
		    cleanTableObjects();
                    fillVarRecsToTable(elementNum);
                    displayTable(mainPanel);
                  }
                } catch (Exception ex) {
                  recordField.setText(""+recordNum);
                  Toolkit.getDefaultToolkit().beep();
                }
            }
        }
   }

/**
 * Clean the contents of the record object.
 */

    void cleanTableObjects() {

        for (int i = 0; i < groups; i++)
	  for (int j = 0; j < ROWS; j++)
	    for (int k = 0; k < totalColumns; k++)
		recordObject[i][j][k] = " ";

    }

/**
 * Clean the contents of the table columns.
 */

    void cleanColumns() {

        for (int i = 0; i < groups; i++)
           for (int j = 0; j < totalColumns; j++)
              columnNames[i][j] = " ";

    }

/**
 * Output the matadata - global attributes.
 */

    void metaToFile(BufferedWriter pout) {

        Vector ga = myCDFExport.sourceCDF.getGlobalAttributes();
	Attribute a;

	try {
	  pout.write("Global Attributes:"); pout.newLine(); pout.newLine();
          for (Enumeration e = ga.elements() ; e.hasMoreElements() ;) {
            a = (Attribute) e.nextElement();
	    pout.write("  "+a.getName()); pout.newLine();
            Vector ent = a.getEntries();
            for (Enumeration e1 = ent.elements(); e1.hasMoreElements();) {
                Entry entry = (Entry) e1.nextElement();
                if (entry != null) {
		  long dt = entry.getDataType();
		  int kk = 0;
		  if (dt == CDF_EPOCH) kk = 1;
		  else if (dt == CDF_EPOCH16) kk = 2;
                  pout.write("    \""+CDFUtils.getStringData(entry.getData()," ",kk)+"\" "); 
		  pout.newLine();
		}
            }
	    pout.newLine();
          }
	} catch (IOException e) {
	  System.err.println("error writing meta data");
	}
    }

/**
 * A thread to write output data to file.
 */

   class OutToFile extends Thread {

	public void run() {
	  try {
	    FileWriter fout = new FileWriter(myCDFExport.cdfspec2);
	    BufferedWriter pout = new BufferedWriter(fout, 8192);

            Vector ga = myCDFExport.sourceCDF.getGlobalAttributes();
            int gaItems;
	    if (myCDFExport.headings == 1) gaItems = (ga == null ? 0 : ga.size());
	    else gaItems = 0;
            totalItems = (lastPageToDisplay + 1) * ROWS * groups * totalColumns +
                          groups * totalColumns + gaItems;


	    progressPanel = new BuildProgressPanel(exportToText, totalItems);

	    int varno = 0;
	    int vaWidth;
	    StringBuffer line = new StringBuffer("");
	    int inHor = 0;
	    int backWidth = 0;

	    if (myCDFExport.headings == 1) {

	      metaToFile(pout);

	      if (vars.size() > 0) {

	        pout.write("Variables:");
	        pout.newLine(); pout.newLine();

	        currentProgressValue = gaItems;
                new UpdateProgress(exportToText, currentProgressValue).start();
	      }
 
	      // headings
              for (int i = 0; i < groups; i++) {
                for (int j = 0; j < totalColumns; j++) {
                  if (i > 0 && j < istart) continue;
		  if (myCDFExport.orientation == 0) {
                    if (columnNames[i][j].equals(null) ||
                       ((String)columnNames[i][j]).trim().length() == 0) break;
		  } else
//		    if (inHor == varsHor.size()) break;
		    if (inHor == totalElements) break;
		  if (columnNames[i][j].equals(headcol1)) 
		    line = CDFToolUtils.CatToString(line, "Record", 6, 1, "*");
		  else if (columnNames[i][j].equals(headcol2))
		    line = CDFToolUtils.CatToString(line, "Indices", 11, 1, "*");
		  else {
		    if (myCDFExport.orientation == 0) vaWidth = varWidth[varno++];
		    else {
			boolean newstart = false;
//			if (!((String)varsHor.elementAt(inHor++)).equals(" ")) {
			for (int ll = 0; ll < vars.size(); ll++) {
			  if (inHor == varsHor[ll]) {
			    newstart = true;
			    break;
			  } else {
			    if (inHor < varsHor[ll]) break;
			  }
			}
			inHor++;
			if (newstart) {
			  // a new var starts
			  vaWidth = varWidth[varno++];
			  backWidth = vaWidth;
			} else
			  vaWidth = backWidth;
		    }
		    line = CDFToolUtils.CatToString(line,(String)columnNames[i][j], 
                                                  vaWidth, 2, "*");
		  }
		  line.append(" ");
                }
	        currentProgressValue += totalColumns;
	      }
	      pout.write(line.toString());
	      pout.newLine();
	      new UpdateProgress(exportToText, currentProgressValue).start();
	    }

            if (vars.size() > 0) {

	      StringBuffer aTemp = new StringBuffer();
	      boolean aStr, backStr = false;
	      // data
	      for (int pageNum = 0; pageNum <= lastPageToDisplay; pageNum++) {
		progressPanel.getProgressLabel().setText("Load data! Please Wait...");
		elementNum = pageNum * ROWS;
	        fillVarRecsToTable(elementNum);
		progressPanel.getProgressLabel().setText("Output data! Please Wait...");
	        for (int i = 0; i < ROWS; i++) {
		  varno = 0;
		  inHor = 0;
		  line.setLength(0);
	          for (int j = 0; j < groups; j++) {
		    for (int k = 0; k < totalColumns; k++) {
	            	if (j == 0 || k >= istart) {
			  if (myCDFExport.orientation == 0) {
                	    if (columnNames[j][k].equals(null) || 
                    	        ((String)columnNames[j][k]).trim().length() == 0) break;
			  } else
//			    if (inHor == varsHor.size()) break;
			    if (inHor == totalElements) break;
			  aTemp.setLength(0);
			  if (columnNames[j][k].equals(headcol1)) {
			    aTemp.append((String)recordObject[j][i][k]);
			    aTemp = CDFToolUtils.Justify(aTemp, -6);
			  } else if (columnNames[j][k].equals(headcol2)) {
			    aTemp.append((String)recordObject[j][i][k]);
			    aTemp = CDFToolUtils.Justify(aTemp, -11);
			  } else {
			    aStr = false;
			    if (myCDFExport.orientation == 0) { // vertical display
			      vaWidth = varWidth[varno];
			      if (varDataType[varno] == CDF_CHAR || 
				  varDataType[varno] == CDF_UCHAR) {
				aStr = true;
			        vaWidth = vaWidth - 2;
			      } 
			      varno++;
			    } else {
                              boolean newstart = false;
                              for (int ll = 0; ll < vars.size(); ll++) {
                                if (inHor == varsHor[ll]) {
                                  newstart = true;
                                  break;
                                } else {
                                  if (inHor < varsHor[ll]) break;
                                }
                              }
                              inHor++;
                              if (newstart) {
//			      if (!((String)varsHor.elementAt(inHor++)).equals(" ")) {
				// a new var starts
                                vaWidth = varWidth[varno];
				if (varDataType[varno] == CDF_CHAR ||
				    varDataType[varno] == CDF_UCHAR) {
				  aStr = true;
				  vaWidth = vaWidth - 2;
				} 
				backWidth = vaWidth;
				backStr = aStr;
				varno++;
			      } else
				vaWidth = backWidth;
				aStr = backStr;
			    }
			    aTemp = CDFToolUtils.CatToString(aTemp, 
							   (String)recordObject[j][i][k].toString(), 
							   vaWidth, 2, "*"); 
			    if (aStr) {
			      if (aTemp != null && aTemp.toString().trim().length() != 0 ) {
			        if (aTemp.toString().trim().length() == vaWidth || 
				    aTemp.charAt(0) != ' ') { 
				  aTemp.insert(0, '"');
				  aTemp.append('"');
			        } else {
				  String aTempStr = aTemp.toString().trim();
				  int idx = aTemp.toString().indexOf(aTempStr);
				  aTemp.insert(idx, '"');
				  aTemp.insert(idx+aTempStr.length()+1, '"');
			        }
			      } else
				aTemp.append("  ");			  
			    }
			  }
			  line.append(aTemp).append(" ");
			}

		    }
		    currentProgressValue += totalColumns;
		  }
		  if (line.toString().trim().length() == 0) break;
		  pout.write(line.toString());
		  pout.newLine();
		  if (lastPageToDisplay == 0 ) 
		    new UpdateProgress(exportToText, currentProgressValue).start();

	        }

	        if (lastPageToDisplay != 0 ) 
		  new UpdateProgress(exportToText, currentProgressValue).start();
	        cleanTableObjects();
	      }
	    }
	    pout.close();
	    myCDFExport.info.append("Done!");
	    new CleanProgress().start();

	  } catch (IOException e) {
	    System.err.println("** error writing output to file");
	  }
	}
    }

    protected BuildProgressPanel getProgressPanel() {
	return progressPanel;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == KeyEvent.VK_UP) { // Up key
          if (focusedObj == pageField) 
            enterButton.doClick();
	  else {
            int tmp = Integer.parseInt(recordField.getText());
	    tmp++;
            int recordNum = elementNum / totalElementsPerRec + 1;
            if (tmp < 1 || tmp > totalWritten+1) {
               recordField.setText(""+recordNum);
               Toolkit.getDefaultToolkit().beep();
            } else {
               if (myCDFExport.orientation == 0)
                 elementNum = (tmp - 1) * totalElementsPerRec;
               else
                 elementNum = tmp - 1;
	       recordField.setText(""+tmp);
               cleanTableObjects();
               fillVarRecsToTable(elementNum);
               displayTable(mainPanel);
            }
	  }
        } else if (keyCode == KeyEvent.VK_DOWN) { // Down key
          if (focusedObj == pageField) 
            backButton.doClick();
	  else {
            int tmp = Integer.parseInt(recordField.getText());
            tmp--;
            int recordNum = elementNum / totalElementsPerRec + 1;
            if (tmp < 1 || tmp > totalWritten+1) { 
               recordField.setText(""+recordNum);
               Toolkit.getDefaultToolkit().beep();
            } else {
               if (myCDFExport.orientation == 0)
                 elementNum = (tmp - 1) * totalElementsPerRec;
               else
                 elementNum = tmp - 1;
               recordField.setText(""+tmp);
               cleanTableObjects();
               fillVarRecsToTable(elementNum);
               displayTable(mainPanel);
            }
          }
        }

    }

    public void keyReleased(KeyEvent e) {

    }

    public void keyTyped(KeyEvent e) {

    }

    public void focusGained(FocusEvent e) {
        focusedObj = e.getSource();
          boolean nomore = false;
          if (focusedObj == pageField) {
            pageField.setNextFocusableComponent(recordField);
          } else if (focusedObj == recordField) {
            recordField.setNextFocusableComponent(pageField);
          }
    }

    public void focusLost(FocusEvent e) {

    }
/*
    public boolean isFocusCycleRoot() {
        return true;

    }
*/
    public boolean isManagingFocus() {
        return true;
    }
/*
    protected JFrame getTableDialog() {
	return exportToText;
    }
*/
/**
 * Create a thread to dispose the progress panel so that other threads which were
 * used to update the progress bar could finish before this thread can start.
 */

    class CleanProgress extends Thread {

        public void run() {
          progressPanel.dispose();
          progressPanel = null;
	  if (myCDFExport.MacOS) System.gc();
        }
    };

}
