//$Id: EntryEvent.java,v 1.1.1.1 2008/08/26 14:05:15 liu Exp $

import java.awt.AWTEvent;
import java.awt.Event;

import gsfc.nssdc.cdf.*;

/**
 * Event to handle a changes to entries.
 *
 * Currently only used by AttributeComboBox to handle entry creation 
 * events. However, the hooks are present to handle various entry events.
 *
 * @author Phil Williams
 * @version $Revision: 1.1.1.1 $
 */
public class EntryEvent extends AWTEvent {

    static final long serialVersionUID = 1L;

    public static final int CREATED = 
	RESERVED_ID_MAX + 10;

    public static final int DELETED = 
	RESERVED_ID_MAX + 20;

    public static final int NAME_CHANGE = 
	RESERVED_ID_MAX + 30;

    public static final int DATATYPE_CHANGE = 
	RESERVED_ID_MAX + 40;

    /**
     * The entry on which the change occured
     */
    private Entry _entry;
    
    /**
     * Get the value of _entry.
     * @return Value of _entry.
     */
    public Entry getEntry() {return _entry;}
    
    public EntryEvent(Object source, Entry entry, int id) {
	super(source, id);
	this._entry = entry;
    }
}
