/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class VariableSpecPanel
extends JLabeledPanel
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private JLabeledTF datatype;
    private JLabeledTF recvary;
    private JLabeledTF ndim;
    private JLabeledTF maxRecN;
    private JLabeledTF maxRecA;
    private JLabeledTF compression;
    private JLabeledTF sparse;
    private JLabeledTF blocking;
    private JLabeledTF pad;
    private JLabeledPanel sizePanel;
    private WholeNumberField[] sizes;
    private Font padCurrFont;
    private Font numRecWtCurrFont;
    private Font numRecAlCurrFont;

    public void reset() {
        this.datatype.set("");
        this.recvary.set("");
        this.ndim.set("");
        this.maxRecN.set("");
        this.maxRecA.set("");
        this.compression.set("");
        this.blocking.set("");
        this.sparse.set("");
        this.pad.set("");
    }

    public void set(Variable variable) {
        long l;
        long l2;
        long l3;
        Object object;
        Object object2;
        long l4;
        long l5;
        this.setBorder(new TitledBorder(new EtchedBorder(), "Variable: " + variable.getName()));
        try {
            l5 = variable.getMaxWrittenRecord() + 1L;
        }
        catch (CDFException cDFException) {
            l5 = 0L;
        }
        try {
            l4 = variable.getNumWrittenRecords();
        }
        catch (CDFException cDFException) {
            l4 = 0L;
        }
        this.maxRecN.set("#: " + l4 + " /Max #: " + l5);
        if (((String)this.maxRecN.get()).length() >= 11) {
            this.maxRecN.textField.setFont(new Font(this.numRecWtCurrFont.getName(), this.numRecWtCurrFont.getStyle(), this.numRecWtCurrFont.getSize() - 1));
        } else {
            this.maxRecN.textField.setFont(this.numRecWtCurrFont);
        }
        String string = CDFUtils.getStringDataType((Variable)variable);
        string = string + '/' + variable.getNumElements();
        this.datatype.set(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(variable.getRecVariance() ? "T/" : "F/");
        long l6 = variable.getNumDims();
        if (l6 != 0L) {
            object2 = variable.getDimVariances();
            int n = 0;
            while (n < (int)l6) {
                stringBuffer.append(object2[n] == 0L ? "F" : "T");
                ++n;
            }
        }
        this.recvary.set(stringBuffer.toString());
        object2 = new StringBuffer();
        ((StringBuffer)object2).append("" + l6 + ':');
        ((StringBuffer)object2).append("[");
        if (l6 != 0L) {
            long[] lArray = variable.getDimSizes();
            int n = 0;
            while (n < (int)l6) {
                ((StringBuffer)object2).append("" + lArray[n]);
                if (n != (int)l6 - 1) {
                    ((StringBuffer)object2).append(",");
                }
                ++n;
            }
        }
        ((StringBuffer)object2).append("]");
        this.ndim.set(((StringBuffer)object2).toString());
        try {
            object = variable.getCompression();
            this.compression.set(object);
        }
        catch (CDFException cDFException) {
            this.compression.set("None");
        }
        object = null;
        try {
            if (variable.checkPadValueExistence()) {
                object = variable.getPadValue();
            }
        }
        catch (CDFException cDFException) {}
        long l7 = variable.getDataType();
        if (object == null) {
            String string2 = "";
        } else if (l7 != 31L && l7 != 32L) {
            String string3 = object.toString();
            this.pad.set(string3);
            if (((String)this.pad.get()).length() >= 15) {
                this.pad.textField.setFont(new Font(this.padCurrFont.getName(), this.padCurrFont.getStyle(), this.padCurrFont.getSize() - 3));
            } else {
                this.pad.textField.setFont(this.padCurrFont);
            }
        } else if (l7 == 31L) {
            String string4 = Epoch.encode((double)((Double)object));
            this.pad.set(string4);
            this.pad.textField.setFont(new Font(this.padCurrFont.getName(), this.padCurrFont.getStyle(), this.padCurrFont.getSize() - 3));
        } else {
            String string5 = Epoch16.encode((Object)((double[])object));
            this.pad.set(string5);
            this.pad.textField.setFont(new Font(this.padCurrFont.getName(), this.padCurrFont.getStyle(), this.padCurrFont.getSize() - 5));
        }
        try {
            l3 = variable.getBlockingFactor();
        }
        catch (CDFException cDFException) {
            l3 = 0L;
        }
        this.blocking.set("" + l3);
        long l8 = variable.getSparseRecords();
        this.sparse.set(CDFUtils.getStringSparseRecord((long)l8));
        try {
            l2 = variable.getNumAllocatedRecords();
        }
        catch (CDFException cDFException) {
            l2 = 0L;
        }
        try {
            l = variable.getMaxAllocatedRecord() + 1L;
        }
        catch (CDFException cDFException) {
            l = 0L;
        }
        this.maxRecA.set("#: " + l2 + " /Max #: " + l);
        if (((String)this.maxRecA.get()).length() >= 11) {
            this.maxRecA.textField.setFont(new Font(this.numRecAlCurrFont.getName(), this.numRecAlCurrFont.getStyle(), this.numRecAlCurrFont.getSize() - 1));
        } else {
            this.maxRecA.textField.setFont(this.numRecAlCurrFont);
        }
    }

    public VariableSpecPanel() {
        super("Variable Specifications", new GridLayout(2, 5));
        this.setSize(670, 70);
        this.datatype = new JLabeledTF("Data Type", 12);
        this.datatype.textField.setEditable(false);
        this.datatype.textField.setOpaque(false);
        this.datatype.textField.setHorizontalAlignment(2);
        this.datatype.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.recvary = new JLabeledTF("Variances", 4);
        this.recvary.textField.setEditable(false);
        this.recvary.textField.setOpaque(false);
        this.recvary.textField.setHorizontalAlignment(2);
        this.recvary.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.ndim = new JLabeledTF("Dimensions", 3);
        this.ndim.textField.setEditable(false);
        this.ndim.textField.setOpaque(false);
        this.ndim.textField.setHorizontalAlignment(2);
        this.ndim.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.maxRecN = new JLabeledTF("Rec Written", 10);
        this.maxRecN.textField.setEditable(false);
        this.maxRecN.textField.setOpaque(false);
        this.maxRecN.textField.setHorizontalAlignment(2);
        this.maxRecN.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.numRecWtCurrFont = this.maxRecN.getFont();
        this.maxRecA = new JLabeledTF("Rec Allocated", 10);
        this.maxRecA.textField.setEditable(false);
        this.maxRecA.textField.setOpaque(false);
        this.maxRecA.textField.setHorizontalAlignment(2);
        this.maxRecA.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.numRecAlCurrFont = this.maxRecA.getFont();
        this.blocking = new JLabeledTF("Blocking", 7);
        this.blocking.textField.setEditable(false);
        this.blocking.textField.setOpaque(false);
        this.blocking.textField.setHorizontalAlignment(2);
        this.blocking.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.pad = new JLabeledTF("Pad Value", 7);
        this.pad.textField.setEditable(false);
        this.pad.textField.setOpaque(false);
        this.pad.textField.setHorizontalAlignment(2);
        this.pad.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.padCurrFont = this.pad.getFont();
        this.sparse = new JLabeledTF("Rec Sparseness", 7);
        this.sparse.textField.setEditable(false);
        this.sparse.textField.setOpaque(false);
        this.sparse.textField.setHorizontalAlignment(2);
        this.sparse.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.compression = new JLabeledTF("Compression", 10);
        this.compression.textField.setEditable(false);
        this.compression.textField.setOpaque(false);
        this.compression.textField.setHorizontalAlignment(2);
        this.compression.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(this.datatype);
        this.add(this.recvary);
        this.add(this.ndim);
        this.add(this.pad);
        this.add(this.blocking);
        this.add(this.maxRecN);
        this.add(this.maxRecA);
        this.add(this.sparse);
        this.add(this.compression);
    }
}

