/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.Entry;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class NewEntryAction
extends AbstractAction
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "New Entry";
    private MYEditor myEditor;
    private EditAttrEntryPanel myPanel;
    private long scope;

    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        this.myPanel.getEntryMenu().setPopupMenuVisible(false);
        if (this.myEditor.theCDF == null) {
            JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "Must open a CDF before creating attribute entries.", "MYEditor: Error", 0);
        } else {
            char c = this.scope == 1L ? (char)'g' : 'v';
            Entry entry = NewEntryDialog.createEntry(this.myPanel, "Create " + c + "AttrEntry for " + this.myPanel.getSelectedAttr());
            if (entry != null) {
                this.myPanel.getAttrScrollBar().getModel().removeChangeListener(this.myPanel.getScrollBarSync());
                if (this.scope == 1L) {
                    this.myEditor.gAttrPanel.updateAttrPanel(this.myPanel.getSelectedAttr(), true);
                    this.myEditor.gAttrPanel.reselectCurrentAttribute();
                } else {
                    this.myEditor.vAttrPanel.updateAttrPanel(this.myPanel.getSelectedAttr(), false);
                    this.myEditor.vAttrPanel.reselectCurrentAttribute();
                }
                this.myPanel.addToListOfEntries(entry);
                this.myPanel.updateAttrEntryPanel(entry, true);
                this.myPanel.getAttrScrollBar().getModel().addChangeListener(this.myPanel.getScrollBarSync());
                this.myPanel.reselectCurrentEntry();
            }
        }
        this.myEditor.setDefaultCursor();
    }

    public NewEntryAction(EditAttrEntryPanel editAttrEntryPanel) {
        this(editAttrEntryPanel, DEFAULT_NAME);
    }

    public NewEntryAction(EditAttrEntryPanel editAttrEntryPanel, String string) {
        super(string);
        this.myPanel = editAttrEntryPanel;
        this.myEditor = editAttrEntryPanel.getMyEditor();
        this.scope = editAttrEntryPanel.getScope();
    }
}

