/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CDFDialog
extends JDialog
implements ActionListener,
CDFConstants {
    static final long serialVersionUID = 1L;
    private static final String UPDATE = "Update";
    private static final String END = "End";
    private static final String CANCEL = "Reset";
    private String name;
    private JButton enter;
    private JButton cancel;
    private JButton end;
    private JLabeledTF jtfcl;
    private JTextField tfcl;
    private JLabeledCB cbcp;
    private JLabeledCB cben;
    private JLabeledCB cbma;
    private JLabeledCB cbfo;
    private JLabeledCB cbcs;
    private JFrame myFrame;
    private boolean enChanged;
    private boolean maChanged;
    private boolean foChanged;
    private boolean csChanged;
    private long compression;
    private long complevel;
    private long encoding;
    private long majority;
    private long format;
    private long checksum;
    private CDF cdf;

    private final void createButtonPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.enter = new JButton(UPDATE);
        this.enter.addActionListener(this);
        this.enter.setToolTipText("Update the CDF specification");
        jPanel2.add(this.enter);
        this.cancel = new JButton(CANCEL);
        this.cancel.addActionListener(this);
        this.cancel.setToolTipText("Reset fields back to their last values");
        jPanel2.add(this.cancel);
        this.end = new JButton(END);
        this.end.addActionListener(this);
        this.end.setToolTipText("End editing");
        jPanel2.add(this.end);
        jPanel.add((Component)jPanel2, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CANCEL)) {
                this.reset();
            } else if (string.equals(END)) {
                this.setVisible(false);
                this.enter.removeActionListener(this);
                this.cancel.removeActionListener(this);
                this.end.removeActionListener(this);
                this.dispose();
                System.gc();
            } else if (string.equals(UPDATE)) {
                ((JButton)object).setEnabled(false);
                long l = -1;
                long[] lArray = new long[1];
                l = this.cbcp.getIndex();
                if (l == (long)4) {
                    ++l;
                }
                try {
                    if (l != this.compression) {
                        if (l == (long)5) {
                            lArray[0] = Long.parseLong((String)this.jtfcl.get());
                            if (lArray[0] > 0L && lArray[0] < 10L) {
                                this.cdf.setCompression(l, lArray);
                                this.compression = l;
                                this.complevel = lArray[0];
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(this.myFrame, "GZIP compression level: has to be between 1 and 9", "CDFEdit: CDFException", 0);
                            }
                        } else {
                            this.cdf.setCompression(l, lArray);
                            this.compression = l;
                            this.complevel = lArray[0];
                        }
                    } else if (l == (long)5) {
                        lArray[0] = Long.parseLong((String)this.jtfcl.get());
                        if (lArray[0] != this.complevel) {
                            if (lArray[0] > 0L && lArray[0] < 10L) {
                                this.cdf.setCompression(l, lArray);
                                this.compression = l;
                                this.complevel = lArray[0];
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(this.myFrame, "GZIP compression level: has to be between 1 and 9", "CDFEdit: CDFException", 0);
                            }
                        }
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Compression Error!", 0);
                }
                if (this.enChanged) {
                    this.enChanged = false;
                    l = (long)this.cben.getIndex() + 1L;
                    if (l > 9L) {
                        ++l;
                    }
                    if (l != this.encoding) {
                        try {
                            this.cdf.setEncoding(l);
                            this.encoding = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Encoding Error!", 0);
                        }
                    }
                }
                if (this.maChanged) {
                    this.maChanged = false;
                    l = (long)this.cbma.getIndex() + 1L;
                    if (l != this.majority) {
                        try {
                            this.cdf.setMajority(l);
                            this.majority = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Majority Error!", 0);
                        }
                    }
                }
                if (this.foChanged) {
                    this.foChanged = false;
                    l = (long)this.cbfo.getIndex() + 1L;
                    if (l == (long)2) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this.myFrame, "Multi_file format is not supported yet!", "CDFEdit: Format Error!", 2);
                    } else {
                        try {
                            this.cdf.setFormat(l);
                            this.format = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Format Error!", 0);
                        }
                    }
                }
                if (this.csChanged) {
                    this.csChanged = false;
                    l = this.cbcs.getIndex();
                    if (l != this.checksum) {
                        try {
                            this.cdf.setChecksum(l);
                            this.checksum = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Checksum Error!", 0);
                        }
                    }
                }
                ((JButton)object).setEnabled(true);
            }
        } else if (object instanceof JTextField) {
            long l;
            long l2 = this.cbcp.getIndex();
            if (l2 > (long)3) {
                ++l2;
            }
            if (l2 == (long)5 && ((l = Long.parseLong((String)this.jtfcl.get())) < 1L || l > 9L)) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, "GZIP compression level: has to be between 1 and 9", "CDFEdit: CDFException", 0);
            }
        }
    }

    public void reset() {
        this.enChanged = false;
        this.maChanged = false;
        this.foChanged = false;
        this.csChanged = false;
        this.compression = this.cdf.getCompressionType();
        if (this.compression == (long)5) {
            long[] lArray = this.cdf.getCompressionParms();
            this.complevel = lArray[0];
        }
        this.encoding = this.cdf.getEncoding();
        this.format = this.cdf.getFormat();
        this.majority = this.cdf.getMajority();
        this.checksum = this.cdf.getChecksum();
        int n = (int)this.compression;
        if (n > 3) {
            --n;
        }
        this.cbcp.setIndex(n);
        if (this.compression == (long)5) {
            this.jtfcl.set("" + this.complevel);
            this.tfcl.setVisible(true);
            this.jtfcl.setEnabled(true);
            this.jtfcl.setEditable(true);
        } else {
            this.tfcl.setVisible(true);
            this.jtfcl.setEnabled(true);
            this.jtfcl.setEditable(false);
            if (this.compression == 0L) {
                this.jtfcl.set("");
            } else {
                this.jtfcl.set("0");
            }
        }
        n = (int)this.encoding - 1;
        if ((long)n > 9L) {
            --n;
        }
        this.cben.setIndex(n);
        n = (int)this.majority - 1;
        this.cbma.setIndex(n);
        n = (int)this.format - 1;
        this.cbfo.setIndex(n);
        this.cbcs.setIndex((int)this.checksum);
    }

    static /* synthetic */ boolean access$4(CDFDialog cDFDialog) {
        return cDFDialog.enChanged;
    }

    static /* synthetic */ boolean access$8(CDFDialog cDFDialog) {
        return cDFDialog.maChanged;
    }

    static /* synthetic */ boolean access$12(CDFDialog cDFDialog) {
        return cDFDialog.csChanged;
    }

    private final /* synthetic */ void this() {
        this.enChanged = false;
        this.maChanged = false;
        this.foChanged = false;
        this.csChanged = false;
        this.cdf = null;
    }

    public CDFDialog() {
        this.this();
    }

    public CDFDialog(JFrame jFrame, CDF cDF) {
        super((Frame)jFrame, true);
        this.this();
        this.myFrame = jFrame;
        this.setTitle("Edit Spec for CDF: " + cDF.toString());
        this.cdf = cDF;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setSize(450, 400);
        this.setLocation(10, 20);
        this.setVisible(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Vector<String> vector = new Vector<String>();
        vector.addElement("NETWORK");
        vector.addElement("SUN");
        vector.addElement("VAX");
        vector.addElement("DECSTATION");
        vector.addElement("SGi");
        vector.addElement("IBMPC");
        vector.addElement("IBMRS");
        vector.addElement("HOST");
        vector.addElement("MAC");
        vector.addElement("HP");
        vector.addElement("NeXT");
        vector.addElement("ALPHAOSF1");
        vector.addElement("ALPHAVMSg");
        vector.addElement("ALPHAVMSd");
        vector.addElement("ALPHAVMSi");
        this.cben = new JLabeledCB("Encoding", vector, false, true);
        this.cben.addItemListener(new EncodingListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cben, gridBagConstraints);
        jPanel2.add(this.cben);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("ROW");
        vector2.addElement("COLUMN");
        this.cbma = new JLabeledCB("Majority", vector2, false, true);
        this.cbma.addItemListener(new MajorityListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbma, gridBagConstraints);
        jPanel2.add(this.cbma);
        Vector<String> vector3 = new Vector<String>();
        vector3.addElement("SINGLE");
        vector3.addElement("MULTI");
        this.cbfo = new JLabeledCB("Format", vector3, false, true);
        this.cbfo.addItemListener(new FormatListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbfo, gridBagConstraints);
        jPanel2.add(this.cbfo);
        Vector<String> vector4 = new Vector<String>();
        vector4.addElement("None");
        vector4.addElement("RLE");
        vector4.addElement("HUFF");
        vector4.addElement("AHUFF");
        vector4.addElement("GZIP");
        this.tfcl = new JTextField(1);
        this.cbcp = new JLabeledCB("Compression", vector4, false);
        this.cbcp.addItemListener(new CompressionListener());
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cbcp, gridBagConstraints);
        jPanel2.add(this.cbcp);
        this.jtfcl = new JLabeledTF("Level", this.tfcl, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfcl, gridBagConstraints);
        jPanel2.add(this.jtfcl);
        Vector<String> vector5 = new Vector<String>();
        vector5.addElement("NO");
        vector5.addElement("MD5");
        this.cbcs = new JLabeledCB("Checksum", vector5, false, true);
        this.cbcs.addItemListener(new ChecksumListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbcs, gridBagConstraints);
        jPanel2.add(this.cbcs);
        jPanel.add((Component)jPanel2, "Center");
        this.createButtonPanel(jPanel);
        this.reset();
        this.pack();
        this.setVisible(true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EncodingListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            int n = CDFDialog.this.cben.getIndex() + 1;
            if ((long)n > 9L) {
                ++n;
            }
            if ((long)n != CDFDialog.this.encoding) {
                CDFDialog.this.enChanged = true;
            }
        }

        EncodingListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MajorityListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if ((long)CDFDialog.this.cbma.getIndex() != CDFDialog.this.majority - 1L) {
                CDFDialog.this.maChanged = true;
            }
        }

        MajorityListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FormatListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if ((long)CDFDialog.this.cbfo.getIndex() != CDFDialog.this.format - 1L) {
                CDFDialog.this.csChanged = true;
            }
        }

        FormatListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CompressionListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            int n = CDFDialog.this.cbcp.getIndex();
            if (n == 4) {
                ++n;
            }
            if (n == 5) {
                CDFDialog.this.jtfcl.setVisible(true);
                CDFDialog.this.jtfcl.setEnabled(true);
                CDFDialog.this.jtfcl.setEditable(true);
                CDFDialog.this.jtfcl.set("5");
            } else {
                CDFDialog.this.jtfcl.setVisible(true);
                CDFDialog.this.jtfcl.setEnabled(true);
                CDFDialog.this.jtfcl.setEditable(false);
                if (n == 0) {
                    CDFDialog.this.jtfcl.set("");
                } else {
                    CDFDialog.this.jtfcl.set("0");
                }
            }
        }

        CompressionListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ChecksumListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if ((long)CDFDialog.this.cbcs.getIndex() != CDFDialog.this.checksum - 1L) {
                CDFDialog.this.csChanged = true;
            }
        }

        ChecksumListener() {
        }
    }
}

