import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import gsfc.nssdc.cdf.*;
import gsfc.nssdc.cdf.util.*;

/**
 *  This class create a table dialog for a CDF allowing user to make
 *  selection how the CDF is exported.
 */

public class BuildProgressPanel extends JFrame {

    static final long serialVersionUID = 1L;

    private JFrame aFrame;
    private ExportCreateCDF exportCreateCDF;
    private ExportToText exportToText;
    private int totalItems;

    // Track build progress
    private int currentProgressValue;
    private JLabel progressLabel = null;
    private JProgressBar progressBar = null;


    BuildProgressPanel(Object which, int totalItems) {

	super("Output data");
	aFrame = this;
	this.totalItems = totalItems;

	if (which instanceof ExportCreateCDF) {
	   exportCreateCDF = (ExportCreateCDF) which;
	} else if (which instanceof ExportToText) {
	   exportToText = (ExportToText) which;
	}

        aFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
            }
        });
        int width = 300;
        int height = 100;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width-width)/2;
        int y = (screen.height-height)/2;

        aFrame.setBounds(x, y, width, height);

        aFrame.getContentPane().setLayout(new BorderLayout());
        JOptionPane.setRootFrame(aFrame);

        JPanel progressPanel = new JPanel() {
          static final long serialVersionUID = 1L;
          public Insets getInsets() {
             return new Insets(10, 10, 10, 10);
          }
        };

        progressPanel.setLayout(new BoxLayout(progressPanel, BoxLayout.Y_AXIS));

        Dimension d = new Dimension(400, 20);

        progressLabel = new JLabel("Load and Output data! Please Wait...");
        progressLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
        progressLabel.setMaximumSize(d);
        progressLabel.setPreferredSize(d);

        UIManager.put("ProgressBar.selectionBackground", Color.black);
        UIManager.put("ProgressBar.selectionForeground", Color.white);
        UIManager.put("ProgressBar.foreground", new Color(8, 32, 128));

        progressBar = new JProgressBar(0, totalItems);
        progressBar.setStringPainted(true);
        progressLabel.setLabelFor(progressBar);
        progressBar.setAlignmentX(Component.CENTER_ALIGNMENT);

        progressPanel.add(progressLabel);
        progressPanel.add(Box.createRigidArea(new Dimension(1,20)));
        progressPanel.add(progressBar);
        aFrame.getContentPane().add(progressPanel, BorderLayout.CENTER);

        aFrame.pack();
        aFrame.setVisible(true);
    }

    protected JProgressBar getProgressBar() {
	return progressBar;
    }

    protected JLabel getProgressLabel() {
        return progressLabel;
    }
}
