/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExportCDFTable
extends JDialog
implements CDFConstants {
    private static ExportCDFTable aCDFTable;
    private static Boolean outputT;
    private static Boolean outputF;
    private static String[] headcol;
    private static String[] headfil;
    protected static String headrow1;
    protected static String headrow2;
    protected static String na;
    static boolean defaultModal;
    private static final String ENTER = "Continue";
    private static final String RESET = "Reset";
    private static final String CANCEL = "Cancel";
    private int varNum;
    private Entry[] entries;
    private JFrame myFrame;
    private JPanel mp;
    private JPanel bp;
    private JPanel bpX;
    private CDFSpecPanel cdfspec;
    private JTabbedPane jtp;
    private JCheckBox avc1;
    private JCheckBox avc2;
    private CDFExport myCDFExport;
    private ExportVarListTable aVarListTable;
    private ExportVarFilterTable aVarFilterTable;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JPanel buttonPanel;
    private String fileName;
    private JButton enterButton;
    private JButton cancelButton;
    private JButton resetButton;
    private String[] columnNames1;
    protected String[] columnNames2;
    private Object[][] dataObject;
    private Object[][] filterObject;
    private Object[][] filterInitialObject;
    private Dimension ss;
    protected int numColumns1;
    protected int numRows;
    protected int numColumns2;
    protected Hashtable myHash;
    protected int istart;
    private boolean fromRESET;

    public static ExportCDFTable createCDFTable(JFrame jFrame, CDFExport cDFExport, String string) {
        if (aCDFTable == null) {
            aCDFTable = new ExportCDFTable(jFrame, cDFExport);
            aCDFTable.setDefaultCloseOperation(0);
            aCDFTable.addWindowListener(new WindowAdapter(){

                public final void windowClosing(WindowEvent windowEvent) {
                }
            });
            aCDFTable.getContentPane().setLayout(new BorderLayout());
            ExportCDFTable.aCDFTable.mp = (JPanel)aCDFTable.getContentPane();
            ExportCDFTable.aCDFTable.bp = new JPanel(new BorderLayout(), true);
            ExportCDFTable.aCDFTable.mp.setBorder(new EmptyBorder(10, 10, 10, 10));
            ExportCDFTable.aCDFTable.cdfspec = new CDFSpecPanel();
        } else {
            ExportCDFTable.aCDFTable.mp.removeAll();
        }
        ExportCDFTable.aCDFTable.fileName = string;
        aCDFTable.buildPanel();
        aCDFTable.setSize(aCDFTable.getPreferredSize());
        aCDFTable.pack();
        Dimension dimension = aCDFTable.getSize();
        aCDFTable.setLocation(ExportCDFTable.aCDFTable.ss.width / 2 - dimension.width / 2, ExportCDFTable.aCDFTable.ss.height / 2 - dimension.height / 2);
        aCDFTable.setVisible(true);
        return aCDFTable;
    }

    private final void buildPanel() {
        aCDFTable.setTitle("Variable Selection for CDF: " + this.fileName);
        this.cdfspec.set(this.myCDFExport.sourceCDF);
        this.mp.add((Component)this.cdfspec, "North");
        this.buildDataTable();
        this.aVarListTable = ExportVarListTable.createVarListTable(this.dataObject, this.columnNames1, this.myCDFExport, aCDFTable);
        if (this.scrollPane1 == null) {
            this.scrollPane1 = new JScrollPane(this.aVarListTable.getTable());
        } else {
            this.scrollPane1.setViewportView(this.aVarListTable.getTable());
        }
        if (this.numColumns2 > 0) {
            this.aVarFilterTable = new ExportVarFilterTable(this.myFrame, this.filterObject, this.columnNames2, aCDFTable);
            if (this.jtp == null) {
                this.jtp = new JTabbedPane();
                this.jtp.addChangeListener(new TabChangeListener());
                this.scrollPane2 = new JScrollPane(this.aVarFilterTable.getTable());
            } else {
                this.jtp.removeTabAt(1);
                this.jtp.removeTabAt(0);
                this.scrollPane2.setViewportView(this.aVarFilterTable.getTable());
            }
            this.jtp.addTab("Output", null, this.scrollPane1, "Variable list and description");
            this.jtp.addTab("Filtering", null, this.scrollPane2, "Filtering information");
            this.mp.add((Component)this.jtp, "Center");
        } else {
            this.mp.add((Component)this.scrollPane1, "Center");
        }
        this.createCBUIs(this.bp);
        this.createButtons(this.bp);
        this.mp.add((Component)this.bp, "South");
    }

    public void reEnter() {
        if (this.myCDFExport.getFilterChanged()) {
            this.myCDFExport.setFilterChanged(false);
            this.numColumns2 = 0;
            if (this.myCDFExport.getFiltering() == 1) {
                if (this.myCDFExport.getValidMin() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getValidMax() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getFillVal() == 1) {
                    ++this.numColumns2;
                }
                if (this.numColumns2 > 0) {
                    ++this.numColumns2;
                }
            }
            if (this.numColumns2 > 0) {
                this.setupFiltering();
                this.aVarFilterTable = new ExportVarFilterTable(this.myFrame, this.filterObject, this.columnNames2, aCDFTable);
                if (this.jtp == null) {
                    this.jtp = new JTabbedPane();
                    this.jtp.addChangeListener(new TabChangeListener());
                    this.scrollPane2 = new JScrollPane(this.aVarFilterTable.getTable());
                } else {
                    this.jtp.removeTabAt(1);
                    this.jtp.removeTabAt(0);
                    this.scrollPane2.setViewportView(this.aVarFilterTable.getTable());
                }
                this.jtp.addTab("Output", null, this.scrollPane1, "Variable list and description");
                this.jtp.addTab("Filtering", null, this.scrollPane2, "Filtering information");
                this.mp.removeAll();
                this.mp.add((Component)this.cdfspec, "North");
                this.mp.add((Component)this.jtp, "Center");
                this.mp.add((Component)this.bp, "South");
            } else {
                this.filterObject = null;
                this.filterInitialObject = null;
                this.columnNames2 = null;
                this.aVarFilterTable = null;
                this.mp.removeAll();
                this.mp.add((Component)this.cdfspec, "North");
                this.mp.add((Component)this.scrollPane1, "Center");
                this.mp.add((Component)this.bp, "South");
            }
            aCDFTable.pack();
            aCDFTable.setSize(aCDFTable.getPreferredSize());
            Dimension dimension = aCDFTable.getSize();
            aCDFTable.setLocation((this.ss.width - dimension.width) / 2, (this.ss.height - dimension.height) / 2);
        } else {
            aCDFTable.pack();
            Dimension dimension = aCDFTable.getSize();
            aCDFTable.setLocation((this.ss.width - dimension.width) / 2, (this.ss.height - dimension.height) / 2);
        }
        aCDFTable.toFront();
        aCDFTable.show();
    }

    private final void buildDataTable() {
        this.varNum = this.myCDFExport.vars.size();
        this.numColumns1 = Array.getLength(headcol);
        this.columnNames1 = new String[this.numColumns1];
        this.istart = this.myCDFExport.recordNum + this.myCDFExport.indiceNum;
        this.numRows = this.varNum + this.istart;
        int n = 0;
        while (n < this.numColumns1) {
            this.columnNames1[n] = headcol[n];
            ++n;
        }
        if (this.myCDFExport.getFilterChanged()) {
            this.myCDFExport.setFilterChanged(false);
            this.numColumns2 = 0;
            if (this.myCDFExport.getFiltering() == 1) {
                if (this.myCDFExport.getValidMin() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getValidMax() == 1) {
                    ++this.numColumns2;
                }
                if (this.myCDFExport.getFillVal() == 1) {
                    ++this.numColumns2;
                }
                if (this.numColumns2 > 0) {
                    ++this.numColumns2;
                }
            }
        }
        this.dataObject = new Object[this.numRows][this.numColumns1];
        if (this.myCDFExport.recordNum == 1) {
            this.myHash.put(headrow1, new Integer(0));
            this.dataObject[0][0] = headrow1;
            this.dataObject[0][1] = na;
            this.dataObject[0][2] = na;
            this.dataObject[0][3] = na;
            this.dataObject[0][4] = na;
            this.dataObject[0][5] = this.myCDFExport.outSelection != 3 && this.myCDFExport.outSelection != 4 ? outputT : outputF;
        }
        if (this.myCDFExport.indiceNum == 1) {
            this.myHash.put(headrow2, new Integer(1));
            this.dataObject[this.myCDFExport.recordNum][0] = headrow2;
            this.dataObject[this.myCDFExport.recordNum][1] = na;
            this.dataObject[this.myCDFExport.recordNum][2] = na;
            this.dataObject[this.myCDFExport.recordNum][3] = na;
            this.dataObject[this.myCDFExport.recordNum][4] = na;
            this.dataObject[this.myCDFExport.recordNum][5] = this.myCDFExport.outSelection != 3 && this.myCDFExport.outSelection != 4 ? outputT : outputF;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        String string = "LABL_PTR_";
        Variable variable = null;
        Enumeration enumeration = this.myCDFExport.vars.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            StringBuffer stringBuffer2;
            String string3;
            Object object;
            variable = (Variable)enumeration.nextElement();
            String string4 = variable.getName();
            try {
                object = variable.getEntryData("LABLAXIS");
                string3 = object.toString();
            }
            catch (CDFException cDFException) {
                string3 = null;
            }
            if (string3 == null) {
                stringBuffer2 = new StringBuffer();
                int n3 = 1;
                while (n3 < Integer.MAX_VALUE) {
                    object = string + n3;
                    try {
                        Object object2 = variable.getEntryData((String)object);
                        String string5 = object2.toString();
                        if (n3 > 1) {
                            stringBuffer2.append(" ");
                        }
                        stringBuffer2.append(string5);
                    }
                    catch (CDFException cDFException) {
                        break;
                    }
                    ++n3;
                }
                if (n3 > 1) {
                    string3 = stringBuffer2.toString();
                }
            }
            if (string3 == null) {
                string3 = " ";
            }
            try {
                object = variable.getEntryData("CATDESC");
                string2 = object.toString();
            }
            catch (CDFException cDFException) {
                string2 = " ";
            }
            object = variable.getDimSizes();
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(CDFUtils.getStringDataType(variable.getDataType()));
            stringBuffer2.append("/");
            String string6 = stringBuffer2.append(String.valueOf(variable.getNumElements())).toString();
            long l = variable.getNumDims();
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(l).append(":[");
            int n4 = 0;
            while ((long)n4 < l) {
                if (n4 > 0) {
                    stringBuffer3.append(",");
                }
                stringBuffer3.append((long)object[n4]);
                ++n4;
            }
            String string7 = stringBuffer3.append("]").toString();
            this.myHash.put(string4, new Integer(this.istart + n2));
            this.dataObject[this.istart + n2][0] = string4;
            this.dataObject[this.istart + n2][1] = string3;
            this.dataObject[this.istart + n2][2] = string2;
            this.dataObject[this.istart + n2][3] = string6;
            this.dataObject[this.istart + n2][4] = string7;
            this.dataObject[this.istart + n2][5] = outputT;
            ++n2;
        }
        if (this.numColumns2 > 0) {
            this.setupFiltering();
        }
    }

    private final void setupFiltering() {
        this.filterObject = new Object[this.numRows][this.numColumns2];
        this.filterInitialObject = new Object[this.numRows][this.numColumns2];
        if (this.myCDFExport.recordNum == 1) {
            this.filterObject[0][0] = headrow1;
            this.filterInitialObject[0][0] = headrow1;
        }
        if (this.myCDFExport.indiceNum == 1) {
            this.filterObject[this.myCDFExport.recordNum][0] = headrow2;
            this.filterInitialObject[this.myCDFExport.recordNum][0] = headrow2;
        }
        int n = 1;
        if (this.myCDFExport.getValidMin() == 1) {
            if (this.myCDFExport.recordNum == 1) {
                this.filterObject[0][n] = na;
                this.filterInitialObject[0][n] = na;
            }
            if (this.myCDFExport.indiceNum == 1) {
                this.filterObject[this.myCDFExport.recordNum][n] = na;
                this.filterInitialObject[this.myCDFExport.recordNum][n] = na;
            }
            ++n;
        }
        if (this.myCDFExport.getValidMax() == 1) {
            if (this.myCDFExport.recordNum == 1) {
                this.filterObject[0][n] = na;
                this.filterInitialObject[0][n] = na;
            }
            if (this.myCDFExport.indiceNum == 1) {
                this.filterObject[this.myCDFExport.recordNum][n] = na;
                this.filterInitialObject[this.myCDFExport.recordNum][n] = na;
            }
            ++n;
        }
        if (this.myCDFExport.getFillVal() == 1) {
            if (this.myCDFExport.recordNum == 1) {
                this.filterObject[0][n] = na;
                this.filterInitialObject[0][n] = na;
            }
            if (this.myCDFExport.indiceNum == 1) {
                this.filterObject[this.myCDFExport.recordNum][n] = na;
                this.filterInitialObject[this.myCDFExport.recordNum][n] = na;
            }
        }
        this.columnNames2 = new String[this.numColumns2];
        this.columnNames2[0] = headfil[0];
        n = 1;
        if (this.myCDFExport.getValidMin() == 1) {
            this.columnNames2[n++] = headfil[1];
        }
        if (this.myCDFExport.getValidMax() == 1) {
            this.columnNames2[n++] = headfil[2];
        }
        if (this.myCDFExport.getFillVal() == 1) {
            this.columnNames2[n++] = headfil[3];
        }
        int n2 = 0;
        String string = null;
        Variable variable = null;
        Enumeration enumeration = this.myCDFExport.vars.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            Object object;
            variable = (Variable)enumeration.nextElement();
            string = variable.getName();
            n = 1;
            this.filterObject[this.istart + n2][0] = string;
            if (this.myCDFExport.getValidMin() == 1) {
                try {
                    object = variable.getEntryData("VALIDMIN");
                    string2 = CDFToolUtils.breakdownData(object);
                    this.filterObject[this.istart + n2][n] = string2;
                    this.filterInitialObject[this.istart + n2][n++] = string2;
                }
                catch (CDFException cDFException) {
                    this.filterObject[this.istart + n2][n] = " ";
                    this.filterInitialObject[this.istart + n2][n++] = " ";
                }
            }
            if (this.myCDFExport.getValidMax() == 1) {
                try {
                    object = variable.getEntryData("VALIDMAX");
                    string2 = CDFToolUtils.breakdownData(object);
                    this.filterObject[this.istart + n2][n] = string2;
                    this.filterInitialObject[this.istart + n2][n++] = string2;
                }
                catch (CDFException cDFException) {
                    this.filterObject[this.istart + n2][n] = " ";
                    this.filterInitialObject[this.istart + n2][n++] = " ";
                }
            }
            if (this.myCDFExport.getFillVal() == 1) {
                try {
                    object = variable.getEntryData("FILLVAL");
                    string2 = CDFToolUtils.breakdownData(object);
                    this.filterObject[this.istart + n2][n] = string2;
                    this.filterInitialObject[this.istart + n2][n] = string2;
                }
                catch (CDFException cDFException) {
                    this.filterObject[this.istart + n2][n] = " ";
                    this.filterInitialObject[this.istart + n2][n] = " ";
                }
            }
            ++n2;
        }
    }

    private final void createCBUIs(JPanel jPanel) {
        if (this.avc1 == null) {
            this.avc1 = new JCheckBox("Select all variables", true);
            this.avc2 = new JCheckBox("Deselect all variables", false);
            OptionsListener optionsListener = new OptionsListener();
            this.avc1.addActionListener(optionsListener);
            this.avc1.setToolTipText("Select all variables for export");
            this.avc2.addActionListener(optionsListener);
            this.avc2.setToolTipText("Deselect all variables for export");
            this.bpX = new JPanel(new GridLayout(2, 3), true);
            this.bpX.add(this.avc1);
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            this.bpX.add(this.avc2);
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            this.bpX.add(Box.createRigidArea(new Dimension(60, 1)));
            jPanel.add((Component)this.bpX, "North");
        }
    }

    private final void createButtons(JPanel jPanel) {
        if (this.enterButton == null) {
            this.enterButton = new JButton(ENTER);
            this.resetButton = new JButton(RESET);
            this.cancelButton = new JButton(CANCEL);
            this.buttonPanel = new JPanel(true);
            this.buttonPanel.add(this.enterButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(20, 1)));
            this.buttonPanel.add(this.resetButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(20, 1)));
            this.buttonPanel.add(this.cancelButton);
            SelectionListener selectionListener = new SelectionListener();
            this.enterButton.addActionListener(selectionListener);
            this.resetButton.addActionListener(selectionListener);
            this.cancelButton.addActionListener(selectionListener);
            this.enterButton.setToolTipText("Continue to the next step ...");
            this.resetButton.setToolTipText("Reset the selections to their defaults...");
            this.cancelButton.setToolTipText("Stop but keep the selections and retrun to the previous step...");
            jPanel.add((Component)this.buttonPanel, "South");
        }
    }

    private final void reset() {
        int n = 0;
        while (n < this.numRows) {
            this.dataObject[n][5] = outputT;
            this.aVarListTable.getModel().setValueAt(outputT, n, 5);
            if (this.fromRESET && this.numColumns2 > 0) {
                int n2 = 1;
                while (n2 < this.numColumns2) {
                    this.filterObject[n][n2] = this.filterInitialObject[n][n2];
                    this.aVarFilterTable.getModel().setValueAt(this.filterObject[n][n2], n, n2);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private final void deselect() {
        int n = this.istart;
        while (n < this.numRows) {
            this.dataObject[n][5] = outputF;
            this.aVarListTable.getModel().setValueAt(outputF, n, 5);
            ++n;
        }
    }

    public Object[][] getDataObject() {
        return this.dataObject;
    }

    public Object[][] getFilterObject() {
        return this.filterObject;
    }

    public JCheckBox getSelectAllCB() {
        return this.avc1;
    }

    public JCheckBox getDeSelectAllCB() {
        return this.avc2;
    }

    static /* synthetic */ boolean access$2(ExportCDFTable exportCDFTable) {
        return exportCDFTable.fromRESET;
    }

    static /* synthetic */ String access$6() {
        return CANCEL;
    }

    static /* synthetic */ String access$9() {
        return ENTER;
    }

    static /* synthetic */ String access$12() {
        return RESET;
    }

    private final /* synthetic */ void this() {
        this.columnNames1 = null;
        this.columnNames2 = null;
        this.dataObject = null;
        this.filterObject = null;
        this.filterInitialObject = null;
        this.ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.numColumns1 = 0;
        this.numRows = 0;
        this.numColumns2 = 0;
        this.myHash = new Hashtable();
        this.istart = 0;
    }

    private ExportCDFTable(JFrame jFrame, CDFExport cDFExport) {
        this(jFrame, cDFExport, defaultModal);
    }

    private ExportCDFTable(JFrame jFrame, CDFExport cDFExport, boolean bl) {
        super((Frame)jFrame, bl);
        this.this();
        this.myFrame = jFrame;
        aCDFTable = this;
        this.myCDFExport = cDFExport;
    }

    static {
        outputT = new Boolean(true);
        outputF = new Boolean(false);
        headcol = new String[]{"Item/Variable", "Description", "CATDESC", "DataType", "Dimension", "Output"};
        headfil = new String[]{"Item/Variable", "VALIDMIN", "VALIDMAX", "FILLVAL"};
        headrow1 = "<Record #>";
        headrow2 = "<Indices>";
        na = "N/A";
        defaultModal = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TabChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (((JTabbedPane)object).getSelectedIndex() != 0) {
                ExportCDFTable.this.avc1.setEnabled(false);
                ExportCDFTable.this.avc2.setEnabled(false);
            } else {
                if (ExportCDFTable.this.avc1 != null) {
                    ExportCDFTable.this.avc1.setEnabled(true);
                }
                if (ExportCDFTable.this.avc2 != null) {
                    ExportCDFTable.this.avc2.setEnabled(true);
                }
            }
        }

        TabChangeListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OptionsListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ExportCDFTable.this.avc1) {
                if (ExportCDFTable.this.avc1.isSelected()) {
                    ExportCDFTable.this.avc2.setSelected(false);
                    ExportCDFTable.this.fromRESET = false;
                    ExportCDFTable.this.reset();
                }
            } else if (object == ExportCDFTable.this.avc2 && ExportCDFTable.this.avc2.isSelected()) {
                ExportCDFTable.this.avc1.setSelected(false);
                ExportCDFTable.this.deselect();
                ExportCDFTable.this.avc2.setSelected(true);
            }
        }

        OptionsListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                String string = actionEvent.getActionCommand();
                if (string.equals(ExportCDFTable.CANCEL)) {
                    aCDFTable.setVisible(false);
                    if (((ExportCDFTable)ExportCDFTable.this).myCDFExport.MacOS) {
                        System.gc();
                    }
                } else if (string.equals(ExportCDFTable.ENTER)) {
                    aCDFTable.setVisible(false);
                    if (ExportCDFTable.this.numColumns2 > 0) {
                        ExportCDFTable.this.aVarFilterTable.getTable().editingStopped(new ChangeEvent(ExportCDFTable.this.aVarFilterTable));
                    }
                    if (((ExportCDFTable)ExportCDFTable.this).myCDFExport.outSelection == 3 || ((ExportCDFTable)ExportCDFTable.this).myCDFExport.outSelection == 4) {
                        ExportCreateCDF exportCreateCDF = new ExportCreateCDF(ExportCDFTable.this.myCDFExport, aCDFTable);
                        new Thread(exportCreateCDF).start();
                    } else {
                        boolean bl = ((ExportCDFTable)ExportCDFTable.this).myCDFExport.outSelection == 1;
                        ExportToText exportToText = ExportToText.createToText(ExportCDFTable.this.myFrame, ExportCDFTable.this.myCDFExport, aCDFTable, bl);
                    }
                } else if (string.equals(ExportCDFTable.RESET)) {
                    ExportCDFTable.this.fromRESET = true;
                    ExportCDFTable.this.reset();
                }
            }
        }

        SelectionListener() {
        }
    }
}

