/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NewVariableDialog
extends JDialog
implements CDFConstants,
ActionListener,
DocumentListener {
    private static final String ENTER = "Create";
    private static final String CANCEL = "Cancel";
    private static NewVariableDialog cache;
    private String name;
    private JButton enter;
    private JButton cancel;
    private JLabeledTF jtfvn;
    private JLabeledTF jtfne;
    private JLabeledTF jtfcl;
    private JLabeledTF jtfbf;
    private JLabeledTF jtfir;
    private JLabeledTF jtfpv;
    private JLabeledTF jtfstr;
    private JLabeledTF jtfend;
    private WholeNumberField tfdim;
    private WholeNumberField tfne;
    private JTextField tfcl;
    private JTextField tfbf;
    private JTextField tfir;
    private JTextField tfpv;
    private JTextField tfstr;
    private JTextField tfend;
    private JLabeledCB cbdt;
    private JLabeledCB cbcp;
    private JLabeledCB cbsp;
    private JCheckBox cbrv;
    private long dataType;
    private JLabeledDataTable jdtsizes;
    private JLabeledDataTable jdtvarys;
    private JLabeledDataTable jdtallorecs;
    private JFrame myFrame;
    private boolean fromEnter;
    private Variable var;
    private CDF cdf;
    private long[] sizes;
    private boolean[] varys;
    private Dimension ss;
    private Dimension ps;

    private final void createButtonPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.enter = new JButton(ENTER);
        this.enter.addActionListener(this);
        this.enter.setToolTipText("Create the variable");
        jPanel2.add(this.enter);
        this.cancel = new JButton(CANCEL);
        this.cancel.addActionListener(this);
        this.cancel.setToolTipText("Cancel the creation of a variable");
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
    }

    private final JPanel createVariancePanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Variances");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cbrv = new JCheckBox("Record (Time)", true);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cbrv, gridBagConstraints);
        jLabeledPanel.add(this.cbrv);
        this.jdtvarys = new JLabeledDataTable("Dimension");
        this.jdtvarys.setVisible(false);
        this.jdtvarys.setEnabled(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.jdtvarys, gridBagConstraints);
        jLabeledPanel.add(this.jdtvarys);
        return jLabeledPanel;
    }

    private final JPanel createDimensionPanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Dimensions");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tfdim = new WholeNumberField(0, 3);
        JLabeledTF jLabeledTF = new JLabeledTF("Number", this.tfdim, true);
        this.tfdim.getDocument().addDocumentListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabeledTF, gridBagConstraints);
        jLabeledPanel.add(jLabeledTF);
        this.jdtsizes = new JLabeledDataTable("Sizes");
        this.jdtsizes.setVisible(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.jdtsizes, gridBagConstraints);
        jLabeledPanel.add(this.jdtsizes);
        return jLabeledPanel;
    }

    private final JPanel createAllocRecsPanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Allocate Records");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tfstr = new JTextField(4);
        this.jtfstr = new JLabeledTF("Start  Rec  #", this.tfstr, true);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfstr, gridBagConstraints);
        jLabeledPanel.add(this.jtfstr);
        this.tfend = new JTextField(4);
        this.jtfend = new JLabeledTF("End  Rec  #", this.tfend, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfend, gridBagConstraints);
        jLabeledPanel.add(this.jtfend);
        return jLabeledPanel;
    }

    public static Variable createVariable(JFrame jFrame, CDF cDF) {
        if (cache == null) {
            cache = new NewVariableDialog(jFrame);
        }
        NewVariableDialog.cache.cdf = cDF;
        NewVariableDialog.cache.jtfvn.requestDefaultFocus();
        cache.setTitle("Create zVariable");
        cache.reset();
        cache.setVisible(true);
        return NewVariableDialog.cache.var;
    }

    public static Variable createVariable(JFrame jFrame, CDF cDF, String string, Object[] objectArray, boolean[] blArray) throws IllegalArgumentException {
        if (objectArray.length != 7) {
            throw new IllegalArgumentException("Wrong number of default values");
        }
        if (blArray.length != 7) {
            throw new IllegalArgumentException("Wrong number of enabled values");
        }
        if (!(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("Bad variable name.");
        }
        if (!(objectArray[1] instanceof Long)) {
            throw new IllegalArgumentException("Bad data type.");
        }
        if (!(objectArray[2] instanceof Long)) {
            throw new IllegalArgumentException("Bad numElements.");
        }
        if (!(objectArray[3] instanceof Long)) {
            throw new IllegalArgumentException("Bad numDims.");
        }
        if (!objectArray[4].getClass().isArray() && (long)Array.getLength(objectArray[4]) != (Long)objectArray[3]) {
            throw new IllegalArgumentException("Bad dimSizes.");
        }
        if (!(objectArray[5] instanceof Boolean)) {
            throw new IllegalArgumentException("Bad recVary.");
        }
        if (!objectArray[6].getClass().isArray() && (long)Array.getLength(objectArray[6]) != (Long)objectArray[3]) {
            throw new IllegalArgumentException("Bad dimVarys.");
        }
        if (cache == null) {
            cache = new NewVariableDialog(jFrame);
        }
        NewVariableDialog.cache.cdf = cDF;
        NewVariableDialog.cache.jtfvn.requestDefaultFocus();
        cache.setTitle(string);
        NewVariableDialog.cache.jtfvn.set(objectArray[0].toString());
        NewVariableDialog.cache.cbdt.set(CDFUtils.getStringDataType((Long)objectArray[1]));
        NewVariableDialog.cache.tfne.setText(objectArray[2].toString());
        NewVariableDialog.cache.tfdim.setText(objectArray[3].toString());
        if (NewVariableDialog.cache.tfdim.longValue() != 0L) {
            NewVariableDialog.cache.jdtsizes.setVisible(true);
            NewVariableDialog.cache.jdtsizes.getModel().setData(objectArray[4]);
            NewVariableDialog.cache.jdtvarys.setVisible(true);
            NewVariableDialog.cache.jdtvarys.getModel().setData(objectArray[6]);
        }
        NewVariableDialog.cache.cbrv.setSelected((Boolean)objectArray[5]);
        if (!objectArray[0].toString().equals("")) {
            NewVariableDialog.cache.jtfvn.setEnabled(blArray[0]);
        }
        NewVariableDialog.cache.cbdt.setEnabled(blArray[1]);
        if ((Long)objectArray[2] == 51L) {
            NewVariableDialog.cache.tfne.setEnabled(blArray[2]);
        }
        NewVariableDialog.cache.tfdim.setEnabled(blArray[3]);
        if (!NewVariableDialog.cache.tfdim.isEnabled()) {
            NewVariableDialog.cache.jdtsizes.setEnabled(blArray[4]);
            NewVariableDialog.cache.jdtvarys.setEnabled(false);
        }
        NewVariableDialog.cache.cbrv.setEnabled(blArray[5]);
        cache.setVisible(true);
        return NewVariableDialog.cache.var;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        long l = !this.tfdim.getText().equals("") ? this.tfdim.longValue() : (long)-1;
        if (l > 0L) {
            this.jdtsizes.setVisible(true);
            this.jdtsizes.getModel().createEmptyTable(1, (int)l, Long.TYPE);
            this.jdtvarys.setVisible(true);
            this.jdtvarys.getModel().createEmptyTable(1, (int)l, Boolean.TYPE);
            boolean[] blArray = new boolean[(int)l];
            int n = 0;
            while (n < (int)l) {
                blArray[n] = true;
                ++n;
            }
            this.jdtvarys.getModel().setData(blArray);
        } else {
            this.jdtsizes.setVisible(false);
            this.jdtsizes.getModel().setData(null);
            this.jdtvarys.setVisible(false);
            this.jdtvarys.getModel().setData(null);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        long l = !this.tfdim.getText().equals("") ? this.tfdim.longValue() : (long)-1;
        if (l > 0L) {
            this.jdtsizes.setVisible(true);
            this.jdtsizes.getModel().createEmptyTable(1, (int)l, Long.TYPE);
            this.jdtvarys.setVisible(true);
            this.jdtvarys.getModel().createEmptyTable(1, (int)l, Boolean.TYPE);
            boolean[] blArray = new boolean[(int)l];
            int n = 0;
            while (n < (int)l) {
                blArray[n] = true;
                ++n;
            }
            this.jdtvarys.getModel().setData(blArray);
        } else {
            this.jdtsizes.setVisible(false);
            this.jdtsizes.getModel().setData(null);
            this.jdtvarys.setVisible(false);
            this.jdtvarys.getModel().setData(null);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        System.err.print("changedUpdate: " + documentEvent.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CANCEL)) {
                if (!this.fromEnter) {
                    this.var = null;
                }
                this.setVisible(false);
                this.dispose();
                System.gc();
            } else if (string.equals(ENTER)) {
                ((JButton)object).setEnabled(false);
                this.jdtsizes.getDataTable().editingStopped(new ChangeEvent(this.jdtsizes));
                this.name = (String)this.jtfvn.get();
                if (this.name != null && this.name.trim().length() > 0) {
                    long[] lArray;
                    this.name = this.name.trim();
                    switch (this.cbdt.getIndex()) {
                        case 0: {
                            this.dataType = 41L;
                            break;
                        }
                        case 1: {
                            this.dataType = 1L;
                            break;
                        }
                        case 2: {
                            this.dataType = 11L;
                            break;
                        }
                        case 3: {
                            this.dataType = 2;
                            break;
                        }
                        case 4: {
                            this.dataType = 12L;
                            break;
                        }
                        case 5: {
                            this.dataType = 4;
                            break;
                        }
                        case 6: {
                            this.dataType = 14L;
                            break;
                        }
                        case 7: {
                            this.dataType = 21L;
                            break;
                        }
                        case 8: {
                            this.dataType = 44L;
                            break;
                        }
                        case 9: {
                            this.dataType = 22L;
                            break;
                        }
                        case 10: {
                            this.dataType = 45L;
                            break;
                        }
                        case 11: {
                            this.dataType = 31L;
                            break;
                        }
                        case 12: {
                            this.dataType = 32L;
                            break;
                        }
                        case 13: {
                            this.dataType = 51L;
                            break;
                        }
                        case 14: {
                            this.dataType = 52L;
                            break;
                        }
                        default: {
                            this.dataType = 41L;
                        }
                    }
                    long l = 1L;
                    if (this.dataType == 51L || this.dataType == 52L) {
                        l = this.tfne.longValue();
                    }
                    long l2 = this.cbrv.isSelected() ? (long)-1 : 0L;
                    long l3 = this.tfdim.longValue();
                    switch ((int)l3) {
                        case 0: {
                            this.sizes = new long[]{1L};
                            lArray = new long[]{-1};
                            break;
                        }
                        case 1: {
                            this.sizes = new long[1];
                            lArray = new long[1];
                            this.sizes[0] = (Long)this.jdtsizes.getModel().getData();
                            boolean bl = (Boolean)this.jdtvarys.getModel().getData();
                            lArray[0] = bl ? (long)-1 : 0L;
                            break;
                        }
                        default: {
                            this.sizes = (long[])this.jdtsizes.getModel().getData();
                            this.varys = (boolean[])this.jdtvarys.getModel().getData();
                            lArray = new long[(int)l3];
                            int n = 0;
                            while (n < (int)l3) {
                                lArray[n] = this.varys[n] ? (long)-1 : 0L;
                                ++n;
                            }
                            break block18;
                        }
                    }
                    try {
                        this.var = Variable.create(this.cdf, this.name, this.dataType, l, l3, this.sizes, l2, lArray);
                        this.doOptional();
                        this.fromEnter = true;
                        this.cancel.doClick();
                    }
                    catch (CDFException cDFException) {
                        cDFException.printStackTrace();
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this.myFrame, "CDF Error:\n" + CDFException.getStatusMsg(cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
                        this.var = null;
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, "Variable name is missing!", "CDFEdit: CDFException", 0);
                    this.var = null;
                }
                ((JButton)object).setEnabled(true);
            }
        }
    }

    private final void reset() {
        this.jtfvn.set("");
        this.tfdim.setText("0");
        this.tfne.setText("1");
        this.cbdt.set("CDF_BYTE");
        this.jtfvn.setEnabled(true);
        this.cbdt.setEnabled(true);
        this.tfne.setEnabled(true);
        this.tfne.setEditable(false);
        this.tfdim.setEnabled(true);
        this.jdtsizes.setEnabled(true);
        this.jdtvarys.setEnabled(true);
        this.cbrv.setEnabled(true);
        this.jdtsizes.setVisible(false);
        this.jdtsizes.getModel().setData(null);
        this.jdtvarys.setVisible(false);
        this.jdtvarys.getModel().setData(null);
        this.cbrv.setSelected(true);
        this.cbcp.set("None");
        this.tfcl.setVisible(true);
        this.tfcl.setEnabled(true);
        this.tfcl.setEditable(false);
        this.tfcl.setText("");
    }

    private final void doOptional() {
        long l;
        Object object;
        Object object2;
        long l2;
        long l3;
        String string = this.tfbf.getText();
        if (string != null && string.trim().length() != 0 && (l3 = Long.parseLong(string)) > 0L) {
            try {
                this.var.setBlockingFactor(l3);
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEdit: Blocking Factor Error", 0);
            }
        }
        if ((l3 = (long)this.cbsp.getIndex()) >= 1L) {
            try {
                this.var.setSparseRecords(l3);
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEdit: Record Sparseness Error", 0);
            }
        }
        if ((l2 = (long)this.cbcp.getIndex()) >= 0L) {
            object2 = new long[1];
            if (l2 == (long)4) {
                ++l2;
                object2[0] = Long.parseLong(this.tfcl.getText());
            }
            try {
                this.var.setCompression(l2, (long[])object2);
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEdit: Compression Error", 0);
            }
        }
        if ((object2 = (Object)this.tfpv.getText()) != null) {
            object2 = ((String)object2).trim();
        }
        if (((String)object2).length() != 0) {
            try {
                object = CDFToolUtils.parseContent((String)object2, this.dataType);
                this.var.setPadValue(object);
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEdit: Pad Value Error", 0);
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, numberFormatException.toString(), "MYEditor: CDFException", 0);
            }
        }
        if ((object = this.tfir.getText()) != null && ((String)object).trim().length() != 0 && (l = Long.parseLong((String)object)) > 0L) {
            try {
                this.var.setInitialRecords(l);
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEdit: Write Initial Records Error", 0);
            }
        }
        l = 0L;
        long l4 = 0L;
        String string2 = this.tfstr.getText();
        String string3 = this.tfend.getText();
        if (string2 != null && string3 != null) {
            String string4 = string2.trim();
            String string5 = string3.trim();
            if (string4 != null && !string4.equals("") && string5 != null && !string5.equals("") && (l = Long.parseLong(string4)) <= (l4 = Long.parseLong(string5)) && l >= 1L) {
                try {
                    this.var.allocateBlock(l - 1L, l4 - 1L);
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEdit: Allocate records Error", 0);
                }
            }
        }
    }

    private final /* synthetic */ void this() {
        this.fromEnter = false;
        this.var = null;
        this.cdf = null;
    }

    public NewVariableDialog() {
        this.this();
    }

    private NewVariableDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.this();
        this.myFrame = jFrame;
        this.setTitle("Create zVariable");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setResizable(false);
        this.setSize(520, 530);
        this.setLocation(10, 20);
        this.setVisible(false);
        this.ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.ps = this.getPreferredSize();
        JSplitPane jSplitPane = new JSplitPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Mandatory");
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jtfvn = new JLabeledTF("Variable Name", 10);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.jtfvn, gridBagConstraints);
        jLabeledPanel.add(this.jtfvn);
        Vector<String> vector = new Vector<String>(15);
        vector.addElement("CDF_BYTE");
        vector.addElement("CDF_INT1");
        vector.addElement("CDF_UINT1");
        vector.addElement("CDF_INT2");
        vector.addElement("CDF_UINT2");
        vector.addElement("CDF_INT4");
        vector.addElement("CDF_UINT4");
        vector.addElement("CDF_REAL4");
        vector.addElement("CDF_FLOAT");
        vector.addElement("CDF_REAL8");
        vector.addElement("CDF_DOUBLE");
        vector.addElement("CDF_EPOCH");
        vector.addElement("CDF_EPOCH16");
        vector.addElement("CDF_CHAR");
        vector.addElement("CDF_UCHAR");
        this.cbdt = new JLabeledCB("Data Type", vector, false);
        this.cbdt.set("CDF_BYTE");
        this.cbdt.addItemListener(new DataTypeListener());
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.cbdt, gridBagConstraints);
        jLabeledPanel.add(this.cbdt);
        this.tfne = new WholeNumberField(1, 3);
        this.jtfne = new JLabeledTF("NumElements", this.tfne, true);
        this.jtfne.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfne, gridBagConstraints);
        jLabeledPanel.add(this.jtfne);
        JPanel jPanel2 = this.createDimensionPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jLabeledPanel.add(jPanel2);
        jPanel2 = this.createVariancePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jLabeledPanel.add(jPanel2);
        JLabeledPanel jLabeledPanel2 = new JLabeledPanel("Optional");
        jLabeledPanel2.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Vector<String> vector2 = new Vector<String>(3);
        vector2.addElement("None");
        vector2.addElement("PAD_SPARSERECORDS");
        vector2.addElement("PREV_SPARSERECORDS");
        this.cbsp = new JLabeledCB("Record Sparseness", vector2, true);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cbsp, gridBagConstraints);
        jLabeledPanel2.add(this.cbsp);
        Vector<String> vector3 = new Vector<String>(5);
        vector3.addElement("None");
        vector3.addElement("RLE");
        vector3.addElement("HUFF");
        vector3.addElement("AHUFF");
        vector3.addElement("GZIP");
        this.cbcp = new JLabeledCB("Compression", vector3, true);
        this.cbcp.addItemListener(new CompressionListener());
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.cbcp, gridBagConstraints);
        jLabeledPanel2.add(this.cbcp);
        this.tfcl = new JTextField(1);
        this.jtfcl = new JLabeledTF("Level", this.tfcl, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfcl, gridBagConstraints);
        jLabeledPanel2.add(this.jtfcl);
        this.tfpv = new JTextField(10);
        this.jtfpv = new JLabeledTF("Pad Value    ", this.tfpv, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfpv, gridBagConstraints);
        jLabeledPanel2.add(this.jtfpv);
        this.tfbf = new JTextField(3);
        this.jtfbf = new JLabeledTF("Blocking Factor", this.tfbf, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfbf, gridBagConstraints);
        jLabeledPanel2.add(this.jtfbf);
        this.tfir = new JTextField(3);
        this.jtfir = new JLabeledTF("Write Initial Records", this.tfir, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfir, gridBagConstraints);
        jLabeledPanel2.add(this.jtfir);
        JPanel jPanel3 = this.createAllocRecsPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jLabeledPanel2.add(jPanel3);
        jSplitPane.setLeftComponent(jLabeledPanel);
        jSplitPane.setRightComponent(jLabeledPanel2);
        jLabeledPanel.setMinimumSize(new Dimension(260, 530));
        jLabeledPanel2.setMinimumSize(new Dimension(260, 530));
        jSplitPane.setDividerLocation(260);
        jSplitPane.setDividerSize(3);
        jSplitPane.setPreferredSize(new Dimension(520, 530));
        jPanel.add((Component)jSplitPane, "Center");
        this.createButtonPanel(jPanel);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DataTypeListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            String string = (String)((JComboBox)object).getSelectedItem();
            if (string.equals("CDF_CHAR") || string.equals("CDF_UCHAR")) {
                NewVariableDialog.this.jtfne.set("10");
                NewVariableDialog.this.tfne.setEnabled(true);
                NewVariableDialog.this.jtfne.setVisible(true);
                NewVariableDialog.this.jtfne.setEditable(true);
            } else {
                NewVariableDialog.this.jtfne.set("1");
                NewVariableDialog.this.tfne.setEnabled(true);
                NewVariableDialog.this.jtfne.setVisible(true);
                NewVariableDialog.this.jtfne.setEditable(false);
            }
        }

        DataTypeListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CompressionListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            int n = NewVariableDialog.this.cbcp.getIndex();
            if (n > 3) {
                ++n;
            }
            if (n == 5) {
                NewVariableDialog.this.jtfcl.setVisible(true);
                NewVariableDialog.this.jtfcl.setEnabled(true);
                NewVariableDialog.this.jtfcl.setEditable(true);
                NewVariableDialog.this.jtfcl.set("5");
            } else {
                NewVariableDialog.this.jtfcl.setVisible(true);
                NewVariableDialog.this.jtfcl.setEnabled(true);
                NewVariableDialog.this.jtfcl.setEditable(false);
                if (n == 0) {
                    NewVariableDialog.this.jtfcl.set("");
                } else {
                    NewVariableDialog.this.jtfcl.set("0");
                }
            }
        }

        CompressionListener() {
        }
    }
}

