/******************************************************************************
*
*  NSSDC/CDF                 AddAttributes - Add variable attributes.
*
*  Version 1.0, 9-Jul-06, Raytheon.
*
*  Modification history:
*
*   V1.0  09-Jul-06, M Liu      Original version.
*
******************************************************************************/

#include "cdfmerge.h"
static CDFid id, ido;

/******************************************************************************
* Main.
******************************************************************************/

MAIN {
  Logical success = TRUE;
  strcpyX (pgmName, "CDFmerge", MAX_PROGRAM_NAME_LEN);
  success = MergeCDFs (argc, argv);
  return BOO(success,EXIT_SUCCESS_,EXIT_FAILURE_);
}

/******************************************************************************
* MergeCDFs.
******************************************************************************/

Logical MergeCDFs (argC, argV)
int argC;
char *argV[];
{

CDFstatus status, status1;
long numDims, dimSizes[CDF_MAX_DIMS], dimVarys[CDF_MAX_DIMS];
long majority, encoding, format,
     numzVars, numAttrs, numgAttrs, numvAttrs, numgEntries, 
     numzEntries, major, reservePct;
long varNum, attrNum, dataType, numElems, scope, recVary, dataTypeX, numElemsX,
     dataTypeY, numElemsY;
long cType, cParms[CDF_MAX_DIMS], cPct;
long maxRec, varMaxRec, sp, bf, maxAllocRec, fromRec, toRec, fromRec2, toRec2,
     nRecords, hyperStep;
long nValuesPerRec, maxGentry = 0;
char **CDFpaths, **varNames;
char outputCDF[CDF_PATHNAME_LEN+1], fileList[CDF_PATHNAME_LEN+1],
     line[CDF_PATHNAME_LEN+1], sourceCDF[CDF_PATHNAME_LEN+1];
char varName[CDF_VAR_NAME_LEN256+1], attrName[CDF_ATTR_NAME_LEN256+1];
char newVarName[CDF_VAR_NAME_LEN256+1], newAttrName[CDF_ATTR_NAME_LEN256+1],
     newVarName2[CDF_VAR_NAME_LEN256+1];
char prefix[1025], entryValue[257], *addGlobalAttr = "FileSource", *newValue;
void *value;
size_t nBytes;
Logical mLog, pad, dataOnly, usePrefix = TRUE, changed;
Logical srcRowMajor, switchMajority;
int  i, ii, j, k, ir, icount, numCDFs, ix, iy, dimN, recNum;
int numOpt, numTokens = 0, count;
Logical qopError = FALSE;
QOP *qop;
static char *validQuals[] = {
  "prefixes", "noprefix", "about", "log", "nolog", "file", "dataonly", 
  "nodataonly", NULL 
};
static int optRequired[] = {
  TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 0
};
Byte **handles[2], *buffer1, *buffer2;
size_t nValueBytes[2]; 
long nHypers, nValues, hyperN;
struct GroupStruct groups; 
struct HyperStruct hyper;
Logical ifound;
int spgAttrs = 0, sp1vAttrs = 25, sp2vAttrs = 9;
char *specialgAttrs[1];
/*
static char *special1vAttrs[] = {"FIELDNAM", "VALIDMIN", "VALIDMAX", "SCALEMIN",
                                 "SCALEMAX", "LABLAXIS", "UNITS",    "FORMAT",
                                 "MONOTON",  "VAR_TYPE", "DICT_KEY", "FILLVAL",
                                 "LABL_PTR_", "UNIT_PTR", "FORM_PTR", "DEPEND_", 
                                 "CATDESC",  "DELTA_PLUS_VAR",       
                                 "DELTA_MINUS_VAR",      "AVG_TYPE",
                                 "DISPLAY_TYPE",         "VAR_NOTES",
                                 "SCAL_PTR", "DERIVN",   "V_PARENT"};
*/
static char *special2vAttrs[] = {
       "LABL_PTR_", "FORM_PTR", "UNIT_PTR", "DEPEND_",
       "SCAL_PTR",  "DERIVN",   "V_PARENT", "COMPONENT_",
       "OFFSET_"
};
static char *dspType = "DISPLAY_TYPE";
FILE *srcFp;

/******************************************************************************
* Parse qualifiers/options/parameters (QOP).
******************************************************************************/

switch (argC) {
  case 1:
    PageOLH ("cdfmerge.olh", argV[0]);
    return TRUE;
  case 2:
    if (strcmp(argV[1],"-java") == 0) {
      PageOLH ("cdfcvtj.olh", argV[0]);
      return TRUE;
    }
  default:
    qop = Qop (argC, argV, validQuals, optRequired);
    if (qop == NULL) return FALSE;
    /************************************************************************
    * Check for `about' qualifier.
    ************************************************************************/
    if (qop->qualEntered[ABOUTqual]) {
      DisplayIdentification (pgmName);
      cdf_FreeMemory (qop, FatalError);
      return TRUE;
    }
    /************************************************************************
    * Check for `file' qualifier.
    ************************************************************************/
    if (qop->qualEntered[FILEqual]) {
      strcpyX (fileList, qop->qualOpt[FILEqual], CDF_PATHNAME_LEN);
#if defined(__CYGWIN__) || defined(__MINGW32__)
      srcFp = fopen (fileList, "rt");
#else
      srcFp = fopen (fileList, "r");
#endif
      if (srcFp == NULL) {
        DisplayError ("Unable to open the source file.");
        qopError = TRUE;
        return TRUE;
      }
      numCDFs = 0;
      while ( fgets(line,DU_MAX_PATH_LEN,srcFp) != NULL) {
        numCDFs++;
        if (numCDFs == 1) 
          numOpt = sscanf(line, "%s %s",sourceCDF, outputCDF);
      }
      if (numCDFs < 3) {
        DisplayError ("Less than 3 files specified in the input file.");
        qopError = TRUE;
        fclose (srcFp);
        return TRUE;
      }
      rewind (srcFp);
      numCDFs--;
      CDFpaths = (char **) cdf_AllocateMemory (sizeof(char *) * numCDFs, 
                                               FatalError);
      if (numOpt == 2) {
        numTokens = numCDFs;
      }
      prefixes = (char **) cdf_AllocateMemory (sizeof(char *) * numCDFs,
                                               FatalError);

      for (i = 0; i < numCDFs; i++) {
        CDFpaths[i] = (char *) cdf_AllocateMemory (DU_MAX_PATH_LEN+1, 
                                                   FatalError);
        prefixes[i] = (char *) cdf_AllocateMemory (PREFIXMAXLEN+1,
                                                   FatalError);
        fgets (line, DU_MAX_PATH_LEN, srcFp);
        if (sscanf(line, "%s %s", CDFpaths[i], prefixes[i]) != numOpt) {
          DisplayError ("Missing prefix in some entries in the input file.");
          qopError = TRUE;
          fclose (srcFp);
          for (j = 0; j <= i; j++) { 
             if (prefixes[j] != NULL) cdf_FreeMemory (prefixes[j], 
                                                      FatalError);
             if (CDFpaths[j] != NULL) cdf_FreeMemory (CDFpaths[j], 
                                                      FatalError);
          }
          if (prefixes != NULL) cdf_FreeMemory (prefixes, FatalError);
          if (CDFpaths != NULL) cdf_FreeMemory (CDFpaths, FatalError);
          return TRUE;
        }
      }
      fgets (line, DU_MAX_PATH_LEN, srcFp);
      strcpyX (outputCDF, line, strlen(line) - 1);
      fclose (srcFp);
      if (numOpt == 1) {
        for (i = 0; i < numCDFs; i++) 
             if (prefixes[i] != NULL) cdf_FreeMemory (prefixes[i],
                                                      FatalError);
        if (prefixes != NULL) cdf_FreeMemory (prefixes, FatalError);
      }
    } else
      MakeNUL (fileList);
    /**************************************************************************
    * Get CDF pathnames if `file' qualifier is not entered.
    **************************************************************************/
    if (NULstring(fileList)) {
      if (qop->Nparms < 3) {
        DisplayError ("Missing parameter(s)... Need at least 3 files (2 inputs 1 output).");
        qopError = TRUE;
        return TRUE;
      }
      else { 
        numCDFs = qop->Nparms - 1;
        CDFpaths = (char **) cdf_AllocateMemory (sizeof(char *) * numCDFs, 
                                                 FatalError);
        for (i = 0; i < numCDFs; i++) {
          CDFpaths[i] = (char *) cdf_AllocateMemory (DU_MAX_PATH_LEN+1, 
                                                     FatalError);
          strcpyX (CDFpaths[i], qop->parms[i], DU_MAX_PATH_LEN);
        }
        strcpyX (outputCDF, qop->parms[qop->Nparms-1], DU_MAX_PATH_LEN);
      }
    }
    /**************************************************************************
    * Check which prefix values should be used was specified. Only check
    * if there is no "file" qualifier entered or no prefixes specified in 
    * that file.
    **************************************************************************/
    if (NULstring(fileList) || numTokens == 0) {
      count = 0;
      if (qop->qualEntered[NOPREFIXqual]) count++;
      if (qop->qualEntered[PREFIXESqual]) count++;
      switch (count) {
        case 0:
          usePrefix = TRUE;
          MakeNUL (prefix);
          break;
        case 1:
          if (qop->qualEntered[NOPREFIXqual]) {
            usePrefix = FALSE;
            MakeNUL (prefix);
            break;
          }
          if (qop->qualEntered[PREFIXESqual]) {
            usePrefix = TRUE;
            strcpyX (prefix, qop->qualOpt[PREFIXESqual], 1024);
            numTokens = GetNumTokens ((int) ',', prefix);
            if (numTokens != numCDFs) {
              DisplayError ("Numbers of prefixes and source CDFs do not match.");
              qopError = TRUE;
              return TRUE;
            } else {
              prefixes = (char **) cdf_AllocateMemory (sizeof(char *) * numTokens,
                                                       FatalError);
              for (i = 0; i < numTokens; i++)
                prefixes[i] = (char *) cdf_AllocateMemory (DU_MAX_PATH_LEN+1,
                                                           FatalError);
              ParseStringForTokens ((int) ',', prefix, prefixes);
            }
            break;
          }
        default:
          DisplayError ("Specify only one prefix option.");
          qopError = TRUE;
      }
    }
    /************************************************************************
    * Check for `log' qualifier.
    ************************************************************************/
    qopError = qopError | !TFqualifier (qop,&mLog,LOGqual,NOLOGqual,
                                        DEFAULTlogMERGE,"log");
    /************************************************************************
    * Check for `dataonly' qualifier.
    ************************************************************************/
    qopError = qopError | !TFqualifier (qop,&dataOnly,DATAONLYqual,
                                        NODATAONLYqual,
                                        DEFAULTdataonlyMERGE,"dataonly");
    /************************************************************************
    * Free QOP memory and check for an error.
    ************************************************************************/
    cdf_FreeMemory (qop, FatalError);
    if (qopError) {
      return FALSE;
    }
    break;
  }

  /***************************************************************************
  * Display converting message.
  ***************************************************************************/
  printf ("Merging \"");
  for (icount = 0; icount < numCDFs; icount++) {
    if (icount != 0) printf ("        \"");
    printf (CDFpaths[icount]);
    if (!EndsWithIgCase(CDFpaths[icount], ".cdf"))
      printf (".cdf\" \n");
    else
      printf ("\" \n");
  }
  printf ("     to \"");
  printf (outputCDF);
  if (!EndsWithIgCase(outputCDF, ".cdf"))
    printf (".cdf");
  printf ("\"\n");

  /***********************************/
  /* Loop through the source CDFs.   */
  /***********************************/

  for (icount = 0; icount < numCDFs; icount++) {

    status = CDFlib (OPEN_, CDF_, CDFpaths[icount], &id,
                     SELECT_, CDF_zMODE_, zMODEon2,
                     GET_, CDF_MAJORITY_, &major,
                           CDF_ENCODING_, &encoding,
                           CDF_FORMAT_, &format,
                           CDF_NUMzVARS_, &numzVars,
                           CDF_NUMATTRS_, &numAttrs,
                           CDF_NUMgATTRS_, &numgAttrs,
                           CDF_NUMvATTRS_, &numvAttrs,
                           CDF_COMPRESSION_, &cType, cParms, &cPct,

                     NULL_);
    if (status < CDF_OK) QuitCDF ("1.0", status, CDFpaths[icount]);

    /***************************************/
    /* Create the output CDF.              */
    /***************************************/

    if (icount == 0) {  
      majority = major;
      dimSizes[0] = 0L;
      status = CDFlib (CREATE_, CDF_, outputCDF, 0L, dimSizes, &ido,
                       PUT_, CDF_MAJORITY_, majority,
                             CDF_ENCODING_, encoding,
                             CDF_FORMAT_, format,
                             CDF_COMPRESSION_, cType, cParms,
                       NULL_);
      if (status < CDF_OK) QuitCDF ("2.0", status, outputCDF);

      if (mLog) printf ("  Merged file created...\n");

      /**************************************/
      /* Add the "FileName" attribute.      */
      /**************************************/

      status = CDFlib (SELECT_, CDF_, ido,
                       CREATE_, ATTR_, addGlobalAttr, GLOBAL_SCOPE, &attrNum,
                       NULL_);
      if (status < CDF_OK) QuitCDF ("3.0", status, addGlobalAttr);

    }

    /********************************************/
    /* Load the Global Attributes.              */
    /********************************************/

    if (numgAttrs > 0) {

      if (icount == 0 || (icount != 0 && !dataOnly)) {

        if (mLog) printf ("  Adding global attributes (%ld) from file: %d...\n",
                          numgAttrs, (icount+1));
        j = 0;
        for (i = 0; i < (int) numAttrs; i++) {
          status = CDFlib (SELECT_, CDF_, id,
                                    ATTR_, (long) i,
                           GET_, ATTR_SCOPE_, &scope,
                           NULL_);
          if (status < CDF_OK) QuitCDF ("4.0", status, NULL);

          if (scope != GLOBAL_SCOPE) continue;

          status = CDFlib (GET_, ATTR_NAME_, attrName,
                                 ATTR_NUMgENTRIES_, &numgEntries,
                           NULL_);
          if (status < CDF_OK) QuitCDF ("5.0", status, attrName);

          if (dataOnly) 
            strcpyX (newAttrName, attrName, 0);
          else {
            /*****************************************************/
            /* Check for special attributes. Its                 */
            /* ISTP-standard name can't be changed.              */
            /*****************************************************/
            ifound = FALSE;
            if (usePrefix) {
              for (j = 0; j < spgAttrs; j++) {
                if (strcmpIgCase(attrName, specialgAttrs[j]) != 0)
                  ifound = TRUE;
              }
            }
            if (usePrefix && !ifound)
              ModifyName (attrName, numTokens, prefixes, icount, 
                          newAttrName);
            else
              strcpyX (newAttrName, attrName, 0);
          }

          status = CDFlib (SELECT_, CDF_, ido,
                           CREATE_, ATTR_, newAttrName, scope, &attrNum,
                           NULL_);
          if (!usePrefix && status == ATTR_EXISTS) {
            status = CDFlib (SELECT_, CDF_, ido,
                                      ATTR_NAME_, newAttrName, 
                             GET_,    ATTR_MAXgENTRY_, &maxGentry,
                             NULL_);
            if (status < CDF_OK) QuitCDF ("6.0", status, newAttrName);
            maxGentry++;
          } else if (status < CDF_OK) 
            QuitCDF ("6.5", status, newAttrName);
      
            j = k = 0;
            if (numgEntries > 0) {
              do {
                status = CDFlib (SELECT_, CDF_, id,
                                          ATTR_, (long) i,
                                          gENTRY_, (long) j,
                                 GET_, gENTRY_DATATYPE_, &dataTypeX,
                                       gENTRY_NUMELEMS_, &numElemsX,
                               NULL_);
              if (status < CDF_OK) {
                j++;
                continue;
              } else {
                nBytes = (size_t) (CDFelemSize(dataTypeX) * numElemsX);
                value = cdf_AllocateMemory ((size_t) nBytes, FatalError);
                status = CDFlib (SELECT_, CDF_, id,
                                          ATTR_, (long) i,
                                          gENTRY_, (long) j,
                                 GET_, gENTRY_DATA_, value,
                                 NULL_);
                if (status < CDF_OK) QuitCDF ("7.0", status, NULL);

                status = CDFlib (SELECT_, CDF_, ido,
                                          ATTR_NAME_, newAttrName,
                                          gENTRY_, (long) (j+maxGentry),
                                 PUT_, gENTRY_DATA_, dataTypeX, numElemsX, value,
                                 NULL_);
                if (status < CDF_OK) QuitCDF ("8.0", status, newAttrName);
                k++;
                j++;
                cdf_FreeMemory (value, FatalError);
              }
            } while (k < (int) numgEntries);
          }
        }
        if (mLog) printf ("  Global attributes from source file: %d added...\n",
                          (icount+1));
      }
    }

    if (numTokens > 0) 
      sprintf (entryValue, "%s: ", prefixes[icount]);
    else
      sprintf (entryValue, "File%d: ", (icount+1));
    strcatX (entryValue, CDFpaths[icount], 0);
    if (!EndsWithIgCase (entryValue, ".cdf"))
      strcatX (entryValue, ".cdf", 0);

    status = CDFlib (SELECT_, CDF_, ido,
                              ATTR_NAME_, addGlobalAttr,
                              gENTRY_, (long) icount,
                     PUT_, gENTRY_DATA_, CDF_CHAR,
                           (long) strlen (entryValue), entryValue,
                     NULL_);
    if (status < CDF_OK) QuitCDF ("9.0", status, addGlobalAttr);

    /*******************************************************/
    /* Load the variables (all are zVariables).           */ 
    /*******************************************************/

    if (numzVars > 0) {

      if (mLog) printf ("  Adding zVariables (%ld) from file: %d...\n",
                        numzVars, (icount+1));

      varNames = (char **) cdf_AllocateMemory (sizeof(char *) * 
                                               (int) numzVars, FatalError);
      for (i = 0; i < numzVars; i++) {
        status = CDFlib (SELECT_, CDF_, id,
                                  zVAR_, (long) i,
                         GET_, zVAR_NAME_, varName,
                               zVAR_DATATYPE_, &dataType,
                               zVAR_NUMELEMS_, &numElems,
                               zVAR_NUMDIMS_, &numDims,
                               zVAR_DIMSIZES_, dimSizes,
                               zVAR_DIMVARYS_, dimVarys,
                               zVAR_RECVARY_, &recVary,
                               zVAR_COMPRESSION_, &cType, cParms, &cPct,
                               zVAR_BLOCKINGFACTOR_, &bf,
                               zVAR_SPARSERECORDS_, &sp,
                        NULL_);
        if (status < CDF_OK) QuitCDF ("10.0", status, varName);

        varNames[i] = (char *) cdf_AllocateMemory (strlen(varName)+1,
                                                   FatalError);
        strcpyX (varNames[i], varName, strlen(varName));

        if (cType != NO_COMPRESSION) {
          status = CDFlib (CONFIRM_, zVAR_RESERVEPERCENT_, &reservePct,
                           NULL_);
          if (status < CDF_OK) QuitCDF ("11.0", status, NULL);
        }

        nBytes = (size_t) (CDFelemSize(dataType) * numElems);
        value = cdf_AllocateMemory ((size_t) nBytes, FatalError);
        status = CDFlib (GET_, zVAR_PADVALUE_, value,
                         NULL_);
        if (status != NO_PADVALUE_SPECIFIED)
          pad = TRUE;
        else
          pad = FALSE;

        if (usePrefix && !dataOnly)
          ModifyName (varName, numTokens, prefixes, icount, newVarName);
        else
          strcpyX (newVarName, varName, 0);

        status = CDFlib (SELECT_, CDF_, ido,
                         CREATE_, zVAR_, newVarName, dataType, numElems, numDims,
                                         dimSizes, recVary, dimVarys, &varNum,
                         PUT_, zVAR_COMPRESSION_, cType, cParms,
                               zVAR_BLOCKINGFACTOR_, bf,
                               zVAR_SPARSERECORDS_, sp,
                         NULL_);

        if (!dataOnly) {
          if (status < CDF_OK) QuitCDF ("12.0", status, newVarName);
        } else
          if (status != CDF_OK && status != VAR_EXISTS) 
            QuitCDF ("12.5", status, newVarName);

        if (status == CDF_OK && cType != NO_COMPRESSION) {
          status1 = CDFlib (SELECT_, zVAR_RESERVEPERCENT_, reservePct,
                            NULL_);
          if (status1 < CDF_OK) QuitCDF ("13.0", status, newVarName);
        }

        if (status == CDF_OK && pad) {
          status1 = CDFlib (PUT_, zVAR_PADVALUE_, value,
                            NULL_);
          if (status1 < CDF_OK) QuitCDF ("14.0", status, newVarName);
        }
        cdf_FreeMemory (value, FatalError);
      }
      if (mLog) printf ("  Variables from source file: %d added...\n",
                        (icount+1));
    }

    /*********************************************/
    /* Load the Variable Attributes.             */
    /*********************************************/

    if (numvAttrs > 0) {

      if (mLog) printf ("  Adding variable attributes (%ld) from source file: %d...\n",
                        numvAttrs, (icount+1));

      for (i = 0; i < (int) numAttrs; i++) {
        status = CDFlib (SELECT_, CDF_, id,
                                  ATTR_, (long) i,
                         GET_, ATTR_SCOPE_, &scope,
                         NULL_);
        if (status < CDF_OK) QuitCDF ("15.0", status, NULL);

        if (scope == GLOBAL_SCOPE) continue;

        status = CDFlib (GET_, ATTR_NAME_, attrName,
                               ATTR_NUMzENTRIES_, &numzEntries,
                         NULL_);
        if (status < CDF_OK) QuitCDF ("16.0", status, attrName);
 
        status = CDFlib (SELECT_, CDF_, ido,
                         CREATE_, ATTR_, attrName, scope, &attrNum,
                         NULL_);
        if (status < CDF_OK) {
          if (status == ATTR_EXISTS) {
            status = CDFlib (SELECT_, CDF_, ido,
                             GET_, ATTR_NUMBER_, attrName, &attrNum,
                             NULL_);
            if (status < CDF_OK) QuitCDF ("17.0", status, attrName);
          } else
            QuitCDF ("17.5", status, attrName);
        }

        j = k = 0;
        if (numzEntries > 0) {
          do {
            status = CDFlib (SELECT_, CDF_, id,
                                      ATTR_, (long) i,
                                      zENTRY_, (long) j,
                             GET_, zENTRY_DATATYPE_, &dataTypeX,
                                   zENTRY_NUMELEMS_, &numElemsX,
                             NULL_);
            if (status < CDF_OK) {
              j++;
              continue;
            } else {
              nBytes = (size_t) (CDFelemSize(dataTypeX) * (numElemsX+1));
              value = cdf_AllocateMemory ((size_t) nBytes, FatalError);
              status = CDFlib (SELECT_, CDF_, id,
                               GET_, zENTRY_DATA_, value,
                               SELECT_, zVAR_, (long) j,
                               GET_, zVAR_NAME_, varName, 
                               NULL_);
              if (status < CDF_OK) QuitCDF ("18.0", status, NULL);

              if (STRINGdataType(dataTypeX)) 
                *(((char *)value)+numElemsX) = NUL;
              if (usePrefix && !dataOnly)
                ModifyName (varName, numTokens, prefixes, icount, newVarName);
              else
                strcpyX (newVarName, varName, 0);

              status = CDFlib (SELECT_, CDF_, ido,
                                        ATTR_NAME_, attrName,
                                        zENTRY_NAME_, newVarName,
                               GET_, zENTRY_DATATYPE_, &dataTypeY,
                                     zENTRY_NUMELEMS_, &numElemsY,
                               NULL_);
              /****************************************************************
              * If already exists, it's an error for noprefix condition.
              * Otherwise, write it.
              ****************************************************************/
              if (status == CDF_OK) {
                if (!usePrefix) {
                  cdf_FreeMemory (value, FatalError);
                  QuitCDF ("18.5", VAR_EXISTS, newVarName);
                }
              } else if (status < CDF_OK) {
                /**************************************************************
                * Check for special attributes that have the entry data of a
                * variable name. For this case, the entry needs to be changed
                * to reflect the prefixed variable name in the merged file.
                **************************************************************/
                if (usePrefix && !dataOnly) {
                  if (strcmpIgCase(attrName, dspType) != 0) {
                    changed = FALSE;
                    newValue = (char *) cdf_AllocateMemory (strlen(value)+150,
                                                            FatalError);
                    /**********************************************************
                    * Parse the entry for DISPLAY_TYPE for variable name(s).
                    * Have to change it as it will have a prefix.
                    **********************************************************/
                    ParseStringForVariables (numTokens, prefixes, icount,
                                             (int) numzVars, varNames,
                                             value, newValue, &changed);
                    if (changed)
                      status = CDFlib (SELECT_, CDF_, ido,
                                                ATTR_NAME_, attrName,
                                                zENTRY_NAME_, newVarName,
                                       PUT_, zENTRY_DATA_, dataTypeX,
                                                           (long) strlen(newValue),
                                                           newValue,
                                       NULL_);
                    else
                      status = CDFlib (SELECT_, CDF_, ido,
                                                ATTR_NAME_, attrName,
                                                zENTRY_NAME_, newVarName,
                                       PUT_, zENTRY_DATA_, dataTypeX, numElemsX,
                                                           value,
                                       NULL_);
                    if (status < CDF_OK) QuitCDF ("19.0", status, newVarName);
                    cdf_FreeMemory (newValue, FatalError);
                  } else {
                    ifound = FALSE;
                    for (ii = 0; ii < sp2vAttrs; ii++) {
                      if (strcmpIgCase(attrName, special2vAttrs[ii]) != 0) {
                        ifound = TRUE;
                        break;
                      }
                    }
                    if (ifound) {
                      *(((char *)value)+numElemsX) = NUL; 
                      ModifyName ((char *)value, numTokens, prefixes, icount, 
                                  newVarName2);
                      numElemsX = (long) strlen (newVarName2);
                    } 
                    status = CDFlib (SELECT_, CDF_, ido,
                                              ATTR_NAME_, attrName,
                                              zENTRY_NAME_, newVarName,
                                     PUT_, zENTRY_DATA_, dataTypeX, numElemsX,
                                                 BOO(ifound,newVarName2,value),
                                     NULL_);
                    if (status < CDF_OK) QuitCDF ("19.5", status, newVarName);
                  }
                } else {                        
                  status = CDFlib (SELECT_, CDF_, ido,
                                            ATTR_NAME_, attrName,
                                            zENTRY_NAME_, newVarName,
                                   PUT_, zENTRY_DATA_, dataTypeX, numElemsX,
                                                       value,
                                   NULL_);
                  if (status < CDF_OK) QuitCDF ("19.7", status, newVarName);
                }
              }
              k++;
              j++;
              cdf_FreeMemory (value, FatalError);
            }
          } while (k < numzEntries);
        }
      }
      
      if (mLog) printf ("  Variable attributes from source file: %d added...\n",
                        (icount+1));
    }

    if (numzVars > 0) 
      for (i = 0; i < (int) numzVars; i++)
         cdf_FreeMemory (varNames[i], FatalError);

    cdf_FreeMemory (varNames, FatalError);

    status = CDFlib (SELECT_, CDF_, id,
                     CLOSE_, CDF_,
                     NULL_);
    if (status < CDF_OK) QuitCDF ("20.0", status, NULL);

  }

  /****************************************/
  /* Load the Variable data.              */
  /****************************************/

  for (icount = 0; icount < numCDFs; icount++) {

    if (mLog) printf ("  Adding variable data from source file: %d...\n",
                      (icount+1));

    status = CDFlib (OPEN_, CDF_, CDFpaths[icount], &id,
                     SELECT_, CDF_zMODE_, zMODEon2,
                     GET_, CDF_MAJORITY_, &major,
                           CDF_NUMzVARS_, &numzVars,
                     NULL_);   
    if (status < CDF_OK) QuitCDF ("21.0", status, CDFpaths[icount]);

    srcRowMajor = ROWmajor(major);

    for (ir = 0; ir < (int) numzVars; ir++) {

      status = CDFlib (SELECT_, CDF_, id,
                                zVAR_, (long) ir,
                       GET_, zVAR_NAME_, varName,
                             zVAR_RECVARY_, &recVary,
                             zVAR_DATATYPE_, &dataType,
                             zVAR_NUMELEMS_, &numElems,
                             zVAR_NUMDIMS_, &numDims,
                             zVAR_DIMSIZES_, dimSizes,
                             zVAR_MAXREC_, &maxRec,
                             zVAR_COMPRESSION_, &cType, cParms, &cPct,
                       NULL_);
      if (status < CDF_OK) QuitCDF ("22.0", status, varName);

      if (maxRec == NO_RECORD) continue;

      /************************************************************************
      * Read/write values using hyper groups...
      ************************************************************************/
      for (dimN = 0, nValuesPerRec = 1; dimN < numDims; dimN++) {
         if (dimVarys[dimN])
           nValuesPerRec *= dimSizes[dimN];
         else
           dimSizes[dimN] = 1;
      }

      if (usePrefix && !dataOnly) 
        ModifyName (varName, numTokens, prefixes, icount, newVarName);
      else
        strcpyX (newVarName, varName, 0);

      status = CDFlib (SELECT_, CDF_, ido,
                       GET_, zVAR_NUMBER_, newVarName, &varNum,
                       NULL_);
      if (status < CDF_OK) QuitCDF ("23.0", status, newVarName);

      status = CDFlib (SELECT_, CDF_, ido,
                                zVAR_, varNum,
                       GET_, zVAR_MAXREC_, &varMaxRec,
                       NULL_);
      if (status < CDF_OK) QuitCDF ("23.5", status, newVarName);

      if (icount == 0) 
        varMaxRec = 0;
      else
        varMaxRec++;

      nBytes = (size_t) (CDFelemSize(dataType) * numElems);
      handles[0] = &buffer1;
      handles[1] = &buffer2;
      nValueBytes[0] = (size_t) nBytes;
      nValueBytes[1] = (size_t) nBytes;
      switchMajority = (numDims > 1 && majority != major);

      if (icount != 0 && dataOnly && !recVary) continue;

      for (recNum = 0; recNum <= (int) maxRec; recNum = toRec + 1) {
        /**********************************************************************
        * Determine the next allocated record.
        **********************************************************************/
        status = CDFlib (SELECT_, CDF_, id,
                                  zVAR_, (long) ir,
                         GET_, zVAR_ALLOCATEDFROM_, (long) recNum, &fromRec,
                         NULL_);
        if (status < CDF_OK) QuitCDF ("24.0", status, newVarName);
        /**********************************************************************
        * Determine the last allocated record (before the next unallocated one).
        * Do not let this exceed the maximum record written to the variable.
        **********************************************************************/
        status = CDFlib (SELECT_, CDF_, id,
                                  zVAR_, (long) ir,
                         GET_, zVAR_ALLOCATEDTO_, fromRec, &toRec,
                         NULL_);
        if (status < CDF_OK) QuitCDF ("25.0", status, newVarName);
        toRec = MINIMUM(toRec,maxRec);

        fromRec2 = fromRec + varMaxRec;
        toRec2 = toRec + varMaxRec;

        /**********************************************************************
        * Allocate the records unless the variable is compressed or has sparse
        * arrays.
        **********************************************************************/
        if (cType == NO_COMPRESSION) {
          status = CDFlib (SELECT_, CDF_, ido,
                                    zVAR_, varNum,
                           PUT_, zVAR_ALLOCATEBLOCK_, fromRec, toRec,
                           NULL_);
          if (status < CDF_OK) QuitCDF ("26.0", status, newVarName);
        }
        /**********************************************************************
        * Calculate the number of records in this group.
        **********************************************************************/
        nRecords = toRec - fromRec + 1;
        /**********************************************************************
        * If the majority is being switched...
        **********************************************************************/
        if (switchMajority) { 
          AllocateBuffers (nRecords, numDims, dimSizes, &groups, 0, 2, handles,
                           nValueBytes, srcRowMajor, 5, FatalError);
          if (HyperFullRecord(&groups,numDims)) {
            long nBytesPerRecord = nValuesPerRec * nBytes, recX;
            InitHyperParms (&hyper, &groups, numDims, &nHypers, &nValues);
            hyper.recNumber = fromRec;
            for (hyperN = 0; hyperN < nHypers; hyperN++) {
              status = CDFlib (SELECT_, CDF_, id,
                                        zVAR_, (long) ir,
                               NULL_);
              if (status < CDF_OK) QuitCDF ("27.0", status, newVarName);
              status = HYPER_READ (id, TRUE, hyper, buffer1);
              if (status < CDF_OK) QuitCDF ("28.0", status, newVarName);
              hyperStep = hyper.recNumber;
              for (recX = 0; recX < hyper.recCount; recX++) {
                size_t offset = (size_t) (recX * nBytesPerRecord);
                if (srcRowMajor)
                  ROWtoCOL (buffer1 + offset, buffer2 + offset, numDims,
                            dimSizes, nBytes);
                else
                  COLtoROW (buffer1 + offset, buffer2 + offset, numDims,
                            dimSizes, nBytes);
              }
              status = CDFlib (SELECT_, CDF_, ido,
                                        zVAR_, varNum,
                               NULL_);
              if (status < CDF_OK) QuitCDF ("29.0", status, newVarName);
              hyper.recNumber = fromRec2;
              status = HYPER_WRITE (ido, TRUE, hyper, buffer2);
              if (status < CDF_OK) QuitCDF ("30.0", status, newVarName);
              hyper.recNumber = hyperStep;
              fromRec2 += hyper.recCount;
              IncrHyperParms (&hyper, &groups, numDims, srcRowMajor, &nValues);
            }
            cdf_FreeMemory (buffer1, FatalError);
            cdf_FreeMemory (buffer2, FatalError);
          } else {
            cdf_FreeMemory (buffer2, FatalError);
            InitHyperParms (&hyper, &groups, numDims, &nHypers, &nValues);
            hyper.recNumber = fromRec;
            for (hyperN = 0; hyperN < nHypers; hyperN++) {
              long indices[CDF_MAX_DIMS]; Byte *value = buffer1; long valueN;
              status = CDFlib (SELECT_, CDF_, ido,
                                        zVAR_, (long) ir,
                               NULL_);
              if (status < CDF_OK) QuitCDF ("31.0", status, newVarName);

              status = HYPER_READ (id, TRUE, hyper, buffer1);
              if (status < CDF_OK) QuitCDF ("32.0", status, newVarName);
              hyperStep = hyper.recNumber;
              hyper.recNumber = fromRec2;
              status = CDFlib (SELECT_, CDF_, ido,
                                        zVAR_, varNum,
                                        zVAR_RECNUMBER_, hyper.recNumber,
                               NULL_);
              if (status < CDF_OK) QuitCDF ("33.0", status, newVarName);
              for (dimN = 0; dimN < numDims; dimN++) 
                indices[dimN] = hyper.dimIndices[dimN];
              for (valueN = 0; valueN < nValues; valueN++) {
                status = CDFlib (SELECT_, zVAR_DIMINDICES_, indices,
                                 PUT_, zVAR_DATA_, value,
                                 NULL_);
                if (status < CDF_OK) QuitCDF ("34.0", status, newVarName);
                if (srcRowMajor)
                  INCRindicesROW (numDims, dimSizes, indices);
                else
                  INCRindicesCOL (numDims, dimSizes, indices);
                value += (size_t) nBytes;
              }
              hyper.recNumber = hyperStep;
              fromRec2 += hyper.recCount;
              IncrHyperParms (&hyper, &groups, numDims, srcRowMajor, &nValues);
            }    
            cdf_FreeMemory (buffer1, FatalError);
          }
        } else { 
          AllocateBuffers (nRecords, numDims, dimSizes, &groups, 0, 1, handles,
                           nValueBytes, srcRowMajor, 5, FatalError);
          InitHyperParms (&hyper, &groups, numDims, &nHypers, &nValues);
          hyper.recNumber = fromRec;
          for (hyperN = 0; hyperN < nHypers; hyperN++) {
            status = CDFlib (SELECT_, CDF_, id,
                                      zVAR_, (long) ir,
                             NULL_);
            if (status < CDF_OK) QuitCDF ("35.0", status, newVarName);
            status = HYPER_READ (id, TRUE, hyper, buffer1);
            if (status < CDF_OK) QuitCDF ("36.0", status, newVarName);
            hyperStep = hyper.recNumber;
            status = CDFlib (SELECT_, CDF_, ido,
                                      zVAR_, varNum,
                             NULL_);
            if (status < CDF_OK) QuitCDF ("37.0", status, newVarName);
            hyper.recNumber = fromRec2;
            status = HYPER_WRITE (ido, TRUE, hyper, buffer1);
            if (status < CDF_OK) QuitCDF ("38.0", status, newVarName);
            hyper.recNumber = hyperStep;
            fromRec2 += hyper.recCount;
            IncrHyperParms (&hyper, &groups, numDims, srcRowMajor, &nValues);
          }      
          cdf_FreeMemory (buffer1, FatalError);
        } /* switchmajority */

      } /* recNum */

    }  /* zVars */
 
    status = CDFlib (SELECT_, CDF_, id,
                     CLOSE_, CDF_,
                     NULL_);
    if (status < CDF_OK) QuitCDF ("39.0", status, NULL);

    if (mLog) printf ("  Variable data from source file: %d added...\n", 
                      (icount+1));

  } /* files */

  for (i = 0; i < numCDFs; i++) {
     if (CDFpaths[i] != NULL) cdf_FreeMemory (CDFpaths[i], FatalError);
  }
  if (CDFpaths != NULL) cdf_FreeMemory (CDFpaths, FatalError);

  if (numTokens != 0) {
    for (i = 0; i < numCDFs; i++) 
      if (prefixes[i] != NULL) cdf_FreeMemory (prefixes[i], FatalError);
    cdf_FreeMemory (prefixes, FatalError);
  }

  status = CDFlib (SELECT_, CDF_, ido,
                   CLOSE_, CDF_, 
                   NULL_);
  if (status < CDF_OK) QuitCDF ("40.0", status, NULL);

  if (mLog) printf ("  Done!\n");

  exit(1);

}

/******************************************************************************
* ModifyName.
******************************************************************************/

void ModifyName (inName, numTokens, prefixes, index, outName)
char *inName;
int  numTokens;
char *prefixes[];
int   index;
char *outName;
{
  char temp[CDF_VAR_NAME_LEN256+1];
  MakeNUL (temp);
  if (numTokens != 0) 
    sprintf (temp, "%s_", prefixes[index]);
  else
    sprintf (temp, "file%d_", (index+1)); 
  sprintf (EofS(temp), "%s", inName);
  strcpyX (outName, temp, 0);
}

/******************************************************************************
* ParseStringForVariables.
******************************************************************************/

void ParseStringForVariables (numTokens, prefixes, index, numVars, varNames, 
                              string1, newValue, changed)
int  numTokens;
char *prefixes[];
int  index;
int  numVars;
char *varNames[];
char *string1;
char *newValue;
Logical *changed;
{
  int  i; 
  char *ptr1, *ptr2, terminator;
  char *tmp, *tmp2, *outName;
  Logical first, found;

  *changed = FALSE;
  /****************************************************************************
  * Check that the entered string is not a NUL string, that there are
  * some possible tokens to match, etc.
  ****************************************************************************/
  if (NULstring(string1)) {
    return;     /* Obviously, no character were found. */
  }    
  /****************************************************************************
  * Scan the entered string of tokens searching for matches with the token.
  * First determine the starting character position and the * ending delimiter.
  ****************************************************************************/
  terminator = NUL;
  ptr1 = string1;
  first = TRUE;
  for (;;) {
     /*************************************************************************
     * Find beginning of the next token in list (skipping past any leading
     * blanks).  If the end of the list is reached instead, then there are
     * no more tokens.
     *************************************************************************/
     ptr2 = strstr (ptr1, "=");
     if (ptr2 == NULL) break;
     if (first) {
       first = FALSE;
       strcpyX (newValue, ptr1, (ptr2-ptr1+1));
     } else
       strcpyX (EofS(newValue), ptr1, (ptr2-ptr1+1));
     ptr1 = ptr2;
     /*************************************************************************
     * Assume ',', '(', ' ' or end of line is the terminator for the field
     * value.
     *************************************************************************/
     while (*ptr1 != ',' && *ptr1 != '(' && *ptr1 != ' ' && *ptr1 != terminator) 
       ptr1++;
     tmp = (char *) cdf_AllocateMemory (ptr1-ptr2, FatalError);
     strcpyX (tmp, ptr2+1, (ptr1-ptr2-1));
     found = FALSE;
     for (i = 0; i < numVars; i++) {
       if (!strcmp(tmp, varNames[i])) {
         found = TRUE;
         break;
       }
     }
     if (found) {
       outName = (char *) cdf_AllocateMemory (strlen(tmp)+50, FatalError);
       ModifyName (tmp, numTokens, prefixes, index, outName);
       strcpyX (EofS(newValue), outName, strlen(outName));
       cdf_FreeMemory (outName, FatalError);
       *changed = TRUE;
     } else 
       strcpyX (EofS(newValue), tmp, strlen(tmp));
     cdf_FreeMemory (tmp, FatalError);
     if (*ptr1 == terminator) break;
  }
  if (*ptr1 != terminator) {
    if (first)
      strcpyX (newValue, ptr1, strlen(ptr1));
    else
      strcpyX (EofS(newValue), ptr1, strlen(ptr1));
  }
}

/******************************************************************************
* QuitCDF.
******************************************************************************/

void QuitCDF (where, status, msg)
char *where;
CDFstatus status;
char *msg;
{
  char text[CDF_STATUSTEXT_LEN+1];
  printf ("Aborting at %s...\n", where);
  if (status < CDF_OK) {
    CDFlib (SELECT_, CDF_STATUS_, status,
            GET_, STATUS_TEXT_, text,
            NULL_);
    printf ("%s ", text);
    if (msg != NULL) printf ("(%s)\n", msg);
    else printf("\n");
  }
  if (id != 0)
    CDFlib (SELECT_, CDF_, id,
            CLOSE_, CDF_,
            NULL_);
  if (ido != 0)
    CDFlib (SELECT_, CDF_, ido,
            CLOSE_, CDF_,
            NULL_);

  printf ("\n");
  exit (EXIT_FAILURE_);
}


