/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class CopyVariableAction
extends AbstractAction {
    private static final String DEFAULT_NAME = "Copy Variable";
    private MYEditor myEditor;

    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        Variable variable = this.myEditor.variablePanel.getSelectedVar();
        if (variable == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, "No variable selected", "MYEditor: Error", 0);
        } else {
            String string = ((Object)variable).toString();
            String string2 = JOptionPane.showInputDialog(this.myEditor, "Enter new variable name", "Copy Variable: " + string, 3);
            if (string2 != null) {
                try {
                    Variable variable2 = variable.duplicate(string2);
                    this.myEditor.variablePanel.addToListOfVariables(variable2.getName());
                    this.myEditor.variablePanel.reselectCurrentVariable();
                    this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    if (this.myEditor.vAttrPanel.getSelectedAttr() != null) {
                        this.myEditor.vAttrPanel.updateAttrPanel(this.myEditor.vAttrPanel.getSelectedAttr(), true);
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor, "CDF Error:\n" + CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFException", 0);
                }
            }
        }
        this.myEditor.setDefaultCursor();
    }

    public CopyVariableAction(MYEditor mYEditor) {
        this(mYEditor, DEFAULT_NAME);
    }

    public CopyVariableAction(MYEditor mYEditor, String string) {
        super(string);
        this.myEditor = mYEditor;
    }
}

