/******************************************************************************
*
*  NSSDC/CDF                            CDF Standard Interface (III) /FORTRAN.
*
*  Version 3.1, 26-May-05, Raytheon ITSS.
*
*  Modification history:
*
*   V1.0  26-May-05, M Liu      Original version (for CDF V3.1).
*
******************************************************************************/

/******************************************************************************
*    This is the third part of the extended FORTRAN interfaces.
******************************************************************************/

#include "cdflib.h"
static CDFid currentCDFid = NULL;

/******************************************************************************
*  CDF_confirm_attr_existence.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_attr_existence__,
               cdf_confirm_attr_existence_,
               cdf_confirm_attr_existence,
               CDF_CONFIRM_ATTR_EXISTENCE)
(id, attr_name Fif_GHOSTARG(len))
Int32     *id;                  /* In: CDF identifier. */
void      *attr_name;           /* In: Attribute name. */
Fif_GHOSTDEF(len)               /* Invisible length of "attr_name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                           CONFIRM_, ATTR_EXISTENCE_,
#if defined(Fif_DESCR)
                                      DESCRtoREFnul(attr_name,
                                                    CDF_ATTR_NAME_LEN256,
                                                    &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                      NULterminate(attr_name,Fif_GHOSTUSE(len),
                                                   &ssh),
#endif
#if defined(Fif_NOLEN)
                                      FindEndNUL(attr_name,
                                                 CDF_ATTR_NAME_LEN256,
                                                 &ssh),
#endif
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_rvar_existence.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_rvar_existence__,
               cdf_confirm_rvar_existence_,
               cdf_confirm_rvar_existence,
               CDF_CONFIRM_RVAR_EXISTENCE)
(id, var_name Fif_GHOSTARG(len))
Int32     *id;                  /* In: CDF identifier. */
void      *var_name;            /* In: rVariable name. */
Fif_GHOSTDEF(len)               /* Invisible length of "var_name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                           CONFIRM_, rVAR_EXISTENCE_,
#if defined(Fif_DESCR)
                                      DESCRtoREFnul(var_name,
                                                    CDF_VAR_NAME_LEN256,
                                                    &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                      NULterminate(var_name,Fif_GHOSTUSE(len),
                                                   &ssh),
#endif
#if defined(Fif_NOLEN)
                                      FindEndNUL(var_name,
                                                 CDF_VAR_NAME_LEN256,
                                                 &ssh),
#endif
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_zvar_existence.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_zvar_existence__,
               cdf_confirm_zvar_existence_,
               cdf_confirm_zvar_existence,
               CDF_CONFIRM_ZVAR_EXISTENCE)
(id, var_name Fif_GHOSTARG(len))
Int32     *id;                  /* In: CDF identifier. */
void      *var_name;            /* In: zVariable name. */
Fif_GHOSTDEF(len)               /* Invisible length of "var_name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                           CONFIRM_, zVAR_EXISTENCE_,
#if defined(Fif_DESCR)
                                      DESCRtoREFnul(var_name,
                                                    CDF_VAR_NAME_LEN256,
                                                    &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                      NULterminate(var_name,Fif_GHOSTUSE(len),
                                                   &ssh),
#endif
#if defined(Fif_NOLEN)
                                      FindEndNUL(var_name,
                                                 CDF_VAR_NAME_LEN256,
                                                 &ssh),
#endif
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_gentry_existence.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_gentry_existence__,
               cdf_confirm_gentry_existence_,
               cdf_confirm_gentry_existence,
               CDF_CONFIRM_GENTRY_EXISTENCE)
(id, attr_num, entry_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *entry_num;           /* In: gEntry number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    ATTR_, (long) (*attr_num - 1),
                           CONFIRM_, gENTRY_EXISTENCE_,
                                                     (long) (*entry_num - 1),
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_rentry_existence.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_rentry_existence__,
               cdf_confirm_rentry_existence_,
               cdf_confirm_rentry_existence,
               CDF_CONFIRM_RENTRY_EXISTENCE)
(id, attr_num, entry_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *entry_num;           /* In: rEntry number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    ATTR_, (long) (*attr_num - 1),
                           CONFIRM_, rENTRY_EXISTENCE_,
                                                     (long) (*entry_num - 1),
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_zentry_existence.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_zentry_existence__,
               cdf_confirm_zentry_existence_,
               cdf_confirm_zentry_existence,
               CDF_CONFIRM_ZENTRY_EXISTENCE)
(id, attr_num, entry_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *entry_num;           /* In: zEntry number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    ATTR_, (long) (*attr_num - 1),
                           CONFIRM_, zENTRY_EXISTENCE_,
                                                     (long) (*entry_num - 1),
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_cur_gentry_exist.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_cur_gentry_exist__,
               cdf_confirm_cur_gentry_exist_,
               cdf_confirm_cur_gentry_exist,
               CDF_CONFIRM_CUR_GENTRY_EXIST)
(id, attr_num, entry_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *entry_num;           /* In: gEntry number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    ATTR_, (long) (*attr_num - 1),
                                    gENTRY_, (long) (*entry_num - 1),
                           CONFIRM_, CURgENTRY_EXISTENCE_,
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_cur_rentry_exist.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_cur_rentry_exist__,
               cdf_confirm_cur_rentry_exist_,
               cdf_confirm_cur_rentry_exist,
               CDF_CONFIRM_CUR_RENTRY_EXIST)
(id, attr_num, entry_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *entry_num;           /* In: rEntry number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    ATTR_, (long) (*attr_num - 1),
                                    rENTRY_, (long) (*entry_num - 1),
                           CONFIRM_, CURrENTRY_EXISTENCE_,
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_cur_zentry_exist.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_cur_zentry_exist__,
               cdf_confirm_cur_zentry_exist_,
               cdf_confirm_cur_zentry_exist,
               CDF_CONFIRM_CUR_ZENTRY_EXIST)
(id, attr_num, entry_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *entry_num;           /* In: zEntry number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    ATTR_, (long) (*attr_num - 1),
                                    zENTRY_, (long) (*entry_num - 1),
                           CONFIRM_, CURzENTRY_EXISTENCE_,
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_rvar_padvalue_exist.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_rvar_padvalue_exist__,
               cdf_confirm_rvar_padvalue_exist_,
               cdf_confirm_rvar_padvalue_exist,
               CDF_CONFIRM_RVAR_PADVALUE_EXIST)
(id, var_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: rVariable number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    rVAR_, (long) (*var_num - 1),
                           CONFIRM_, rVAR_PADVALUE_,
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_confirm_zvar_padvalue_exist.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
Int32
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_confirm_zvar_padvalue_exist__,
               cdf_confirm_zvar_padvalue_exist_,
               cdf_confirm_zvar_padvalue_exist,
               CDF_CONFIRM_ZVAR_PADVALUE_EXIST)
(id, var_num)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
{
  Int32 status;

  status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                    zVAR_, (long) (*var_num - 1),
                           CONFIRM_, zVAR_PADVALUE_,
                           NULL_);

  return status;
}

/******************************************************************************
*  CDF_select_current_cdf.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_cdf__,
               cdf_select_current_cdf_,
               cdf_select_current_cdf,
               CDF_SELECT_CURRENT_CDF)
(id, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_attr.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_attr__,
               cdf_select_current_attr_,
               cdf_select_current_attr,
               CDF_SELECT_CURRENT_ATTR)
(id, attr_num, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_attr_byname.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_attr_byname__,
               cdf_select_current_attr_byname_,
               cdf_select_current_attr_byname,
               CDF_SELECT_CURRENT_ATTR_BYNAME)
(id, attr_name, status Fif_GHOSTARG(len))
Int32     *id;                  /* In: CDF identifier. */
void      *attr_name;           /* In: Attribute name. */
Int32     *status;              /* Out: CDF status code. */
Fif_GHOSTDEF(len)               /* Invisible length of "attr_name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_NAME_,
#if defined(Fif_DESCR)
                                              DESCRtoREFnul(attr_name,
                                                        CDF_ATTR_NAME_LEN256,
                                                            &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                              NULterminate(attr_name,
                                                           Fif_GHOSTUSE(len),
                                                           &ssh),
#endif
#if defined(Fif_NOLEN)
                                              FindEndNUL(attr_name,
                                                         CDF_ATTR_NAME_LEN256,
                                                         &ssh),
#endif
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_rvar.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_rvar__,
               cdf_select_current_rvar_,
               cdf_select_current_rvar,
               CDF_SELECT_CURRENT_RVAR)
(id, var_num, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: rVariable number. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_rvar_byname.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_rvar_byname__,
               cdf_select_current_rvar_byname_,
               cdf_select_current_rvar_byname,
               CDF_SELECT_CURRENT_RVAR_BYNAME)
(id, var_name, status Fif_GHOSTARG(len))
Int32     *id;                  /* In: CDF identifier. */
void      *var_name;            /* In: rVariable name. */
Int32     *status;              /* Out: CDF status code. */
Fif_GHOSTDEF(len)               /* Invisible length of "var_name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_NAME_,
#if defined(Fif_DESCR)
                                              DESCRtoREFnul(var_name,
                                                        CDF_VAR_NAME_LEN256,
                                                            &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                              NULterminate(var_name,
                                                           Fif_GHOSTUSE(len),
                                                           &ssh),
#endif
#if defined(Fif_NOLEN)
                                              FindEndNUL(var_name,
                                                         CDF_VAR_NAME_LEN256,
                                                         &ssh),
#endif
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_zvar.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_zvar__,
               cdf_select_current_zvar_,
               cdf_select_current_zvar,
               CDF_SELECT_CURRENT_ZVAR)
(id, var_num, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_zvar_byname.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_zvar_byname__,
               cdf_select_current_zvar_byname_,
               cdf_select_current_zvar_byname,
               CDF_SELECT_CURRENT_RVAR_BYNAME)
(id, var_name, status Fif_GHOSTARG(len))
Int32     *id;                  /* In: CDF identifier. */
void      *var_name;            /* In: zVariable name. */
Int32     *status;              /* Out: CDF status code. */
Fif_GHOSTDEF(len)               /* Invisible length of "var_name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_NAME_,
#if defined(Fif_DESCR)
                                              DESCRtoREFnul(var_name,
                                                        CDF_VAR_NAME_LEN256,
                                                            &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                              NULterminate(var_name,
                                                           Fif_GHOSTUSE(len),
                                                           &ssh),
#endif
#if defined(Fif_NOLEN)
                                              FindEndNUL(var_name,
                                                         CDF_VAR_NAME_LEN256,
                                                         &ssh),
#endif
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_rvars_recnumber.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_recnumber__,
               cdf_set_rvars_recnumber_,
               cdf_set_rvars_recnumber,
               CDF_SET_RVARS_RECNUMBER)
(id, rec_num, status)
Int32     *id;              /* In: CDF identifier. */
Int32     *rec_num;         /* In: Current record number for all rVariables. */
Int32     *status;          /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_RECNUMBER_, (long) (*rec_num - 1),
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_recnumber.
******************************************************************************/
VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_recnumber__,
               cdf_set_zvar_recnumber_,
               cdf_set_zvar_recnumber,
               CDF_SET_ZVAR_RECNUMBER)
(id, var_num, rec_num, status)
Int32     *id;            /* In: CDF identifier. */
Int32     *var_num;       /* In: Current zVariable number. */
Int32     *rec_num;       /* In: Current record number for cur. zVariable. */
Int32     *status;        /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                                     zVAR_RECNUMBER_, (long) (*rec_num - 1),
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvars_reccount.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_reccount__,
               cdf_set_rvars_reccount_,
               cdf_set_rvars_reccount,
               CDF_SET_RVARS_RECCOUNT)
(id, rec_count, status)
Int32     *id;               /* In: CDF identifier. */
Int32     *rec_count;        /* In: Current record count for all rVariables. */
Int32     *status;           /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_RECCOUNT_, (long) *rec_count,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_reccount.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_reccount__,
               cdf_set_zvar_reccount_,
               cdf_set_zvar_reccount,
               CDF_SET_ZVAR_RECCOUNT)
(id, var_num, rec_count, status)
Int32     *id;            /* In: CDF identifier. */
Int32     *var_num;       /* In: Current zVariable number. */
Int32     *rec_count;     /* In: Current record count for cur. zVariable. */
Int32     *status;        /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                                     zVAR_RECCOUNT_, (long) *rec_count,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvars_recinterval.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_recinterval__,
               cdf_set_rvars_recinterval_,
               cdf_set_rvars_recinterval,
               CDF_SET_RVARS_RECINTERVAL)
(id, rec_interval, status)
Int32     *id;             /* In: CDF identifier. */
Int32     *rec_interval;   /* In: Current record interval for all rVariables. */
Int32     *status;         /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_RECNUMBER_, (long) *rec_interval,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_recinterval.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_recinterval__,
               cdf_set_zvar_recinterval_,
               cdf_set_zvar_recinterval,
               CDF_SET_ZVAR_RECINTERVAL)
(id, var_num, rec_interval, status)
Int32     *id;            /* In: CDF identifier. */
Int32     *var_num;       /* In: Current zVariable number. */
Int32     *rec_interval;  /* In: Current record interval for cur. zVariable. */
Int32     *status;        /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                                     zVARs_RECNUMBER_, (long) *rec_interval,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvars_dimindices.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_dimindices__,
               cdf_set_rvars_dimindices_,
               cdf_set_rvars_dimindices,
               CDF_SET_RVARS_DIMINDICES)
(id, dim_indices, status)
Int32     *id;             /* In: CDF identifier. */
Int32     dim_indices[];   /* In: Current dim indices for all rVariables. */
Int32     *status;         /* Out: CDF status code. */
{
  long numDims, dimIndices[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  for (ix = 0; ix < (int) numDims; ix++)
     dimIndices[ix] = (long) (dim_indices[ix] - 1);

  *status = (Int32) CDFlib (SELECT_, rVARs_DIMINDICES_, dimIndices,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_dimindices.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_dimindices__,
               cdf_set_zvar_dimindices_,
               cdf_set_zvar_dimindices,
               CDF_SET_ZVAR_DIMINDICES)
(id, var_num, dim_indices, status)
Int32     *id;             /* In: CDF identifier. */
Int32     *var_num;        /* In: Current zVariable number. */
Int32     dim_indices[];   /* In: Current dim indices for cur. zVariable. */
Int32     *status;         /* Out: CDF status code. */
{

  long numDims, dimIndices[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  for (ix = 0; ix < (int) numDims; ix++)
     dimIndices[ix] = (long) (dim_indices[ix] - 1);

  *status = (Int32) CDFlib (SELECT_, zVAR_DIMINDICES_, dimIndices,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvars_dimcounts.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_dimcounts__,
               cdf_set_rvars_dimcounts_,
               cdf_set_rvars_dimcounts,
               CDF_SET_RVARS_DIMCOUNTS)
(id, dim_counts, status)
Int32     *id;             /* In: CDF identifier. */
Int32     dim_counts[];    /* In: Current dim counts for all rVariables. */
Int32     *status;         /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_DIMCOUNTS_, dim_counts,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_dimcounts.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_dimcounts__,
               cdf_set_zvar_dimcounts_,
               cdf_set_zvar_dimcounts,
               CDF_SET_ZVAR_DIMCOUNTS)
(id, var_num, dim_counts, status)
Int32     *id;             /* In: CDF identifier. */
Int32     *var_num;        /* In: Current zVariable number. */
Int32     dim_counts[];    /* In: Current dim counts for cur. zVariable. */
Int32     *status;         /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                                     zVAR_DIMCOUNTS_, dim_counts,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvars_dimintervals.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_dimintervals__,
               cdf_set_rvars_dimintervals_,
               cdf_set_rvars_dimintervals,
               CDF_SET_RVARS_DIMINTERVALS)
(id, dim_intervals, status)
Int32     *id;             /* In: CDF identifier. */
Int32     dim_intervals[]; /* In: Current dim intervals for all rVariables. */
Int32     *status;         /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_DIMINTERVALS_, dim_intervals,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_dimintervals.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_dimintervals__,
               cdf_set_zvar_dimintervals_,
               cdf_set_zvar_dimintervals,
               CDF_SET_ZVAR_DIMINTERVALS)
(id, var_num, dim_intervals, status)
Int32     *id;             /* In: CDF identifier. */
Int32     *var_num;        /* In: Current zvariable number. */
Int32     dim_intervals[]; /* In: Current dim intervals for cur. zvariable. */
Int32     *status;         /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                                     zVAR_DIMINTERVALS_, dim_intervals,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_select_current_gentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_gentry__,
               cdf_select_current_gentry_,
               cdf_select_current_gentry,
               CDF_SELECT_CURRENT_GENTRY)
(id, entry_num, status)
Int32     *id;                  /* In: cdf identifier. */
Int32     *entry_num;           /* In: gentry number. */
Int32     *status;              /* Out: cdf status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     gENTRY_, (long) (*entry_num - 1),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_rentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_rentry__,
               cdf_select_current_rentry_,
               cdf_select_current_rentry,
               CDF_SELECT_CURRENT_RENTRY)
(id, entry_num, status)
Int32     *id;                  /* In: cdf identifier. */
Int32     *entry_num;           /* In: gentry number. */
Int32     *status;              /* Out: cdf status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rENTRY_, (long) (*entry_num - 1),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_select_current_zentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_select_current_zentry__,
               cdf_select_current_zentry_,
               cdf_select_current_zentry,
               CDF_SELECT_CURRENT_ZENTRY)
(id, entry_num, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *entry_num;           /* In: zEntry number. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zENTRY_, (long) (*entry_num - 1),
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_decoding.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_decoding__,
               cdf_set_decoding_,
               cdf_set_decoding,
               CDF_SET_DECODING)
(id, decoding, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *decoding;            /* In: CDF decoding. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     CDF_DECODING_, (long) *decoding,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_readonly_mode.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_readonly_mode__,
               cdf_set_readonly_mode_,
               cdf_set_readonly_mode,
               CDF_SET_READONLY_MODE)
(id, mode, status)
Int32     *id;                  /* in: cdf identifier. */
Int32     *mode;                /* in: cdf readonly mode. */
Int32     *status;              /* out: cdf status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     CDF_READONLY_MODE_, (long) *mode,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_negtoposfp0_mode.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_negtoposfp0_mode__,
               cdf_set_negtoposfp0_mode_,
               cdf_set_negtoposfp0_mode,
               CDF_SET_NEGTOPOSFP0_MODE)
(id, mode, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *mode;                /* In: CDF negtoposfp0 mode. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     CDF_NEGtoPOSfp0_MODE_, (long) *mode,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_compress_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_compress_cachesize__,
               cdf_set_compress_cachesize_,
               cdf_set_compress_cachesize,
               CDF_SET_COMPRESS_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* In: CDF compress cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     COMPRESS_CACHESIZE_, (long) *cache_size,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_stage_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_stage_cachesize__,
               cdf_set_stage_cachesize_,
               cdf_set_stage_cachesize,
               CDF_SET_STAGE_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* In: CDF stage cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     STAGE_CACHESIZE_, (long) *cache_size,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_rvar_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_cachesize__,
               cdf_set_rvar_cachesize_,
               cdf_set_rvar_cachesize,
               CDF_SET_RVAR_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: cdf identifier. */
Int32     *cache_size;          /* In: cdf rVariable cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_CACHESIZE_, (long) *cache_size,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_zvar_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_cachesize__,
               cdf_set_zvar_cachesize_,
               cdf_set_zvar_cachesize,
               CDF_SET_ZVAR_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* In: CDF zVariable cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_CACHESIZE_, (long) *cache_size,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_rvars_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvars_cachesize__,
               cdf_set_rvars_cachesize_,
               cdf_set_rvars_cachesize,
               CDF_SET_RVARs_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* In: CDF rVariables's cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_CACHESIZE_, (long) *cache_size,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_zvars_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvars_cachesize__,
               cdf_set_zvars_cachesize_,
               cdf_set_zvars_cachesize,
               CDF_SET_ZVARS_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* In: CDF zVariables's cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVARs_CACHESIZE_, (long) *cache_size,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_rvar_seqpos.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_seqpos__,
               cdf_set_rvar_seqpos_,
               cdf_set_rvar_seqpos,
               CDF_SET_RVAR_SEQPOS)
(id, var_num, rec_num, indices, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF rVariable number. */
Int32     *rec_num;             /* In: CDF rVariable record number. */
Int32     indices[];            /* In: CDF rVariable indices. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, indicesT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);

  if (StatusBAD(*status)) return;

  for (ix = 0; ix < (int) numDims; ix++)
     indicesT[ix] = (long) (indices[ix] - 1);
  *status = (Int32) CDFlib (SELECT_, rVAR_SEQPOS_, (long) (*rec_num -1),
                                                   indicesT,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_zvar_seqpos.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_seqpos__,
               cdf_set_zvar_seqpos_,
               cdf_set_zvar_seqpos,
               CDF_SET_ZVAR_SEQPOS)
(id, var_num, rec_num, indices, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF zVariable number. */
Int32     *rec_num;             /* In: CDF zVariable record number. */
Int32     indices[];            /* In: CDF zVariable indices. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, indicesT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);

  if (StatusBAD(*status)) return;

  for (ix = 0; ix < (int) numDims; ix++)
     indicesT[ix] = (long) (indices[ix] - 1);
  *status = (Int32) CDFlib (SELECT_, zVAR_SEQPOS_, (long) (*rec_num -1),
                                                   indicesT,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_rvar_reservepercent.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_reservepercent__,
               cdf_set_rvar_reservepercent_,
               cdf_set_rvar_reservepercent,
               CDF_SET_RVAR_RESERVEPERCENT)
(id, var_num, percent, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF rVariable number. */
Int32     *percent;             /* In: CDF rVariable reserve percentage. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                                     rVAR_RESERVEPERCENT_, (long) *percent,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_zvar_reservepercent.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_reservepercent__,
               cdf_set_zvar_reservepercent_,
               cdf_set_zvar_reservepercent,
               CDF_SET_ZVAR_RESERVEPERCENT)
(id, var_num, percent, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF zVariable number. */
Int32     *percent;             /* In: CDF zVariable reserve percentage. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                                     zVAR_RESERVEPERCENT_, (long) *percent,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_zmode.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zmode__,
               cdf_set_zmode_,
               cdf_set_zmode,
               CDF_SET_ZMODE)
(id, mode, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *mode;                /* In: CDF zMode. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     CDF_zMODE_, (long) *mode,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_attr_scope.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_attr_scope__,
               cdf_set_attr_scope_,
               cdf_set_attr_scope,
               CDF_SET_ATTR_SCOPE)
(id, attr_num, attr_scope, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *attr_scope;          /* In: Attribute scope. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            PUT_, ATTR_SCOPE_, (long) *attr_scope,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_set_attr_gentry_dataspec.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_attr_gentry_dataspec__,
	       cdf_set_attr_gentry_dataspec_,
	       cdf_set_attr_gentry_dataspec,
	       CDF_SET_ATTR_GENTRY_DATASPEC)
(id, attr_num, entry_num, data_type, num_elems, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: gEntry number. */
Int32     *data_type;           /* In: Data Type. */
Int32     *num_elems;           /* Int: Number of elements. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     gENTRY_, (long) (*entry_num - 1),
                            PUT_,    gENTRY_DATASPEC_, (long) data_type,
                                                       (long) num_elems,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_set_attr_rentry_dataspec.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_attr_rentry_dataspec__,
	       cdf_set_attr_rentry_dataspec_,
	       cdf_set_attr_rentry_dataspec,
	       CDF_SET_ATTR_RENTRY_DATASPEC)
(id, attr_num, entry_num, data_type, num_elems, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: rEntry number. */
Int32     *data_type;           /* In: Data Type. */
Int32     *num_elems;           /* Int: Number of elements. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     rENTRY_, (long) (*entry_num - 1),
                            PUT_,    rENTRY_DATASPEC_, (long) data_type,
                                                       (long) num_elems,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_set_attr_zentry_dataspec.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_attr_zentry_dataspec__,
	       cdf_set_attr_zentry_dataspec_,
	       cdf_set_attr_zentry_dataspec,
	       CDF_SET_ATTR_ZENTRY_DATASPEC)
(id, attr_num, entry_num, data_type, num_elems, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: zEntry number. */
Int32     *data_type;           /* In: Data Type. */
Int32     *num_elems;           /* Int: Number of elements. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     zENTRY_, (long) (*entry_num - 1),
                            PUT_,    zENTRY_DATASPEC_, (long) data_type,
                                                       (long) num_elems,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_set_compression.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_compression__,
               cdf_set_compression_,
               cdf_set_compression,
               CDF_SET_COMPRESSION)
(id, compress_type, compress_parms, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *compress_type;	/* In: CDF Compression type. */
Int32     compress_parms[];  	/* In: CDF Compression parameters. */
Int32     *status;              /* Out: CDF status code. */
{
  long cType, cParms[CDF_MAX_PARMS];
  int ix;

  cType = (long) *compress_type;
  for (ix = 0; ix < CDF_MAX_PARMS; ix++)
     cParms[ix] = (long) compress_parms[ix];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            PUT_, CDF_COMPRESSION_, cType, cParms,
		            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_encoding.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_encoding__,
               cdf_set_encoding_,
               cdf_set_encoding,
               CDF_SET_ENCODING)
(id, encoding, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *encoding;		/* In: CDF encoding. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            PUT_, CDF_ENCODING_, (long) *encoding,
		            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_format.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_format__,
               cdf_set_format_,
               cdf_set_format,
               CDF_SET_FORMAT)
(id, format, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *format;		/* In: CDF format. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            PUT_, CDF_FORMAT_, (long) *format,
		            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_majority.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_majority__,
               cdf_set_majority_,
               cdf_set_majority,
               CDF_SET_MAJORITY)
(id, majority, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *majority;		/* In: CDF majority. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            PUT_, CDF_MAJORITY_, (long) *majority,
		            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_cachesize__,
               cdf_set_cachesize_,
               cdf_set_cachesize,
               CDF_SET_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* In: CDF cache size. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     CDF_CACHESIZE_, (long) *cache_size,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_dataspec.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_dataspec__,
               cdf_set_rvar_dataspec_,
               cdf_set_rvar_dataspec,
               CDF_SET_RVAR_DATASPEC)
(id, var_num, data_type, num_elems, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *data_type;   /* In: rVariable's data type. */
Int32     *num_elems;   /* In: rVariable's number of elements. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_DATASPEC_, (long) *data_type,
                                                  (long) *num_elems,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_dataspec.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_dataspec__,
               cdf_set_zvar_dataspec_,
               cdf_set_zvar_dataspec,
               CDF_SET_ZVAR_DATASPEC)
(id, var_num, data_type, num_elems, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *data_type;   /* In: zVariable's data type. */
Int32     *num_elems;   /* In: zVariable's number of elements. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_DATASPEC_, (long) *data_type,
                                                  (long) *num_elems,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_recvariance.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_recvariance__,
               cdf_set_rvar_recvariance_,
               cdf_set_rvar_recvariance,
               CDF_SET_RVAR_RECVARIANCE)
(id, var_num, rec_vary, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *rec_vary;    /* In: rVariable's record variance. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_RECVARY_, (long) *rec_vary,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_recvariance.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_recvariance__,
               cdf_set_zvar_recvariance_,
               cdf_set_zvar_recvariance,
               CDF_SET_ZVAR_RECVARIANCE)
(id, var_num, rec_vary, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *rec_vary;    /* In: zVariable's record variance. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_RECVARY_, (long) *rec_vary,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_dimvariances.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_dimvariances__,
               cdf_set_rvar_dimvariances_,
               cdf_set_rvar_dimvariances,
               CDF_SET_RVAR_DIMVARIANCES)
(id, var_num, dim_varys, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     dim_varys[];  /* In: rVariable's dimensional variances. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, dimVarys[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  for (ix = 0; ix < (int) numDims; ix++) dimVarys[ix] = (long) dim_varys[ix];
  *status = (Int32) CDFlib (PUT_, rVAR_DIMVARYS_, dimVarys,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_dimvariances.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_dimvariances__,
               cdf_set_zvar_dimvariances_,
               cdf_set_zvar_dimvariances,
               CDF_SET_ZVAR_DIMVARIANCES)
(id, var_num, dim_varys, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     dim_varys[];  /* In: zVariable's dimensional variances. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, dimVarys[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  for (ix = 0; ix < (int) numDims; ix++) dimVarys[ix] = (long) dim_varys[ix];
  *status = (Int32) CDFlib (PUT_, zVAR_DIMVARYS_, dimVarys,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_blockingfactor.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_blockingfactor__,
               cdf_set_rvar_blockingfactor_,
               cdf_set_rvar_blockingfactor,
               CDF_SET_RVAR_BLOCKINGFACTOR)
(id, var_num, blocking_factor, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *blocking_factor; /* In: rVariable's blocking factor. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_BLOCKINGFACTOR_,
                                                     (long) *blocking_factor,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_blockingfactor.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_blockingfactor__,
               cdf_set_zvar_blockingfactor_,
               cdf_set_zvar_blockingfactor,
               CDF_SET_ZVAR_BLOCKINGFACTOR)
(id, var_num, blocking_factor, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *blocking_factor; /* Out: zVariable's blocking factor. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_BLOCKINGFACTOR_,
                                                      (long) *blocking_factor,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_compression.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_compression__,
               cdf_set_rvar_compression_,
               cdf_set_rvar_compression,
               CDF_SET_RVAR_COMPRESSION)
(id, var_num, compress_type, compress_parms, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *compress_type; /* In: rVariable's compression type. */
Int32     compress_parms[]; /* In: rVariable's compression parameters. */
Int32     *status;      /* Out: CDF status code. */
{
  long cParms[CDF_MAX_PARMS];
  int ix;

  for (ix = 0; ix < CDF_MAX_PARMS; ix++)
    cParms[ix] = (long) compress_parms[ix];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_COMPRESSION_, (long) *compress_type,
                                                     cParms,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_compression.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_compression__,
               cdf_set_zvar_compression_,
               cdf_set_zvar_compression,
               CDF_SET_ZVAR_COMPRESSION)
(id, var_num, compress_type, compress_parms, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *compress_type;   /* In: zVariable's compression type. */
Int32     compress_parms[]; /* In: zVariable's compression parameters. */
Int32     *status;      /* Out: CDF status code. */
{
  long cParms[CDF_MAX_PARMS];
  int ix;

  for (ix = 0; ix < CDF_MAX_PARMS; ix++)
    cParms[ix] = (long) compress_parms[ix];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_COMPRESSION_, (long) *compress_type,
                                                     cParms,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_padvalue.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_padvalue__,
               cdf_set_rvar_padvalue_,
               cdf_set_rvar_padvalue,
               CDF_SET_RVAR_PADVALUE)
(id, var_num, pad_value, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
void      *pad_value;   /* In: rVariable's pad value. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (PUT_, rVAR_PADVALUE_,
#if defined(Fif_DESCR)
                                          BOO(STRINGdataType(dataType),
                                              DESCRtoREF(pad_value),pad_value),
#else
                                          pad_value,
#endif

                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_padvalue.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_padvalue__,
               cdf_set_zvar_padvalue_,
               cdf_set_zvar_padvalue,
               CDF_SET_ZVAR_PADVALUE)
(id, var_num, pad_value, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
void      *pad_value;   /* In: zVariable's pad value. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (PUT_, zVAR_PADVALUE_,
#if defined(Fif_DESCR)
                                          BOO(STRINGdataType(dataType),
                                              DESCRtoREF(pad_value),pad_value),
#else
                                          pad_value,
#endif

                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_sparserecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_sparserecords__,
               cdf_set_rvar_sparserecords_,
               cdf_set_rvar_sparserecords,
               CDF_SET_RVAR_SPARSERECORDS)
(id, var_num, sparse_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *sparse_records; /* In: rVariable's sparse records. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_SPARSERECORDS_, (long) *sparse_records,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_sparserecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_sparserecords__,
               cdf_set_zvar_sparserecords_,
               cdf_set_zvar_sparserecords,
               CDF_SET_ZVAR_SPARSERECORDS)
(id, var_num, sparse_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *sparse_records; /* In: zVariable's sparse records. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_SPARSERECORDS_, (long) *sparse_records,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_sparsearrays.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_sparsearrays__,
               cdf_set_rvar_sparsearrays_,
               cdf_set_rvar_sparsearrays,
               CDF_SET_RVAR_SPARSEARRAYS)
(id, var_num, sarrays_type, sarrays_parms, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *sarrays_type;   /* In: rVariable's sparse array type. */
Int32     sarrays_parms[]; /* In: rVariable's sparse array parameters. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, sArraysType, sArraysParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);

  if (StatusBAD(*status)) return;

  sArraysType = (long) *sarrays_type;
  for (ix = 0; ix < (int) numDims; ix++)
     sArraysParms[ix] = (long) sarrays_parms[ix];

  *status = (Int32) CDFlib (SELECT_, rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_SPARSEARRAYS_, sArraysType,
                                                      sArraysParms,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_sparsearrays.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_sparsearrays__,
               cdf_set_zvar_sparsearrays_,
               cdf_set_zvar_sparsearrays,
               CDF_SET_ZVAR_SPARSEARRAYS)
(id, var_num, sarrays_type, sarrays_parms, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *sarrays_type;   /* In: zVariable's sparse array type. */
Int32     sarrays_parms[]; /* In: zVariable's sparse array parameters. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, sArraysType, sArraysParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);

  if (StatusBAD(*status)) return;

  sArraysType = (long) *sarrays_type;
  for (ix = 0; ix < CDF_MAX_PARMS; ix++)
     sArraysParms[ix] = (long) sarrays_parms[ix];

  *status = (Int32) CDFlib (PUT_, zVAR_SPARSEARRAYS_, sArraysType,
                                                      sArraysParms,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_allocrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_allocrecords__,
               cdf_set_rvar_allocrecords_,
               cdf_set_rvar_allocrecords,
               CDF_SET_RVAR_ALLOCRECORDS)
(id, var_num, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *rec_num;     /* In: rVariables's allocated record number. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_ALLOCATERECS_, (long) *rec_num,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_allocrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_allocrecords__,
               cdf_set_zvar_allocrecords_,
               cdf_set_zvar_allocrecords,
               CDF_SET_ZVAR_ALLOCRECORDS)
(id, var_num, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *rec_num;     /* In: zVariables's allocated record number. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_ALLOCATERECS_, (long) *rec_num,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_allocblockrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_allocblockrecords__,
               cdf_set_rvar_allocblockrecords_,
               cdf_set_rvar_allocblockrecords,
               CDF_SET_RVAR_ALLOCBLOCKRECORDS)
(id, var_num, start_rec, end_rec, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *start_rec;   /* In: rVariables's allocated block start record no. */
Int32     *end_rec;     /* In: rVariables's allocated block end record no. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_ALLOCATEBLOCK_, (long) (*start_rec - 1),
                                                       (long) (*end_rec - 1),
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_allocblockrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_allocblockrecords__,
               cdf_set_zvar_allocblockrecords_,
               cdf_set_zvar_allocblockrecords,
               CDF_SET_ZVAR_ALLOCBLOCKRECORDS)
(id, var_num, start_rec, end_rec, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *start_rec;   /* In: zVariables's allocated block start record no. */
Int32     *end_rec;     /* In: zVariables's allocated block end record no. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_ALLOCATEBLOCK_, (long) (*start_rec - 1),
                                                       (long) (*end_rec - 1),
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_rvar_initialrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_rvar_initialrecords__,
               cdf_set_rvar_initialrecords_,
               cdf_set_rvar_initialrecords,
               CDF_SET_RVAR_INITIALRECORDS)
(id, var_num, num_rec, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *num_rec;     /* In: rVariables's initially allocated records. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            PUT_, rVAR_INITIALRECS_, (long) *num_rec,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_set_zvar_initialrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_set_zvar_initialrecords__,
               cdf_set_zvar_initialrecords_,
               cdf_set_zvar_initialrecords,
               CDF_SET_ZVAR_INITIALRECORDS)
(id, var_num, num_rec, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_rec;     /* In: zVariables's initially allocated records. */
Int32     *status;      /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            PUT_, zVAR_INITIALRECS_, (long) *num_rec,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_put_rvar_seqdata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_put_rvar_seqdata__,
               cdf_put_rvar_seqdata_,
               cdf_put_rvar_seqdata,
               CDF_PUT_RVAR_SEQDATA)
(id, var_num, data, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
void      *data;        /* In: CDF rVariable's data. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (PUT_, rVAR_SEQDATA_,
#if defined(Fif_DESCR)
                                              BOO(STRINGdataType(dataType),
                                                  DESCRtoREF(data),data),
#else
                                              data,
#endif

                            NULL_);

  return;
}

/******************************************************************************
*  CDF_put_zvar_seqdata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_put_zvar_seqdata__,
               cdf_put_zvar_seqdata_,
               cdf_put_zvar_seqdata,
               CDF_PUT_ZVAR_SEQDATA)
(id, var_num, data, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
void      *data;        /* In: CDF zVariable's data. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (PUT_, zVAR_SEQDATA_,
#if defined(Fif_DESCR)
                                              BOO(STRINGdataType(dataType),
                                                  DESCRtoREF(data),data),
#else
                                              data,
#endif

                            NULL_);

  return;
}

/******************************************************************************
*  CDF_put_rvar_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_put_rvar_recorddata__,
               cdf_put_rvar_recorddata_,
               cdf_put_rvar_recorddata,
               CDF_PUT_RVAR_RECORDDATA)
(id, var_num, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF rVariable number. */
Int32     *rec_num;             /* In: CDF rVariable record number. */
void      *buffer;              /* In: rVariable's full record data. */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars, varNums[CDF_MAX_DIMS];

  numVars = 1;
  varNums[0] = (long) (*var_num - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, id,
                                     rVARs_RECNUMBER_, (long) (*rec_num - 1),
                            PUT_, rVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_put_zvar_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_put_zvar_recorddata__,
               cdf_put_zvar_recorddata_,
               cdf_put_zvar_recorddata,
               CDF_PUT_ZVAR_RECORDDATA)
(id, var_num, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF zVariable number. */
Int32     *rec_num;             /* In: CDF zVariable record number. */
void      *buffer;              /* In: zVariable's full record data. */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars, varNums[CDF_MAX_DIMS];

  numVars = 1;
  varNums[0] = (long) (*var_num - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, id,
                                     zVAR_RECNUMBER_, (long) (*rec_num - 1),
                            PUT_, zVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_put_rvars_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_put_rvars_recorddata__,
               cdf_put_rvars_recorddata_,
               cdf_put_rvars_recorddata,
               CDF_PUT_RVARS_RECORDDATA)
(id, num_vars, var_nums, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *num_vars;            /* In: Number of rVariables. */
Int32     var_nums[];           /* In: rVariable numbers. */
Int32     *rec_num;             /* In: Record number. */
void      *buffer;              /* In: Buffer for output data */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars = (long) *num_vars;
  long recNum = (long) (*rec_num - 1);
  long varNums[CDF_MAX_DIMS];
  int ix;

  if (*num_vars < 1) {
    *status = (Int32) CDF_OK;
    return;
  }

  for (ix = 0; ix < *num_vars; ix++) varNums[ix] = (long) (var_nums[ix] - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_RECNUMBER_, (long) (*rec_num - 1),
                            PUT_, rVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_put_zvars_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_put_zvars_recorddata__,
               cdf_put_zvars_recorddata_,
               cdf_put_zvars_recorddata,
               CDF_PUT_ZVARS_RECORDDATA)
(id, num_vars, var_nums, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *num_vars;            /* In: Number of rVariables. */
Int32     var_nums[];           /* In: zVariable numbers. */
Int32     *rec_num;             /* In: Record number. */
void      *buffer;              /* In: Buffer for output data */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars = (long) *num_vars;
  long recNum = (long) (*rec_num - 1);
  long varNums[CDF_MAX_DIMS];
  int ix;

  if (*num_vars < 1) {
    *status = (Int32) CDF_OK;
    return;
  }

  for (ix = 0; ix < *num_vars; ix++) varNums[ix] = (long) (var_nums[ix] - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVARs_RECNUMBER_, (long) (*rec_num - 1),
                            PUT_, zVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);

  return;
}

