/******************************************************************************
*
*  NSSDC/CDF				CDF Standard Interface (II) /FORTRAN.
*
*  Version 3.1, 26-May-05, Raytheon ITSS.
*
*  Modification history:
*
*   V1.0  26-May-05, M Liu   	Original version (for CDF V3.1).
*
******************************************************************************/

/******************************************************************************
*    This is the second part of the extended FORTRAN interfaces.
******************************************************************************/

#include "cdflib.h"
static CDFid currentCDFid = NULL;

/******************************************************************************
*  CDF_delete_attr.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_attr__,
	       cdf_delete_attr_,
	       cdf_delete_attr,
	       CDF_DELETE_ATTR)
(id, attr_num, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
			    DELETE_, ATTR_,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_get_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_cachesize__,
               cdf_get_cachesize_,
               cdf_get_cachesize,
               CDF_GET_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* Out: CDF cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long cacheSize;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, CDF_CACHESIZE_, &cacheSize,
                            NULL_);
  if (StatusOK(*status)) *cache_size = (Int32) cacheSize;
  return;
}

/******************************************************************************
*  CDF_get_decoding.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_decoding__,
               cdf_get_decoding_,
               cdf_get_decoding,
               CDF_GET_DECODING)
(id, decoding, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *decoding;            /* Out: CDF decoding. */
Int32     *status;              /* Out: CDF status code. */
{
  long decodingT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, CDF_DECODING_, &decodingT,
                            NULL_);
  if (StatusOK(*status)) *decoding = (Int32) decodingT;
  return;
}

/******************************************************************************
*  CDF_get_negtoposfp0_mode.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_negtoposfp0_mode__,
               cdf_get_negtoposfp0_mode_,
               cdf_get_negtoposfp0_mode,
               CDF_GET_NEGTOPOSFP0_MODE)
(id, negtoposfp0, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *negtoposfp0;         /* Out: CDF NEGtoPOSfp0 mode. */
Int32     *status;              /* Out: CDF status code. */
{
  long negtoposfp0T;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, CDF_NEGtoPOSfp0_MODE_, &negtoposfp0T,
                            NULL_);
  if (StatusOK(*status)) *negtoposfp0 = (Int32) negtoposfp0T;
  return;
}

/******************************************************************************
*  CDF_get_readonly_mode.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_readonly_mode__,
               cdf_get_readonly_mode_,
               cdf_get_readonly_mode,
               CDF_GET_READONLY_MODE)
(id, readonlymode, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *readonlymode;        /* Out: CDF read only mode. */
Int32     *status;              /* Out: CDF status code. */
{
  long readOnlyModeT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, CDF_READONLY_MODE_, &readOnlyModeT,
                            NULL_);
  if (StatusOK(*status)) *readonlymode = (Int32) readOnlyModeT;
  return;
}

/******************************************************************************
*  CDF_get_zmode.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zmode__,
               cdf_get_zmode_,
               cdf_get_zmode,
               CDF_GET_ZMODE)
(id, zmode, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *zmode;               /* Out: CDF zMode. */
Int32     *status;              /* Out: CDF status code. */
{
  long zModeT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, CDF_zMODE_, &zModeT,
                            NULL_);
  if (StatusOK(*status)) *zmode = (Int32) zModeT;
  return;
}

/******************************************************************************
*  CDF_get_compress_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_compress_cachesize__,
               cdf_get_compress_cachesize_,
               cdf_get_compress_cachesize,
               CDF_GET_COMPRESS_CACHESIZE)
(id, num_buffers, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *num_buffers;         /* Out: CDF compression cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long numBuffers;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, COMPRESS_CACHESIZE_, &numBuffers,
                            NULL_);
  if (StatusOK(*status)) *num_buffers = (Int32) numBuffers;
  return;
}

/******************************************************************************
*  CDF_get_stage_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_stage_cachesize__,
               cdf_get_stage_cachesize_,
               cdf_get_stage_cachesize,
               CDF_GET_STAGE_CACHESIZE)
(id, num_buffers, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *num_buffers;         /* Out: CDF stage cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long numBuffers;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, STAGE_CACHESIZE_, &numBuffers,
                            NULL_);
  if (StatusOK(*status)) *num_buffers = (Int32) numBuffers;
  return;
}

/******************************************************************************
*  CDF_get_current_cdf.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_cdf__,
               cdf_get_current_cdf_,
               cdf_get_current_cdf,
               CDF_GET_CURRENT_CDF)
(cdf_id, status)
Int32     *cdf_id;              /* Out: Current CDF id. */
Int32     *status;              /* Out: CDF status code. */
{
  CDFid cdfId;

  *status = (Int32) CDFlib (CONFIRM_, CDF_, &cdfId,
                            NULL_);
  if (StatusOK(*status)) *cdf_id = CDFidToInt32(cdfId);
  return;
}

/******************************************************************************
*  CDF_get_current_cdfname.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_cdfname__,
               cdf_get_current_cdfname_,
               cdf_get_current_cdfname,
               CDF_GET_CURRENT_CDFNAME)
(cdf_name, status Fif_GHOSTARG(len))
void      *cdf_name;            /* Out: Current CDF name. */
Int32     *status;              /* Out: CDF status code. */
Fif_GHOSTDEF(len)               /* Invisible length of "cdf_name"
                                   (generated by FORTRAN compiler). */
{
  char cdfName[CDF_PATHNAME_LEN];

  *status = (Int32) CDFlib (CONFIRM_, CDF_NAME_, cdfName,
                            NULL_);

  if (StatusBAD(*status)) return;
#if defined(Fif_GHOSTLEN)
    CtoFORTstring (cdfName, cdf_name, Fif_GHOSTUSE(len));
#else
    CtoFORTstring (cdfName, cdf_name, CDF_PATHNAME_LEN);
#endif
  return;
}

/******************************************************************************
*  CDF_get_current_rvar.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_rvar__,
               cdf_get_current_rvar_,
               cdf_get_current_rvar,
               CDF_GET_CURRENT_RVAR)
(var_num, status)
Int32     *var_num;             /* Out: Current rVariable number. */
Int32     *status;              /* Out: CDF status code. */
{
  long varNum;

  *status = (Int32) CDFlib (CONFIRM_, rVAR_, &varNum,
                            NULL_);
  if (StatusOK(*status)) *var_num = (Int32) varNum;
  return;
}

/******************************************************************************
*  CDF_get_current_zvar.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_zvar__,
               cdf_get_current_zvar_,
               cdf_get_current_zvar,
               CDF_GET_CURRENT_ZVAR)
(var_num, status)
Int32     *var_num;             /* Out: Current zVariable number. */
Int32     *status;              /* Out: CDF status code. */
{
  long varNum;

  *status = (Int32) CDFlib (CONFIRM_, zVAR_, &varNum,
                            NULL_);
  if (StatusOK(*status)) *var_num = (Int32) varNum;
  return;
}

/******************************************************************************
*  CDF_get_current_attr.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_attr__,
               cdf_get_current_attr_,
               cdf_get_current_attr,
               CDF_GET_CURRENT_ATTR)
(attr_num, status)
Int32     *attr_num;            /* Out: Current attribute number. */
Int32     *status;              /* Out: CDF status code. */
{
  long attrNum;

  *status = (Int32) CDFlib (CONFIRM_, ATTR_, &attrNum,
                            NULL_);
  if (StatusOK(*status)) *attr_num = (Int32) attrNum;
  return;
}

/******************************************************************************
*  CDF_get_current_gentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_gentry__,
               cdf_get_current_gentry_,
               cdf_get_current_gentry,
               CDF_GET_CURRENT_GENTRY)
(entry_num, status)
Int32     *entry_num;           /* Out: Current gEntry number. */
Int32     *status;              /* Out: CDF status code. */
{
  long entryNum;

  *status = (Int32) CDFlib (CONFIRM_, gENTRY_, &entryNum,
                            NULL_);
  if (StatusOK(*status)) *entry_num = (Int32) entryNum;
  return;
}

/******************************************************************************
*  CDF_get_current_rentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_rentry__,
               cdf_get_current_rentry_,
               cdf_get_current_rentry,
               CDF_GET_CURRENT_RENTRY)
(entry_num, status)
Int32     *entry_num;           /* Out: Current rEntry number. */
Int32     *status;              /* Out: CDF status code. */
{
  long entryNum;

  *status = (Int32) CDFlib (CONFIRM_, rENTRY_, &entryNum,
                            NULL_);
  if (StatusOK(*status)) *entry_num = (Int32) entryNum;
  return;
}

/******************************************************************************
*  CDF_get_current_zentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_current_zentry__,
               cdf_get_current_zentry_,
               cdf_get_current_zentry,
               CDF_GET_CURRENT_ZENTRY)
(entry_num, status)
Int32     *entry_num;           /* Out: Current zEntry number. */
Int32     *status;              /* Out: CDF status code. */
{
  long entryNum;

  *status = (Int32) CDFlib (CONFIRM_, zENTRY_, &entryNum,
                            NULL_);
  if (StatusOK(*status)) *entry_num = (Int32) entryNum;
  return;
}

/******************************************************************************
*  CDF_get_rvar_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_cachesize__,
               cdf_get_rvar_cachesize_,
               cdf_get_rvar_cachesize,
               CDF_GET_RVAR_CACHESIZE)
(id, var_num, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* Out: rVariable number. */
Int32     *cache_size;          /* Out: rVariable's cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long cacheSize;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            CONFIRM_, rVAR_CACHESIZE_, &cacheSize,
                            NULL_);
  if (StatusOK(*status)) *cache_size = (Int32) cacheSize;
  return;
}

/******************************************************************************
*  CDF_get_zvar_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_cachesize__,
               cdf_get_zvar_cachesize_,
               cdf_get_zvar_cachesize,
               CDF_GET_ZVAR_CACHESIZE)
(id, var_num, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* Out: zVariable number. */
Int32     *cache_size;          /* Out: zVariable's cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long cacheSize;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            CONFIRM_, zVAR_CACHESIZE_, &cacheSize,
                            NULL_);
  if (StatusOK(*status)) *cache_size = (Int32) cacheSize;
  return;
}

/******************************************************************************
*  CDF_get_rvars_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_cachesize__,
               cdf_get_rvars_cachesize_,
               cdf_get_rvars_cachesize,
               CDF_GET_RVARS_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* Out: rVariables's cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long cacheSize;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, rVARs_CACHESIZE_, &cacheSize,
                            NULL_);
  if (StatusOK(*status)) *cache_size = (Int32) cacheSize;
  return;
}

/******************************************************************************
*  CDF_get_zvars_cachesize.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvars_cachesize__,
               cdf_get_zvars_cachesize_,
               cdf_get_zvars_cachesize,
               CDF_GET_ZVARS_CACHESIZE)
(id, cache_size, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *cache_size;          /* Out: zVariables's cache size. */
Int32     *status;              /* Out: CDF status code. */
{
  long cacheSize;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, zVARs_CACHESIZE_, &cacheSize,
                            NULL_);
  if (StatusOK(*status)) *cache_size = (Int32) cacheSize;
  return;
}

/******************************************************************************
*  CDF_get_rvar_reservepercent.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_reservepercent__,
               cdf_get_rvar_reservepercent_,
               cdf_get_rvar_reservepercent,
               CDF_GET_RVAR_RESERVEPERCENT)
(id, var_num, reserve_percent, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: rVariable number. */
Int32     *reserve_percent;     /* Out: rVariable's reserve percentage. */
Int32     *status;              /* Out: CDF status code. */
{
  long reservePercent;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            CONFIRM_, rVAR_RESERVEPERCENT_, &reservePercent,
                            NULL_);
  if (StatusOK(*status)) *reserve_percent = (Int32) reservePercent;
  return;
}

/******************************************************************************
*  CDF_get_zvar_reservepercent.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_reservepercent__,
               cdf_get_zvar_reservepercent_,
               cdf_get_zvar_reservepercent,
               CDF_GET_ZVAR_RESERVEPERCENT)
(id, var_num, reserve_percent, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *reserve_percent;     /* Out: zVariable's reserve percentage. */
Int32     *status;              /* Out: CDF status code. */
{
  long reservePercent;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            CONFIRM_, zVAR_RESERVEPERCENT_, &reservePercent,
                            NULL_);
  if (StatusOK(*status)) *reserve_percent = (Int32) reservePercent;
  return;
}

/******************************************************************************
*  CDF_get_rvar_seqpos.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_seqpos__,
               cdf_get_rvar_seqpos_,
               cdf_get_rvar_seqpos,
               CDF_GET_RVAR_SEQPOS)
(id, var_num, rec_num, indices, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: rVariable number. */
Int32     *rec_num;             /* out: rVariable's record number. */
Int32     indices[];            /* Out: rVariable's record indices. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, recNum, indicesT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, rVAR_SEQPOS_, &recNum, indicesT,
                            NULL_);
  if (StatusOK(*status)) {
    *rec_num = (Int32) (recNum + 1);
    for (ix = 0; ix < (int) numDims; ix++)
       indices[ix] = (Int32) (indicesT[ix] + 1);
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_seqpos.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_seqpos__,
               cdf_get_zvar_seqpos_,
               cdf_get_zvar_seqpos,
               CDF_GET_ZVAR_SEQPOS)
(id, var_num, rec_num, indices, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *rec_num;             /* out: zVariable's record number. */
Int32     indices[];            /* Out: zVariable's record indices. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, recNum, indicesT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, zVAR_SEQPOS_, &recNum, indicesT,
                            NULL_);
  if (StatusOK(*status)) {
    *rec_num = (Int32) (recNum + 1);
    for (ix = 0; ix < (int) numDims; ix++)
       indices[ix] = (Int32) (indicesT[ix] + 1);
  }
  return;
}

/******************************************************************************
*  CDF_get_rvars_dimcounts.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_dimcounts__,
               cdf_get_rvars_dimcounts_,
               cdf_get_rvars_dimcounts,
               CDF_GET_RVARS_DIMCOUNTS)
(id, counts, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     counts[];             /* Out: rVariable's dimension counts. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, countsT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, rVARs_DIMCOUNTS_, countsT,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       counts[ix] = (Int32) countsT[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_dimcounts.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_dimcounts__,
               cdf_get_zvar_dimcounts_,
               cdf_get_zvar_dimcounts,
               CDF_GET_ZVAR_DIMCOUNTS)
(id, var_num, counts, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     counts[];             /* Out: zVariable's dimension counts. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, countsT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, zVAR_DIMCOUNTS_, countsT,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       counts[ix] = (Int32) countsT[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_rvars_dimindices.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_dimindices__,
               cdf_get_rvars_dimindices_,
               cdf_get_rvars_dimindices,
               CDF_GET_RVARS_DIMINDICES)
(id, indices, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     indices[];            /* Out: rVariable's dimension indices. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, indicesT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, rVARs_DIMINDICES_, indicesT,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       indices[ix] = (Int32) (indicesT[ix] + 1);
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_dimindices.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_dimindices__,
               cdf_get_zvar_dimindices_,
               cdf_get_zvar_dimindices,
               CDF_GET_ZVAR_DIMINDICES)
(id, var_num, indices, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     indices[];            /* Out: zVariable's dimension indices. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, indicesT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, zVAR_DIMINDICES_, indicesT,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       indices[ix] = (Int32) (indicesT[ix] + 1);
  }
  return;
}

/******************************************************************************
*  CDF_get_rvars_dimintervals.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_dimintervals__,
               cdf_get_rvars_dimintervals_,
               cdf_get_rvars_dimintervals,
               CDF_GET_RVARS_DIMINTERVALS)
(id, intervals, status)
Int32     *id;           /* In: CDF identifier. */
Int32     intervals[];   /* Out: Currnet dim intervals for all rVariables. */
Int32     *status;       /* Out: CDF status code. */
{
  long numDims, intervalsT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, rVARs_DIMINTERVALS_, intervalsT,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       intervals[ix] = (Int32) intervalsT[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_dimintervals.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_dimintervals__,
               cdf_get_zvar_dimintervals_,
               cdf_get_zvar_dimintervals,
               CDF_GET_ZVAR_DIMINTERVALS)
(id, var_num, intervals, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     intervals[];          /* Out: zVariable's dimension intervals. */
Int32     *status;              /* Out: CDF status code. */
{
  long numDims, intervalsT[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (CONFIRM_, zVAR_DIMINTERVALS_, intervalsT,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       intervals[ix] = (Int32) intervalsT[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_rvars_recnumber.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_recnumber__,
               cdf_get_rvars_recnumber_,
               cdf_get_rvars_recnumber,
               CDF_GET_RVARS_RECNUMBER)
(id, number, status)
Int32     *id;           /* In: CDF identifier. */
Int32     *number;       /* Out: Current record number for all rVariables. */
Int32     *status;       /* Out: CDF status code. */
{
  long numberT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, rVARs_RECNUMBER_, &numberT,
                            NULL_);
  if (StatusOK(*status)) *number = (Int32) (numberT + 1);
  return;
}

/******************************************************************************
*  CDF_get_zvar_recnumber.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_recnumber__,
               cdf_get_zvar_recnumber_,
               cdf_get_zvar_recnumber,
               CDF_GET_ZVAR_RECNUMBER)
(id, var_num, number, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *number;              /* Out: zVariable's record number. */
Int32     *status;              /* Out: CDF status code. */
{
  long numberT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            CONFIRM_, zVAR_RECNUMBER_, &numberT,
                            NULL_);
  if (StatusOK(*status)) *number = (Int32) (numberT + 1);
  return;
}

/******************************************************************************
*  CDF_get_rvars_recinterval.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_recinterval__,
               cdf_get_rvars_recinterval_,
               cdf_get_rvars_recinterval,
               CDF_GET_RVARS_RECINTERVAL)
(id, interval, status)
Int32     *id;           /* In: CDF identifier. */
Int32     *interval;     /* Out: Current record interval for all rVariables. */
Int32     *status;       /* Out: CDF status code. */
{
  long intervalT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, rVARs_RECINTERVAL_, &intervalT,
                            NULL_);
  if (StatusOK(*status)) *interval = (Int32) intervalT;
  return;
}

/******************************************************************************
*  CDF_get_zvar_recinterval.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_recinterval__,
               cdf_get_zvar_recinterval_,
               cdf_get_zvar_recinterval,
               CDF_GET_ZVAR_RECINTERVAL)
(id, var_num, interval, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *interval;            /* Out: zVariable's record interval. */
Int32     *status;              /* Out: CDF status code. */
{
  long intervalT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            CONFIRM_, zVAR_RECINTERVAL_, &intervalT,
                            NULL_);
  if (StatusOK(*status)) *interval = (Int32) intervalT;
  return;
}

/******************************************************************************
*  CDF_get_rvars_reccount.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_reccount__,
               cdf_get_rvars_reccount_,
               cdf_get_rvars_reccount,
               CDF_GET_RVARS_RECCOUNT)
(id, count, status)
Int32     *id;             /* In: CDF identifier. */
Int32     *count;          /* Out: Current record count for all rVariables. */
Int32     *status;         /* Out: CDF status code. */
{
  long countT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, rVARs_RECCOUNT_, &countT,
                            NULL_);
  if (StatusOK(*status)) *count = (Int32) countT;
  return;
}

/******************************************************************************
*  CDF_get_zvar_reccount.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_reccount__,
               cdf_get_zvar_reccount_,
               cdf_get_zvar_reccount,
               CDF_GET_ZVAR_RECCOUNT)
(id, var_num, count, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *count;               /* Out: zVariable's record count. */
Int32     *status;              /* Out: CDF status code. */
{
  long countT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            CONFIRM_, zVAR_RECCOUNT_, &countT,
                            NULL_);
  if (StatusOK(*status)) *count = (Int32) countT;
  return;
}

/******************************************************************************
*  CDF_get_attr_name.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_name__,
               cdf_get_attr_name_,
               cdf_get_attr_name,
               CDF_GET_ATTR_NAME)
(id, attr_num, attr_name, status Fif_GHOSTARG(len))
Int32     *id;          /* In: CDF identifier. */
Int32     *attr_num;    /* In: CDF attribute number. */
void      *attr_name;   /* Out: CDF attribute name. */
Int32     *status;      /* Out: CDF status code. */
Fif_GHOSTDEF(len)       /* Invisible length of "attr_name"
                           (generated by FORTRAN compiler). */
{
  char attrName[CDF_ATTR_NAME_LEN256];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_, ATTR_NAME_, attrName,
                            NULL_);
  if (StatusOK(*status)) {
#if defined(Fif_GHOSTLEN)
    CtoFORTstring (attrName, attr_name, Fif_GHOSTUSE(len));
#else
    CtoFORTstring (attrName, attr_name, CDF_ATTR_NAME_LEN256);
#endif
  }

  return;
}

/******************************************************************************
*  CDF_get_attr_scope.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_scope__,
               cdf_get_attr_scope_,
               cdf_get_attr_scope,
               CDF_GET_ATTR_SCOPE)
(id, attr_num, attr_scope, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *attr_num;            /* In: Attribute number. */
Int32     *attr_scope;          /* Out: Attribute scope. */
Int32     *status;              /* Out: CDF status code. */
{
  long scope;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_, ATTR_SCOPE_, &scope,
                            NULL_);
  if (StatusBAD(*status)) return;
  *attr_scope = (Int32) scope;

  return;
}

/******************************************************************************
*  CDF_delete_attr_gentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_attr_gentry__,
	       cdf_delete_attr_gentry_,
	       cdf_delete_attr_gentry,
	       CDF_DELETE_ATTR_GENTRY)
(id, attr_num, entry_num, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: gEntry number. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     gENTRY_, (long) (*entry_num - 1),
			    DELETE_, gENTRY_,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_delete_attr_rentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_attr_rentry__,
	       cdf_delete_attr_rentry_,
	       cdf_delete_attr_rentry,
	       CDF_DELETE_ATTR_RENTRY)
(id, attr_num, entry_num, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: rEntry number. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     rENTRY_, (long) (*entry_num - 1),
			    DELETE_, rENTRY_,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_delete_attr_zentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_attr_zentry__,
	       cdf_delete_attr_zentry_,
	       cdf_delete_attr_zentry,
	       CDF_DELETE_ATTR_ZENTRY)
(id, attr_num, entry_num, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: zEntry number. */
Int32	  *status;		/* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     zENTRY_, (long) (*entry_num - 1),
			    DELETE_, zENTRY_,
			    NULL_);
  return;
}

/******************************************************************************
*  CDF_get_attr_num_gentries.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_num_gentries__,
	       cdf_get_attr_num_gentries_,
	       cdf_get_attr_num_gentries,
	       CDF_GET_ATTR_NUM_GENTRIES)
(id, attr_num, entries, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entries;             /* Out: Number of gEntries. */
Int32	  *status;		/* Out: CDF status code. */
{

  long entriesT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_,    ATTR_NUMgENTRIES_, &entriesT,
			    NULL_);
  if (StatusOK(*status)) *entries = (Int32) entriesT;
  return;
}

/******************************************************************************
*  CDF_get_attr_num_rentries.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_num_rentries__,
	       cdf_get_attr_num_rentries_,
	       cdf_get_attr_num_rentries,
	       CDF_GET_ATTR_NUM_RENTRIES)
(id, attr_num, entries, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entries;             /* Out: Number of rEntries. */
Int32	  *status;		/* Out: CDF status code. */
{

  long entriesT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_,    ATTR_NUMrENTRIES_, &entriesT,
			    NULL_);
  if (StatusOK(*status)) *entries = (Int32) entriesT;
  return;
}

/******************************************************************************
*  CDF_get_attr_num_zentries.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_num_zentries__,
	       cdf_get_attr_num_zentries_,
	       cdf_get_attr_num_zentries,
	       CDF_GET_ATTR_NUM_ZENTRIES)
(id, attr_num, entries, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entries;             /* Out: Number of zEntries. */
Int32	  *status;		/* Out: CDF status code. */
{

  long entriesT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_,    ATTR_NUMzENTRIES_, &entriesT,
			    NULL_);
  if (StatusOK(*status)) *entries = (Int32) entriesT;
  return;
}

/******************************************************************************
*  CDF_get_attr_max_gentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_max_gentry__,
	       cdf_get_attr_max_gentry_,
	       cdf_get_attr_max_gentry,
	       CDF_GET_ATTR_MAX_GENTRY)
(id, attr_num, entries, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entries;             /* Out: Max number of gEntry. */
Int32	  *status;		/* Out: CDF status code. */
{

  long entriesT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_,    ATTR_MAXgENTRY_, &entriesT,
			    NULL_);
  if (StatusOK(*status))
    *entries = (Int32) (entriesT + 1);
  return;
}

/******************************************************************************
*  CDF_get_attr_max_rentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_max_rentry__,
	       cdf_get_attr_max_rentry_,
	       cdf_get_attr_max_rentry,
	       CDF_GET_attr_max_RENTRY)
(id, attr_num, entries, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entries;             /* Out: Max number of rEntry. */
Int32	  *status;		/* Out: CDF status code. */
{

  long entriesT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_,    ATTR_MAXrENTRY_, &entriesT,
			    NULL_);
  if (StatusOK(*status))
    *entries = (Int32) (entriesT + 1);
  return;
}

/******************************************************************************
*  CDF_get_attr_max_zentry.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_max_zentry__,
	       cdf_get_attr_max_zentry_,
	       cdf_get_attr_max_zentry,
	       CDF_GET_ATTR_MAX_ZENTRY)
(id, attr_num, entries, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entries;             /* Out: Max number of zEntry. */
Int32	  *status;		/* Out: CDF status code. */
{

  long entriesT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                            GET_,    ATTR_MAXzENTRY_, &entriesT,
			    NULL_);
  if (StatusOK(*status))
    *entries = (Int32) (entriesT + 1);
  return;
}

/******************************************************************************
*  CDF_get_attr_gentry_datatype.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_gentry_datatype__,
	       cdf_get_attr_gentry_datatype_,
	       cdf_get_attr_gentry_datatype,
	       CDF_GET_ATTR_GENTRY_DATATYPE)
(id, attr_num, entry_num, data_type, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: gEntry number. */
Int32     *data_type;           /* Out: Data type. */
Int32	  *status;		/* Out: CDF status code. */
{

  long dataTypeT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     gENTRY_, (long) (*entry_num - 1),
                            GET_,    gENTRY_DATATYPE_, &dataTypeT,
			    NULL_);
  if (StatusOK(*status)) *data_type = (Int32) dataTypeT;
  return;
}

/******************************************************************************
*  CDF_get_attr_rentry_datatype.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_rentry_datatype__,
	       cdf_get_attr_rentry_datatype_,
	       cdf_get_attr_rentry_datatype,
	       CDF_GET_ATTR_RENTRY_DATATYPE)
(id, attr_num, entry_num, data_type, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: rEntry number. */
Int32     *data_type;           /* Out: Data type. */
Int32	  *status;		/* Out: CDF status code. */
{

  long dataTypeT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     rENTRY_, (long) (*entry_num - 1),
                            GET_,    rENTRY_DATATYPE_, &dataTypeT,
			    NULL_);
  if (StatusOK(*status)) *data_type = (Int32) dataTypeT;
  return;
}

/******************************************************************************
*  CDF_get_attr_zentry_datatype.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_zentry_datatype__,
	       cdf_get_attr_zentry_datatype_,
	       cdf_get_attr_zentry_datatype,
	       CDF_GET_ATTR_ZENTRY_DATATYPE)
(id, attr_num, entry_num, data_type, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: zEntry number. */
Int32     *data_type;           /* Out: Data type. */
Int32	  *status;		/* Out: CDF status code. */
{

  long dataTypeT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     zENTRY_, (long) (*entry_num - 1),
                            GET_,    zENTRY_DATATYPE_, &dataTypeT,
			    NULL_);
  if (StatusOK(*status)) *data_type = (Int32) dataTypeT;
  return;
}

/******************************************************************************
*  CDF_get_attr_gentry_numelems.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_gentry_numelems__,
	       cdf_get_attr_gentry_numelems_,
	       cdf_get_attr_gentry_numelems,
	       CDF_GET_ATTR_GENTRY_NUMELEMS)
(id, attr_num, entry_num, num_elems, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: gEntry number. */
Int32     *num_elems;           /* Out: Number of elements. */
Int32	  *status;		/* Out: CDF status code. */
{

  long numElemsT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     gENTRY_, (long) (*entry_num - 1),
                            GET_,    gENTRY_NUMELEMS_, &numElemsT,
			    NULL_);
  if (StatusOK(*status)) *num_elems = (Int32) numElemsT;
  return;
}

/******************************************************************************
*  CDF_get_attr_rentry_numelems.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_rentry_numelems__,
	       cdf_get_attr_rentry_numelems_,
	       cdf_get_attr_rentry_numelems,
	       CDF_GET_ATTR_RENTRY_NUMELEMS)
(id, attr_num, entry_num, num_elems, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: rEntry number. */
Int32     *num_elems;           /* Out: Number of elements. */
Int32	  *status;		/* Out: CDF status code. */
{

  long numElemsT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     rENTRY_, (long) (*entry_num - 1),
                            GET_,    rENTRY_NUMELEMS_, &numElemsT,
			    NULL_);
  if (StatusOK(*status)) *num_elems = (Int32) numElemsT;
  return;
}

/******************************************************************************
*  CDF_get_attr_zentry_numelems.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_attr_zentry_numelems__,
	       cdf_get_attr_zentry_numelems_,
	       cdf_get_attr_zentry_numelems,
	       CDF_GET_ATTR_ZENTRY_NUMELEMS)
(id, attr_num, entry_num, num_elems, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32	  *attr_num;	   	/* In: Attribute number. */
Int32     *entry_num;           /* In: zEntry number. */
Int32     *num_elems;           /* Out: Number of elements. */
Int32	  *status;		/* Out: CDF status code. */
{

  long numElemsT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     ATTR_, (long) (*attr_num - 1),
                                     zENTRY_, (long) (*entry_num - 1),
                            GET_,    zENTRY_NUMELEMS_, &numElemsT,
			    NULL_);
  if (StatusOK(*status)) *num_elems = (Int32) numElemsT;
  return;
}

/******************************************************************************
*  CDF_delete_rvar.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_rvar__,
               cdf_delete_rvar_,
               cdf_delete_rvar,
               CDF_DELETE_RVAR)
(id, var_num, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *var_num;	   	/* In: rVariable number. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		                     rVAR_NUMBER_, (long) (*var_num -1),
		            DELETE_, rVAR_,
		            NULL_);
  return;
}

/******************************************************************************
*  CDF_delete_zvar.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_zvar__,
               cdf_delete_zvar_,
               cdf_delete_zvar,
               CDF_DELETE_ZVAR)
(id, var_num, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *var_num;	   	/* In: zVariable number. */
Int32     *status;              /* Out: CDF status code. */
{

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		                     zVAR_NUMBER_, (long) (*var_num -1),
		            DELETE_, zVAR_,
		            NULL_);
  return;
}

/******************************************************************************
*  CDF_delete_rvar_recs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_rvar_recs__,
               cdf_delete_rvar_recs_,
               cdf_delete_rvar_recs,
               CDF_DELETE_RVAR_RECS)
(id, var_num, start_rec, end_rec, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: rVariable number. */
Int32     *start_rec;           /* In: rVariable's start record number. */
Int32     *end_rec;             /* In: rVariable's end record number. */
Int32     *status;              /* Out: CDF status code. */
{
  long startRec = (long) (*start_rec - 1);
  long endRec = (long) (*end_rec - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_NUMBER_, (long) (*var_num -1),
                            DELETE_, rVAR_RECORDS_, startRec, endRec,
                            NULL_);
  return;
}

/******************************************************************************
* CDF_delete_zvar_recs.
******************************************************************************/
VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_delete_zvar_recs__,
               cdf_delete_zvar_recs_,
               cdf_delete_zvar_recs,
               CDF_DELETE_ZVAR_RECS)
(id, var_num, start_rec, end_rec, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: zVariable number. */
Int32     *start_rec;           /* In: zVariable's start record number. */
Int32     *end_rec;             /* In: zVariable's end record number. */
Int32     *status;              /* Out: CDF status code. */
{
  long startRec = (long) (*start_rec - 1);
  long endRec = (long) (*end_rec - 1);
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_NUMBER_, (long) (*var_num -1),
                            DELETE_, zVAR_RECORDS_, startRec, endRec,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_get_num_rvars.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_num_rvars__,
               cdf_get_num_rvars_,
               cdf_get_num_rvars,
               CDF_GET_NUM_RVARS)
(id, num_vars, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *num_vars;	   	/* Out: Number of rVariables. */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_NUMrVARS_, &numVars,
		            NULL_);
  if (StatusOK(*status))
    *num_vars = (Int32) numVars;
  return;
}

/******************************************************************************
*  CDF_get_num_zvars.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_num_zvars__,
               cdf_get_num_zvars_,
               cdf_get_num_zvars,
               CDF_GET_NUM_ZVARS)
(id, num_vars, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *num_vars;	   	/* Out: Number of zVariables. */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_NUMzVARS_, &numVars,
		            NULL_);
  if (StatusOK(*status))
    *num_vars = (Int32) numVars;
  return;
}

/******************************************************************************
*  CDF_get_compression.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_compression__,
               cdf_get_compression_,
               cdf_get_compression,
               CDF_GET_COMPRESSION)
(id, compression_type, compression_parms, compression_percent, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *compression_type;	/* Out: CDF compression type. */
Int32     compression_parms[];  /* Out: CDF compression parameters. */
Int32     *compression_percent; /* Out: CDF compression percentage. */
Int32     *status;              /* Out: CDF status code. */
{
  long cType, cPct, cParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_COMPRESSION_, &cType, cParms, &cPct,
		            NULL_);
  if (StatusOK(*status)) {
    *compression_type = (Int32) cType;
    *compression_percent = (Int32) cPct;
    for (ix = 0; ix < CDF_MAX_PARMS; ix++)
       compression_parms[ix] = (Int32) cParms[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_copyright.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_copyright__,
               cdf_get_copyright_,
               cdf_get_copyright,
               CDF_GET_COPYRIGHT)
(id, copy_right, status Fif_GHOSTARG(len))
Int32	  *id;		   	/* In: CDF identifier. */
void      *copy_right;	        /* Out: Copyright. */
Int32     *status;              /* Out: CDF status code. */
Fif_GHOSTDEF(len)               /* Invisible length of "copy_right"
                                   (generated by FORTRAN compiler). */
{
  char copyRightT[CDF_COPYRIGHT_LEN+1];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_COPYRIGHT_, copyRightT,
		            NULL_);
  if (StatusBAD(*status)) {
    return;
  }

#if defined(Fif_GHOSTLEN)
  CtoFORTstring (copyRightT, copy_right, Fif_GHOSTUSE(len));
#else
  CtoFORTstring (copyRightT, copy_right, CDF_COPYRIGHT_LEN);
#endif
  return;
}

/******************************************************************************
*  CDF_get_encoding.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_encoding__,
               cdf_get_encoding_,
               cdf_get_encoding,
               CDF_GET_ENCODING)
(id, encoding, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *encoding;		/* Out: CDF encoding. */
Int32     *status;              /* Out: CDF status code. */
{
  long encodingT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_ENCODING_, &encodingT,
		            NULL_);
  if (StatusOK(*status)) *encoding = (Int32) encodingT;

  return;
}

/******************************************************************************
*  CDF_get_format.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_format__,
               cdf_get_format_,
               cdf_get_format,
               CDF_GET_FORMAT)
(id, format, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *format;		/* Out: CDF format. */
Int32     *status;              /* Out: CDF status code. */
{
  long formatT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_FORMAT_, &formatT,
		            NULL_);
  if (StatusOK(*status)) *format = (Int32) formatT;

  return;
}

/******************************************************************************
*  CDF_get_majority.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_majority__,
               cdf_get_majority_,
               cdf_get_majority,
               CDF_GET_MAJORITY)
(id, majority, status)
Int32	  *id;		   	/* In: CDF identifier. */
Int32     *majority;		/* Out: CDF majority. */
Int32     *status;              /* Out: CDF status code. */
{
  long majorityT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_MAJORITY_, &majorityT,
		            NULL_);
  if (StatusOK(*status)) *majority = (Int32) majorityT;

  return;
}

/******************************************************************************
*  CDF_get_info.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_info__,
               cdf_get_info_,
               cdf_get_info,
               CDF_GET_INFO)
(name, compress_type, compress_parms, compress_size, uncompress_size,
status Fif_GHOSTARG(len))
void      *name;                /* In: CDF name. */
Int32     *compress_type;       /* Out: CDF compression type. */
Int32     compress_parms[];     /* Out: CDF compression parameters. */
OFF_T     *compress_size;       /* Out: CDF compressed size. */
OFF_T     *uncompress_size;     /* Out: CDF uncompressed size. */
Int32     *status;              /* Out: CDF status code. */
Fif_GHOSTDEF(len) 	        /* Invisible length of "name"
                                   (generated by FORTRAN compiler). */
{
  struct STRINGstruct *ssh = NULL;      /* Head of STRINGstruct linked list. */
  long cType, cParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (GET_, CDF_INFO_,
#if defined(Fif_DESCR)
                                           DESCRtoREFnul(name,
                                                         CDF_PATHNAME_LEN,
                                                         &ssh),
#endif
#if defined(Fif_GHOSTLEN)
                                           NULterminate(name,
                                                        Fif_GHOSTUSE(len),
                                                        &ssh),
#endif
#if defined(Fif_NOLEN)
                                           FindEndNUL(name,
                                                      CDF_PATHNAME_LEN,&ssh),
#endif
                                             &cType, cParms, compress_size,
                                             uncompress_size,
		            NULL_);
  if (StatusOK(*status)) {
    *compress_type = (Int32) cType;
    for (ix = 0; ix < CDF_MAX_PARMS; ix++)
      compress_parms[ix] = (Int32) cParms[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_num_attrs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_num_attrs__,
               cdf_get_num_attrs_,
               cdf_get_num_attrs,
               CDF_GET_NUM_ATTRS)
(id, num_attrs, status)
Int32	  *id;		/* In: CDF identifier. */
Int32     *num_attrs;  	/* Out: CDF number of attributes. */
Int32     *status;      /* Out: CDF status code. */
{
  long numAttrs;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_NUMATTRS_, &numAttrs,
		            NULL_);
  if (StatusOK(*status)) *num_attrs = (Int32) numAttrs;

  return;
}

/******************************************************************************
*  CDF_get_num_gattrs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_num_gattrs__,
               cdf_get_num_gattrs_,
               cdf_get_num_gattrs,
               CDF_GET_NUM_GATTRS)
(id, num_attrs, status)
Int32	  *id;		/* In: CDF identifier. */
Int32     *num_attrs;  	/* Out: CDF number of gAttributes. */
Int32     *status;      /* Out: CDF status code. */
{
  long numAttrs;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_NUMgATTRS_, &numAttrs,
		            NULL_);
  if (StatusOK(*status)) *num_attrs = (Int32) numAttrs;

  return;
}

/******************************************************************************
*  CDF_get_num_vattrs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_num_vattrs__,
               cdf_get_num_vattrs_,
               cdf_get_num_vattrs,
               CDF_GET_NUM_VATTRS)
(id, num_attrs, status)
Int32	  *id;		/* In: CDF identifier. */
Int32     *num_attrs;  	/* Out: CDF number of vAttributes. */
Int32     *status;      /* Out: CDF status code. */
{
  long numAttrs;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
		            GET_, CDF_NUMvATTRS_, &numAttrs,
		            NULL_);
  if (StatusOK(*status)) *num_attrs = (Int32) numAttrs;

  return;
}

/******************************************************************************
*  CDF_get_datatype_size.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_datatype_size__,
               cdf_get_datatype_size_,
               cdf_get_datatype_size,
               CDF_GET_DATATYPE_SIZE)
(datatype, datatype_size, status)
Int32     *datatype;            /* In: CDF data type. */
Int32     *datatype_size;  	/* Out: CDF data type size. */
Int32     *status;      	/* Out: CDF status code. */
{
  long dtSize;

  *status = (Int32) CDFlib (GET_, DATATYPE_SIZE_, (long) *datatype, &dtSize,
		            NULL_);
  if (StatusOK(*status)) *datatype_size = (Int32) dtSize;

  return;
}

/******************************************************************************
*  CDF_get_lib_copyright.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_lib_copyright__,
               cdf_get_lib_copyright_,
               cdf_get_lib_copyright,
               CDF_GET_LIB_COPYRIGHT)
(copy_right, status Fif_GHOSTARG(len))
void      *copy_right;  /* Out: CDF library copy right. */
Int32     *status;      /* Out: CDF status code. */
Fif_GHOSTDEF(len)       /* Invisible length of "copy_right"
                           (generated by FORTRAN compiler). */
{
  char copyRight[CDF_COPYRIGHT_LEN+1];

  *status = (Int32) CDFlib (GET_, LIB_COPYRIGHT_, copyRight,
		            NULL_);
  if (StatusOK(*status)) {
#if defined(Fif_GHOSTLEN)
    CtoFORTstring (copyRight, copy_right, Fif_GHOSTUSE(len));
#else
    CtoFORTstring (copyRight, copy_right, CDF_COPYRIGHT_LEN);
#endif
  }

  return;
}

/******************************************************************************
*  CDF_get_lib_version.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_lib_version__,
               cdf_get_lib_version_,
               cdf_get_lib_version,
               CDF_GET_LIB_VERSION)
(version, release, increment, subincrement, status Fif_GHOSTARG(len))
Int32     *version;  	/* Out: CDF library version. */
Int32     *release;     /* Out: CDF library release. */
Int32     *increment;   /* Out: CDF library increment. */
void      *subincrement;/* Out: CDF library sub_increment. */
Int32     *status;     	/* Out: CDF status code. */
Fif_GHOSTDEF(len)       /* Invisible length of "subincrement"
                           (generated by FORTRAN compiler). */
{
  long versionT, releaseT, incrementT; 
  char subIncrementT;

  *status = (Int32) CDFlib (GET_, LIB_VERSION_, &versionT,
                                  LIB_RELEASE_, &releaseT,
                                  LIB_INCREMENT_, &incrementT,
                                  LIB_subINCREMENT_, &subIncrementT,
		            NULL_);
  if (StatusOK(*status)) {
    *version = (Int32) versionT;
    *release = (Int32) releaseT;
    *increment = (Int32) incrementT;
  }
#if defined(Fif_GHOSTLEN)
  CtoFORTstring (&subIncrementT, subincrement, Fif_GHOSTUSE(len));
#else
  CtoFORTstring (&subIncrementT, subincrement, 1);
#endif

  return;
}

/******************************************************************************
*  CDF_get_version.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_version__,
               cdf_get_version_,
               cdf_get_version,
               CDF_GET_VERSION)
(id, version, release, increment, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *version;     /* Out: CDF version. */
Int32     *release;     /* Out: CDF release. */
Int32     *increment;   /* Out: CDF increment. */
Int32     *status;      /* Out: CDF status code. */
{
  long versionT, releaseT, incrementT;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, CDF_VERSION_, &versionT,
                                  CDF_RELEASE_, &releaseT,
                                  CDF_INCREMENT_, &incrementT,
                            NULL_);
  if (StatusOK(*status)) {
    *version = (Int32) versionT;
    *release = (Int32) releaseT;
    *increment = (Int32) incrementT;
  }

  return;
}

/******************************************************************************
*  CDF_get_name.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_name__,
               cdf_get_name_,
               cdf_get_name,
               CDF_GET_NAME)
(id, cdf_name, status Fif_GHOSTARG(len))
Int32     *id;     	/* In: CDF identifier. */
void      *cdf_name;    /* Out: CDF name. */
Int32     *status;      /* Out: CDF status code. */
Fif_GHOSTDEF(len)       /* Invisible length of "cdf_name"
                           (generated by FORTRAN compiler). */
{
  char cdfName[DU_MAX_PATH_LEN+1];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            CONFIRM_, CDF_NAME_, cdfName,
                            NULL_);
  if (StatusOK(*status)) {
#if defined(Fif_GHOSTLEN)
    CtoFORTstring (cdfName, cdf_name, Fif_GHOSTUSE(len));
#else
    CtoFORTstring (cdfName, cdf_name, DU_MAX_PATH_LEN);
#endif
  }

  return;
}

/******************************************************************************
*  CDF_get_rvar_name.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_name__,
               cdf_get_rvar_name_,
               cdf_get_rvar_name,
               CDF_GET_RVAR_NAME)
(id, var_num, var_name, status Fif_GHOSTARG(len))
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
void      *var_name;    /* Out: CDF rVariable name. */
Int32     *status;      /* Out: CDF status code. */
Fif_GHOSTDEF(len)       /* Invisible length of "var_name"
                           (generated by FORTRAN compiler). */
{
  char varName[CDF_VAR_NAME_LEN256];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_NAME_, varName,
                            NULL_);
  if (StatusOK(*status)) {
#if defined(Fif_GHOSTLEN)
    CtoFORTstring (varName, var_name, Fif_GHOSTUSE(len));
#else
    CtoFORTstring (varName, var_name, CDF_VAR_NAME_LEN256);
#endif
  }

  return;
}

/******************************************************************************
*  CDF_get_zvar_name.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_name__,
               cdf_get_zvar_name_,
               cdf_get_zvar_name,
               CDF_GET_ZVAR_NAME)
(id, var_num, var_name, status Fif_GHOSTARG(len))
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
void      *var_name;    /* Out: CDF zVariable name. */
Int32     *status;      /* Out: CDF status code. */
Fif_GHOSTDEF(len)       /* Invisible length of "var_name"
                           (generated by FORTRAN compiler). */
{
  char varName[CDF_VAR_NAME_LEN256];

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NAME_, varName,
                            NULL_);
  if (StatusOK(*status)) {
#if defined(Fif_GHOSTLEN)
    CtoFORTstring (varName, var_name, Fif_GHOSTUSE(len));
#else
    CtoFORTstring (varName, var_name, CDF_VAR_NAME_LEN256);
#endif
  }

  return;
}

/******************************************************************************
*  CDF_get_rvar_maxwrittenrecnum.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_maxwrittenrecnum__,
               cdf_get_rvar_maxwrittenrecnum_,
               cdf_get_rvar_maxwrittenrecnum,
               CDF_GET_RVAR_MAXWRITTENRECNUM)
(id, var_num, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *rec_num;     /* Out: rVariable's maximum written record number. */
Int32     *status;      /* Out: CDF status code. */
{
  long recNum;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_MAXREC_, &recNum,
                            NULL_);
  if (StatusOK(*status)) *rec_num = (Int32) (recNum + 1);

  return;
}

/******************************************************************************
*  CDF_get_zvar_maxwrittenrecnum.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_maxwrittenrecnum__,
               cdf_get_zvar_maxwrittenrecnum_,
               cdf_get_zvar_maxwrittenrecnum,
               CDF_GET_ZVAR_MAXWRITTENRECNUM)
(id, var_num, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *rec_num;     /* Out: zVariable's maximum written record number. */
Int32     *status;      /* Out: CDF status code. */
{
  long recNum;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_MAXREC_, &recNum,
                            NULL_);
  if (StatusOK(*status)) *rec_num = (Int32) (recNum + 1);

  return;
}

/******************************************************************************
*  CDF_get_rvar_maxallocrecnum.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_maxallocrecnum__,
               cdf_get_rvar_maxallocrecnum_,
               cdf_get_rvar_maxallocrecnum,
               CDF_GET_RVAR_MAXALLOCRECNUM)
(id, var_num, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *rec_num;     /* Out: rVariables's maximum allocated record number.*/
Int32     *status;      /* Out: CDF status code. */
{
  long recNum;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_MAXallocREC_, &recNum,
                            NULL_);
  if (StatusOK(*status)) *rec_num = (Int32) (recNum + 1);

  return;
}

/******************************************************************************
*  CDF_get_zvar_maxallocrecnum.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_maxallocrecnum__,
               cdf_get_zvar_maxallocrecnum_,
               cdf_get_zvar_maxallocrecnum,
               CDF_GET_ZVAR_MAXALLOCRECNUM)
(id, var_num, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *rec_num;     /* Out: zVariables's maximum allocated record number.*/
Int32     *status;      /* Out: CDF status code. */
{
  long recNum;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_MAXallocREC_, &recNum,
                            NULL_);
  if (StatusOK(*status)) *rec_num = (Int32) (recNum + 1);

  return;
}

/******************************************************************************
*  CDF_get_rvars_maxwrittenrecnum.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_maxwrittenrecnum__,
               cdf_get_rvars_maxwrittenrecnum_,
               cdf_get_rvars_maxwrittenrecnum,
               CDF_GET_RVARS_MAXWRITTENRECNUM)
(id, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *rec_num;     /* Out: rVariables's maximum written record number. */
Int32     *status;      /* Out: CDF status code. */
{
  long recNum;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_MAXREC_, &recNum,
                            NULL_);
  if (StatusOK(*status)) *rec_num = (Int32) (recNum + 1);

  return;
}

/******************************************************************************
*  CDF_get_zvars_maxwrittenrecnum.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvars_maxwrittenrecnum__,
               cdf_get_zvars_maxwrittenrecnum_,
               cdf_get_zvars_maxwrittenrecnum,
               CDF_GET_ZVARS_MAXWRITTENRECNUM)
(id, rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *rec_num;     /* Out: zVariables's maximum written record number. */
Int32     *status;      /* Out: CDF status code. */
{
  long recNum;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, zVARs_MAXREC_, &recNum,
                            NULL_);
  if (StatusOK(*status)) *rec_num = (Int32) (recNum + 1);

  return;
}

/******************************************************************************
*  CDF_get_rvar_allocrecs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_allocrecs__,
               cdf_get_rvar_allocrecs_,
               cdf_get_rvar_allocrecs,
               CDF_GET_RVAR_ALLOCRECS)
(id, var_num, num_recs, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* zVariable number. */
Int32     *num_recs;    /* Out: zVariable's number of allocated records. */
Int32     *status;      /* Out: CDF status code. */
{
  long numRecs;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_NUMallocRECS_, &numRecs,
                            NULL_);
  if (StatusOK(*status)) *num_recs = (Int32) numRecs;

  return;
}

/******************************************************************************
*  CDF_get_zvar_allocrecs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_allocrecs,
               cdf_get_zvar_allocrecs,
               cdf_get_zvar_allocrecs,
               CDF_GET_ZVAR_ALLOCRECS)
(id, var_num, num_recs, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* zVariable number. */
Int32     *num_recs;    /* Out: zVariable's number of allocated records. */
Int32     *status;      /* Out: CDF status code. */
{
  long numRecs;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMallocRECS_, &numRecs,
                            NULL_);
  if (StatusOK(*status)) *num_recs = (Int32) numRecs;

  return;
}

/******************************************************************************
*  CDF_get_rvar_allocrecfrom.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_allocrecfrom__,
               cdf_get_rvar_allocrecfrom_,
               cdf_get_rvar_allocrecfrom,
               CDF_GET_RVAR_ALLOCRECFROM)
(id, var_num, start_rec, next_rec, status)
Int32     *id;        /* In: CDF identifier. */
Int32     *var_num;   /* In: rVariable number. */
Int32     *start_rec; /* In: A rVariables's referenced record number. */
Int32     *next_rec;  /* Out: The next allocated rec number from start_rec. */
Int32     *status;    /* Out: CDF status code. */
{
  long nextRec;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_ALLOCATEDFROM_, (long) (*start_rec - 1),
                                                       &nextRec,
                            NULL_);
  if (StatusOK(*status)) *next_rec = (Int32) (nextRec + 1);

  return;
}

/******************************************************************************
*  CDF_get_zvar_allocrecfrom.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_allocrecfrom__,
               cdf_get_zvar_allocrecfrom_,
               cdf_get_zvar_allocrecfrom,
               CDF_GET_ZVAR_ALLOCRECFROM)
(id, var_num, start_rec, next_rec, status)
Int32     *id;        /* In: CDF identifier. */
Int32     *var_num;   /* In: zVariable number. */
Int32     *start_rec; /* In: A zVariables's referenced record number. */
Int32     *next_rec;  /* Out: The next allocated rec number from start_rec. */
Int32     *status;    /* Out: CDF status code. */
{
  long nextRec;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_ALLOCATEDFROM_, (long) (*start_rec - 1),
                                                       &nextRec,
                            NULL_);
  if (StatusOK(*status)) *next_rec = (Int32) (nextRec + 1);
  return;
}

/******************************************************************************
*  CDF_get_rvar_allocrecto.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_allocrecto__,
               cdf_get_rvar_allocrecto_,
               cdf_get_rvar_allocrecto,
               CDF_GET_RVAR_ALLOCRECTO)
(id, var_num, start_rec, last_rec, status)
Int32     *id;        /* In: CDF identifier. */
Int32     *var_num;   /* In: rVariable number. */
Int32     *start_rec; /* In: A rVariables's referenced record number. */
Int32     *last_rec;  /* Out: The last allocated rec number from start_rec. */
Int32     *status;    /* Out: CDF status code. */
{
  long lastRec;
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_ALLOCATEDTO_, (long) (*start_rec - 1),
                                                     &lastRec,
                            NULL_);
  if (StatusOK(*status)) *last_rec = (Int32) (lastRec + 1);
  return;
}

/******************************************************************************
*  CDF_get_zvar_allocrecto.
******************************************************************************/
VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_allocrecto__,
               cdf_get_zvar_allocrecto_,
               cdf_get_zvar_allocrecto,
               CDF_GET_ZVAR_ALLOCRECTO)
(id, var_num, start_rec, last_rec, status)
Int32     *id;        /* In: CDF identifier. */
Int32     *var_num;   /* In: zVariable number. */
Int32     *start_rec; /* In: A zVariables's referenced record number. */
Int32     *last_rec;  /* Out: The last allocated rec number from start_rec. */
Int32     *status;    /* Out: CDF status code. */
{
  long lastRec;
  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_ALLOCATEDTO_, (long) (*start_rec - 1),
                                                     &lastRec,
                            NULL_);
  if (StatusOK(*status)) *last_rec = (Int32) (lastRec + 1);
  return;
}

/******************************************************************************
*  CDF_get_rvar_datatype.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_datatype__,
               cdf_get_rvar_datatype_,
               cdf_get_rvar_datatype,
               CDF_GET_RVAR_DATATYPE)
(id, var_num, data_type, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *data_type;   /* Out: rVariable's data type. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_DATATYPE_, &dataType,
                            NULL_);
  if (StatusOK(*status)) *data_type = (Int32) dataType;

  return;
}

/******************************************************************************
*  CDF_get_zvar_datatype.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_datatype__,
               cdf_get_zvar_datatype_,
               cdf_get_zvar_datatype,
               CDF_GET_ZVAR_DATATYPE)
(id, var_num, data_type, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *data_type;   /* Out: zVariable's data type. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);
  if (StatusOK(*status)) *data_type = (Int32) dataType;

  return;
}

/******************************************************************************
*  CDF_get_rvar_numelems.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_numelems__,
               cdf_get_rvar_numelems_,
               cdf_get_rvar_numelems,
               CDF_GET_RVAR_NUMELEMS)
(id, var_num, num_elems, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_elems;   /* Out: rVariable's number of elements. */
Int32     *status;      /* Out: CDF status code. */
{
  long numElems;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_NUMELEMS_, &numElems,
                            NULL_);
  if (StatusOK(*status)) *num_elems = (Int32) numElems;

  return;
}

/******************************************************************************
*  CDF_get_zvar_numelems.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_numelems__,
               cdf_get_zvar_numelems_,
               cdf_get_zvar_numelems,
               CDF_GET_ZVAR_NUMELEMS)
(id, var_num, num_elems, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_elems;   /* Out: zVariable's number of elements. */
Int32     *status;      /* Out: CDF status code. */
{
  long numElems;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMELEMS_, &numElems,
                            NULL_);
  if (StatusOK(*status)) *num_elems = (Int32) numElems;

  return;
}

/******************************************************************************
*  CDF_get_rvars_numdims.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_numdims__,
               cdf_get_rvars_numdims_,
               cdf_get_rvars_numdims,
               CDF_GET_RVARS_NUMDIMS)
(id, num_dims, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *num_dims;    /* Out: rVariables's number of dimensions. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) *num_dims = (Int32) numDims;

  return;
}

/******************************************************************************
*  CDF_get_zvar_numdims.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_numdims__,
               cdf_get_zvar_numdims_,
               cdf_get_zvar_numdims,
               CDF_GET_ZVAR_NUMDIMS)
(id, var_num, num_dims, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_dims;    /* Out: zVariable's number of dimensions. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) *num_dims = (Int32) numDims;

  return;
}

/******************************************************************************
*  CDF_get_rvars_dimsizes.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_dimsizes__,
               cdf_get_rvars_dimsizes_,
               cdf_get_rvars_dimsizes,
               CDF_GET_RVARS_DIMSIZES)
(id, dim_sizes, status)
Int32     *id;          /* In: CDF identifier. */
Int32     dim_sizes[];  /* Out: rVariables's dimensional sizes. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, dimSizes[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_DIMSIZES_, dimSizes,
                                  rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       dim_sizes[ix] = (Int32) dimSizes[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_dimsizes.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_dimsizes__,
               cdf_get_zvar_dimsizes_,
               cdf_get_zvar_dimsizes,
               CDF_GET_ZVAR_DIMSIZES)
(id, var_num, dim_sizes, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     dim_sizes[];  /* Out: zVariable's dimensional sizes. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, dimSizes[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DIMSIZES_, dimSizes,
                                  zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       dim_sizes[ix] = (Int32) dimSizes[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_rvar_recvariance.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_recvariance__,
               cdf_get_rvar_recvariance_,
               cdf_get_rvar_recvariance,
               CDF_GET_RVAR_RECVARIANCE)
(id, var_num, rec_vary, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *rec_vary;    /* Out: rVariable's record variance. */
Int32     *status;      /* Out: CDF status code. */
{
  long recVary;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_RECVARY_, &recVary,
                            NULL_);
  if (StatusOK(*status)) *rec_vary = (Int32) recVary;

  return;
}

/******************************************************************************
*  CDF_get_zvar_recvariance.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_recvariance__,
               cdf_get_zvar_recvariance_,
               cdf_get_zvar_recvariance,
               CDF_GET_ZVAR_RECVARIANCE)
(id, var_num, rec_vary, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *rec_vary;    /* Out: zVariable's record variance. */
Int32     *status;      /* Out: CDF status code. */
{
  long recVary;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_RECVARY_, &recVary,
                            NULL_);
  if (StatusOK(*status)) *rec_vary = (Int32) recVary;

  return;
}

/******************************************************************************
*  CDF_get_rvar_dimvariances.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_dimvariances__,
               cdf_get_rvar_dimvariances_,
               cdf_get_rvar_dimvariances,
               CDF_GET_RVAR_DIMVARIANCES)
(id, var_num, dim_varys, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     dim_varys[];  /* Out: rVariable's dimensional variances. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, dimVarys[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_DIMVARYS_, dimVarys,
                                  rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       dim_varys[ix] = (Int32) dimVarys[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_dimvariances.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_dimvariances__,
               cdf_get_zvar_dimvariances_,
               cdf_get_zvar_dimvariances,
               CDF_GET_ZVAR_DIMVARIANCES)
(id, var_num, dim_varys, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     dim_varys[];  /* Out: zVariable's dimensional variances. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, dimVarys[CDF_MAX_DIMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DIMVARYS_, dimVarys,
                                  zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) {
    for (ix = 0; ix < (int) numDims; ix++)
       dim_varys[ix] = (Int32) dimVarys[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_rvar_blockingfactor.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_blockingfactor__,
               cdf_get_rvar_blockingfactor_,
               cdf_get_rvar_blockingfactor,
               CDF_GET_RVAR_BLOCKINGFACTOR)
(id, var_num, blocking_factor, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *blocking_factor; /* Out: rVariable's blocking factor. */
Int32     *status;      /* Out: CDF status code. */
{
  long blockingFactor;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_BLOCKINGFACTOR_, &blockingFactor,
                            NULL_);
  if (StatusOK(*status)) *blocking_factor = (Int32) blockingFactor;

  return;
}

/******************************************************************************
*  CDF_get_zvar_blockingfactor.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_blockingfactor__,
               cdf_get_zvar_blockingfactor_,
               cdf_get_zvar_blockingfactor,
               CDF_GET_ZVAR_BLOCKINGFACTOR)
(id, var_num, blocking_factor, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *blocking_factor; /* Out: zVariable's blocking factor. */
Int32     *status;      /* Out: CDF status code. */
{
  long blockingFactor;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_BLOCKINGFACTOR_, &blockingFactor,
                            NULL_);
  if (StatusOK(*status)) *blocking_factor = (Int32) blockingFactor;

  return;
}

/******************************************************************************
*  CDF_get_rvar_compression.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_compression__,
               cdf_get_rvar_compression_,
               cdf_get_rvar_compression,
               CDF_GET_RVAR_COMPRESSION)
(id, var_num, compress_type, compress_parms, compress_percent, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *compress_type;   /* Out: rVariable's compression type. */
Int32     compress_parms[]; /* Out: rVariable's compression parameters. */
Int32     *compress_percent;/* Out: rVariable's compression percentage. */
Int32     *status;      /* Out: CDF status code. */
{
  long cType, cPct, cParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_COMPRESSION_, &cType, cParms, &cPct,
                            NULL_);
  if (StatusOK(*status)) {
    *compress_type = (Int32) cType;
    *compress_percent = (Int32) cPct;
    for (ix = 0; ix < CDF_MAX_PARMS; ix++)
      compress_parms[ix] = (Int32) cParms[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_compression.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_compression__,
               cdf_get_zvar_compression_,
               cdf_get_zvar_compression,
               CDF_GET_ZVAR_COMPRESSION)
(id, var_num, compress_type, compress_parms, compress_percent, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *compress_type;   /* Out: zVariable's compression type. */
Int32     compress_parms[]; /* Out: zVariable's compression parameters. */
Int32     *compress_percent;/* Out: zVariable's compression percentage. */
Int32     *status;      /* Out: CDF status code. */
{
  long cType, cPct, cParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_COMPRESSION_, &cType, cParms, &cPct,
                            NULL_);
  if (StatusOK(*status)) {
    *compress_type = (Int32) cType;
    *compress_percent = (Int32) cPct;
    for (ix = 0; ix < CDF_MAX_PARMS; ix++)
      compress_parms[ix] = (Int32) cParms[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_rvar_padvalue.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_padvalue__,
               cdf_get_rvar_padvalue_,
               cdf_get_rvar_padvalue,
               CDF_GET_RVAR_PADVALUE)
(id, var_num, pad_value, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
void      *pad_value;   /* Out: rVariable's pad value. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (GET_, rVAR_PADVALUE_,
#if defined(Fif_DESCR)
                                          BOO(STRINGdataType(dataType),
                                              DESCRtoREF(pad_value),pad_value),
#else
                                          pad_value,
#endif

                            NULL_);
  if (StatusOK(*status)) {
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_padvalue.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_padvalue__,
               cdf_get_zvar_padvalue_,
               cdf_get_zvar_padvalue,
               CDF_GET_ZVAR_PADVALUE)
(id, var_num, pad_value, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
void      *pad_value;   /* Out: zVariable's pad value. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (GET_, zVAR_PADVALUE_,
#if defined(Fif_DESCR)
                                          BOO(STRINGdataType(dataType),
                                              DESCRtoREF(pad_value),pad_value),
#else
                                          pad_value,
#endif

                            NULL_);
  if (StatusOK(*status)) {
  }
  return;
}

/******************************************************************************
*  CDF_get_rvar_sparserecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_sparserecords__,
               cdf_get_rvar_sparserecords_,
               cdf_get_rvar_sparserecords,
               CDF_GET_RVAR_SPARSERECORDS)
(id, var_num, sparse_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *sparse_records; /* Out: rVariable's sparse records. */
Int32     *status;      /* Out: CDF status code. */
{
  long sparseRecords;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_SPARSERECORDS_, &sparseRecords,
                            NULL_);
  if (StatusOK(*status)) *sparse_records = (Int32) sparseRecords;

  return;
}

/******************************************************************************
*  CDF_get_zvar_sparserecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_sparserecords__,
               cdf_get_zvar_sparserecords_,
               cdf_get_zvar_sparserecords,
               CDF_GET_ZVAR_SPARSERECORDS)
(id, var_num, sparse_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *sparse_records; /* Out: zVariable's sparse records. */
Int32     *status;      /* Out: CDF status code. */
{
  long sparseRecords;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_SPARSERECORDS_, &sparseRecords,
                            NULL_);
  if (StatusOK(*status)) *sparse_records = (Int32) sparseRecords;

  return;
}

/******************************************************************************
*  CDF_get_rvar_sparsearrays.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_sparsearrays__,
               cdf_get_rvar_sparsearrays_,
               cdf_get_rvar_sparsearrays,
               CDF_GET_RVAR_SPARSEARRAYS)
(id, var_num, sarrays_type, sarrays_parms, sarrays_pct, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *sarrays_type;   /* Out: rVariable's sparse array type. */
Int32     sarrays_parms[]; /* Out: rVariable's sparse array parameters. */
Int32     *sarrays_pct;    /* Out: rVariable's sparse array percentage. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, sArraysType, sArraysPct, sArraysParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_SPARSEARRAYS_, &sArraysType, sArraysParms,
                                                      &sArraysPct,
                                  rVARs_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) {
    *sarrays_type = (Int32) sArraysType;
    *sarrays_pct = (Int32) sArraysPct;
    for (ix = 0; ix < (int) numDims; ix++)
       sarrays_parms[ix] = (Int32) sArraysParms[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_zvar_sparsearrays.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_sparsearrays__,
               cdf_get_zvar_sparsearrays_,
               cdf_get_zvar_sparsearrays,
               CDF_GET_ZVAR_SPARSEARRAYS)
(id, var_num, sarrays_type, sarrays_parms, sarrays_pct, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *sarrays_type;   /* Out: zVariable's sparse array type. */
Int32     sarrays_parms[]; /* Out: zVariable's sparse array parameters. */
Int32     *sarrays_pct;    /* Out: zVariable's sparse array percentage. */
Int32     *status;      /* Out: CDF status code. */
{
  long numDims, sArraysType, sArraysPct, sArraysParms[CDF_MAX_PARMS];
  int ix;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_SPARSEARRAYS_, &sArraysType, sArraysParms,
                                                      &sArraysPct,
                                  zVAR_NUMDIMS_, &numDims,
                            NULL_);
  if (StatusOK(*status)) {
    *sarrays_type = (Int32) sArraysType;
    *sarrays_pct = (Int32) sArraysPct;
    for (ix = 0; ix < (int) numDims; ix++)
       sarrays_parms[ix] = (Int32) sArraysParms[ix];
  }
  return;
}

/******************************************************************************
*  CDF_get_rvar_numrecs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_numrecs__,
               cdf_get_rvar_numrecs_,
               cdf_get_rvar_numrecs,
               CDF_GET_RVAR_NUMRECS)
(id, var_num, num_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *num_records; /* Out: rVariable's written records. */
Int32     *status;      /* Out: CDF status code. */
{
  long numRecords;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_NUMRECS_, &numRecords,
                            NULL_);
  if (StatusOK(*status)) *num_records = (Int32) numRecords;

  return;
}

/******************************************************************************
*  CDF_get_zvar_numrecs.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_numrecs__,
               cdf_get_zvar_numrecs_,
               cdf_get_zvar_numrecs,
               CDF_GET_ZVAR_NUMRECS)
(id, var_num, num_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_records; /* Out: zVariable's written records. */
Int32     *status;      /* Out: CDF status code. */
{
  long numRecords;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_NUMRECS_, &numRecords,
                            NULL_);
  if (StatusOK(*status)) *num_records = (Int32) numRecords;

  return;
}

/******************************************************************************
*  CDF_get_vars_maxwrittenrecnums.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_vars_maxwrittenrecnums__,
               cdf_get_vars_maxwrittenrecnums_,
               cdf_get_vars_maxwrittenrecnums,
               CDF_GET_VARS_MAXWRITTENRECNUMS)
(id, rvar_rec_num, zvar_rec_num, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *rvar_rec_num; /* Out: CDF rVariables's max written record number. */
Int32     *zvar_rec_num; /* Out: CDF zVariables's max written record number. */
Int32     *status;      /* Out: CDF status code. */
{
  long recNum1, recNum2;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                            GET_, rVARs_MAXREC_, &recNum1,
                                  zVARs_MAXREC_, &recNum2,
                            NULL_);
  if (StatusOK(*status)) {
    *rvar_rec_num = (Int32) recNum1;
    *rvar_rec_num = (Int32) recNum1;
  }

  return;
}

/******************************************************************************
*  CDF_get_rvar_numindexentries.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_numindexentries__,
               cdf_get_rvar_numindexentries_,
               cdf_get_rvar_numindexentries,
               CDF_GET_RVAR_NUMINDEXENTRIES)
(id, var_num, num_idx_entries, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *num_idx_entries; /* Out: CDF rVariable's number of index entries. */
Int32     *status;      /* Out: CDF status code. */
{
  long numIdxEntries;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_nINDEXENTRIES_, &numIdxEntries,
                            NULL_);
  if (StatusOK(*status)) *num_idx_entries = (Int32) numIdxEntries;

  return;
}

/******************************************************************************
*  CDF_get_zvar_numindexentries.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_numindexentries__,
               cdf_get_zvar_numindexentries_,
               cdf_get_zvar_numindexentries,
               CDF_GET_ZVAR_NUMINDEXENTRIES)
(id, var_num, num_idx_entries, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_idx_entries; /* Out: CDF zVariable's number of index entries. */
Int32     *status;      /* Out: CDF status code. */
{
  long numIdxEntries;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_nINDEXENTRIES_, &numIdxEntries,
                            NULL_);
  if (StatusOK(*status)) *num_idx_entries = (Int32) numIdxEntries;

  return;
}

/******************************************************************************
*  CDF_get_rvar_numindexlevels.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_numindexlevels__,
               cdf_get_rvar_numindexlevels_,
               cdf_get_rvar_numindexlevels,
               CDF_GET_RVAR_NUMINDEXLEVELS)
(id, var_num, num_idx_levels, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *num_idx_levels; /* Out: CDF rVariable's number of index levels. */
Int32     *status;      /* Out: CDF status code. */
{
  long numIdxLevels;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_nINDEXLEVELS_, &numIdxLevels,
                            NULL_);
  if (StatusOK(*status)) *num_idx_levels = (Int32) numIdxLevels;

  return;
}

/******************************************************************************
*  CDF_get_zvar_numindexlevels.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_numindexlevels__,
               cdf_get_zvar_numindexlevels_,
               cdf_get_zvar_numindexlevels,
               CDF_GET_ZVAR_NUMINDEXLEVELS)
(id, var_num, num_idx_levels, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_idx_levels; /* Out: CDF zVariable's number of index levels. */
Int32     *status;      /* Out: CDF status code. */
{
  long numIdxLevels;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_nINDEXLEVELS_, &numIdxLevels,
                            NULL_);
  if (StatusOK(*status)) *num_idx_levels = (Int32) numIdxLevels;

  return;
}

/******************************************************************************
*  CDF_get_rvar_numindexrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_numindexrecords__,
               cdf_get_rvar_numindexrecords_,
               cdf_get_rvar_numindexrecords,
               CDF_GET_RVAR_NUMINDEXRECORDS)
(id, var_num, num_idx_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
Int32     *num_idx_records; /* Out: CDF rVariable's number of index records. */
Int32     *status;      /* Out: CDF status code. */
{
  long numIdxRecords;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_nINDEXRECORDS_, &numIdxRecords,
                            NULL_);
  if (StatusOK(*status)) *num_idx_records = (Int32) numIdxRecords;

  return;
}

/******************************************************************************
*  CDF_get_zvar_numindexrecords.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_numindexrecords__,
               cdf_get_zvar_numindexrecords_,
               cdf_get_zvar_numindexrecords,
               CDF_GET_ZVAR_NUMINDEXRECORDS)
(id, var_num, num_idx_records, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
Int32     *num_idx_records; /* Out: CDF zVariable's number of index records. */
Int32     *status;      /* Out: CDF status code. */
{
  long numIdxRecords;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_nINDEXRECORDS_, &numIdxRecords,
                            NULL_);
  if (StatusOK(*status)) *num_idx_records = (Int32) numIdxRecords;

  return;
}

/******************************************************************************
*  CDF_get_rvar_seqdata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_seqdata__,
               cdf_get_rvar_seqdata_,
               cdf_get_rvar_seqdata,
               CDF_GET_RVAR_SEQDATA)
(id, var_num, data, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF rVariable number. */
void      *data;        /* Out: CDF rVariable's data. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVAR_, (long) (*var_num - 1),
                            GET_, rVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (GET_, rVAR_SEQDATA_,
#if defined(Fif_DESCR)
                                              BOO(STRINGdataType(dataType),
                                                  DESCRtoREF(data),data),
#else
                                              data,
#endif

                            NULL_);

  return;
}

/******************************************************************************
*  CDF_get_zvar_seqdata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_seqdata__,
               cdf_get_zvar_seqdata_,
               cdf_get_zvar_seqdata,
               CDF_GET_ZVAR_SEQDATA)
(id, var_num, data, status)
Int32     *id;          /* In: CDF identifier. */
Int32     *var_num;     /* In: CDF zVariable number. */
void      *data;        /* Out: CDF zVariable's data. */
Int32     *status;      /* Out: CDF status code. */
{
  long dataType;

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVAR_, (long) (*var_num - 1),
                            GET_, zVAR_DATATYPE_, &dataType,
                            NULL_);

  if (StatusBAD(*status)) return;

  *status = (Int32) CDFlib (GET_, zVAR_SEQDATA_,
#if defined(Fif_DESCR)
                                              BOO(STRINGdataType(dataType),
                                                  DESCRtoREF(data),data),
#else
                                              data,
#endif

                            NULL_);

  return;
}

/******************************************************************************
*  CDF_get_rvars_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvars_recorddata__,
               cdf_get_rvars_recorddata_,
               cdf_get_rvars_recorddata,
               CDF_GET_RVARS_RECORDDATA)
(id, num_vars, var_nums, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *num_vars;            /* In: Number of rVariables. */
Int32     var_nums[];           /* In: rVariable numbers. */
Int32     *rec_num;             /* In: Record number. */
void      *buffer;              /* In: Buffer for output data */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars = (long) *num_vars;
  long recNum = (long) (*rec_num - 1);
  long varNums[CDF_MAX_DIMS];
  int ix;

  if (*num_vars < 1) {
    *status = (Int32) CDF_OK;
    return;
  }

  for (ix = 0; ix < *num_vars; ix++) varNums[ix] = (long) (var_nums[ix] - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     rVARs_RECNUMBER_, (long) (*rec_num - 1),
                            GET_, rVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_get_zvars_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvars_recorddata__,
               cdf_get_zvars_recorddata_,
               cdf_get_zvars_recorddata,
               CDF_GET_ZVARS_RECORDDATA)
(id, num_vars, var_nums, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *num_vars;            /* In: Number of rVariables. */
Int32     var_nums[];           /* In: zVariable numbers. */
Int32     *rec_num;             /* In: Record number. */
void      *buffer;              /* Out: Buffer for input data */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars = (long) *num_vars;
  long recNum = (long) (*rec_num - 1);
  long varNums[CDF_MAX_DIMS];
  int ix;

  if (*num_vars < 1) {
    *status = (Int32) CDF_OK;
    return;
  }

  for (ix = 0; ix < *num_vars; ix++) varNums[ix] = (long) (var_nums[ix] - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, Int32ToCDFid(*id),
                                     zVARs_RECNUMBER_, (long) (*rec_num - 1),
                            GET_, zVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);

  return;
}

/******************************************************************************
*  CDF_get_rvar_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_rvar_recorddata__,
               cdf_get_rvar_recorddata_,
               cdf_get_rvar_recorddata,
               CDF_GET_RVAR_RECORDDATA)
(id, var_num, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF rVariable number. */
Int32     *rec_num;             /* In: CDF rVariable record number. */
void      *buffer;              /* Out: rVariable's full record data. */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars, varNums[CDF_MAX_DIMS];

  numVars = 1;
  varNums[0] = (long) (*var_num - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, id,
                                     rVARs_RECNUMBER_, (long) (*rec_num - 1),
                            GET_, rVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);
  return;
}

/******************************************************************************
*  CDF_get_zvar_recorddata.
******************************************************************************/

VISIBLE_PREFIX
Fif_PREFIXa
void
Fif_PREFIXb
Fif_ENTRYPOINT(cdf_get_zvar_recorddata__,
               cdf_get_zvar_recorddata_,
               cdf_get_zvar_recorddata,
               CDF_GET_ZVAR_RECORDDATA)
(id, var_num, rec_num, buffer, status)
Int32     *id;                  /* In: CDF identifier. */
Int32     *var_num;             /* In: CDF zVariable number. */
Int32     *rec_num;             /* In: CDF zVariable record number. */
void      *buffer;              /* Out: zVariable's full record data. */
Int32     *status;              /* Out: CDF status code. */
{
  long numVars, varNums[CDF_MAX_DIMS];

  numVars = 1;
  varNums[0] = (long) (*var_num - 1);

  *status = (Int32) CDFlib (SELECT_, CDF_, id,
                                     zVARs_RECNUMBER_, (long) (*rec_num - 1),
                            GET_, zVARs_RECDATA_, numVars, varNums, buffer,
                            NULL_);
  return;
}


