import java.io.*;
import java.text.*;
import java.util.*;
import gsfc.nssdc.cdf.*;
import gsfc.nssdc.cdf.util.*;

/**
 * This test program demonstrates how to create a single-file CDF 
 * called test.cdf.  It also copies a variable along with data out of
 * test.cdf and creates a new single-file CDF called test1.cdf.
 *
 * Thie program demonstrates the following techniques: 
 *
 *   - how to create a variable
 *   - how to create a global attribute
 *   - how to create a variable attribute
 *   - how to create a global variable attribute entry 
 *   - how to create a variable attribute entry 
 *   - how to add data to a variable
 *   - how to delete a variable attribute
 *   - how to rename a variable
 *   - how to rename a variable attribute
 *   - how to copy a variable with or without data
 *   - how to delete data (records) out of a variable
 *   - how to set options that are available with a CDF file and a variable
 */

public class TestEpoch implements CDFConstants{

   public static void main(String[] args) {
      CDF cdf  = null,
          cdf1 = null;

      try {

          /******************************************************************/
          /*  If the file to be created is a multifile (not a single file), */
          /*  the following restrictions apply:                             */
          /*                                                                */
          /*     - CDF file extension is not allowed (i.e. .cdf)            */
          /*     - Compression and sparse records are not allowed           */
          /*     - Deleting a variable is not allowed                       */
          /******************************************************************/
          File cdfFile = new File("testEpoch.cdf");
          if (cdfFile.exists()) cdfFile.delete();

          cdf  = CDF.create("testEpoch");

          /*******************************************/
          /*  Create global and variable attributes  */
          /*******************************************/
          Attribute 
             project  = Attribute.create(cdf, "Project", GLOBAL_SCOPE),

             myAttr   = Attribute.create(cdf, "myAttr", VARIABLE_SCOPE);

          System.out.println("Created attributes.");
                                            
          Variable
            ep = Variable.create(cdf, "ep", CDF_EPOCH16, 
                                 1, 0, new long [] {0},
                                 VARY, 
                                 new long [] {VARY});

          System.out.println("Created variables.");
          double mmm;
          double[] testDateData  = new double[2];
	  mmm = Epoch16.compute((long)2002, (long)4, (long)25, (long)1, 
				(long)2, (long)3, (long)4, (long)5, 
				(long)6, (long)7, testDateData);
          Entry.create(myAttr, ep.getID(), CDF_EPOCH16, testDateData); 
          System.out.println("\tEPOCH16 completed.");

          /************************************/
          /*  Add variable attribute entries  */
          /************************************/
          System.out.println("Adding variable attribute entries...");

          double[] testDateData1 = new double[2];
	  mmm  = Epoch16.compute((long)2002, (long)5, (long)13, (long)0, 
				 (long)0, (long)0,(long)100,(long)200,
				 (long)300,(long)400, testDateData1);
          ep.putEntry(myAttr,  CDF_EPOCH16, testDateData1);
          System.out.println("Added myAttr for ep.");

          /*****************/
          /*  Add ep data  */
          /*****************/
          double[] epData = new double[2], epData1 = new double[2];
	  mmm = Epoch16.compute((long)1999, (long)3, (long)5, (long)5, 
				(long)0, (long)0, (long)2,(long)4,
				(long)6,(long)800,epData);
          mmm = Epoch16.compute((long)1998, (long)1, (long)2, (long)3, 
				(long)0, (long)0, (long)3,(long)6,
				(long)9,(long)12,epData1);
          String e0 = Epoch16.encode(epData1);
          double[] p0 = (double[]) Epoch16.parse(e0);

          ep.putScalarData(0L, epData); 
          ep.putScalarData(1L, p0); 

          System.out.println("\tAdded putSingleData ep data.");

          cdf.close();
          System.out.println("** Tested successfully **");

        } catch (Exception e) {
            System.out.println("A bad thing happened on the way to the CDF.");
            e.printStackTrace();
        }
    }
}
