/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ExportToCDFOptions
extends JDialog {
    private static ExportToCDFOptions dialog;
    static boolean defaultModal;
    private static final String ENTER = "Continue";
    private static final String RESET = "Reset";
    private static final String CANCEL = "Cancel";
    private JFrame myFrame;
    protected CDFExport cdfexport;
    private ButtonGroup majoritygp;
    private JRadioButton majority0;
    private JRadioButton majority1;
    private JRadioButton majority2;
    private ButtonGroup encodinggp;
    private JRadioButton encoding1;
    private JRadioButton encoding2;
    private ButtonGroup formatgp;
    private JRadioButton format1;
    private JRadioButton format2;
    private ButtonGroup compressiongp;
    private JRadioButton compression1;
    private JRadioButton compression2;
    private JRadioButton compression3;
    private JRadioButton compression4;
    private JRadioButton compression5;
    private JCheckBox oec;
    private JTextField compressLevel;

    public static ExportToCDFOptions createToCDFOptions(JFrame jFrame, CDFExport cDFExport, boolean bl) {
        if (dialog == null) {
            dialog = new ExportToCDFOptions(jFrame, bl);
            dialog.getContentPane().setLayout(new BorderLayout());
        }
        ExportToCDFOptions.dialog.cdfexport = cDFExport;
        dialog.packUIs();
        return dialog;
    }

    public void displayToCDFOptions() {
        dialog.setVisible(true);
    }

    private final void packUIs() {
        dialog.setTitle("Output To CDF Options");
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        dialog.setSize(450, 400);
        dialog.setLocation(0, 0);
        JPanel jPanel = (JPanel)dialog.getContentPane();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.buildUIs();
        JPanel jPanel2 = new JPanel(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Majority");
        jLabeledPanel.setLayout(new BoxLayout(jLabeledPanel, 1));
        jLabeledPanel.setAlignmentY(0.0f);
        jLabeledPanel.add(this.majority0);
        jLabeledPanel.add(this.majority1);
        jLabeledPanel.add(this.majority2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jLabeledPanel, gridBagConstraints);
        jPanel2.add(jLabeledPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        Component component = Box.createRigidArea(new Dimension(50, 1));
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel2.add(component);
        JLabeledPanel jLabeledPanel2 = new JLabeledPanel("Encoding");
        jLabeledPanel2.setLayout(new BoxLayout(jLabeledPanel2, 1));
        jLabeledPanel2.setAlignmentY(0.0f);
        jLabeledPanel2.add(this.encoding1);
        jLabeledPanel2.add(this.encoding2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jLabeledPanel2, gridBagConstraints);
        jPanel2.add(jLabeledPanel2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel2.add(component);
        JLabeledPanel jLabeledPanel3 = new JLabeledPanel("Format");
        jLabeledPanel3.setLayout(new BoxLayout(jLabeledPanel3, 1));
        jLabeledPanel3.setAlignmentY(0.0f);
        jLabeledPanel3.add(this.format1);
        jLabeledPanel3.add(this.format2);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jLabeledPanel3, gridBagConstraints);
        jPanel2.add(jLabeledPanel3);
        JLabeledPanel jLabeledPanel4 = new JLabeledPanel("Compression");
        jLabeledPanel4.setLayout(new BoxLayout(jLabeledPanel4, 1));
        jLabeledPanel4.setAlignmentY(0.0f);
        jLabeledPanel4.setAlignmentX(0.0f);
        jLabeledPanel4.add(this.compression1);
        jLabeledPanel4.add(this.compression2);
        jLabeledPanel4.add(this.compression3);
        jLabeledPanel4.add(this.compression4);
        JPanel jPanel3 = new JPanel(new FlowLayout(), true);
        jPanel3.add(this.compression5);
        jPanel3.add(this.compressLevel);
        this.compressLevel.setEnabled(false);
        jLabeledPanel4.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabeledPanel4, gridBagConstraints);
        jPanel2.add(jLabeledPanel4);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.oec, gridBagConstraints);
        jPanel2.add(this.oec);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel2.add(component);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(Box.createVerticalStrut(20), gridBagConstraints);
        jPanel2.add(Box.createVerticalStrut(20));
        jPanel.add((Component)jPanel2, "Center");
        this.createButtonPanel(jPanel);
    }

    private final void buildUIs() {
        this.oec = new JCheckBox("Overwrite the existing CDF");
        this.compressLevel = new JTextField(1);
        this.majoritygp = new ButtonGroup();
        this.majority0 = new JRadioButton("Source");
        this.majority1 = new JRadioButton("Row");
        this.majority2 = new JRadioButton("Column");
        MajorityListener majorityListener = new MajorityListener();
        this.majority0.setActionCommand("0");
        this.majority1.setActionCommand("1");
        this.majority2.setActionCommand("2");
        this.majority0.addActionListener(majorityListener);
        this.majority1.addActionListener(majorityListener);
        this.majority2.addActionListener(majorityListener);
        this.majority0.setSelected(true);
        this.majoritygp.add(this.majority0);
        this.majoritygp.add(this.majority1);
        this.majoritygp.add(this.majority2);
        this.majority0.setToolTipText("Use source CDF's majority for the output file");
        this.majority1.setToolTipText("use Row majority for the output file");
        this.majority2.setToolTipText("Use Column majority for the output file");
        this.encodinggp = new ButtonGroup();
        this.encoding1 = new JRadioButton("Host");
        this.encoding2 = new JRadioButton("Network");
        EncodingListener encodingListener = new EncodingListener();
        this.encoding1.setActionCommand("0");
        this.encoding2.setActionCommand("1");
        this.encoding1.addActionListener(encodingListener);
        this.encoding2.addActionListener(encodingListener);
        this.encoding1.setSelected(true);
        this.encodinggp.add(this.encoding1);
        this.encodinggp.add(this.encoding2);
        this.encoding1.setToolTipText("use netork encoding for the output file");
        this.encoding2.setToolTipText("Use host machine's encoding for the output file");
        this.formatgp = new ButtonGroup();
        this.format1 = new JRadioButton("Single-file CDF");
        this.format2 = new JRadioButton("Multi-file CDF");
        FormatListener formatListener = new FormatListener();
        this.format1.setActionCommand("1");
        this.format2.setActionCommand("2");
        this.format1.addActionListener(formatListener);
        this.format2.addActionListener(formatListener);
        this.format1.setSelected(true);
        this.formatgp.add(this.format1);
        this.formatgp.add(this.format2);
        this.format1.setToolTipText("Use single file format for the output file");
        this.format2.setToolTipText("Use multi-file format for the output file");
        this.compressiongp = new ButtonGroup();
        this.compression1 = new JRadioButton("None");
        this.compression2 = new JRadioButton("RLE");
        this.compression3 = new JRadioButton("Huffman");
        this.compression4 = new JRadioButton("AHuffman");
        this.compression5 = new JRadioButton("GZIP");
        CompressionListener compressionListener = new CompressionListener();
        this.compression1.setActionCommand("0");
        this.compression2.setActionCommand("1");
        this.compression3.setActionCommand("2");
        this.compression4.setActionCommand("3");
        this.compression5.setActionCommand("5");
        this.compression1.addActionListener(compressionListener);
        this.compression2.addActionListener(compressionListener);
        this.compression3.addActionListener(compressionListener);
        this.compression4.addActionListener(compressionListener);
        this.compression5.addActionListener(compressionListener);
        this.compression1.setSelected(true);
        this.compressiongp.add(this.compression1);
        this.compressiongp.add(this.compression2);
        this.compressiongp.add(this.compression3);
        this.compressiongp.add(this.compression4);
        this.compressiongp.add(this.compression5);
        this.compression1.setToolTipText("No compression applied");
        this.compression2.setToolTipText("Use Run-Length Encoding compression method");
        this.compression3.setToolTipText("Use Huffman compression method");
        this.compression4.setToolTipText("Use Adaptive Huffman compression method");
        this.compression5.setToolTipText("Use GNU GZIP compression method");
        OptionsListener optionsListener = new OptionsListener();
        this.oec.addItemListener(optionsListener);
        this.oec.setToolTipText("Overwrite the existing CDF");
        TextFieldListener textFieldListener = new TextFieldListener();
        this.compressLevel.addActionListener(textFieldListener);
        this.compressLevel.setToolTipText("Compression level (1-9) for GZIP method");
    }

    private final void createButtonPanel(JPanel jPanel) {
        JButton jButton = new JButton(ENTER);
        JButton jButton2 = new JButton(RESET);
        JButton jButton3 = new JButton(CANCEL);
        JPanel jPanel2 = new JPanel(true);
        SelectionListener selectionListener = new SelectionListener();
        jButton.addActionListener(selectionListener);
        jButton2.addActionListener(selectionListener);
        jButton3.addActionListener(selectionListener);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton3);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jButton.setToolTipText("Continue to the next step ...");
        jButton2.setToolTipText("Reset the selections to their defaults...");
        jButton3.setToolTipText("Stop but keep the selections and retrun to the previous step...");
        jPanel.add((Component)jPanel2, "South");
    }

    public void reset() {
        this.majority0.setSelected(true);
        this.encoding1.setSelected(true);
        this.format1.setSelected(true);
        this.compression1.setSelected(true);
        this.compressLevel.setEnabled(false);
        this.oec.setSelected(false);
        this.compressLevel.setText("");
        this.cdfexport.majority = 0L;
        this.cdfexport.encoding = 0L;
        this.cdfexport.format = 1L;
        this.cdfexport.compressionType = 0;
        this.cdfexport.compressionLevel = 0;
        this.cdfexport.overwrite = 0;
    }

    static /* synthetic */ String access$5() {
        return CANCEL;
    }

    static /* synthetic */ String access$6() {
        return ENTER;
    }

    static /* synthetic */ String access$7() {
        return RESET;
    }

    ExportToCDFOptions(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
    }

    static {
        defaultModal = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MajorityListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ExportToCDFOptions.this.cdfexport.majority = Integer.parseInt(actionEvent.getActionCommand());
        }

        private MajorityListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EncodingListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ExportToCDFOptions.this.cdfexport.encoding = Integer.parseInt(actionEvent.getActionCommand());
        }

        private EncodingListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class FormatListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ExportToCDFOptions.this.cdfexport.format = Integer.parseInt(actionEvent.getActionCommand());
        }

        private FormatListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CompressionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ExportToCDFOptions.this.cdfexport.compressionType = Integer.parseInt(actionEvent.getActionCommand());
            if (ExportToCDFOptions.this.cdfexport.compressionType == 5) {
                ExportToCDFOptions.this.compressLevel.setEnabled(true);
                String string = ExportToCDFOptions.this.compressLevel.getText();
                if (string.equals(null) || string.trim().length() == 0) {
                    ExportToCDFOptions.this.compressLevel.setText("5");
                }
            } else {
                ExportToCDFOptions.this.compressLevel.setEnabled(false);
                ExportToCDFOptions.this.compressLevel.setText("");
            }
        }

        private CompressionListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OptionsListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == ExportToCDFOptions.this.oec) {
                if (ExportToCDFOptions.this.oec.isSelected()) {
                    int n = JOptionPane.showConfirmDialog(ExportToCDFOptions.this.myFrame, "Do you want to overwrite the existing CDF file?", "Delete Existing File?", 1);
                    if (n == 0) {
                        ExportToCDFOptions.this.cdfexport.overwrite = 1;
                    } else {
                        ExportToCDFOptions.this.oec.setSelected(false);
                        ExportToCDFOptions.this.cdfexport.overwrite = 0;
                    }
                } else {
                    ExportToCDFOptions.this.cdfexport.overwrite = 0;
                }
            }
        }

        private OptionsListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TextFieldListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JTextField)actionEvent.getSource()).getText();
            int n = Integer.parseInt(string);
            if (n < 1 || n > 9) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(dialog, "Compression level has to\nbe between 1 and 9", "Compression Level Error", 0);
                ExportToCDFOptions.this.compressLevel.setText("");
            } else {
                ExportToCDFOptions.this.compression5.setSelected(true);
                ExportToCDFOptions.this.cdfexport.compressionType = 5;
                ExportToCDFOptions.this.cdfexport.compressionLevel = n;
            }
        }

        private TextFieldListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                String string = actionEvent.getActionCommand();
                if (string.equals(ExportToCDFOptions.CANCEL)) {
                    dialog.setVisible(false);
                    ExportToCDFOptions.this.cdfexport.repaint();
                } else if (string.equals(ExportToCDFOptions.ENTER)) {
                    if (ExportToCDFOptions.this.compression5.isSelected()) {
                        String string2 = ExportToCDFOptions.this.compressLevel.getText();
                        if (!string2.equals(null) && string2.trim().length() != 0) {
                            int n = Integer.parseInt(string2);
                            if (n > 0 && n < 10) {
                                dialog.setVisible(false);
                                ExportToCDFOptions.this.cdfexport.compressionLevel = n;
                            }
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(dialog, "Compression level has to\nbe between 1 and 9 for GZIP", "Compression Level Error", 0);
                            ExportToCDFOptions.this.compressLevel.setText("");
                        }
                    }
                    dialog.setVisible(false);
                    ExportToCDFOptions.this.cdfexport.repaint();
                } else if (string.equals(ExportToCDFOptions.RESET)) {
                    ExportToCDFOptions.this.reset();
                }
            }
        }

        private SelectionListener() {
        }
    }
}

