/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VariableValuePanel
extends JPanel
implements CDFConstants,
ActionListener,
KeyListener,
FocusListener,
DocumentListener,
VariableEventListener {
    private static final String UPDATE = "Update";
    private static final String CANCEL = "Cancel";
    private CDF cdf;
    private MYEditor myEditor;
    private VariablePanel myVP;
    private Variable var;
    private Variable oldVar;
    private VariableValuePanel values;
    private boolean variance;
    private long nDims;
    private long[] sizes;
    private long dataType;
    private long[] dimVars;
    private long[] dimSizes;
    private Object padValue;
    private long sparseRec;
    private long maxRec;
    private long numElements;
    private long status;
    private String Virtual;
    private boolean virtual;
    private Object datavalue;
    private String output;
    private Object focusedObj;
    private JLabeledTF jtfRec;
    private JLabeledTF jtfVal;
    private JTextField oldRec;
    private JLabeledPanel jpIndex;
    private JTextField[] jtfIndex;
    private JTextField[] oldIndex;
    private JButton update;
    private JButton cancel;
    private long[] dimIndex;
    private long recNum;
    private JLabeledPanel jp;
    private String format;

    public void set(Variable variable) {
        this.values.setVisible(true);
        this.var = variable;
        if (this.oldVar != null && this.oldVar.getRecVariance()) {
            this.jtfRec.removeActionListener(this);
            this.jtfRec.textField.removeKeyListener(this);
            this.jtfRec.textField.removeFocusListener(this);
        }
        this.oldVar = variable;
        this.variance = variable.getRecVariance();
        this.nDims = variable.getNumDims();
        this.dataType = variable.getDataType();
        this.numElements = variable.getNumElements();
        this.dimVars = variable.getDimVariances();
        this.dimSizes = variable.getDimSizes();
        this.padValue = null;
        try {
            if (variable.checkPadValueExistence()) {
                this.padValue = variable.getPadValue();
            }
        }
        catch (CDFException cDFException) {}
        this.format = CDFToolUtils.getCFormat(variable);
        this.sparseRec = variable.getSparseRecords();
        try {
            this.maxRec = variable.getMaxWrittenRecord();
        }
        catch (CDFException cDFException) {
            this.maxRec = -1;
        }
        if (this.variance) {
            this.jtfRec.setEnabled(true);
            this.jtfRec.setEditable(true);
            this.jtfRec.addActionListener(this);
            this.jtfRec.textField.addKeyListener(this);
            this.jtfRec.textField.addFocusListener(this);
            this.jtfRec.textField.setRequestFocusEnabled(true);
        } else {
            this.jtfRec.setEditable(false);
            this.jtfRec.setEnabled(true);
            this.jtfRec.textField.setRequestFocusEnabled(false);
        }
        this.jpIndex.removeAll();
        if (this.nDims > 0L) {
            this.jtfIndex = new JTextField[(int)this.nDims];
            this.oldIndex = new JTextField[(int)this.nDims];
            this.dimIndex = new long[(int)this.nDims];
            int n = 0;
            while (n < (int)this.nDims) {
                final long l = this.dimVars[n];
                this.jtfIndex[n] = new JTextField(4){

                    public final boolean isFocusTraversable() {
                        return l == (long)-1;
                    }
                };
                this.jtfIndex[n].setHorizontalAlignment(4);
                this.oldIndex[n] = new JTextField();
                if (this.dimVars[n] == (long)-1) {
                    this.jtfIndex[n].addActionListener(this);
                    this.jtfIndex[n].addKeyListener(this);
                    this.jtfIndex[n].addFocusListener(this);
                } else {
                    this.jtfIndex[n].setRequestFocusEnabled(false);
                }
                this.jpIndex.add(this.jtfIndex[n]);
                ++n;
            }
        } else {
            this.jtfIndex = new JTextField[1];
            this.jtfIndex[0] = new JTextField();
            this.jtfIndex[0].setHorizontalAlignment(4);
            this.dimIndex = new long[1];
            this.jtfIndex[0] = new JTextField(4);
            this.jtfIndex[0].setEnabled(false);
            this.jtfIndex[0].setRequestFocusEnabled(false);
            this.jpIndex.add(this.jtfIndex[0]);
        }
        this.jp.validate();
        this.setInitialIndex();
        this.showIndexData();
    }

    private final void setInitialIndex() {
        this.recNum = 0L;
        if (this.variance) {
            this.jtfRec.set("1");
        } else {
            this.jtfRec.set("*");
        }
        if (this.nDims > 0L) {
            int n = 0;
            while (n < (int)this.nDims) {
                String string;
                this.dimIndex[n] = 0L;
                if (this.dimVars[n] == 0L) {
                    string = "*";
                    this.jtfIndex[n].setEditable(false);
                } else {
                    string = "1";
                    this.jtfIndex[n].setEditable(true);
                }
                this.jtfIndex[n].setText(string);
                ++n;
            }
        } else {
            String string = "*";
            this.jtfIndex[0].setEnabled(false);
            this.jtfIndex[0].setEditable(false);
            this.jtfIndex[0].setText(string);
        }
    }

    private final void showIndexData() {
        String string = null;
        this.virtual = false;
        if (this.recNum <= this.maxRec) {
            try {
                this.datavalue = this.var.getSingleData(this.recNum, this.dimIndex);
            }
            catch (CDFException cDFException) {
                this.datavalue = null;
            }
            if (this.sparseRec != 0L) {
                this.status = this.cdf.getStatus();
                if (this.status == 1001L) {
                    this.virtual = true;
                }
            }
            if (this.dataType == 31L) {
                string = Epoch.encode((double)((Double)this.datavalue));
            } else if (this.dataType == 32L) {
                string = Epoch16.encode((Object)((double[])this.datavalue));
            } else if (this.dataType == 51L || this.dataType == 52L) {
                if ((long)((String)this.datavalue).length() >= this.numElements) {
                    string = ((String)this.datavalue).substring(0, (int)this.numElements);
                } else if ((long)((String)this.datavalue).length() < this.numElements) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (n < (int)this.numElements - ((String)this.datavalue).length()) {
                        stringBuffer.append(" ");
                        ++n;
                    }
                    string = (String)this.datavalue + stringBuffer.toString();
                }
                string = "\"" + string + '\"';
            } else if (this.format == null) {
                string = this.datavalue.toString();
            } else if (this.dataType == 21L || this.dataType == 44L || this.dataType == 45L) {
                double d = this.dataType == 21L || this.dataType == 44L ? (double)((Float)this.datavalue).floatValue() : (Double)this.datavalue;
                string = Cformat.getInstance(this.format).form(d).toString();
            } else {
                string = this.datavalue.toString();
            }
        } else {
            this.virtual = true;
            if (this.padValue == null) {
                switch ((int)this.dataType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 41: {
                        string = "0";
                        break;
                    }
                    case 21: 
                    case 44: 
                    case 45: {
                        string = "0.0000";
                        break;
                    }
                    case 31: {
                        string = "01-Jan-0000 00:00:00.000";
                        break;
                    }
                    case 32: {
                        string = "01-Jan-0000 00:00:00.000.000.000.000";
                        break;
                    }
                    case 51: 
                    case 52: {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\"");
                        int n = 0;
                        while (n < (int)this.numElements) {
                            stringBuffer.append(" ");
                            ++n;
                        }
                        stringBuffer.append("\"");
                        string = stringBuffer.toString();
                        break;
                    }
                }
            } else if (this.dataType != 31L && this.dataType != 32L) {
                string = this.padValue.toString();
            } else if (this.dataType == 31L) {
                if (this.padValue instanceof String) {
                    string = (String)this.padValue;
                } else {
                    double d = (Double)this.padValue;
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    string = Epoch.encode((double)d);
                }
            } else {
                string = this.padValue instanceof String ? (String)this.padValue : Epoch16.encode((Object)((double[])this.padValue));
            }
        }
        this.jtfVal.set(this.virtual ? string + "     " + this.Virtual : string);
        this.update.setEnabled(false);
        this.cancel.setEnabled(false);
    }

    public void reset() {
        this.values.setVisible(false);
    }

    public void performVariableAction(VariableEvent variableEvent) {
        Variable variable = variableEvent.getVariable();
        int n = variableEvent.getID();
        switch (n) {
            case 2009: {
                new NewVariableAction(this.myEditor, variable.toString());
                break;
            }
            case 2019: {
                this.reset();
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = (String)this.jtfRec.get();
        long l = string.trim().equals("*") ? 1L : Long.parseLong(string.trim());
        if (this.variance) {
            if (--l < 0L) {
                Toolkit.getDefaultToolkit().beep();
                this.jtfRec.set(this.oldRec.getText());
                return;
            }
            this.oldRec.setText(string);
            this.recNum = l;
        }
        if (this.nDims < 1L) {
            this.dimIndex = new long[1];
        } else {
            int n = 0;
            while ((long)n < this.nDims) {
                if (object == this.jtfIndex[n]) {
                    l = Long.parseLong(this.jtfIndex[n].getText().trim());
                    if (l < 1L || l > this.dimSizes[n]) {
                        Toolkit.getDefaultToolkit().beep();
                        this.jtfIndex[n].setText(this.oldIndex[n].getText());
                        return;
                    }
                    this.oldIndex[n].setText(this.jtfIndex[n].getText());
                    this.dimIndex[n] = l - 1L;
                }
                ++n;
            }
        }
        if (object instanceof JTextField) {
            this.showIndexData();
        } else if (object instanceof JButton) {
            this.update.setEnabled(false);
            this.cancel.setEnabled(false);
            String string2 = actionEvent.getActionCommand();
            if (string2.equals(CANCEL)) {
                this.showIndexData();
            } else if (string2.equals(UPDATE)) {
                try {
                    String string3;
                    Object object2 = null;
                    String string4 = ((String)this.jtfVal.get()).trim();
                    boolean bl = false;
                    int n = string4.toLowerCase().indexOf("<virtual>");
                    if (n != -1) {
                        string3 = string4.substring(0, n - 1).trim();
                        this.jtfVal.set(string4);
                    } else {
                        string3 = new String(string4);
                    }
                    switch ((int)this.dataType) {
                        case 1: 
                        case 41: {
                            object2 = new Byte(string3);
                            bl = true;
                            break;
                        }
                        case 2: 
                        case 11: {
                            object2 = new Short(string3);
                            bl = true;
                            break;
                        }
                        case 4: 
                        case 12: {
                            object2 = new Integer(string3);
                            bl = true;
                            break;
                        }
                        case 14: {
                            object2 = new Long(string3);
                            bl = true;
                            break;
                        }
                        case 21: 
                        case 44: {
                            double d = Cformat.atof(string3);
                            object2 = new Float(d);
                            bl = true;
                            break;
                        }
                        case 22: 
                        case 45: {
                            object2 = new Double(Cformat.atof(string3));
                            bl = true;
                            break;
                        }
                        case 31: {
                            try {
                                object2 = new Double(Epoch.parse((String)string3));
                                bl = true;
                            }
                            catch (CDFException cDFException) {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(this.myEditor.getFrame(), "ILLEGAL_EPOCH_VALUE:" + string3);
                                this.showIndexData();
                                this.update.setEnabled(false);
                                this.cancel.setEnabled(false);
                            }
                            break;
                        }
                        case 32: {
                            try {
                                object2 = Epoch16.parse((String)string3);
                                bl = true;
                            }
                            catch (CDFException cDFException) {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(this.myEditor.getFrame(), "ILLEGAL_EPOCH_VALUE:" + string3);
                                this.showIndexData();
                                this.update.setEnabled(false);
                                this.cancel.setEnabled(false);
                            }
                            break;
                        }
                        case 51: 
                        case 52: {
                            string3 = string3.substring(1, string3.length() - 1);
                            if ((long)string3.length() > this.numElements) {
                                string3 = string3.substring(0, (int)this.numElements);
                            }
                            object2 = string3;
                            bl = true;
                            break;
                        }
                        default: {
                            this.dataType = 41L;
                            object2 = null;
                        }
                    }
                    if (bl) {
                        this.var.putSingleData(this.recNum, this.dimIndex, object2);
                        if (this.sparseRec == 0L && this.recNum > this.maxRec || this.sparseRec != 0L && this.virtual) {
                            this.myEditor.variablePanel.getVarSpecPanel().set(this.var);
                            this.myEditor.variablePanel.getRightPanel().revalidate();
                            this.myEditor.variablePanel.getRightPanel().repaint();
                            this.maxRec = this.recNum;
                            if (CDFToolUtils.getMaxRecNum(this.myEditor.theCDF) != this.myEditor.gAttrPanel.getMaxWritten()) {
                                int n2 = CDFToolUtils.getMaxRecNum(this.myEditor.theCDF);
                                this.myEditor.gAttrPanel.setMaxWritten(n2);
                                this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                                this.myEditor.gAttrPanel.getRightPanel().revalidate();
                                this.myEditor.gAttrPanel.getRightPanel().repaint();
                                this.myEditor.vAttrPanel.setMaxWritten(n2);
                                this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                                this.myEditor.vAttrPanel.getRightPanel().revalidate();
                                this.myEditor.vAttrPanel.getRightPanel().repaint();
                            }
                        }
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor.getFrame(), CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor.getFrame(), numberFormatException.toString(), "MYEditor: CDFException", 0);
                }
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
        block11: {
            int n;
            block12: {
                block13: {
                    n = keyEvent.getKeyCode();
                    if (n != 38) break block12;
                    if (this.focusedObj != this.jtfRec.textField) break block13;
                    ++this.recNum;
                    this.jtfRec.set("" + (this.recNum + 1L));
                    this.showIndexData();
                    break block11;
                }
                if (this.nDims <= 0L) break block11;
                int n2 = 0;
                while ((long)n2 < this.nDims) {
                    if (this.focusedObj == this.jtfIndex[n2]) {
                        if (this.dimVars[n2] == 0L) break block11;
                        int n3 = n2;
                        this.dimIndex[n3] = this.dimIndex[n3] + 1L;
                        if (this.dimIndex[n2] == this.dimSizes[n2]) {
                            this.dimIndex[n2] = 0L;
                        }
                        this.jtfIndex[n2].setText("" + (this.dimIndex[n2] + 1L));
                        this.showIndexData();
                        break block11;
                    }
                    ++n2;
                }
                break block11;
            }
            if (n != 40) break block11;
            if (this.focusedObj == this.jtfRec.textField) {
                --this.recNum;
                if (this.recNum < 0L) {
                    this.recNum = this.maxRec;
                }
                if (this.recNum < 0L) {
                    this.recNum = 0L;
                }
                this.jtfRec.set("" + (this.recNum + 1L));
                this.showIndexData();
            } else if (this.nDims > 0L) {
                int n4 = 0;
                while ((long)n4 < this.nDims) {
                    if (this.focusedObj == this.jtfIndex[n4]) {
                        if (this.dimVars[n4] == 0L) break;
                        int n5 = n4;
                        this.dimIndex[n5] = this.dimIndex[n5] - 1L;
                        if (this.dimIndex[n4] < 0L) {
                            this.dimIndex[n4] = this.dimSizes[n4] - 1L;
                        }
                        this.jtfIndex[n4].setText("" + (this.dimIndex[n4] + 1L));
                        this.showIndexData();
                        break;
                    }
                    ++n4;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focusedObj = focusEvent.getSource();
        boolean bl = false;
        if (this.focusedObj == this.jtfRec.textField) {
            if (this.nDims > 0L) {
                int n = 0;
                while ((long)n < this.nDims) {
                    if (this.dimVars[n] == (long)-1) {
                        this.jtfRec.textField.setNextFocusableComponent(this.jtfIndex[n]);
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.jtfRec.textField.setNextFocusableComponent(this.jtfVal.textField);
            }
        } else if (this.focusedObj == this.jtfVal.textField) {
            if (this.variance) {
                this.jtfVal.textField.setNextFocusableComponent(this.jtfRec.textField);
            } else {
                if (this.nDims > 0L) {
                    int n = 0;
                    while ((long)n < this.nDims) {
                        if (this.dimVars[n] == (long)-1) {
                            this.jtfVal.textField.setNextFocusableComponent(this.jtfIndex[n]);
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    this.jtfVal.textField.setNextFocusableComponent(this.jtfVal.textField);
                }
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public long getRecNum() {
        return this.recNum;
    }

    private final /* synthetic */ void this() {
        this.var = null;
        this.oldVar = null;
        this.Virtual = "<Virtual>";
        this.focusedObj = null;
    }

    public VariableValuePanel(VariablePanel variablePanel) {
        super(true);
        this.this();
        this.values = this;
        this.myVP = variablePanel;
        this.myEditor = variablePanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.jp = new JLabeledPanel("Edit Data", BorderFactory.createEtchedBorder(), 2, 2, new FlowLayout());
        this.jtfRec = new JLabeledTF("Record", 5);
        this.jtfRec.textField.setHorizontalAlignment(4);
        this.oldRec = new JTextField();
        this.jp.add(this.jtfRec);
        this.jpIndex = new JLabeledPanel("Index", BorderFactory.createEmptyBorder(), 2, 2, new FlowLayout());
        JTextField jTextField = new JTextField("1");
        JTextField jTextField2 = new JTextField("1");
        JTextField jTextField3 = new JTextField("1");
        this.jpIndex.add(jTextField);
        this.jpIndex.add(jTextField2);
        this.jpIndex.add(jTextField3);
        jTextField.setHorizontalAlignment(4);
        jTextField2.setHorizontalAlignment(4);
        jTextField3.setHorizontalAlignment(4);
        this.jp.add(this.jpIndex);
        this.jtfVal = new JLabeledTF("Data Value", 32);
        this.jtfVal.textField.getDocument().addDocumentListener(this);
        this.jtfVal.textField.addFocusListener(this);
        this.jp.add(this.jtfVal);
        this.jp.add(Box.createRigidArea(new Dimension(18, 8)));
        JPanel jPanel = new JPanel();
        this.update = new JButton(UPDATE){

            public final boolean isFocusTraversable() {
                return false;
            }
        };
        this.update.setToolTipText("Click to apply change to the Variable's value");
        this.update.addActionListener(this);
        this.update.setEnabled(false);
        this.jp.add(this.update);
        this.cancel = new JButton(CANCEL){

            public final boolean isFocusTraversable() {
                return false;
            }
        };
        this.cancel.setToolTipText("Click to cancel change to the Variable's value");
        this.cancel.addActionListener(this);
        this.cancel.setEnabled(false);
        this.jp.add(this.cancel);
        this.add(this.jp);
        this.values.setVisible(false);
    }
}

