/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.border.EmptyBorder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExportToText
extends JDialog
implements CDFConstants,
KeyListener,
FocusListener {
    private static ExportToText exportToText;
    private static String headcol1;
    private static String headcol2;
    static boolean defaultModal;
    private static final String ENTER = "Next";
    private static final String BACK = "Back";
    private static final String CANCEL = "Cancel";
    private int[] eleIndex;
    private int currentVar;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JPanel pagePanel;
    private JLabel pageLabel;
    private JLabel recordLabel;
    private JLabel pageTotal;
    private JLabel recordTotal;
    private JTextField pageField;
    private JTextField recordField;
    private JButton enterButton;
    private JButton cancelButton;
    private JButton backButton;
    private Object focusedObj;
    private SelectionListener aSelection;
    private PageRecListener aPageRecListener;
    private CDFSpecPanel cdfspec;
    private JPanel center;
    private ExportCDFTable aCDFTable;
    private CDFExport myCDFExport;
    private BuildProgressPanel progressPanel;
    private JTabbedPane jtp;
    private JScrollPane[] scrollPane;
    private ExportVarDisplayTable[] aToScreenTable;
    private String[][] columnNames;
    private Object[][][] recordObject;
    private Vector vars;
    private int[] varsHor;
    private int groups;
    private int outVars;
    private int COLUMNS;
    private int ROWS;
    private int recHeading;
    private int indexHeading;
    private int totalColumns;
    private int numColumns;
    private int totalElementsPerRec;
    private int totalWritten;
    private boolean indiceOut;
    private long[] indiceSizes;
    private int indiceDim;
    private int elementNum;
    private int lastPageToDisplay;
    private long majority;
    private int istart;
    private int totalElements;
    private Object aRecord;
    private Hashtable formatHash;
    private boolean toScreen;
    private Cursor curCursor;
    private Cursor waitCursor;
    private Object newMin;
    private Object newMax;
    private Object newFil;
    private Object minObj;
    private Object maxObj;
    private Object filObj;
    private int irec;
    private int filterElementsNum;
    private int minLen;
    private int maxLen;
    private int filLen;
    private long[] elementBase;
    private int[] varWidth;
    private int[] varDataType;
    private int currentProgressValue;
    private int totalItems;
    private Dimension ss;

    public static ExportToText createToText(JFrame jFrame, CDFExport cDFExport, ExportCDFTable exportCDFTable, boolean bl) {
        if (exportToText == null) {
            exportToText = new ExportToText(jFrame);
            ExportToText.exportToText.myCDFExport = cDFExport;
            ExportToText.exportToText.aCDFTable = exportCDFTable;
        }
        ExportToText.exportToText.toScreen = bl;
        if (bl) {
            if (ExportToText.exportToText.mainPanel == null) {
                ExportToText.exportToText.mainPanel = (JPanel)exportToText.getContentPane();
                ExportToText.exportToText.mainPanel.setLayout(new BorderLayout());
                ExportToText.exportToText.mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
                ExportToText.exportToText.pageField.setHorizontalAlignment(0);
                ExportToText.exportToText.pageField.addKeyListener(exportToText);
                ExportToText.exportToText.pageField.addFocusListener(exportToText);
                ExportToText.exportToText.recordField.setHorizontalAlignment(0);
                ExportToText.exportToText.recordField.addKeyListener(exportToText);
                ExportToText.exportToText.recordField.addFocusListener(exportToText);
                exportToText.setDefaultCloseOperation(0);
                exportToText.addWindowListener(new WindowAdapter(){

                    public final void windowClosing(WindowEvent windowEvent) {
                    }
                });
                exportToText.setSize(800, 800);
                ExportToText.exportToText.cdfspec = new CDFSpecPanel();
                ExportToText.exportToText.bottomPanel = new JPanel(new BorderLayout(), true);
                ExportToText.exportToText.aPageRecListener = exportToText.new PageRecListener();
            }
            exportToText.buildPanel();
            RepaintManager.currentManager(null).setDoubleBufferingEnabled(true);
        }
        ExportToText.exportToText.ROWS = cDFExport.ROWS;
        ExportToText.exportToText.COLUMNS = cDFExport.COLUMNS;
        exportToText.setupDataTable();
        exportToText.displayDataTable();
        return exportToText;
    }

    public void displayDataTable() {
        int n;
        if (this.myCDFExport.orientation == 0) {
            n = this.totalElementsPerRec * (this.totalWritten + 1);
            this.lastPageToDisplay = n / this.ROWS;
            if (n % this.ROWS == 0) {
                --this.lastPageToDisplay;
            }
        } else {
            n = this.totalWritten + 1;
            this.lastPageToDisplay = n / this.ROWS;
            if (n % this.ROWS == 0) {
                --this.lastPageToDisplay;
            }
        }
        if (this.toScreen) {
            if (this.outVars > 0) {
                this.elementNum = 0;
                this.fillVarRecsToTable(this.elementNum);
                this.displayTable(this.mainPanel);
                exportToText.pack();
                Dimension dimension = exportToText.getSize();
                exportToText.setLocation((this.ss.width - dimension.width) / 2, (this.ss.height - dimension.height) / 2);
                exportToText.show();
            }
        } else {
            this.myCDFExport.info.setText("Start writing output to: " + this.myCDFExport.outfile + "\n\n");
            OutToFile outToFile = new OutToFile();
            outToFile.start();
        }
    }

    void setupDataTable() {
        int n;
        String string;
        this.majority = this.myCDFExport.majority;
        this.recHeading = 1;
        if (this.myCDFExport.recordNum == 0 || !((Boolean)this.aCDFTable.getDataObject()[0][5]).booleanValue()) {
            this.recHeading = 0;
        }
        this.indexHeading = 1;
        this.indiceOut = true;
        if (this.myCDFExport.indiceNum == 0 || !((Boolean)this.aCDFTable.getDataObject()[this.myCDFExport.recordNum][5]).booleanValue()) {
            this.indiceOut = false;
            this.indexHeading = 0;
        }
        this.vars = new Vector();
        this.outVars = 0;
        int n2 = this.aCDFTable.istart;
        while (n2 < this.aCDFTable.numRows) {
            if (((Boolean)this.aCDFTable.getDataObject()[n2][5]).booleanValue()) {
                ++this.outVars;
                string = (String)this.aCDFTable.getDataObject()[n2][0];
                this.vars.addElement(string);
            }
            ++n2;
        }
        if (this.outVars == 0) {
            return;
        }
        long[] lArray = null;
        long l = 0L;
        this.varWidth = new int[this.vars.size()];
        this.varDataType = new int[this.vars.size()];
        this.totalElements = 0;
        this.varsHor = new int[this.vars.size()];
        this.eleIndex = new int[this.vars.size()];
        this.formatHash = new Hashtable();
        int n3 = 0;
        while (n3 < this.vars.size()) {
            int n4;
            int n5;
            long[] lArray2;
            long l2;
            string = (String)this.vars.elementAt(n3);
            this.varsHor[n3] = this.totalElements;
            try {
                Variable variable = this.myCDFExport.sourceCDF.getVariable(string);
                l2 = variable.getNumDims();
                lArray2 = variable.getDimSizes();
                this.eleIndex[n3] = this.totalElements;
                n5 = (int)variable.getMaxWrittenRecord();
                String string2 = CDFToolUtils.getCFormat(variable);
                if (string2 != null) {
                    this.formatHash.put(variable, string2);
                }
                long l3 = variable.getDataType();
                this.varWidth[n3] = CDFToolUtils.VariableWidth(this.myCDFExport.epoch, variable, l3, string2);
                this.varDataType[n3] = (int)l3;
                n4 = 1;
                if (l2 > 0L) {
                    n = 0;
                    while ((long)n < l2) {
                        n4 = (int)((long)n4 * lArray2[n]);
                        ++n;
                    }
                }
                this.totalElements += n4;
            }
            catch (CDFException cDFException) {
                System.err.println("ERROR!  " + (Object)((Object)cDFException));
                return;
            }
            if (l2 == 0L) {
                this.indiceOut = false;
            }
            if (n3 == 0) {
                l = l2;
                this.totalWritten = n5;
                this.totalElementsPerRec = n4;
                if ((int)l2 == 0) {
                    lArray = null;
                    this.indiceSizes = null;
                } else {
                    lArray = new long[(int)l2];
                    this.indiceSizes = new long[(int)l2];
                    System.arraycopy(lArray2, 0, lArray, 0, (int)l2);
                    System.arraycopy(lArray2, 0, this.indiceSizes, 0, (int)l2);
                }
                this.indiceDim = (int)l2;
            } else {
                if (this.totalWritten < n5) {
                    this.totalWritten = n5;
                }
                if (this.indiceOut) {
                    if (this.totalElementsPerRec != n4 || l != l2) {
                        this.indiceOut = false;
                    } else {
                        n = 0;
                        while ((long)n < l2) {
                            if (lArray == null) {
                                this.indiceOut = false;
                                break;
                            }
                            if (lArray2[n] != lArray[n]) {
                                this.indiceOut = false;
                                break;
                            }
                            ++n;
                        }
                    }
                }
                if (this.totalElementsPerRec < n4) {
                    this.totalElementsPerRec = n4;
                    this.indiceDim = (int)l2;
                    this.indiceSizes = new long[(int)l2];
                    System.arraycopy(lArray2, 0, this.indiceSizes, 0, (int)l2);
                }
            }
            ++n3;
        }
        if (this.COLUMNS == 0) {
            this.COLUMNS = this.myCDFExport.orientation == 0 ? this.outVars : this.totalElements;
        }
        if (this.ROWS == 0) {
            this.ROWS = this.myCDFExport.orientation == 1 ? this.totalWritten + 1 : (this.totalWritten + 1) * this.totalElementsPerRec;
        }
        if (this.myCDFExport.orientation == 0) {
            if (this.outVars > this.COLUMNS) {
                this.numColumns = this.COLUMNS;
                this.groups = this.outVars / this.COLUMNS;
                if (this.outVars % this.COLUMNS != 0) {
                    ++this.groups;
                }
            } else {
                this.numColumns = this.outVars;
                this.groups = 1;
            }
        } else if (this.totalElements > this.COLUMNS) {
            this.numColumns = this.COLUMNS;
            this.groups = this.totalElements / this.COLUMNS;
            if (this.totalElements % this.COLUMNS != 0) {
                ++this.groups;
            }
        } else {
            this.numColumns = this.totalElements;
            this.groups = 1;
        }
        this.indexHeading = this.indiceOut ? 1 : 0;
        this.istart = this.recHeading + this.indexHeading;
        this.totalColumns = this.numColumns + this.istart;
        this.columnNames = new String[this.groups][this.totalColumns];
        this.recordObject = new Object[this.groups][this.ROWS][this.totalColumns];
        this.cleanColumns();
        this.cleanTableObjects();
        n3 = 0;
        n = 0;
        while (n < this.groups) {
            if (this.recHeading == 1) {
                this.columnNames[n][0] = headcol1;
            }
            if (this.indexHeading == 1) {
                this.columnNames[n][this.recHeading] = headcol2;
            }
            int n6 = 0;
            while (n6 < this.numColumns) {
                if (this.myCDFExport.orientation == 0) {
                    if (n3 >= this.vars.size()) break;
                    this.columnNames[n][n6 + this.istart] = (String)this.vars.elementAt(n3++);
                } else {
                    if (n3 >= this.totalElements) break;
                    int n7 = 0;
                    while (n7 < this.vars.size()) {
                        if (n3 == this.varsHor[n7]) {
                            this.columnNames[n][n6 + this.istart] = (String)this.vars.elementAt(n7);
                            break;
                        }
                        if (n3 < this.varsHor[n7] || n7 == this.vars.size() - 1) {
                            this.columnNames[n][n6 + this.istart] = " ";
                            break;
                        }
                        ++n7;
                    }
                    ++n3;
                }
                ++n6;
            }
            ++n;
        }
    }

    private final void buildPanel() {
        exportToText.setTitle("CDF: " + this.myCDFExport.cdfspec1);
        this.cdfspec.set(this.myCDFExport.sourceCDF);
        this.mainPanel.add((Component)this.cdfspec, "North");
        this.createButton(this.bottomPanel);
        this.mainPanel.add((Component)this.bottomPanel, "South");
    }

    private final void fillVarRecsToTable(int n) {
        if (this.recHeading == 1 || this.indexHeading == 1) {
            this.doRecIndexColumn(n);
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.vars.size()) {
            int n3;
            int n4;
            Variable variable;
            this.currentVar = n2;
            String string = (String)this.vars.elementAt(n2);
            try {
                variable = this.myCDFExport.sourceCDF.getVariable(string);
            }
            catch (CDFException cDFException) {
                System.err.println("error getting variable");
                return;
            }
            if (this.myCDFExport.orientation == 0) {
                n4 = n2 / this.COLUMNS;
                n3 = n2 % this.COLUMNS + this.istart;
            } else {
                n4 = this.eleIndex[n2] / this.COLUMNS;
                n3 = this.eleIndex[n2] % this.COLUMNS + this.istart;
            }
            this.loadVarRecords(variable, n, n4, n3);
            ++n2;
        }
    }

    void doRecIndexColumn(int n) {
        int n2 = n;
        int n3 = this.myCDFExport.orientation == 0 ? n2 / this.totalElementsPerRec : n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.indexHeading == 1) {
            this.dimensionBase();
        }
        int n4 = 0;
        while (n4 < this.ROWS) {
            int n5;
            if (this.indexHeading == 1) {
                long[] lArray = this.currentIndex(n2);
                if (stringBuffer.capacity() > 0) {
                    stringBuffer.setLength(0);
                }
                stringBuffer.append("[");
                n5 = 0;
                while (n5 < this.indiceDim) {
                    if (n5 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(lArray[n5] + 1L);
                    ++n5;
                }
                stringBuffer.append("]");
            }
            n5 = 0;
            while (n5 < this.groups) {
                if (this.myCDFExport.orientation == 0) {
                    if (this.recHeading == 1) {
                        this.recordObject[n5][n4][0] = Integer.toString(n3 + 1);
                    }
                    if (this.indexHeading == 1) {
                        this.recordObject[n5][n4][this.recHeading] = stringBuffer.toString();
                    }
                } else {
                    this.recordObject[n5][n4][0] = Integer.toString(n3 + 1);
                }
                ++n5;
            }
            n3 = this.myCDFExport.orientation == 0 ? n2 / this.totalElementsPerRec : ++n2;
            if (n3 > this.totalWritten) break;
            ++n4;
        }
    }

    void displayTable(JPanel jPanel) {
        int n = this.elementNum % this.ROWS == 0 ? this.elementNum / this.ROWS + 1 : Math.round((float)this.elementNum / (float)this.ROWS) + 1;
        if (n > this.lastPageToDisplay + 1) {
            n = this.lastPageToDisplay + 1;
        }
        int n2 = this.myCDFExport.orientation == 0 ? this.elementNum / this.totalElementsPerRec + 1 : this.elementNum + 1;
        this.pageField.setText("" + n);
        this.recordField.setText("" + n2);
        if (this.scrollPane == null) {
            jPanel.add((Component)this.center, "Center");
            this.scrollPane = new JScrollPane[this.groups];
            this.aToScreenTable = new ExportVarDisplayTable[this.groups];
            int n3 = 0;
            while (n3 < this.groups) {
                Object[][] objectArray = (Object[][])Array.get(this.recordObject, n3);
                String[] stringArray = (String[])Array.get(this.columnNames, n3);
                this.aToScreenTable[n3] = new ExportVarDisplayTable(objectArray, stringArray);
                this.scrollPane[n3] = new JScrollPane(this.aToScreenTable[n3].getTable(), 20, 30);
                ++n3;
            }
            if (this.groups == 1) {
                if (this.COLUMNS > 9) {
                    this.aToScreenTable[0].getTable().setAutoResizeMode(0);
                }
                this.center.add((Component)this.scrollPane[0], "Center");
            } else {
                if (this.jtp == null) {
                    this.jtp = new JTabbedPane();
                }
                n3 = 0;
                while (n3 < this.groups) {
                    this.jtp.addTab("Group " + (n3 + 1), null, this.scrollPane[n3]);
                    ++n3;
                }
                this.center.add((Component)this.jtp, "Center");
            }
            this.pageTotal.setText(" / " + (this.lastPageToDisplay + 1));
            this.recordTotal.setText(" / " + (this.totalWritten + 1));
            this.pagePanel.add(this.pageLabel);
            this.pagePanel.add(this.pageField);
            this.pagePanel.add(this.pageTotal);
            this.pagePanel.add(Box.createRigidArea(new Dimension(10, 1)));
            this.pagePanel.add(this.recordLabel);
            this.pagePanel.add(this.recordField);
            this.pagePanel.add(this.recordTotal);
            this.pageField.addActionListener(this.aPageRecListener);
            this.recordField.addActionListener(this.aPageRecListener);
            this.pageField.setToolTipText("Enter a page number and hit Return or Up/Down arrow keys to display a new page.");
            this.recordField.setToolTipText("Enter a record number and hit Return or Up/Down arrow keys to display a new page. ");
            this.center.add((Component)this.pagePanel, "South");
        } else {
            int n4 = 0;
            while (n4 < this.groups) {
                Object[][] objectArray = (Object[][])Array.get(this.recordObject, n4);
                this.aToScreenTable[n4].setDataTable(objectArray);
                ++n4;
            }
        }
    }

    void dimensionBase() {
        if (this.indiceDim <= 1) {
            this.elementBase = new long[]{1L};
        } else {
            this.elementBase = new long[this.indiceDim];
            if (this.majority == 1L) {
                int n = 0;
                while (n < this.indiceDim) {
                    this.elementBase[n] = 1L;
                    int n2 = n + 1;
                    while (n2 < this.indiceDim) {
                        int n3 = n;
                        this.elementBase[n3] = this.elementBase[n3] * this.indiceSizes[n2];
                        ++n2;
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.indiceDim) {
                    this.elementBase[n] = 1L;
                    int n4 = 0;
                    while (n4 <= n) {
                        int n5 = n;
                        this.elementBase[n5] = this.elementBase[n5] * this.indiceSizes[n4];
                        ++n4;
                    }
                    ++n;
                }
            }
        }
    }

    long[] currentIndex(int n) {
        int n2 = n % this.totalElementsPerRec;
        long[] lArray = new long[this.indiceDim];
        if (this.indiceDim <= 1) {
            lArray[0] = n2;
        } else if (this.majority == 1L) {
            int n3 = 0;
            while (n3 < this.indiceDim) {
                lArray[n3] = (long)n2 / this.elementBase[n3];
                n2 = (int)((long)n2 % this.elementBase[n3]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.indiceDim) {
                lArray[n4] = (long)n2 % this.elementBase[n4];
                n2 = (int)((long)n2 / this.elementBase[n4]);
                ++n4;
            }
        }
        return lArray;
    }

    private final void loadVarRecords(Variable variable, int n, int n2, int n3) {
        int n4;
        long[] lArray;
        long[] lArray2;
        int n5;
        int n6;
        long l;
        long l2 = variable.getDataType();
        long[] lArray3 = null;
        long[] lArray4 = null;
        long l3 = variable.getNumDims();
        String string = variable.getName();
        int n7 = 1;
        try {
            l = variable.getMaxWrittenRecord();
        }
        catch (CDFException cDFException) {
            l = -1;
        }
        if (l == (long)-1) {
            return;
        }
        if (l3 > 0L) {
            lArray3 = variable.getDimSizes();
            lArray4 = variable.getDimVariances();
            int n8 = 0;
            while ((long)n8 < l3) {
                n7 = (int)((long)n7 * lArray3[n8]);
                ++n8;
            }
        }
        this.filObj = null;
        this.maxObj = null;
        this.minObj = null;
        if (this.myCDFExport.getFiltering() == 1) {
            this.checkFiltering(variable, string, l2);
        }
        int n9 = n;
        int n10 = n + this.ROWS - 1;
        if (this.myCDFExport.orientation == 0) {
            n6 = n9 / this.totalElementsPerRec;
            n5 = n10 / this.totalElementsPerRec;
        } else {
            n6 = n9;
            n5 = n10;
        }
        if ((long)n6 > l) {
            return;
        }
        String string2 = null;
        if (this.formatHash.containsKey(variable)) {
            string2 = (String)this.formatHash.get(variable);
        }
        long l4 = variable.getSparseRecords();
        Object object = null;
        if ((long)n5 > l) {
            n5 = (int)l;
        }
        long l5 = n5 - n6 + 1;
        long l6 = 1L;
        if (l3 > 0L) {
            lArray2 = new long[(int)l3];
            lArray = new long[(int)l3];
            n4 = 0;
            while (n4 < (int)l3) {
                lArray2[n4] = 1L;
                lArray[n4] = 0L;
                ++n4;
            }
        } else {
            lArray3 = new long[1];
            lArray2 = new long[1];
            lArray = new long[1];
            lArray3[0] = 0L;
            lArray2[0] = 1L;
            lArray[0] = 0L;
        }
        try {
            object = variable.getHyperData((long)n6, l5, l6, lArray, lArray3, lArray2);
        }
        catch (CDFException cDFException) {
            System.err.println("error hyperget records: " + (Object)((Object)cDFException));
            return;
        }
        n4 = 0;
        if (l2 == 32L) {
            n4 = 2;
        }
        int n11 = n6;
        while (n11 <= n5) {
            if ((long)n11 <= l) {
                this.aRecord = l5 <= 1L ? object : (l3 > 0L && n7 > 1 ? ((Object[])object)[n11 - n6] : CDFToolUtils.retrieveData(object, n11 - n6, n4));
                this.fillScreenTable(this.aRecord, variable, l2, (int)l3, lArray3, n2, n3, n, n11, n10, string2);
            }
            ++n11;
        }
    }

    void checkFiltering(Variable variable, String string, long l) {
        Object object;
        int n = (Integer)this.aCDFTable.myHash.get(string);
        int n2 = 0;
        if (this.myCDFExport.getValidMin() == 1) {
            this.newMin = this.aCDFTable.getFilterObject()[n][++n2];
            if (this.newMin != null && ((String)this.newMin).trim().length() != 0) {
                object = new StringTokenizer((String)this.newMin, ",");
                this.minLen = ((StringTokenizer)object).countTokens();
                this.minObj = this.minLen == -1 ? null : CDFToolUtils.parseContents((String)this.newMin, l);
            }
        }
        if (this.myCDFExport.getValidMax() == 1) {
            this.newMax = this.aCDFTable.getFilterObject()[n][++n2];
            if (this.newMax != null && ((String)this.newMax).trim().length() != 0) {
                object = new StringTokenizer((String)this.newMax, ",");
                this.maxLen = ((StringTokenizer)object).countTokens();
                this.maxObj = this.maxLen == -1 ? null : CDFToolUtils.parseContents((String)this.newMax, l);
            }
        }
        if (this.myCDFExport.getFillVal() == 1) {
            this.newFil = this.aCDFTable.getFilterObject()[n][++n2];
            if (this.newFil != null && ((String)this.newFil).trim().length() != 0) {
                object = new StringTokenizer((String)this.newFil, ",");
                this.filLen = ((StringTokenizer)object).countTokens();
                this.filObj = this.filLen == -1 ? null : CDFToolUtils.parseContents((String)this.newFil, l);
            }
        } else if (this.myCDFExport.getValidMin() == 1 || this.myCDFExport.getValidMax() == 1) {
            try {
                object = this.myCDFExport.sourceCDF.getAttribute("FILLVAL");
                if (object == null) {
                    this.filObj = null;
                } else {
                    Entry entry = object.getEntry(variable);
                    long l2 = entry.getDataType();
                    if (l2 != l) {
                        this.filObj = null;
                    } else {
                        Object object2 = entry.getData();
                        String string2 = l == 31L ? Epoch.encode((double)((Double)object2)) : (l == 32L ? Epoch16.encode((Object)((double[])object2)) : CDFUtils.getStringData((Object)object2, (String)","));
                        StringTokenizer stringTokenizer = new StringTokenizer((String)this.newFil, ",");
                        this.filLen = stringTokenizer.countTokens();
                        this.filObj = this.filLen == -1 ? null : CDFToolUtils.parseContents(string2, l);
                    }
                }
            }
            catch (CDFException cDFException) {
                this.filObj = null;
            }
        }
    }

    private final Object fillScreenTable(Object object, Variable variable, long l, int n, long[] lArray, int n2, int n3, int n4, int n5, int n6, String string) {
        block426: {
            int n7;
            block427: {
                block460: {
                    block456: {
                        block452: {
                            block448: {
                                block444: {
                                    block440: {
                                        block436: {
                                            block428: {
                                                boolean bl;
                                                block435: {
                                                    block434: {
                                                        block433: {
                                                            block432: {
                                                                block431: {
                                                                    block430: {
                                                                        block429: {
                                                                            n7 = this.myCDFExport.orientation == 0 ? n5 * this.totalElementsPerRec - n4 : n5 - n4;
                                                                            if (n > 1) break block427;
                                                                            if (n != 0) break block428;
                                                                            int n8 = n7;
                                                                            bl = true;
                                                                            if (n8 < 0 || n8 >= this.ROWS) {
                                                                                return this.recordObject;
                                                                            }
                                                                            if (l != 51L && l != 52L) break block429;
                                                                            int n9 = (int)variable.getNumElements();
                                                                            byte[] byArray = new byte[n9];
                                                                            String string2 = new String((byte[])object);
                                                                            this.recordObject[n2][n8][n3] = string2;
                                                                            break block426;
                                                                        }
                                                                        if (l != 41L && l != 1L) break block430;
                                                                        byte by = (Byte)object;
                                                                        byte by2 = 0;
                                                                        byte by3 = 0;
                                                                        byte by4 = 0;
                                                                        if (this.filObj != null) {
                                                                            by2 = ((byte[])this.filObj)[0];
                                                                        }
                                                                        if (this.minObj != null) {
                                                                            by4 = ((byte[])this.minObj)[0];
                                                                        }
                                                                        if (this.maxObj != null) {
                                                                            by3 = ((byte[])this.maxObj)[0];
                                                                        }
                                                                        if (this.minObj != null && by < by4) {
                                                                            bl = false;
                                                                            by = this.filObj != null ? by2 : (byte)0;
                                                                        }
                                                                        if (bl && this.maxObj != null && by > by3) {
                                                                            by = this.filObj != null ? by2 : (byte)0;
                                                                        }
                                                                        this.recordObject[n2][n8][n3] = string == null ? new Byte(by) : Cformat.getInstance(string).form(by);
                                                                        break block426;
                                                                    }
                                                                    if (l != (long)2 && l != 11L) break block431;
                                                                    short s = (Short)object;
                                                                    short s2 = 0;
                                                                    short s3 = 0;
                                                                    short s4 = 0;
                                                                    if (this.filObj != null) {
                                                                        s2 = ((short[])this.filObj)[0];
                                                                    }
                                                                    if (this.minObj != null) {
                                                                        s4 = ((short[])this.minObj)[0];
                                                                    }
                                                                    if (this.maxObj != null) {
                                                                        s3 = ((short[])this.maxObj)[0];
                                                                    }
                                                                    if (l == 11L) {
                                                                        if (s2 < 0) {
                                                                            s2 = (short)(s2 - -256);
                                                                        }
                                                                        if (s < 0) {
                                                                            s = (short)(s - -256);
                                                                        }
                                                                        if (s4 < 0) {
                                                                            s4 = (short)(s4 - -256);
                                                                        }
                                                                        if (s3 < 0) {
                                                                            s3 = (short)(s3 - -256);
                                                                        }
                                                                    }
                                                                    if (this.minObj != null && s < s4) {
                                                                        bl = false;
                                                                        s = this.filObj != null ? s2 : (short)0;
                                                                    }
                                                                    if (bl && this.maxObj != null && s > s3) {
                                                                        s = this.filObj != null ? s2 : (short)0;
                                                                    }
                                                                    this.recordObject[n2][n8][n3] = string == null ? new Short(s) : Cformat.getInstance(string).form(s);
                                                                    break block426;
                                                                }
                                                                if (l != (long)4 && l != 12L) break block432;
                                                                int n10 = (Integer)object;
                                                                int n11 = 0;
                                                                int n12 = 0;
                                                                int n13 = 0;
                                                                if (this.filObj != null) {
                                                                    n11 = ((int[])this.filObj)[0];
                                                                }
                                                                if (this.minObj != null) {
                                                                    n13 = ((int[])this.minObj)[0];
                                                                }
                                                                if (this.maxObj != null) {
                                                                    n12 = ((int[])this.maxObj)[0];
                                                                }
                                                                if (l == 12L) {
                                                                    if (n11 < 0) {
                                                                        n11 -= -65536;
                                                                    }
                                                                    if (n10 < 0) {
                                                                        n10 -= -65536;
                                                                    }
                                                                    if (n13 < 0) {
                                                                        n13 -= -65536;
                                                                    }
                                                                    if (n12 < 0) {
                                                                        n12 -= -65536;
                                                                    }
                                                                }
                                                                if (this.minObj != null && n10 < n13) {
                                                                    bl = false;
                                                                    n10 = this.filObj != null ? n11 : 0;
                                                                }
                                                                if (bl && this.maxObj != null && n10 > n12) {
                                                                    n10 = this.filObj != null ? n11 : 0;
                                                                }
                                                                this.recordObject[n2][n8][n3] = string == null ? new Integer(n10) : Cformat.getInstance(string).form(n10);
                                                                break block426;
                                                            }
                                                            if (l != 14L) break block433;
                                                            long l2 = (Long)object;
                                                            long l3 = 0L;
                                                            long l4 = 0L;
                                                            long l5 = 0L;
                                                            if (this.filObj != null) {
                                                                l3 = ((long[])this.filObj)[0];
                                                            }
                                                            if (this.minObj != null) {
                                                                l5 = ((long[])this.minObj)[0];
                                                            }
                                                            if (this.maxObj != null) {
                                                                l4 = ((long[])this.maxObj)[0];
                                                            }
                                                            if (l == 14L) {
                                                                if (l3 < 0L) {
                                                                    l3 -= -4294967296L;
                                                                }
                                                                if (l2 < 0L) {
                                                                    l2 -= -4294967296L;
                                                                }
                                                                if (l5 < 0L) {
                                                                    l5 -= -4294967296L;
                                                                }
                                                                if (l4 < 0L) {
                                                                    l4 -= -4294967296L;
                                                                }
                                                            }
                                                            if (this.minObj != null && l2 < l5) {
                                                                bl = false;
                                                                l2 = this.filObj != null ? l3 : 0L;
                                                            }
                                                            if (bl && this.maxObj != null && l2 > l4) {
                                                                l2 = this.filObj != null ? l3 : 0L;
                                                            }
                                                            this.recordObject[n2][n8][n3] = string == null ? new Long(l2) : Cformat.getInstance(string).form(l2);
                                                            break block426;
                                                        }
                                                        if (l != 21L && l != 44L) break block434;
                                                        float f = ((Float)object).floatValue();
                                                        float f2 = 0.0f;
                                                        float f3 = 0.0f;
                                                        float f4 = 0.0f;
                                                        if (this.filObj != null) {
                                                            f2 = ((float[])this.filObj)[0];
                                                        }
                                                        if (this.minObj != null) {
                                                            f4 = ((float[])this.minObj)[0];
                                                        }
                                                        if (this.maxObj != null) {
                                                            f3 = ((float[])this.maxObj)[0];
                                                        }
                                                        if (this.minObj != null && f < f4) {
                                                            bl = false;
                                                            f = this.filObj != null ? f2 : 0.0f;
                                                        }
                                                        if (bl && this.maxObj != null && f > f3) {
                                                            f = this.filObj != null ? f2 : 0.0f;
                                                        }
                                                        this.recordObject[n2][n8][n3] = string == null ? new Float(f) : Cformat.getInstance(string).form(f);
                                                        break block426;
                                                    }
                                                    if (l != 22L && l != 45L && l != 31L) break block435;
                                                    double d = (Double)object;
                                                    double d2 = 0.0;
                                                    double d3 = 0.0;
                                                    double d4 = 0.0;
                                                    if (this.filObj != null) {
                                                        d2 = ((double[])this.filObj)[0];
                                                    }
                                                    if (this.minObj != null) {
                                                        d4 = ((double[])this.minObj)[0];
                                                    }
                                                    if (this.maxObj != null) {
                                                        d3 = ((double[])this.maxObj)[0];
                                                    }
                                                    if (this.minObj != null && d < d4) {
                                                        bl = false;
                                                        d = this.filObj != null ? d2 : 0.0;
                                                    }
                                                    if (bl && this.maxObj != null && d > d3) {
                                                        d = this.filObj != null ? d2 : 0.0;
                                                    }
                                                    if (l != 31L) {
                                                        this.recordObject[n2][n8][n3] = string == null ? new Double(d) : Cformat.getInstance(string).form(d);
                                                    } else {
                                                        String string3 = null;
                                                        if (this.myCDFExport.epoch == 0) {
                                                            string3 = Epoch.encode((double)d);
                                                        } else if (this.myCDFExport.epoch == 1) {
                                                            string3 = Epoch.encode1((double)d);
                                                        } else if (this.myCDFExport.epoch == 2) {
                                                            string3 = Epoch.encode2((double)d);
                                                        } else if (this.myCDFExport.epoch == 3) {
                                                            string3 = Epoch.encode3((double)d);
                                                        } else if (this.myCDFExport.epoch == 5) {
                                                            try {
                                                                String string4 = (String)variable.getEntryData("FORMAT");
                                                                string3 = string4 == null || string4.trim().length() == 0 ? Epoch.encode((double)d) : Epoch.encodex((double)d, (String)string4);
                                                            }
                                                            catch (CDFException cDFException) {
                                                                string3 = Epoch.encode((double)d);
                                                            }
                                                        }
                                                        this.recordObject[n2][n8][n3] = string3;
                                                    }
                                                    break block426;
                                                }
                                                if (l != 32L) break block426;
                                                double[] dArray = new double[]{((double[])object)[0], ((double[])object)[1]};
                                                double[] dArray2 = new double[2];
                                                double[] dArray3 = new double[2];
                                                double[] dArray4 = new double[2];
                                                if (this.filObj != null) {
                                                    dArray2[0] = ((double[])this.filObj)[0];
                                                    dArray2[1] = ((double[])this.filObj)[1];
                                                }
                                                if (this.minObj != null) {
                                                    dArray4[0] = ((double[])this.minObj)[0];
                                                    dArray4[1] = ((double[])this.minObj)[1];
                                                }
                                                if (this.maxObj != null) {
                                                    dArray3[0] = ((double[])this.maxObj)[0];
                                                    dArray3[1] = ((double[])this.maxObj)[1];
                                                }
                                                if (this.minObj != null && (dArray[0] < dArray4[0] || dArray[0] == dArray4[0] && dArray[1] < dArray4[1])) {
                                                    bl = false;
                                                    if (this.filObj != null) {
                                                        dArray[0] = dArray2[0];
                                                        dArray[1] = dArray2[1];
                                                    } else {
                                                        dArray[0] = 0.0;
                                                        dArray[1] = 0.0;
                                                    }
                                                }
                                                if (bl && this.maxObj != null && (dArray[0] > dArray3[0] || dArray[0] == dArray3[0] && dArray[1] > dArray3[1])) {
                                                    if (this.filObj != null) {
                                                        dArray[0] = dArray2[0];
                                                        dArray[1] = dArray2[1];
                                                    } else {
                                                        dArray[0] = 0.0;
                                                        dArray[1] = 0.0;
                                                    }
                                                }
                                                String string5 = null;
                                                if (this.myCDFExport.epoch == 0) {
                                                    string5 = Epoch16.encode((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 1) {
                                                    string5 = Epoch16.encode1((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 2) {
                                                    string5 = Epoch16.encode2((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 3) {
                                                    string5 = Epoch16.encode3((Object)dArray);
                                                } else if (this.myCDFExport.epoch == 5) {
                                                    try {
                                                        String string6 = (String)variable.getEntryData("FORMAT");
                                                        string5 = string6 == null || string6.trim().length() == 0 ? Epoch16.encode((Object)dArray) : Epoch16.encodex((Object)dArray, (String)string6);
                                                    }
                                                    catch (CDFException cDFException) {
                                                        string5 = Epoch16.encode((Object)dArray);
                                                    }
                                                }
                                                this.recordObject[n2][n8][n3] = string5;
                                                break block426;
                                            }
                                            if (l != 51L && l != 52L) break block436;
                                            int n14 = (int)variable.getNumElements();
                                            byte[] byArray = new byte[n14];
                                            int n15 = 0;
                                            while (n15 < (int)lArray[0]) {
                                                block438: {
                                                    block439: {
                                                        int n16;
                                                        block437: {
                                                            if (this.myCDFExport.orientation != 0) break block437;
                                                            n16 = n15 + n7;
                                                            if (n16 < 0) break block438;
                                                            if (n16 >= this.ROWS) {
                                                                break block426;
                                                            }
                                                            break block439;
                                                        }
                                                        n16 = n7;
                                                        n2 = (this.eleIndex[this.currentVar] + n15) / this.COLUMNS;
                                                        n3 = (this.eleIndex[this.currentVar] + n15) % this.COLUMNS + this.istart;
                                                    }
                                                    System.arraycopy(((String[])object)[n15].getBytes(), 0, byArray, 0, n14);
                                                    String string7 = new String(byArray);
                                                    this.recordObject[n2][n16][n3] = string7;
                                                }
                                                ++n15;
                                            }
                                            break block426;
                                        }
                                        if (l != 41L && l != 1L) break block440;
                                        byte by = 0;
                                        byte by5 = 0;
                                        byte by6 = 0;
                                        byte by7 = 0;
                                        if (this.minObj != null && this.minLen == 1) {
                                            by5 = ((byte[])this.minObj)[0];
                                        }
                                        if (this.maxObj != null && this.maxLen == 1) {
                                            by6 = ((byte[])this.maxObj)[0];
                                        }
                                        if (this.filObj != null) {
                                            by7 = ((byte[])this.filObj)[0];
                                        }
                                        int n17 = 0;
                                        while (n17 < (int)lArray[0]) {
                                            block442: {
                                                block443: {
                                                    int n18;
                                                    block441: {
                                                        if (this.myCDFExport.orientation != 0) break block441;
                                                        n18 = n17 + n7;
                                                        if (n18 < 0) break block442;
                                                        if (n18 >= this.ROWS) {
                                                            break block426;
                                                        }
                                                        break block443;
                                                    }
                                                    n18 = n7;
                                                    n2 = (this.eleIndex[this.currentVar] + n17) / this.COLUMNS;
                                                    n3 = (this.eleIndex[this.currentVar] + n17) % this.COLUMNS + this.istart;
                                                }
                                                by = lArray[0] > 1L ? ((byte[])object)[n17] : (Byte)object;
                                                boolean bl = true;
                                                if (this.minObj != null) {
                                                    if (this.minLen == 1) {
                                                        if (by < by5) {
                                                            bl = false;
                                                            by = this.filObj != null ? by7 : (byte)0;
                                                        }
                                                    } else if (((byte[])this.minObj).length > n17 && by < ((byte[])this.minObj)[n17]) {
                                                        bl = false;
                                                        by = this.filObj != null ? by7 : (byte)0;
                                                    }
                                                }
                                                if (bl && this.maxObj != null) {
                                                    if (this.maxLen == 1) {
                                                        if (by > by6) {
                                                            by = this.filObj != null ? by7 : (byte)0;
                                                        }
                                                    } else if (((byte[])this.maxObj).length > n17 && by > ((byte[])this.maxObj)[n17]) {
                                                        by = this.filObj != null ? by7 : (byte)0;
                                                    }
                                                }
                                                this.recordObject[n2][n18][n3] = string == null ? new Byte(by) : Cformat.getInstance(string).form(by);
                                            }
                                            ++n17;
                                        }
                                        break block426;
                                    }
                                    if (l != (long)2 && l != 11L) break block444;
                                    short s = 0;
                                    short s5 = 0;
                                    short s6 = 0;
                                    short s7 = 0;
                                    if (this.minObj != null) {
                                        s5 = ((short[])this.minObj)[0];
                                    }
                                    if (this.maxObj != null) {
                                        s6 = ((short[])this.maxObj)[0];
                                    }
                                    if (this.filObj != null) {
                                        s7 = ((short[])this.filObj)[0];
                                    }
                                    if (l == 11L) {
                                        if (s5 < 0) {
                                            s5 = (short)(s5 - -256);
                                        }
                                        if (s6 < 0) {
                                            s6 = (short)(s6 - -256);
                                        }
                                        if (s7 < 0) {
                                            s7 = (short)(s7 - -256);
                                        }
                                    }
                                    int n19 = 0;
                                    while (n19 < (int)lArray[0]) {
                                        block446: {
                                            short s8;
                                            block447: {
                                                int n20;
                                                block445: {
                                                    if (this.myCDFExport.orientation != 0) break block445;
                                                    n20 = n19 + n7;
                                                    if (n20 < 0) break block446;
                                                    if (n20 >= this.ROWS) {
                                                        break block426;
                                                    }
                                                    break block447;
                                                }
                                                n20 = n7;
                                                n2 = (this.eleIndex[this.currentVar] + n19) / this.COLUMNS;
                                                n3 = (this.eleIndex[this.currentVar] + n19) % this.COLUMNS + this.istart;
                                            }
                                            s = lArray[0] > 1L ? ((short[])object)[n19] : (Short)object;
                                            if (l == 11L && s < 0) {
                                                s = (short)(s - -256);
                                            }
                                            boolean bl = true;
                                            if (this.minObj != null) {
                                                if (this.minLen == 1) {
                                                    if (s < s5) {
                                                        bl = false;
                                                        s = this.filObj != null ? s7 : (short)0;
                                                    }
                                                } else if (((short[])this.minObj).length > n19) {
                                                    s8 = ((short[])this.minObj)[n19];
                                                    if (l == 11L && s8 < 0) {
                                                        s8 = (short)(s8 - -256);
                                                    }
                                                    if (s < s8) {
                                                        bl = false;
                                                        s = this.filObj != null ? s7 : (short)0;
                                                    }
                                                }
                                            }
                                            if (bl && this.maxObj != null) {
                                                if (this.maxLen == 1) {
                                                    if (s > s6) {
                                                        s = this.filObj != null ? s7 : (short)0;
                                                    }
                                                } else if (((short[])this.maxObj).length > n19) {
                                                    s8 = ((short[])this.maxObj)[n19];
                                                    if (l == 11L && s8 < 0) {
                                                        s8 = (short)(s8 - -256);
                                                    }
                                                    if (s > s8) {
                                                        s = this.filObj != null ? s7 : (short)0;
                                                    }
                                                }
                                            }
                                            this.recordObject[n2][n20][n3] = string == null ? new Short(s) : Cformat.getInstance(string).form(s);
                                        }
                                        ++n19;
                                    }
                                    break block426;
                                }
                                if (l != (long)4 && l != 12L) break block448;
                                int n21 = 0;
                                int n22 = 0;
                                int n23 = 0;
                                int n24 = 0;
                                if (this.minObj != null) {
                                    n22 = ((int[])this.minObj)[0];
                                }
                                if (this.maxObj != null) {
                                    n23 = ((int[])this.maxObj)[0];
                                }
                                if (this.filObj != null) {
                                    n24 = ((int[])this.filObj)[0];
                                }
                                if (l == 12L) {
                                    if (n22 < 0) {
                                        n22 -= -65536;
                                    }
                                    if (n23 < 0) {
                                        n23 -= -65536;
                                    }
                                    if (n24 < 0) {
                                        n24 -= -65536;
                                    }
                                }
                                int n25 = 0;
                                while (n25 < (int)lArray[0]) {
                                    block450: {
                                        int n26;
                                        block451: {
                                            int n27;
                                            block449: {
                                                if (this.myCDFExport.orientation != 0) break block449;
                                                n27 = n25 + n7;
                                                if (n27 < 0) break block450;
                                                if (n27 >= this.ROWS) {
                                                    break block426;
                                                }
                                                break block451;
                                            }
                                            n27 = n7;
                                            n2 = (this.eleIndex[this.currentVar] + n25) / this.COLUMNS;
                                            n3 = (this.eleIndex[this.currentVar] + n25) % this.COLUMNS + this.istart;
                                        }
                                        n21 = lArray[0] > 1L ? ((int[])object)[n25] : (Integer)object;
                                        if (l == 12L && n21 < 0) {
                                            n21 -= -65536;
                                        }
                                        boolean bl = true;
                                        if (this.minObj != null) {
                                            if (this.minLen == 1) {
                                                if (n21 < n22) {
                                                    bl = false;
                                                    n21 = this.filObj != null ? n24 : 0;
                                                }
                                            } else if (((int[])this.minObj).length > n25) {
                                                n26 = ((int[])this.minObj)[n25];
                                                if (l == 12L && n26 < 0) {
                                                    n26 -= -65536;
                                                }
                                                if (n21 < n26) {
                                                    bl = false;
                                                    n21 = this.filObj != null ? n24 : 0;
                                                }
                                            }
                                        }
                                        if (bl && this.maxObj != null) {
                                            if (this.maxLen == 1) {
                                                if (n21 > n23) {
                                                    n21 = this.filObj != null ? n24 : 0;
                                                }
                                            } else if (((int[])this.maxObj).length > n25) {
                                                n26 = ((int[])this.maxObj)[n25];
                                                if (l == 12L && n26 < 0) {
                                                    n26 -= -65536;
                                                }
                                                if (n21 > n26) {
                                                    n21 = this.filObj != null ? n24 : 0;
                                                }
                                            }
                                        }
                                        this.recordObject[n2][n27][n3] = string == null ? new Integer(n21) : Cformat.getInstance(string).form(n21);
                                    }
                                    ++n25;
                                }
                                break block426;
                            }
                            if (l != 14L) break block452;
                            long l6 = 0L;
                            long l7 = 0L;
                            long l8 = 0L;
                            long l9 = 0L;
                            if (this.minObj != null) {
                                l7 = ((long[])this.minObj)[0];
                            }
                            if (this.maxObj != null) {
                                l8 = ((long[])this.maxObj)[0];
                            }
                            if (this.filObj != null) {
                                l9 = ((long[])this.filObj)[0];
                            }
                            if (l7 < 0L) {
                                l7 -= -4294967296L;
                            }
                            if (l8 < 0L) {
                                l8 -= -4294967296L;
                            }
                            if (l9 < 0L) {
                                l9 -= -4294967296L;
                            }
                            int n28 = 0;
                            while (n28 < (int)lArray[0]) {
                                block454: {
                                    long l10;
                                    block455: {
                                        int n29;
                                        block453: {
                                            if (this.myCDFExport.orientation != 0) break block453;
                                            n29 = n28 + n7;
                                            if (n29 < 0) break block454;
                                            if (n29 >= this.ROWS) {
                                                break block426;
                                            }
                                            break block455;
                                        }
                                        n29 = n7;
                                        n2 = (this.eleIndex[this.currentVar] + n28) / this.COLUMNS;
                                        n3 = (this.eleIndex[this.currentVar] + n28) % this.COLUMNS + this.istart;
                                    }
                                    if ((l6 = lArray[0] > 1L ? ((long[])object)[n28] : (Long)object) < 0L) {
                                        l6 -= -4294967296L;
                                    }
                                    boolean bl = true;
                                    if (this.minObj != null) {
                                        if (this.minLen == 1) {
                                            if (l6 < l7) {
                                                bl = false;
                                                l6 = this.filObj != null ? l9 : 0L;
                                            }
                                        } else if (((long[])this.minObj).length > n28) {
                                            l10 = ((long[])this.minObj)[n28];
                                            if (l10 < 0L) {
                                                l10 -= -4294967296L;
                                            }
                                            if (l6 < l10) {
                                                bl = false;
                                                l6 = this.filObj != null ? l9 : 0L;
                                            }
                                        }
                                    }
                                    if (bl && this.maxObj != null) {
                                        if (this.maxLen == 1) {
                                            if (l6 > l8) {
                                                l6 = this.filObj != null ? l9 : 0L;
                                            }
                                        } else if (((long[])this.maxObj).length > n28) {
                                            l10 = ((long[])this.maxObj)[n28];
                                            if (l10 < 0L) {
                                                l10 -= -4294967296L;
                                            }
                                            if (l6 > l10) {
                                                l6 = this.filObj != null ? l9 : 0L;
                                            }
                                        }
                                    }
                                    this.recordObject[n2][n29][n3] = string == null ? new Long(l6) : Cformat.getInstance(string).form(l6);
                                }
                                ++n28;
                            }
                            break block426;
                        }
                        if (l != 21L && l != 44L) break block456;
                        float f = 0.0f;
                        float f5 = 0.0f;
                        float f6 = 0.0f;
                        float f7 = 0.0f;
                        if (this.minObj != null && this.minLen == 1) {
                            f5 = ((float[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            f6 = ((float[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            f7 = ((float[])this.filObj)[0];
                        }
                        int n30 = 0;
                        while (n30 < (int)lArray[0]) {
                            block458: {
                                block459: {
                                    int n31;
                                    block457: {
                                        if (this.myCDFExport.orientation != 0) break block457;
                                        n31 = n30 + n7;
                                        if (n31 < 0) break block458;
                                        if (n31 >= this.ROWS) {
                                            break block426;
                                        }
                                        break block459;
                                    }
                                    n31 = n7;
                                    n2 = (this.eleIndex[this.currentVar] + n30) / this.COLUMNS;
                                    n3 = (this.eleIndex[this.currentVar] + n30) % this.COLUMNS + this.istart;
                                }
                                f = lArray[0] > 1L ? ((float[])object)[n30] : ((Float)object).floatValue();
                                boolean bl = true;
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (f < f5) {
                                            bl = false;
                                            f = this.filObj != null ? f7 : 0.0f;
                                        }
                                    } else if (((float[])this.minObj).length > n30 && f < ((float[])this.minObj)[n30]) {
                                        bl = false;
                                        f = this.filObj != null ? f7 : 0.0f;
                                    }
                                }
                                if (bl && this.maxObj != null) {
                                    if (this.maxLen == 1) {
                                        if (f > f6) {
                                            f = this.filObj != null ? f7 : 0.0f;
                                        }
                                    } else if (((float[])this.maxObj).length > n30 && f > ((float[])this.maxObj)[n30]) {
                                        f = this.filObj != null ? f7 : 0.0f;
                                    }
                                }
                                this.recordObject[n2][n31][n3] = string == null ? new Float(f) : Cformat.getInstance(string).form(f);
                            }
                            ++n30;
                        }
                        break block426;
                    }
                    if (l != 22L && l != 45L && l != 31L) break block460;
                    double d = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    if (this.minObj != null && this.minLen == 1) {
                        d5 = ((double[])this.minObj)[0];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        d6 = ((double[])this.maxObj)[0];
                    }
                    if (this.filObj != null) {
                        d7 = ((double[])this.filObj)[0];
                    }
                    int n32 = 0;
                    while (n32 < (int)lArray[0]) {
                        block462: {
                            block463: {
                                int n33;
                                block461: {
                                    if (this.myCDFExport.orientation != 0) break block461;
                                    n33 = n32 + n7;
                                    if (n33 < 0) break block462;
                                    if (n33 >= this.ROWS) {
                                        break block426;
                                    }
                                    break block463;
                                }
                                n33 = n7;
                                n2 = (this.eleIndex[this.currentVar] + n32) / this.COLUMNS;
                                n3 = (this.eleIndex[this.currentVar] + n32) % this.COLUMNS + this.istart;
                            }
                            d = lArray[0] > 1L ? ((double[])object)[n32] : (Double)object;
                            boolean bl = true;
                            if (this.minObj != null) {
                                if (this.minLen == 1) {
                                    if (d < d5) {
                                        bl = false;
                                        d = this.filObj != null ? d7 : 0.0;
                                    }
                                } else if (((double[])this.minObj).length > n32 && d < ((double[])this.minObj)[n32]) {
                                    bl = false;
                                    d = this.filObj != null ? d7 : 0.0;
                                }
                            }
                            if (bl && this.maxObj != null) {
                                if (this.maxLen == 1) {
                                    if (d > d6) {
                                        d = this.filObj != null ? d7 : 0.0;
                                    }
                                } else if (((double[])this.maxObj).length > n32 && d > ((double[])this.maxObj)[n32]) {
                                    d = this.filObj != null ? d7 : 0.0;
                                }
                            }
                            if (l != 31L) {
                                this.recordObject[n2][n33][n3] = string == null ? new Double(d) : Cformat.getInstance(string).form(d);
                            } else {
                                String string8 = null;
                                if (this.myCDFExport.epoch == 0) {
                                    string8 = Epoch.encode((double)d);
                                } else if (this.myCDFExport.epoch == 1) {
                                    string8 = Epoch.encode1((double)d);
                                } else if (this.myCDFExport.epoch == 2) {
                                    string8 = Epoch.encode2((double)d);
                                } else if (this.myCDFExport.epoch == 3) {
                                    string8 = Epoch.encode3((double)d);
                                } else if (this.myCDFExport.epoch == 5) {
                                    try {
                                        String string9 = (String)variable.getEntryData("FORMAT");
                                        string8 = string9 == null || string9.trim().length() == 0 ? Epoch.encode((double)d) : Epoch.encodex((double)d, (String)string9);
                                    }
                                    catch (CDFException cDFException) {
                                        string8 = Epoch.encode((double)d);
                                    }
                                }
                                this.recordObject[n2][n33][n3] = string8;
                            }
                        }
                        ++n32;
                    }
                    break block426;
                }
                if (l != 32L) break block426;
                double[] dArray = new double[2];
                double[] dArray5 = new double[2];
                double[] dArray6 = new double[2];
                double[] dArray7 = new double[2];
                if (this.minObj != null && this.minLen == 1) {
                    dArray5[0] = ((double[])this.minObj)[0];
                    dArray5[0] = ((double[])this.minObj)[0];
                }
                if (this.maxObj != null && this.maxLen == 1) {
                    dArray6[0] = ((double[])this.maxObj)[0];
                    dArray6[0] = ((double[])this.maxObj)[0];
                }
                if (this.filObj != null) {
                    dArray7[0] = ((double[])this.filObj)[0];
                    dArray7[0] = ((double[])this.filObj)[0];
                }
                int n34 = 0;
                while (n34 < (int)lArray[0]) {
                    block465: {
                        block466: {
                            int n35;
                            block464: {
                                if (this.myCDFExport.orientation != 0) break block464;
                                n35 = n34 + n7;
                                if (n35 < 0) break block465;
                                if (n35 >= this.ROWS) {
                                    break block426;
                                }
                                break block466;
                            }
                            n35 = n7;
                            n2 = (this.eleIndex[this.currentVar] + n34) / this.COLUMNS;
                            n3 = (this.eleIndex[this.currentVar] + n34) % this.COLUMNS + this.istart;
                        }
                        if (lArray[0] > 1L) {
                            dArray[0] = ((double[])object)[2 * n34];
                            dArray[1] = ((double[])object)[2 * n34 + 1];
                        } else {
                            dArray[0] = ((double[])object)[0];
                            dArray[1] = ((double[])object)[1];
                        }
                        boolean bl = true;
                        if (this.minObj != null) {
                            if (this.minLen == 1) {
                                if (dArray[0] < dArray5[0] || dArray[0] == dArray5[0] && dArray[1] < dArray5[1]) {
                                    bl = false;
                                    if (this.filObj != null) {
                                        dArray[0] = dArray7[0];
                                        dArray[1] = dArray7[1];
                                    } else {
                                        dArray[0] = 0.0;
                                        dArray[0] = 0.0;
                                    }
                                }
                            } else if (((double[])this.minObj).length > n34 && (dArray[0] < ((double[])this.minObj)[2 * n34] || dArray[0] == ((double[])this.minObj)[2 * n34] && dArray[1] < ((double[])this.minObj)[2 * n34 + 1])) {
                                bl = false;
                                if (this.filObj != null) {
                                    dArray[0] = dArray7[0];
                                    dArray[1] = dArray7[1];
                                } else {
                                    dArray[1] = 0.0;
                                    dArray[0] = 0.0;
                                }
                            }
                        }
                        if (bl && this.maxObj != null) {
                            if (this.maxLen == 1) {
                                if (dArray[0] > dArray6[0] || dArray[0] == dArray6[0] && dArray[1] > dArray6[1]) {
                                    if (this.filObj != null) {
                                        dArray[0] = dArray7[0];
                                        dArray[1] = dArray7[1];
                                    } else {
                                        dArray[1] = 0.0;
                                        dArray[0] = 0.0;
                                    }
                                }
                            } else if (((double[])this.maxObj).length > n34 && (dArray[0] > ((double[])this.maxObj)[2 * n34] || dArray[0] == ((double[])this.maxObj)[2 * n34] && dArray[1] > ((double[])this.maxObj)[2 * n34 + 1])) {
                                if (this.filObj != null) {
                                    dArray[0] = dArray7[0];
                                    dArray[1] = dArray7[1];
                                } else {
                                    dArray[1] = 0.0;
                                    dArray[0] = 0.0;
                                }
                            }
                        }
                        String string10 = null;
                        if (this.myCDFExport.epoch == 0) {
                            string10 = Epoch16.encode((Object)dArray);
                        } else if (this.myCDFExport.epoch == 1) {
                            string10 = Epoch16.encode1((Object)dArray);
                        } else if (this.myCDFExport.epoch == 2) {
                            string10 = Epoch16.encode2((Object)dArray);
                        } else if (this.myCDFExport.epoch == 3) {
                            string10 = Epoch16.encode3((Object)dArray);
                        } else if (this.myCDFExport.epoch == 5) {
                            try {
                                String string11 = (String)variable.getEntryData("FORMAT");
                                string10 = string11 == null || string11.trim().length() == 0 ? Epoch16.encode((Object)dArray) : Epoch16.encodex((Object)dArray, (String)string11);
                            }
                            catch (CDFException cDFException) {
                                string10 = Epoch16.encode((Object)dArray);
                            }
                        }
                        this.recordObject[n2][n35][n3] = string10;
                    }
                    ++n34;
                }
                break block426;
            }
            int n36 = this.eleIndex[this.currentVar];
            int n37 = (int)lArray[n - 1];
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[n - 1];
            int[] nArray = new int[n - 1];
            long[] lArray2 = new long[n - 1];
            nArray[0] = 0;
            lArray2[0] = this.product(lArray, 0, n);
            objectArray2[0] = object;
            int n38 = 1;
            while (n38 < n - 1) {
                objectArray2[n38] = Array.get(objectArray2[n38 - 1], 0);
                lArray2[n38] = this.product(lArray, n38, n);
                nArray[n38] = 0;
                ++n38;
            }
            n38 = 0;
            Object object2 = object;
            while ((long)n38 < lArray2[0]) {
                block471: {
                    boolean bl;
                    int n39;
                    int n40;
                    block492: {
                        int n41;
                        int n42;
                        block488: {
                            block484: {
                                block480: {
                                    block476: {
                                        block472: {
                                            block467: {
                                                if (n38 != 0) {
                                                    int n43 = 0;
                                                    while (n43 < n - 1) {
                                                        boolean bl2;
                                                        boolean bl3 = false;
                                                        if ((long)n38 % lArray2[n43] == 0L) {
                                                            bl3 = true;
                                                        }
                                                        if (bl2 = bl3) {
                                                            int n44 = n43;
                                                            nArray[n44] = nArray[n44] + 1;
                                                            objectArray2[n43] = object2 = Array.get(object2, nArray[n43]);
                                                            int n45 = n43 + 1;
                                                            while (n45 < n - 1) {
                                                                nArray[n45] = 0;
                                                                objectArray2[n45] = Array.get(objectArray2[n45 - 1], nArray[n45]);
                                                                ++n45;
                                                            }
                                                            break;
                                                        }
                                                        object2 = objectArray2[n43];
                                                        ++n43;
                                                    }
                                                }
                                                if (l != 51L && l != 52L) break block467;
                                                int n46 = (int)variable.getNumElements();
                                                byte[] byArray = new byte[n46];
                                                int n47 = 0;
                                                while (n47 < (int)lArray[n - 2]) {
                                                    objectArray = (String[])Array.get(objectArray2[n - 2], n47);
                                                    int n48 = 0;
                                                    while (n48 < n37) {
                                                        block469: {
                                                            block470: {
                                                                block468: {
                                                                    if (this.myCDFExport.orientation != 0) break block468;
                                                                    n40 = n48 + n7 + n47 * n37;
                                                                    if (n40 < 0) break block469;
                                                                    if (n40 > n6) {
                                                                        break;
                                                                    }
                                                                    break block470;
                                                                }
                                                                n40 = n7;
                                                                n2 = n36 / this.COLUMNS;
                                                                n3 = n36 % this.COLUMNS + this.istart;
                                                                ++n36;
                                                            }
                                                            System.arraycopy(objectArray[n47].getBytes(), 0, byArray, 0, n46);
                                                            String string12 = new String(byArray);
                                                            this.recordObject[n2][n40][n3] = string12;
                                                        }
                                                        ++n48;
                                                    }
                                                    ++n47;
                                                }
                                                break block471;
                                            }
                                            if (l != 41L && l != 1L) break block472;
                                            byte by = 0;
                                            byte by8 = 0;
                                            byte by9 = 0;
                                            byte by10 = 0;
                                            if (this.minObj != null && this.minLen == 1) {
                                                by8 = ((byte[])this.minObj)[0];
                                            }
                                            if (this.maxObj != null && this.maxLen == 1) {
                                                by9 = ((byte[])this.maxObj)[0];
                                            }
                                            if (this.filObj != null) {
                                                by10 = ((byte[])this.filObj)[0];
                                            }
                                            int n49 = 0;
                                            while (n49 < (int)lArray[n - 2]) {
                                                objectArray = (byte[])Array.get(objectArray2[n - 2], n49);
                                                n39 = 0;
                                                while (n39 < n37) {
                                                    block474: {
                                                        block475: {
                                                            block473: {
                                                                if (this.myCDFExport.orientation != 0) break block473;
                                                                n40 = n39 + n7 + n49 * n37;
                                                                if (n40 < 0) break block474;
                                                                if (n40 >= this.ROWS) {
                                                                    break;
                                                                }
                                                                break block475;
                                                            }
                                                            n40 = n7;
                                                            n2 = n36 / this.COLUMNS;
                                                            n3 = n36 % this.COLUMNS + this.istart;
                                                            ++n36;
                                                        }
                                                        by = ((byte[])objectArray)[n39];
                                                        bl = true;
                                                        if (this.minObj != null) {
                                                            if (this.minLen == 1) {
                                                                if (by < by8) {
                                                                    bl = false;
                                                                    by = this.filObj != null ? by10 : (byte)0;
                                                                }
                                                            } else if (((byte[])this.minObj).length > n39 && by < ((byte[])this.minObj)[n39]) {
                                                                bl = false;
                                                                by = this.filObj != null ? by10 : (byte)0;
                                                            }
                                                        }
                                                        if (bl && this.maxObj != null) {
                                                            if (this.maxLen == 1) {
                                                                if (by > by9) {
                                                                    by = this.filObj != null ? by10 : (byte)0;
                                                                }
                                                            } else if (((byte[])this.maxObj).length > n39 && by > ((byte[])this.maxObj)[n39]) {
                                                                by = this.filObj != null ? by10 : (byte)0;
                                                            }
                                                        }
                                                        this.recordObject[n2][n40][n3] = string == null ? new Byte(by) : Cformat.getInstance(string).form(by);
                                                    }
                                                    ++n39;
                                                }
                                                ++n49;
                                            }
                                            break block471;
                                        }
                                        if (l != (long)2 && l != 11L) break block476;
                                        short s = 0;
                                        short s9 = 0;
                                        short s10 = 0;
                                        short s11 = 0;
                                        if (this.minObj != null) {
                                            s9 = ((short[])this.minObj)[0];
                                        }
                                        if (this.maxObj != null) {
                                            s10 = ((short[])this.maxObj)[0];
                                        }
                                        if (this.filObj != null) {
                                            s11 = ((short[])this.filObj)[0];
                                        }
                                        if (l == 11L) {
                                            if (s9 < 0) {
                                                s9 = (short)(s9 - -256);
                                            }
                                            if (s10 < 0) {
                                                s10 = (short)(s10 - -256);
                                            }
                                            if (s11 < 0) {
                                                s11 = (short)(s11 - -256);
                                            }
                                        }
                                        int n50 = 0;
                                        while (n50 < (int)lArray[n - 2]) {
                                            objectArray = (short[])Array.get(objectArray2[n - 2], n50);
                                            n39 = 0;
                                            while (n39 < n37) {
                                                block478: {
                                                    short s12;
                                                    block479: {
                                                        block477: {
                                                            if (this.myCDFExport.orientation != 0) break block477;
                                                            n40 = n39 + n7 + n50 * n37;
                                                            if (n40 < 0) break block478;
                                                            if (n40 >= this.ROWS) {
                                                                break;
                                                            }
                                                            break block479;
                                                        }
                                                        n40 = n7;
                                                        n2 = n36 / this.COLUMNS;
                                                        n3 = n36 % this.COLUMNS + this.istart;
                                                        ++n36;
                                                    }
                                                    s = ((short[])objectArray)[n39];
                                                    if (l == 11L && s < 0) {
                                                        s = (short)(s - -256);
                                                    }
                                                    bl = true;
                                                    if (this.minObj != null) {
                                                        if (this.minLen == 1) {
                                                            if (s < s9) {
                                                                bl = false;
                                                                s = this.filObj != null ? s11 : (short)0;
                                                            }
                                                        } else if (((short[])this.minObj).length > n39) {
                                                            s12 = ((short[])this.minObj)[n39];
                                                            if (l == 11L && s12 < 0) {
                                                                s12 = (short)(s12 - -256);
                                                            }
                                                            if (s < s12) {
                                                                bl = false;
                                                                s = this.filObj != null ? s11 : (short)0;
                                                            }
                                                        }
                                                    }
                                                    if (bl && this.maxObj != null) {
                                                        if (this.maxLen == 1) {
                                                            if (s > s10) {
                                                                s = this.filObj != null ? s11 : (short)0;
                                                            }
                                                        } else if (((short[])this.maxObj).length > n39) {
                                                            s12 = ((short[])this.maxObj)[n39];
                                                            if (l == 11L && s12 < 0) {
                                                                s12 = (short)(s12 - -256);
                                                            }
                                                            if (s > s12) {
                                                                s = this.filObj != null ? s11 : (short)0;
                                                            }
                                                        }
                                                    }
                                                    this.recordObject[n2][n40][n3] = string == null ? new Short(s) : Cformat.getInstance(string).form(s);
                                                }
                                                ++n39;
                                            }
                                            ++n50;
                                        }
                                        break block471;
                                    }
                                    if (l != (long)4 && l != 12L) break block480;
                                    int n51 = 0;
                                    int n52 = 0;
                                    int n53 = 0;
                                    int n54 = 0;
                                    if (this.minObj != null) {
                                        n52 = ((int[])this.minObj)[0];
                                    }
                                    if (this.maxObj != null) {
                                        n53 = ((int[])this.maxObj)[0];
                                    }
                                    if (this.filObj != null) {
                                        n54 = ((int[])this.filObj)[0];
                                    }
                                    if (l == 12L) {
                                        if (n52 < 0) {
                                            n52 -= -65536;
                                        }
                                        if (n53 < 0) {
                                            n53 -= -65536;
                                        }
                                        if (n54 < 0) {
                                            n54 -= -65536;
                                        }
                                    }
                                    int n55 = 0;
                                    while (n55 < (int)lArray[n - 2]) {
                                        objectArray = (int[])Array.get(objectArray2[n - 2], n55);
                                        n39 = 0;
                                        while (n39 < n37) {
                                            block482: {
                                                int n56;
                                                block483: {
                                                    block481: {
                                                        if (this.myCDFExport.orientation != 0) break block481;
                                                        n40 = n39 + n7 + n55 * n37;
                                                        if (n40 < 0) break block482;
                                                        if (n40 >= this.ROWS) {
                                                            break;
                                                        }
                                                        break block483;
                                                    }
                                                    n40 = n7;
                                                    n2 = n36 / this.COLUMNS;
                                                    n3 = n36 % this.COLUMNS + this.istart;
                                                    ++n36;
                                                }
                                                n51 = ((int[])objectArray)[n39];
                                                if (l == 12L && n51 < 0) {
                                                    n51 -= -65536;
                                                }
                                                bl = true;
                                                if (this.minObj != null) {
                                                    if (this.minLen == 1) {
                                                        if (n51 < n52) {
                                                            bl = false;
                                                            n51 = this.filObj != null ? n54 : 0;
                                                        }
                                                    } else if (((int[])this.minObj).length > n39) {
                                                        n56 = ((int[])this.minObj)[n39];
                                                        if (l == 12L && n56 < 0) {
                                                            n56 -= -65536;
                                                        }
                                                        if (n51 < n56) {
                                                            bl = false;
                                                            n51 = this.filObj != null ? n54 : 0;
                                                        }
                                                    }
                                                }
                                                if (bl && this.maxObj != null) {
                                                    if (this.maxLen == 1) {
                                                        if (n51 > n52) {
                                                            n51 = this.filObj != null ? n54 : 0;
                                                        }
                                                    } else if (((int[])this.maxObj).length > n39) {
                                                        n56 = ((int[])this.maxObj)[n39];
                                                        if (l == 12L && n56 < 0) {
                                                            n56 -= -65536;
                                                        }
                                                        if (n51 > n56) {
                                                            n51 = this.filObj != null ? n54 : 0;
                                                        }
                                                    }
                                                }
                                                this.recordObject[n2][n40][n3] = string == null ? new Integer(n51) : Cformat.getInstance(string).form(n51);
                                            }
                                            ++n39;
                                        }
                                        ++n55;
                                    }
                                    break block471;
                                }
                                if (l != 14L) break block484;
                                long l11 = 0L;
                                long l12 = 0L;
                                long l13 = 0L;
                                long l14 = 0L;
                                if (this.minObj != null) {
                                    l12 = ((long[])this.minObj)[0];
                                }
                                if (this.maxObj != null) {
                                    l13 = ((long[])this.maxObj)[0];
                                }
                                if (this.filObj != null) {
                                    l14 = ((long[])this.filObj)[0];
                                }
                                if (l12 < 0L) {
                                    l12 -= -4294967296L;
                                }
                                if (l13 < 0L) {
                                    l13 -= -4294967296L;
                                }
                                if (l14 < 0L) {
                                    l14 -= -4294967296L;
                                }
                                n42 = 0;
                                while (n42 < (int)lArray[n - 2]) {
                                    objectArray = (long[])Array.get(objectArray2[n - 2], n42);
                                    n41 = 0;
                                    while (n41 < n37) {
                                        block486: {
                                            long l15;
                                            block487: {
                                                block485: {
                                                    if (this.myCDFExport.orientation != 0) break block485;
                                                    n40 = n41 + n7 + n42 * n37;
                                                    if (n40 < 0) break block486;
                                                    if (n40 >= this.ROWS) {
                                                        break;
                                                    }
                                                    break block487;
                                                }
                                                n40 = n7;
                                                n2 = n36 / this.COLUMNS;
                                                n3 = n36 % this.COLUMNS + this.istart;
                                                ++n36;
                                            }
                                            if ((l11 = ((long[])objectArray)[n41]) < 0L) {
                                                l11 -= -4294967296L;
                                            }
                                            bl = true;
                                            if (this.minObj != null) {
                                                if (this.minLen == 1) {
                                                    if (l11 < l12) {
                                                        bl = false;
                                                        l11 = this.filObj != null ? l14 : 0L;
                                                    }
                                                } else if (((long[])this.minObj).length > n41) {
                                                    l15 = ((long[])this.minObj)[n41];
                                                    if (l15 < 0L) {
                                                        l15 -= -4294967296L;
                                                    }
                                                    if (l11 < l15) {
                                                        bl = false;
                                                        l11 = this.filObj != null ? l14 : 0L;
                                                    }
                                                }
                                            }
                                            if (bl && this.maxObj != null) {
                                                if (this.maxLen == 1) {
                                                    if (l11 > l13) {
                                                        l11 = this.filObj != null ? l14 : 0L;
                                                    }
                                                } else if (((long[])this.maxObj).length > n41) {
                                                    l15 = ((long[])this.maxObj)[n41];
                                                    if (l15 < 0L) {
                                                        l15 -= -4294967296L;
                                                    }
                                                    if (l11 > l15) {
                                                        l11 = this.filObj != null ? l14 : 0L;
                                                    }
                                                }
                                            }
                                            this.recordObject[n2][n40][n3] = string == null ? new Long(l11) : Cformat.getInstance(string).form(l11);
                                        }
                                        ++n41;
                                    }
                                    ++n42;
                                }
                                break block471;
                            }
                            if (l != 21L && l != 44L) break block488;
                            float f = 0.0f;
                            float f8 = 0.0f;
                            float f9 = 0.0f;
                            float f10 = 0.0f;
                            if (this.minObj != null && this.minLen == 1) {
                                f8 = ((float[])this.minObj)[0];
                            }
                            if (this.maxObj != null && this.maxLen == 1) {
                                f9 = ((float[])this.maxObj)[0];
                            }
                            if (this.filObj != null) {
                                f10 = ((float[])this.filObj)[0];
                            }
                            int n57 = 0;
                            while (n57 < (int)lArray[n - 2]) {
                                objectArray = (float[])Array.get(objectArray2[n - 2], n57);
                                n39 = 0;
                                while (n39 < n37) {
                                    block490: {
                                        block491: {
                                            block489: {
                                                if (this.myCDFExport.orientation != 0) break block489;
                                                n40 = n39 + n7 + n57 * n37;
                                                if (n40 < 0) break block490;
                                                if (n40 >= this.ROWS) {
                                                    break;
                                                }
                                                break block491;
                                            }
                                            n40 = n7;
                                            n2 = n36 / this.COLUMNS;
                                            n3 = n36 % this.COLUMNS + this.istart;
                                            ++n36;
                                        }
                                        f = ((float[])objectArray)[n39];
                                        bl = true;
                                        if (this.minObj != null) {
                                            if (this.minLen == 1) {
                                                if (f < f8) {
                                                    bl = false;
                                                    f = this.filObj != null ? f10 : 0.0f;
                                                }
                                            } else if (((float[])this.minObj).length > n39 && f < ((float[])this.minObj)[n39]) {
                                                bl = false;
                                                f = this.filObj != null ? f10 : 0.0f;
                                            }
                                        }
                                        if (bl && this.maxObj != null) {
                                            if (this.maxLen == 1) {
                                                if (f > f9) {
                                                    f = this.filObj != null ? f10 : 0.0f;
                                                }
                                            } else if (((float[])this.maxObj).length > n39 && f > ((float[])this.maxObj)[n39]) {
                                                f = this.filObj != null ? f10 : 0.0f;
                                            }
                                        }
                                        this.recordObject[n2][n40][n3] = string == null ? new Float(f) : Cformat.getInstance(string).form(f);
                                    }
                                    ++n39;
                                }
                                ++n57;
                            }
                            break block471;
                        }
                        if (l != 22L && l != 45L && l != 31L) break block492;
                        double d = 0.0;
                        double d8 = 0.0;
                        double d9 = 0.0;
                        double d10 = 0.0;
                        if (this.minObj != null && this.minLen == 1) {
                            d8 = ((double[])this.minObj)[0];
                        }
                        if (this.maxObj != null && this.maxLen == 1) {
                            d9 = ((double[])this.maxObj)[0];
                        }
                        if (this.filObj != null) {
                            d10 = ((double[])this.filObj)[0];
                        }
                        n42 = 0;
                        while (n42 < (int)lArray[n - 2]) {
                            objectArray = (double[])Array.get(objectArray2[n - 2], n42);
                            n41 = 0;
                            while (n41 < n37) {
                                block494: {
                                    block495: {
                                        block493: {
                                            if (this.myCDFExport.orientation != 0) break block493;
                                            n40 = n41 + n7 + n42 * n37;
                                            if (n40 < 0) break block494;
                                            if (n40 >= this.ROWS) {
                                                break;
                                            }
                                            break block495;
                                        }
                                        n40 = n7;
                                        n2 = n36 / this.COLUMNS;
                                        n3 = n36 % this.COLUMNS + this.istart;
                                        ++n36;
                                    }
                                    d = ((double[])objectArray)[n41];
                                    bl = true;
                                    if (this.minObj != null) {
                                        if (this.minLen == 1) {
                                            if (d < d8) {
                                                bl = false;
                                                d = this.filObj != null ? d10 : 0.0;
                                            }
                                        } else if (((double[])this.minObj).length > n41 && d < ((double[])this.minObj)[n41]) {
                                            bl = false;
                                            d = this.filObj != null ? d10 : 0.0;
                                        }
                                    }
                                    if (bl && this.maxObj != null) {
                                        if (this.maxLen == 1) {
                                            if (d > d9) {
                                                d = this.filObj != null ? d10 : 0.0;
                                            }
                                        } else if (((double[])this.maxObj).length > n41 && d > ((double[])this.maxObj)[n41]) {
                                            d = this.filObj != null ? d10 : 0.0;
                                        }
                                    }
                                    if (l != 31L) {
                                        this.recordObject[n2][n40][n3] = string == null ? new Double(d) : Cformat.getInstance(string).form(d);
                                    } else {
                                        String string13 = null;
                                        if (this.myCDFExport.epoch == 0) {
                                            string13 = Epoch.encode((double)d);
                                        } else if (this.myCDFExport.epoch == 1) {
                                            string13 = Epoch.encode1((double)d);
                                        } else if (this.myCDFExport.epoch == 2) {
                                            string13 = Epoch.encode2((double)d);
                                        } else if (this.myCDFExport.epoch == 3) {
                                            string13 = Epoch.encode3((double)d);
                                        } else if (this.myCDFExport.epoch == 5) {
                                            try {
                                                String string14 = (String)variable.getEntryData("FORMAT");
                                                string13 = string14 == null || string14.trim().length() == 0 ? Epoch.encode((double)d) : Epoch.encodex((double)d, (String)string14);
                                            }
                                            catch (CDFException cDFException) {
                                                string13 = Epoch.encode((double)d);
                                            }
                                        }
                                        this.recordObject[n2][n40][n3] = string13;
                                    }
                                }
                                ++n41;
                            }
                            ++n42;
                        }
                        break block471;
                    }
                    if (l != 32L) break block471;
                    double[] dArray = new double[2];
                    double[] dArray8 = new double[2];
                    double[] dArray9 = new double[2];
                    double[] dArray10 = new double[2];
                    if (this.minObj != null && this.minLen == 1) {
                        dArray8[0] = ((double[])this.minObj)[0];
                        dArray8[1] = ((double[])this.minObj)[1];
                    }
                    if (this.maxObj != null && this.maxLen == 1) {
                        dArray9[0] = ((double[])this.maxObj)[0];
                        dArray9[1] = ((double[])this.maxObj)[1];
                    }
                    if (this.filObj != null) {
                        dArray10[0] = ((double[])this.filObj)[0];
                        dArray10[1] = ((double[])this.filObj)[1];
                    }
                    int n58 = 0;
                    while (n58 < (int)lArray[n - 2]) {
                        objectArray = (double[])Array.get(objectArray2[n - 2], n58);
                        n39 = 0;
                        while (n39 < n37) {
                            block497: {
                                block498: {
                                    block496: {
                                        if (this.myCDFExport.orientation != 0) break block496;
                                        n40 = n39 + n7 + n58 * n37;
                                        if (n40 < 0) break block497;
                                        if (n40 >= this.ROWS) {
                                            break;
                                        }
                                        break block498;
                                    }
                                    n40 = n7;
                                    n2 = n36 / this.COLUMNS;
                                    n3 = n36 % this.COLUMNS + this.istart;
                                    ++n36;
                                }
                                dArray[0] = ((double[])objectArray)[2 * n39];
                                dArray[1] = ((double[])objectArray)[2 * n39 + 1];
                                bl = true;
                                if (this.minObj != null) {
                                    if (this.minLen == 1) {
                                        if (dArray[0] < dArray8[0] || dArray[0] < dArray8[0] && dArray[1] < dArray8[1]) {
                                            bl = false;
                                            if (this.filObj != null) {
                                                dArray[0] = dArray10[0];
                                                dArray[1] = dArray10[1];
                                            } else {
                                                dArray[1] = 0.0;
                                                dArray[0] = 0.0;
                                            }
                                        }
                                    } else if (((double[])this.minObj).length > n39 && (dArray[0] < ((double[])this.minObj)[2 * n39] || dArray[0] == ((double[])this.minObj)[2 * n39] && dArray[1] < ((double[])this.minObj)[2 * n39 + 1])) {
                                        bl = false;
                                        if (this.filObj != null) {
                                            dArray[0] = dArray10[0];
                                            dArray[1] = dArray10[1];
                                        } else {
                                            dArray[1] = 0.0;
                                            dArray[0] = 0.0;
                                        }
                                    }
                                }
                                if (bl && this.maxObj != null) {
                                    if (this.maxLen == 1) {
                                        if (dArray[0] > dArray9[0] || dArray[0] == dArray9[0] && dArray[1] > dArray9[1]) {
                                            if (this.filObj != null) {
                                                dArray[0] = dArray10[0];
                                                dArray[1] = dArray10[1];
                                            } else {
                                                dArray[1] = 0.0;
                                                dArray[0] = 0.0;
                                            }
                                        }
                                    } else if (((double[])this.maxObj).length > n39 && (dArray[0] > ((double[])this.maxObj)[2 * n39] || dArray[0] == ((double[])this.maxObj)[2 * n39] && dArray[1] > ((double[])this.maxObj)[2 * n39 + 1])) {
                                        if (this.filObj != null) {
                                            dArray[0] = dArray10[0];
                                            dArray[1] = dArray10[1];
                                        } else {
                                            dArray[1] = 0.0;
                                            dArray[0] = 0.0;
                                        }
                                    }
                                }
                                String string15 = null;
                                if (this.myCDFExport.epoch == 0) {
                                    string15 = Epoch16.encode((Object)dArray);
                                } else if (this.myCDFExport.epoch == 1) {
                                    string15 = Epoch16.encode1((Object)dArray);
                                } else if (this.myCDFExport.epoch == 2) {
                                    string15 = Epoch16.encode2((Object)dArray);
                                } else if (this.myCDFExport.epoch == 3) {
                                    string15 = Epoch16.encode3((Object)dArray);
                                } else if (this.myCDFExport.epoch == 5) {
                                    try {
                                        String string16 = (String)variable.getEntryData("FORMAT");
                                        string15 = string16 == null || string16.trim().length() == 0 ? Epoch16.encode((Object)dArray) : Epoch16.encodex((Object)dArray, (String)string16);
                                    }
                                    catch (CDFException cDFException) {
                                        string15 = Epoch16.encode((Object)dArray);
                                    }
                                    this.recordObject[n2][n40][n3] = string15;
                                }
                            }
                            ++n39;
                        }
                        ++n58;
                    }
                }
                n38 = (int)((long)n38 + lArray2[n - 2]);
            }
        }
        return object;
    }

    private final long product(long[] lArray, int n, int n2) {
        long l = 1L;
        int n3 = n;
        while (n3 < n2) {
            if (lArray[n3] > 1L) {
                l *= lArray[n3];
            }
            ++n3;
        }
        return l;
    }

    private final void createButton(JPanel jPanel) {
        if (this.enterButton == null) {
            this.enterButton = new JButton(ENTER);
            this.backButton = new JButton(BACK);
            this.cancelButton = new JButton(CANCEL);
            this.buttonPanel = new JPanel(true);
            this.buttonPanel.add(this.enterButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(30, 1)));
            this.buttonPanel.add(this.backButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(30, 1)));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(30, 1)));
            this.aSelection = new SelectionListener();
            this.enterButton.addActionListener(this.aSelection);
            this.backButton.addActionListener(this.aSelection);
            this.cancelButton.addActionListener(this.aSelection);
            this.enterButton.setToolTipText("Continue to the next page...");
            this.backButton.setToolTipText("Back to the previous page...");
            this.cancelButton.setToolTipText("Stop and retrun...");
            jPanel.add((Component)this.buttonPanel, "South");
        }
    }

    void cleanTableObjects() {
        int n = 0;
        while (n < this.groups) {
            int n2 = 0;
            while (n2 < this.ROWS) {
                int n3 = 0;
                while (n3 < this.totalColumns) {
                    this.recordObject[n][n2][n3] = " ";
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    void cleanColumns() {
        int n = 0;
        while (n < this.groups) {
            int n2 = 0;
            while (n2 < this.totalColumns) {
                this.columnNames[n][n2] = " ";
                ++n2;
            }
            ++n;
        }
    }

    void metaToFile(BufferedWriter bufferedWriter) {
        Vector vector = this.myCDFExport.sourceCDF.getGlobalAttributes();
        try {
            bufferedWriter.write("Global Attributes:");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                bufferedWriter.write("  " + attribute.getName());
                bufferedWriter.newLine();
                Vector vector2 = attribute.getEntries();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    Entry entry = (Entry)enumeration2.nextElement();
                    if (entry == null) continue;
                    long l = entry.getDataType();
                    int n = 0;
                    if (l == 31L) {
                        n = 1;
                    } else if (l == 32L) {
                        n = 2;
                    }
                    bufferedWriter.write("    \"" + CDFUtils.getStringData((Object)entry.getData(), (String)" ", (int)n) + "\" ");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            System.err.println("error writing meta data");
        }
    }

    protected BuildProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            if (this.focusedObj == this.pageField) {
                this.enterButton.doClick();
            } else {
                int n2 = Integer.parseInt(this.recordField.getText());
                int n3 = this.elementNum / this.totalElementsPerRec + 1;
                if (++n2 < 1 || n2 > this.totalWritten + 1) {
                    this.recordField.setText("" + n3);
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.elementNum = this.myCDFExport.orientation == 0 ? (n2 - 1) * this.totalElementsPerRec : n2 - 1;
                    this.recordField.setText("" + n2);
                    this.cleanTableObjects();
                    this.fillVarRecsToTable(this.elementNum);
                    this.displayTable(this.mainPanel);
                }
            }
        } else if (n == 40) {
            if (this.focusedObj == this.pageField) {
                this.backButton.doClick();
            } else {
                int n4 = Integer.parseInt(this.recordField.getText());
                int n5 = this.elementNum / this.totalElementsPerRec + 1;
                if (--n4 < 1 || n4 > this.totalWritten + 1) {
                    this.recordField.setText("" + n5);
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.elementNum = this.myCDFExport.orientation == 0 ? (n4 - 1) * this.totalElementsPerRec : n4 - 1;
                    this.recordField.setText("" + n4);
                    this.cleanTableObjects();
                    this.fillVarRecsToTable(this.elementNum);
                    this.displayTable(this.mainPanel);
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focusedObj = focusEvent.getSource();
        boolean bl = false;
        if (this.focusedObj == this.pageField) {
            this.pageField.setNextFocusableComponent(this.recordField);
        } else if (this.focusedObj == this.recordField) {
            this.recordField.setNextFocusableComponent(this.pageField);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isManagingFocus() {
        return true;
    }

    static /* synthetic */ String access$0() {
        return CANCEL;
    }

    static /* synthetic */ ExportVarDisplayTable[] access$2(ExportToText exportToText) {
        return exportToText.aToScreenTable;
    }

    static /* synthetic */ String access$12() {
        return ENTER;
    }

    static /* synthetic */ String access$19() {
        return BACK;
    }

    private final /* synthetic */ void this() {
        this.pagePanel = new JPanel();
        this.pageLabel = new JLabel("Page: ");
        this.recordLabel = new JLabel("Record: ");
        this.pageTotal = new JLabel();
        this.recordTotal = new JLabel();
        this.pageField = new JTextField(5);
        this.recordField = new JTextField(5);
        this.focusedObj = null;
        this.center = new JPanel(new BorderLayout(), true);
        this.scrollPane = null;
        this.aToScreenTable = null;
        this.columnNames = null;
        this.recordObject = null;
        this.aRecord = null;
        this.curCursor = Cursor.getPredefinedCursor(0);
        this.waitCursor = Cursor.getPredefinedCursor(3);
        this.minObj = null;
        this.maxObj = null;
        this.filObj = null;
        this.ss = Toolkit.getDefaultToolkit().getScreenSize();
    }

    private ExportToText(JFrame jFrame) {
        super((Frame)jFrame, defaultModal);
        this.this();
    }

    static {
        headcol1 = "Record #";
        headcol2 = "Indices";
        defaultModal = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PageRecListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            block14: {
                Object object = actionEvent.getSource();
                if (object.equals(ExportToText.this.pageField)) {
                    int n = ExportToText.this.elementNum / ExportToText.this.ROWS + 1;
                    try {
                        int n2 = Integer.parseInt(ExportToText.this.pageField.getText());
                        if (n2 < 1 || n2 > ExportToText.this.lastPageToDisplay + 1) {
                            ExportToText.this.pageField.setText("" + n);
                            Toolkit.getDefaultToolkit().beep();
                            break block14;
                        }
                        if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                            ExportToText.this.elementNum = (n2 - 1) * ExportToText.this.ROWS;
                        } else {
                            ExportToText.this.elementNum = n2 - 1;
                        }
                        ExportToText.this.cleanTableObjects();
                        ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                        ExportToText.this.displayTable(ExportToText.this.mainPanel);
                    }
                    catch (Exception exception) {
                        ExportToText.this.pageField.setText("" + n);
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (object.equals(ExportToText.this.recordField)) {
                    int n = ExportToText.this.elementNum / ExportToText.this.totalElementsPerRec + 1;
                    try {
                        int n3 = Integer.parseInt(ExportToText.this.recordField.getText());
                        if (n3 < 1 || n3 > ExportToText.this.totalWritten + 1) {
                            ExportToText.this.recordField.setText("" + n);
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                                ExportToText.this.elementNum = (n3 - 1) * ExportToText.this.totalElementsPerRec;
                            } else {
                                ExportToText.this.elementNum = n3 - 1;
                            }
                            ExportToText.this.cleanTableObjects();
                            ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                            ExportToText.this.displayTable(ExportToText.this.mainPanel);
                        }
                    }
                    catch (Exception exception) {
                        ExportToText.this.recordField.setText("" + n);
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        PageRecListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OutToFile
    extends Thread {
        public void run() {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                FileWriter fileWriter = new FileWriter(((ExportToText)ExportToText.this).myCDFExport.outfile);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter, 8192);
                Vector vector = ((ExportToText)ExportToText.this).myCDFExport.sourceCDF.getGlobalAttributes();
                if (((ExportToText)ExportToText.this).myCDFExport.headings == 1) {
                    int n6 = 0;
                    if (vector != null) {
                        n6 = vector.size();
                    }
                    n5 = n6;
                } else {
                    n5 = 0;
                }
                ExportToText.this.totalItems = (ExportToText.this.lastPageToDisplay + 1) * ExportToText.this.ROWS * ExportToText.this.groups * ExportToText.this.totalColumns + ExportToText.this.groups * ExportToText.this.totalColumns + n5;
                ExportToText.this.progressPanel = new BuildProgressPanel((Object)exportToText, ExportToText.this.totalItems);
                int n7 = 0;
                StringBuffer stringBuffer = new StringBuffer("");
                int n8 = 0;
                int n9 = 0;
                if (((ExportToText)ExportToText.this).myCDFExport.headings == 1) {
                    ExportToText.this.metaToFile(bufferedWriter);
                    if (ExportToText.this.vars.size() > 0) {
                        bufferedWriter.write("Variables:");
                        bufferedWriter.newLine();
                        bufferedWriter.newLine();
                        ExportToText.this.currentProgressValue = n5;
                        new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                    }
                    int n10 = 0;
                    while (n10 < ExportToText.this.groups) {
                        n4 = 0;
                        while (n4 < ExportToText.this.totalColumns) {
                            if (n10 <= 0 || n4 >= ExportToText.this.istart) {
                                if (((ExportToText)ExportToText.this).myCDFExport.orientation != 0 ? n8 == ExportToText.this.totalElements : ExportToText.this.columnNames[n10][n4].equals(null) || ExportToText.this.columnNames[n10][n4].trim().length() == 0) break;
                                if (ExportToText.this.columnNames[n10][n4].equals(headcol1)) {
                                    stringBuffer = CDFToolUtils.CatToString(stringBuffer, "Record", 6, 1, "*");
                                } else if (ExportToText.this.columnNames[n10][n4].equals(headcol2)) {
                                    stringBuffer = CDFToolUtils.CatToString(stringBuffer, "Indices", 11, 1, "*");
                                } else {
                                    if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                                        n3 = ExportToText.this.varWidth[n7++];
                                    } else {
                                        n2 = 0;
                                        n = 0;
                                        while (n < ExportToText.this.vars.size()) {
                                            if (n8 == ExportToText.this.varsHor[n]) {
                                                n2 = 1;
                                                break;
                                            }
                                            if (n8 < ExportToText.this.varsHor[n]) break;
                                            ++n;
                                        }
                                        ++n8;
                                        if (n2 != 0) {
                                            n9 = n3 = ExportToText.this.varWidth[n7++];
                                        } else {
                                            n3 = n9;
                                        }
                                    }
                                    stringBuffer = CDFToolUtils.CatToString(stringBuffer, ExportToText.this.columnNames[n10][n4], n3, 2, "*");
                                }
                                stringBuffer.append(" ");
                            }
                            ++n4;
                        }
                        ExportToText exportToText = ExportToText.this;
                        exportToText.currentProgressValue = exportToText.currentProgressValue + ExportToText.this.totalColumns;
                        ++n10;
                    }
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                    new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                }
                if (ExportToText.this.vars.size() > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    n2 = 0;
                    n = 0;
                    while (n <= ExportToText.this.lastPageToDisplay) {
                        ExportToText.this.progressPanel.getProgressLabel().setText("Load data! Please Wait...");
                        ExportToText.this.elementNum = n * ExportToText.this.ROWS;
                        ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                        ExportToText.this.progressPanel.getProgressLabel().setText("Output data! Please Wait...");
                        int n11 = 0;
                        while (n11 < ExportToText.this.ROWS) {
                            n7 = 0;
                            n8 = 0;
                            stringBuffer.setLength(0);
                            int n12 = 0;
                            while (n12 < ExportToText.this.groups) {
                                int n13 = 0;
                                while (n13 < ExportToText.this.totalColumns) {
                                    if (n12 == 0 || n13 >= ExportToText.this.istart) {
                                        if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0 ? ExportToText.this.columnNames[n12][n13].equals(null) || ExportToText.this.columnNames[n12][n13].trim().length() == 0 : n8 == ExportToText.this.totalElements) break;
                                        stringBuffer2.setLength(0);
                                        if (ExportToText.this.columnNames[n12][n13].equals(headcol1)) {
                                            stringBuffer2.append((String)ExportToText.this.recordObject[n12][n11][n13]);
                                            stringBuffer2 = CDFToolUtils.Justify(stringBuffer2, -6);
                                        } else if (ExportToText.this.columnNames[n12][n13].equals(headcol2)) {
                                            stringBuffer2.append((String)ExportToText.this.recordObject[n12][n11][n13]);
                                            stringBuffer2 = CDFToolUtils.Justify(stringBuffer2, -11);
                                        } else {
                                            int n14;
                                            n4 = 0;
                                            if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                                                n3 = ExportToText.this.varWidth[n7];
                                                if ((long)ExportToText.this.varDataType[n7] == 51L || (long)ExportToText.this.varDataType[n7] == 52L) {
                                                    n4 = 1;
                                                    n3 -= 2;
                                                }
                                                ++n7;
                                            } else {
                                                boolean bl = false;
                                                n14 = 0;
                                                while (n14 < ExportToText.this.vars.size()) {
                                                    if (n8 == ExportToText.this.varsHor[n14]) {
                                                        bl = true;
                                                        break;
                                                    }
                                                    if (n8 < ExportToText.this.varsHor[n14]) break;
                                                    ++n14;
                                                }
                                                ++n8;
                                                if (bl) {
                                                    n3 = ExportToText.this.varWidth[n7];
                                                    if ((long)ExportToText.this.varDataType[n7] == 51L || (long)ExportToText.this.varDataType[n7] == 52L) {
                                                        n4 = 1;
                                                        n3 -= 2;
                                                    }
                                                    n9 = n3;
                                                    n2 = n4;
                                                    ++n7;
                                                } else {
                                                    n3 = n9;
                                                }
                                                n4 = n2;
                                            }
                                            stringBuffer2 = CDFToolUtils.CatToString(stringBuffer2, ExportToText.this.recordObject[n12][n11][n13].toString(), n3, 2, "*");
                                            if (n4 != 0) {
                                                if (stringBuffer2 != null && stringBuffer2.toString().trim().length() != 0) {
                                                    if (stringBuffer2.toString().trim().length() == n3 || stringBuffer2.charAt(0) != ' ') {
                                                        stringBuffer2.insert(0, '\"');
                                                        stringBuffer2.append('\"');
                                                    } else {
                                                        String string = stringBuffer2.toString().trim();
                                                        n14 = stringBuffer2.toString().indexOf(string);
                                                        stringBuffer2.insert(n14, '\"');
                                                        stringBuffer2.insert(n14 + string.length() + 1, '\"');
                                                    }
                                                } else {
                                                    stringBuffer2.append("  ");
                                                }
                                            }
                                        }
                                        stringBuffer.append(stringBuffer2).append(" ");
                                    }
                                    ++n13;
                                }
                                ExportToText exportToText = ExportToText.this;
                                exportToText.currentProgressValue = exportToText.currentProgressValue + ExportToText.this.totalColumns;
                                ++n12;
                            }
                            if (stringBuffer.toString().trim().length() == 0) break;
                            bufferedWriter.write(stringBuffer.toString());
                            bufferedWriter.newLine();
                            if (ExportToText.this.lastPageToDisplay == 0) {
                                new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                            }
                            ++n11;
                        }
                        if (ExportToText.this.lastPageToDisplay != 0) {
                            new UpdateProgress(exportToText, ExportToText.this.currentProgressValue).start();
                        }
                        ExportToText.this.cleanTableObjects();
                        ++n;
                    }
                }
                bufferedWriter.close();
                ((ExportToText)ExportToText.this).myCDFExport.info.append("Done!");
                new CleanProgress().start();
            }
            catch (IOException iOException) {
                System.err.println("** error writing output to file");
            }
        }

        OutToFile() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                int n;
                String string = actionEvent.getActionCommand();
                if (string.equals(ExportToText.CANCEL)) {
                    exportToText.setVisible(false);
                    ExportToText.this.aToScreenTable = null;
                    ExportToText.this.center.removeAll();
                    if (ExportToText.this.jtp != null && ExportToText.this.jtp.getTabCount() > 0) {
                        int n2 = ExportToText.this.jtp.getTabCount() - 1;
                        while (n2 > -1) {
                            ExportToText.this.jtp.removeTabAt(n2);
                            ((ExportToText)ExportToText.this).scrollPane[n2] = null;
                            --n2;
                        }
                    }
                    ExportToText.this.scrollPane = null;
                    ExportToText.this.mainPanel.removeAll();
                    ExportToText.this.recordObject = null;
                    if (((ExportToText)ExportToText.this).myCDFExport.MacOS) {
                        System.gc();
                    }
                    ExportToText.this.myCDFExport.setVisible(true);
                } else if (string.equals(ExportToText.ENTER)) {
                    boolean bl = false;
                    if (((ExportToText)ExportToText.this).myCDFExport.orientation == 0) {
                        if (ExportToText.this.elementNum + ExportToText.this.ROWS < (ExportToText.this.totalWritten + 1) * ExportToText.this.totalElementsPerRec) {
                            bl = true;
                        }
                    } else if (ExportToText.this.elementNum + ExportToText.this.ROWS < ExportToText.this.totalWritten + 1) {
                        bl = true;
                    }
                    if (bl) {
                        ExportToText.this.cleanTableObjects();
                        ExportToText exportToText = ExportToText.this;
                        exportToText.elementNum = exportToText.elementNum + ExportToText.this.ROWS;
                        ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                        ExportToText.this.displayTable(ExportToText.this.mainPanel);
                    }
                } else if (string.equals(ExportToText.BACK) && ((n = ((ExportToText)ExportToText.this).myCDFExport.orientation == 0 ? ExportToText.this.elementNum / ExportToText.this.ROWS : ExportToText.this.elementNum) != 0 || ExportToText.this.elementNum != 0)) {
                    ExportToText.this.cleanTableObjects();
                    ExportToText exportToText = ExportToText.this;
                    exportToText.elementNum = exportToText.elementNum - ExportToText.this.ROWS;
                    if (ExportToText.this.elementNum < 0) {
                        ExportToText.this.elementNum = 0;
                    }
                    ExportToText.this.fillVarRecsToTable(ExportToText.this.elementNum);
                    ExportToText.this.displayTable(ExportToText.this.mainPanel);
                }
            }
        }

        SelectionListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CleanProgress
    extends Thread {
        public void run() {
            ExportToText.this.progressPanel.dispose();
            ExportToText.this.progressPanel = null;
            if (((ExportToText)ExportToText.this).myCDFExport.MacOS) {
                System.gc();
            }
        }

        CleanProgress() {
        }
    }
}

