/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EditvAttributeTableScrollPane
extends JScrollPane
implements TableModelListener,
CDFConstants {
    private static String[] headcol = new String[]{"Var Name", "Data Type", "Entry Data"};
    private static String na = "N/A";
    private Attribute attr;
    private EditvAttributeTableScrollPane aTableScrollPane;
    private MYEditor myEditor;
    private JLabeledDataTable myTable;
    private CDFEdit myCDFEdit;
    private CDF cdf;
    private Vector entries;
    private JTable table;
    private MyTableModel myModel;
    private Object[][] dataObject;

    public void buildTable(Attribute attribute) {
        this.attr = attribute;
        this.table = null;
        this.myModel = null;
        if (attribute != null) {
            this.buildDataTable();
        } else {
            this.aTableScrollPane.removeAll();
            this.aTableScrollPane.validate();
        }
        if (this.dataObject != null) {
            this.aTableScrollPane.setVisible(true);
            this.myModel = new MyTableModel();
            this.table = new JTable(this.myModel);
            this.table.setPreferredScrollableViewportSize(new Dimension(660, 500));
            this.table.setRowSelectionAllowed(false);
            this.table.setAutoResizeMode(4);
            TableColumn tableColumn = null;
            int n = 0;
            while (n < headcol.length) {
                tableColumn = this.table.getColumnModel().getColumn(n);
                tableColumn.setResizable(true);
                if (n == 0) {
                    tableColumn.setPreferredWidth(130);
                }
                if (n == 1) {
                    tableColumn.setPreferredWidth(120);
                }
                if (n == 2) {
                    tableColumn.setPreferredWidth(410);
                }
                ++n;
            }
            this.aTableScrollPane.setViewportView(this.table);
        } else {
            this.aTableScrollPane.removeAll();
            this.aTableScrollPane.revalidate();
        }
    }

    public void setTable(Object[][] objectArray) {
        this.dataObject = objectArray;
        this.myModel.fireTableDataChanged();
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setColumnNames(String[] stringArray) {
        headcol = stringArray;
    }

    public String[] getColumnNames() {
        return headcol;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("CDF_BYTE");
        jComboBox.addItem("CDF_INT1");
        jComboBox.addItem("CDF_UINT1");
        jComboBox.addItem("CDF_INT2");
        jComboBox.addItem("CDF_UINT2");
        jComboBox.addItem("CDF_INT4");
        jComboBox.addItem("CDF_UINT4");
        jComboBox.addItem("CDF_REAL4");
        jComboBox.addItem("CDF_FLOAT");
        jComboBox.addItem("CDF_REAL8");
        jComboBox.addItem("CDF_DOUBLE");
        jComboBox.addItem("CDF_EPOCH");
        jComboBox.addItem("CDF_EPOCH16");
        jComboBox.addItem("CDF_CHAR");
        jComboBox.addItem("CDF_UCHAR");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for valid data types");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Click the dataType to see a list of choices");
        }
    }

    private final void buildDataTable() {
        this.dataObject = null;
        int n = (int)this.cdf.getNumVars();
        if (n > 0) {
            int n2 = 0;
            Entry[] entryArray = new Entry[n];
            int n3 = 0;
            while (n3 < n) {
                try {
                    entryArray[n3] = this.attr.getEntry((long)n3);
                    ++n2;
                }
                catch (CDFException cDFException) {
                    entryArray[n3] = null;
                }
                ++n3;
            }
            if (n2 > 0) {
                this.dataObject = new Object[n2][headcol.length];
                Object object = null;
                int n4 = -1;
                int n5 = 0;
                while (n5 < n) {
                    if (entryArray[n5] != null) {
                        try {
                            StringBuffer stringBuffer;
                            String string = this.cdf.getVariable((long)n5).getName();
                            long l = entryArray[n5].getDataType();
                            object = entryArray[n5].getData();
                            long l2 = entryArray[n5].getNumElements();
                            this.dataObject[++n4][0] = string;
                            this.dataObject[n4][1] = CDFUtils.getStringDataType((long)l) + '/' + l2;
                            if (l == 31L) {
                                if (object.getClass().getName().indexOf(91) == 0) {
                                    stringBuffer = new StringBuffer();
                                    int n6 = 0;
                                    while (n6 < ((double[])object).length) {
                                        String string2 = Epoch.encode((double)((double[])object)[n6]);
                                        stringBuffer.append(string2).append(", ");
                                        ++n6;
                                    }
                                    stringBuffer.setLength(stringBuffer.length() - 2);
                                    this.dataObject[n4][2] = stringBuffer.toString();
                                } else {
                                    this.dataObject[n4][2] = Epoch.encode((double)((Double)object));
                                }
                            } else if (l == 32L) {
                                if (object.getClass().getName().indexOf(91) == 0) {
                                    stringBuffer = new StringBuffer();
                                    double[] dArray = new double[2];
                                    int n7 = 0;
                                    while (n7 < ((double[])object).length) {
                                        dArray[0] = ((double[])object)[n7];
                                        dArray[1] = ((double[])object)[n7 + 1];
                                        String string3 = Epoch16.encode((Object)dArray);
                                        stringBuffer.append(string3).append(", ");
                                        n7 += 2;
                                    }
                                    stringBuffer.setLength(stringBuffer.length() - 2);
                                    this.dataObject[n4][2] = stringBuffer.toString();
                                }
                            } else {
                                this.dataObject[n4][2] = CDFUtils.getStringData((Object)object, (String)", ");
                            }
                        }
                        catch (CDFException cDFException) {}
                    }
                    ++n5;
                }
            }
        }
    }

    public void reset() {
        this.dataObject = null;
        this.aTableScrollPane.setVisible(false);
    }

    private final /* synthetic */ void this() {
        this.dataObject = null;
    }

    EditvAttributeTableScrollPane(AttributePanel attributePanel) {
        super(20, 30);
        this.this();
        this.aTableScrollPane = this;
        this.myEditor = attributePanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.setVisible(false);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MyTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return headcol.length;
        }

        public int getRowCount() {
            if (EditvAttributeTableScrollPane.this.dataObject != null) {
                return EditvAttributeTableScrollPane.this.dataObject.length;
            }
            return 0;
        }

        public String getColumnName(int n) {
            return headcol[n];
        }

        public Object getValueAt(int n, int n2) {
            if (EditvAttributeTableScrollPane.this.dataObject != null) {
                return EditvAttributeTableScrollPane.this.dataObject[n][n2];
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Integer) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = new Integer((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only integer values.");
                }
            } else if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Float) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = new Float((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only float values.");
                }
            } else if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Byte) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = new Byte((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only yyte values.");
                }
            } else if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Long) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = new Long((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only long values.");
                }
            } else if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Short) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = new Short((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only short values.");
                }
            } else if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Double) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = new Double((String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only double values.");
                }
            } else if (EditvAttributeTableScrollPane.this.dataObject[0][n2] instanceof Boolean) {
                try {
                    if (n2 == 1) {
                        this.applyValue(object2, object, n, n2);
                    }
                    if (n2 == 2) {
                        object = this.checkValue(object, n);
                    }
                    ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = (Boolean)object;
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The \"" + this.getColumnName(n2) + "\" column accepts only boolean values.");
                }
            } else {
                if (n2 == 1) {
                    this.applyValue(object2, object, n, n2);
                }
                if (n2 == 2) {
                    object = this.checkValue(object, n);
                }
                ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        void applyValue(Object object, Object object2, int n, int n2) {
            if (!((String)object).equals((String)object2) && (((String)object2).equals("CDF_CHAR") || ((String)object2).equals("CDF_UCHAR"))) {
                JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The data type changed from " + object + " to " + object2 + ". Please change entry value accordingly.");
            }
        }

        void checkNumElem(Object object, int n) {
            String string = (String)this.getValueAt(n, 1);
            ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][2] = string.equals("CDF_CHAR") && string.equals("CDF_UCHAR") ? "" + ((String)object).length() : "1";
            this.fireTableCellUpdated(n, 2);
        }

        Object checkValue(Object object, int n) {
            String string = (String)this.getValueAt(n, 1);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (string.equals("CDF_BYTE") || string.equals("CDF_INT1")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Byte) {
                        return new Byte(numberFormat.parse(((Byte)object).toString()).byteValue());
                    }
                    return "" + numberFormat.parse((String)object).byteValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT1") || string.equals("CDF_INT2")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Short) {
                        return new Short(numberFormat.parse(((Short)object).toString()).shortValue());
                    }
                    return "" + numberFormat.parse((String)object).shortValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_UINT2") || string.equals("CDF_INT4")) {
                numberFormat.setParseIntegerOnly(true);
                try {
                    if (object instanceof Integer) {
                        return new Long(numberFormat.parse(((Integer)object).toString()).intValue());
                    }
                    return "" + numberFormat.parse((String)object).intValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_REAL4") || string.equals("CDF_FLOAT")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    if (object instanceof Float) {
                        return new Float(numberFormat.parse(((Float)object).toString()).floatValue());
                    }
                    return "" + numberFormat.parse((String)object).floatValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_REAL8") || string.equals("CDF_EPOCH")) {
                numberFormat.setParseIntegerOnly(false);
                try {
                    if (object instanceof Double) {
                        return new Double(numberFormat.parse(((Double)object).toString()).doubleValue());
                    }
                    return "" + numberFormat.parse((String)object).doubleValue();
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            if (string.equals("CDF_CHAR") || string.equals("CDF_UCHAR")) {
                return object;
            }
            return null;
        }

        MyTableModel() {
        }
    }
}

