/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class DeleteAttributeAction
extends AbstractAction
implements CDFConstants {
    private static final String DEFAULT_NAME = "Delete Attribute";
    private MYEditor myEditor;
    private AttributePanel attrPanel;
    private long scope;

    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        Attribute attribute = this.attrPanel.getSelectedAttr();
        long l = this.attrPanel.getScope();
        if (attribute == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, "No attribute selected", "MYEditor: Error", 0);
        } else {
            char c = l == 1L ? (char)'g' : 'v';
            int n = JOptionPane.showConfirmDialog(this.myEditor, "Do you want to delete " + c + "Attribute: " + attribute.toString(), "Delete " + c + "Attribute", 0);
            if (n == 0) {
                this.myEditor.setWaitCursor();
                try {
                    this.attrPanel.deleteSelectedAttr();
                    this.attrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    if (l == (long)2) {
                        this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                        this.myEditor.gAttrPanel.getRightPanel().revalidate();
                        this.myEditor.gAttrPanel.getRightPanel().repaint();
                    } else {
                        this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                        this.myEditor.vAttrPanel.getRightPanel().revalidate();
                        this.myEditor.vAttrPanel.getRightPanel().repaint();
                    }
                    this.attrPanel.updateAttrPanel(null, true);
                    this.attrPanel.removeFromListOfAttributes(attribute);
                    if (l == (long)2 && this.myEditor.variablePanel.getSelectedVar() != null) {
                        this.myEditor.variablePanel.updateVarPanel(this.myEditor.variablePanel.getSelectedVar());
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor, "CDF Error:\n" + CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: CDFException", 0);
                }
            }
        }
        this.myEditor.setDefaultCursor();
    }

    public DeleteAttributeAction(AttributePanel attributePanel, char c) {
        this(attributePanel, "Delete " + c + "Attribute");
    }

    public DeleteAttributeAction(AttributePanel attributePanel, String string) {
        super(string);
        this.attrPanel = attributePanel;
        this.myEditor = attributePanel.getMyEditor();
    }
}

