;------------------------------------------------------------------------------
;
;  NSSDC/CDF				      IDL/CDF Interface, parseEPOCH2.
;
;  Version 1.0, 9-Sep-96, Hughes STX.
;
;  Modification history:
;
;   V1.0   9-Sep-96, J Love	Original version.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; parseEPOCH2.
;------------------------------------------------------------------------------

;+
; NAME:
;       parseEPOCH2
;
; PURPOSE:
;       `parseEPOCH2' is used to parse a CDF_EPOCH value from the alternate/2
;       EPOCH character string.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       epoch = parseEPOCH2 (epString)
;
; INPUTS:
;       epString:       STRING.  The alternate/2 EPOCH character string.  The
;                       syntax of this string is `yyyymoddhhmmss' where `yyyy'
;                       is the year, `mo' is the month (1-12), `dd' is the day
;                       of the month (1-31), `hh' is the hour (0-23), `mm' is
;                       the minute (0-59), and `ss' is the second (0-59).
;
;       All input variables must have been created/initialized before calling
;       `parseEPOCH2'.
;
; OUTPUTS:
;       epoch:          DOUBLE (double precision floating-point).  The
;                       parsed CDF_EPOCH value.
;
;       All output variables are (re)created/assigned by `parseEPOCH2'.
;
; EXAMPLE:
;       IDL> epString = '19960909120000'
;       IDL> epoch = parseEPOCH2 (epString)
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;        9-Sep-96       Original version.
;-

function parseEPOCH2, epString
on_error, 1
idl_parsepoch2, epString, epoch
return, epoch
end
