;------------------------------------------------------------------------------
;
;  NSSDC/CDF				      IDL/CDF Interface, CDFvarRename.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarRename.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarRename
;
; PURPOSE:
;       `CDFvarRename' is used to rename an existing rVariable.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarRename (id, varNum, varName)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varNum:         LONG.  The number of the rVariable.
;       varName:        STRING.  The new rVariable name.
;
;       All input variables must have been created/initialized before calling
;       `CDFvarRename'.
;
; OUTPUTS:
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarRename'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFvarRename (id, CDFvarNum(id,'EPOCH'), 'Time')
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarRename failed.'
;
; RESTRICTIONS:
;       The new rVariable name must not already be in use in the CDF.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarRename, CDF_id,var_num,var_mnemonic
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfvarren, cdfid_, cdfstatus_, status, CDF_id, var_num, var_mnemonic
return, status
end
