;------------------------------------------------------------------------------
;
;  NSSDC/CDF		   Quick-Start Test for IDL I/F (Standard Interface).
;
;  Version 1.2, 9-Sep-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  31-Oct-94, J Love	Original version.
;   V1.1  23-Feb-95, J Love	Modifications to `BadStatus'.
;   V1.1a 26-Jun-95, J Love	IDL 4.0.
;   V1.2   9-Sep-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; BadStatus.
;------------------------------------------------------------------------------

function BadStatus, status, id, where
@cdf0x.pro
  if (status lt CDFic.CDF_OK) then begin
    text = '<none>'
    status_ = CDFerror (status, text)
    if (status_ eq CDFic.CDF_OK) then begin
      print, text, ' (', where, ')'
    endif else begin
      print, 'status: ', status_, ' (', where, ')'
    endelse
    if (id ne 0) then status_ = CDFclose (id)
  endif
  if (status lt CDFx.CDF_WARN) then return, 1
  return, 0
end

;------------------------------------------------------------------------------
; qstsi.
;------------------------------------------------------------------------------

pro qstsi
@cdf0x.pro

  ;----------------------------------------------------------------------------
  ; Open CDF and delete if successful.
  ;----------------------------------------------------------------------------

  cdfname = 'temp1'

  status = CDFopen (cdfname, id)
  case status of
    CDFic.CDF_OK: begin
      status = CDFdelete (id)
      if (BadStatus(status,0,'1')) then return
      end
    CDFec.NO_SUCH_CDF: begin
      end
    else: begin
      if (BadStatus(status,0,'2')) then return
      end
  endcase

  ;----------------------------------------------------------------------------
  ; Create CDF (or recreate if it existed and was deleted).
  ;----------------------------------------------------------------------------

  rnumdims = 0l
  rdimsizes = lonarr(CDFx.CDF_MAX_DIMS)
  encoding = CDFen.MAC_ENCODING
  majority = CDFx.COLUMN_MAJOR

  status = CDFcreate (cdfname, rnumdims, rdimsizes, encoding, majority, id)
  if (BadStatus(status,0,'3')) then return

  ;----------------------------------------------------------------------------
  ; Create variable.
  ;----------------------------------------------------------------------------

  rvarname = "rVar1"
  rdatatype = CDFdt.CDF_REAL4
  rnumelems = 1l
  rrecvary = CDFx.VARY
  rdimvarys = lonarr(CDFx.CDF_MAX_DIMS)
  rdimvarys(0) = CDFx.VARY
  rdimvarys(1) = CDFx.VARY

  status = CDFvarCreate (id, rvarname, rdatatype, rnumelems, rrecvary, $
			 rdimvarys, varnum)
  if (BadStatus(status,id,'4')) then return

  ;----------------------------------------------------------------------------
  ; Write to variables.
  ;----------------------------------------------------------------------------

  rrecnumber = 4l
  rindices = lonarr(CDFx.CDF_MAX_DIMS)
  rvarvalue = 4.4

  status = CDFvarPut (id, varnum, rrecnumber, rindices, rvarvalue)
  if (BadStatus(status,id,'5')) then return

  rrecnumber = 9l
  rreccount = 3l
  rrecinterval = 2l
  rindices = lonarr(CDFx.CDF_MAX_DIMS)
  rcounts = lonarr(CDFx.CDF_MAX_DIMS)
  rintervals = lonarr(CDFx.CDF_MAX_DIMS)
  rvarvalues = fltarr(3)
  rvarvalues(0) = 9.9
  rvarvalues(1) = 11.11
  rvarvalues(2) = 13.13

  status = CDFvarHyperPut (id, varnum, rrecnumber, rreccount, rrecinterval, $
			   rindices, rcounts, rintervals, rvarvalues)
  if (BadStatus(status,id,'6')) then return

  ;----------------------------------------------------------------------------
  ; Create attributes/entries.
  ;----------------------------------------------------------------------------

  vattrname = "vAttr1"
  vattrscope = CDFx.VARIABLE_SCOPE

  status = CDFattrCreate (id, vattrname, vattrscope, attrnum)
  if (BadStatus(status,id,'7')) then return

  vdatatype = CDFdt.CDF_CHAR
  vnumelems = 10
  entryvalue = '1234567890'

  status = CDFattrPut (id, attrnum, varnum, vdatatype, vnumelems, entryvalue)
  if (BadStatus(status,id,'8')) then return

  ;----------------------------------------------------------------------------
  ; Close CDF.
  ;----------------------------------------------------------------------------

  status = CDFclose (id)
  if (BadStatus(status,0,'9')) then return

  ;----------------------------------------------------------------------------
  ; Reopen CDF.
  ;----------------------------------------------------------------------------

  status = CDFopen (cdfname, id)
  if (BadStatus(status,0,'10')) then return

  ;----------------------------------------------------------------------------
  ; Inquire CDF.
  ;----------------------------------------------------------------------------

  status = CDFinquire (id, rnumdimsOut, rdimsizesOut, encodingOut, $
		       majorityOut, rmaxrec, numvars, numattrs)
  if (BadStatus(status,0,'11')) then return

  if (rnumdimsOut ne rnumdims) then begin
    print, "Verification error <1.1>."
    return
  endif
  if (numattrs ne 1) then begin
    print, "Verification error <1.2>."
    return
  endif
  if (numvars ne 1) then begin
    print, "Verification error <1.3>."
    return
  endif
  if (rmaxrec ne 13) then begin
    print, "Verification error <1.4>."
    return
  endif
  if (encodingOut ne encoding) then begin
    print, "Verification error <1.5>."
    return
  endif
  if (majorityOut ne majority) then begin
    print, "Verification error <1.6>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Get variable/attribute numbers.
  ;----------------------------------------------------------------------------

  varnum = CDFvarNum (id, rvarname)
  attrnum = CDFattrNum (id, vattrname)

  ;----------------------------------------------------------------------------
  ; Rename variable/attribute.
  ;----------------------------------------------------------------------------

  rvarnameNew = 'rVar1a'
  status = CDFvarRename (id, varnum, rvarnameNew)
  if (BadStatus(status,id,'11.1')) then return

  vattrnameNew = 'vAttr1a'
  status = CDFattrRename (id, attrnum, vattrnameNew)
  if (BadStatus(status,id,'11.2')) then return

  ;----------------------------------------------------------------------------
  ; Read variable values.
  ;----------------------------------------------------------------------------

  rrecnumber = 4l
  rindices = lonarr(CDFx.CDF_MAX_DIMS)

  status = CDFvarGet (id, varnum, rrecnumber, rindices, rvarvalueOut)
  if (BadStatus(status,id,'12')) then return
  if (rvarvalue ne rvarvalueOut) then begin
    print, "Verification error <2>."
    return
  endif

  rrecnumber = 9l
  rreccount = 3l
  rrecinterval = 2l
  rindices = lonarr(CDFx.CDF_MAX_DIMS)
  rcounts = lonarr(CDFx.CDF_MAX_DIMS)
  rintervals = lonarr(CDFx.CDF_MAX_DIMS)

  status = CDFvarHyperGet (id, varnum, rrecnumber, rreccount, rrecinterval, $
			   rindices, rcounts, rintervals, rvarvaluesOut)
  if (BadStatus(status,id,'13')) then return
  if (rvarvalues(0) ne rvarvaluesOut(0) or $
      rvarvalues(1) ne rvarvaluesOut(1) or $
      rvarvalues(2) ne rvarvaluesOut(2)) then begin
    print, "Verification error <3>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Read attribute entry.
  ;----------------------------------------------------------------------------

  status = CDFattrGet (id, attrnum, varnum, entryvalueOut)
  if (BadStatus(status,id,'13.1')) then return
  if (entryvalueOut ne entryvalue) then begin
    print, "Verification error <4>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Inquire variable.
  ;----------------------------------------------------------------------------

  status = CDFvarInquire (id, varnum, varnameOut, dataTypeOut, numElemsOut, $
			  recVaryOut, dimVarysOut)
  if (BadStatus(status,0,'14')) then return
  if (varnameOut ne rvarnameNew) then begin
    print, "Verification error <5.1>."
    return
  endif
  if (dataTypeOut ne rdatatype) then begin
    print, "Verification error <5.2>."
    return
  endif
  if (numElemsOut ne rnumelems) then begin
    print, "Verification error <5.3>."
    return
  endif
  if (recVaryOut ne rrecvary) then begin
    print, "Verification error <5.4>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Inquire attribute/entry.
  ;----------------------------------------------------------------------------

  status = CDFattrInquire (id, attrnum, attrnameOut, scopeOut, maxEntryOut)
  if (BadStatus(status,0,'15')) then return
  if (attrnameOut ne vattrNameNew) then begin
    print, "Verification error <6.1>."
    return
  endif
  if (scopeOut ne vattrscope) then begin
    print, "Verification error <6.2>."
    return
  endif
  if (maxEntryOut ne varnum) then begin
    print, "Verification error <6.2>."
    return
  endif

  status = CDFattrEntryInquire (id, attrnum, varnum, dataTypeOut, numElemsOut)
  if (BadStatus(status,0,'16')) then return
  if (dataTypeOut ne vdatatype) then begin
    print, "Verification error <7.1>."
    return
  endif
  if (numElemsOut ne vnumelems) then begin
    print, "Verification error <7.2>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Close CDF.
  ;----------------------------------------------------------------------------

  status = CDFclose (id)
  if (BadStatus(status,0,'17')) then return

  ;----------------------------------------------------------------------------
  ; Inquire status code explanation.
  ;----------------------------------------------------------------------------

  status = CDFerror (CDFic.CDF_OK, text)
  if (BadStatus(status,0,'18')) then return

  ;----------------------------------------------------------------------------
  ; Display `success' message and exit.
  ;----------------------------------------------------------------------------

  print, "Test successful."
  return
end
