;------------------------------------------------------------------------------
;
;  NSSDC/CDF		   Quick-Start Test for IDL I/F (Internal Interface).
;
;  Version 1.3a, 21-Feb-97, Hughes STX.
;
;  Modification history:
;
;   V1.0  14-Dec-93, J Love	Original version.
;   V1.0a 22-Feb-94, J Love	Spelling lesson.
;   V1.1  31-Oct-94, J Love	CDF V2.5.
;   V1.2  23-Feb-94, J Love	Use `cdf0'.  Modifications to `BadStatus'.
;   V1.2a 26-Jun-95, J Love	IDL 4.0.
;   V1.3   9-Sep-96, J Love	CDF V2.6.
;   V1.3a 21-Feb-97, J Love	Removed RICE.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; BadStatus.
;------------------------------------------------------------------------------

function BadStatus, status, id, where
@cdf0x.pro
  if (status ne CDFx.CDF_OK) then begin
    text = '<none>'
    status_ = CDFlib (CDFiif.SELECT_, CDFiix.CDF_STATUS_, status, $
		      CDFiif.GET_, CDFiix.STATUS_TEXT_, text, $
		      CDFiif.NULL_)
    if (status_ eq CDFx.CDF_OK) then begin
      print, text, ' (', where, ')'
    endif else begin
      print, 'status: ', status, ' text: ', text, ' (', where, ')'
    endelse
    if (id ne 0) then status_ = CDFlib (CDFiif.SELECT_, CDFiix.CDF_, id,$
				        CDFiif.CLOSE_, CDFiix.CDF_, $
				        CDFiif.NULL_)
  endif
  if (status lt CDFx.CDF_WARN) then return, 1
  return, 0
end

;------------------------------------------------------------------------------
; qstii.
;------------------------------------------------------------------------------

pro qstii
@cdf0x.pro

  ;----------------------------------------------------------------------------
  ; Open CDF and delete if successful.
  ;----------------------------------------------------------------------------

  cdfname = 'temp1'

  status = CDFlib (CDFiif.OPEN_, CDFiix.CDF_, cdfname, id, $
		   CDFiif.DELETE_, CDFiix.CDF_, $
		   CDFiif.NULL_)
  if (status ne CDFec.NO_SUCH_CDF and status ne CDFx.CDF_OK) then begin
    if (BadStatus(status,0,'1')) then return
  endif

  ;----------------------------------------------------------------------------
  ; Create CDF (or recreate if it existed and was deleted).
  ;----------------------------------------------------------------------------

  rnumdims = 2L
  rdimsizes = lonarr(CDFx.CDF_MAX_DIMS)
  rdimsizes(0) = 2L
  rdimsizes(1) = 4L

  status = CDFlib (CDFiif.CREATE_, CDFiix.CDF_, cdfname, rnumdims, $
						rdimsizes, id, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'2')) then return

  format = CDFx.SINGLE_FILE
  majority = CDFx.COLUMN_MAJOR
  encoding = CDFen.NETWORK_ENCODING

  status = CDFlib (CDFiif.SELECT_, CDFiix.CDF_, id, $
		   CDFiif.PUT_, CDFiix.CDF_FORMAT_, format, $
				CDFiix.CDF_MAJORITY_, majority, $
				CDFiix.CDF_ENCODING_, encoding, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'3')) then return

  ;----------------------------------------------------------------------------
  ; Create variables.
  ;----------------------------------------------------------------------------

  rvarname = "rVarA"
  rdatatype = CDFdt.CDF_REAL4
  rnumelems = 1L
  rrecvary = CDFx.VARY
  rdimvarys = lonarr(CDFx.CDF_MAX_DIMS)
  rdimvarys(0) = CDFx.VARY
  rdimvarys(1) = CDFx.VARY
  rpadvalue = -9.99
  rinitialrecs = 30L
  rblockingfactor = 10L
  rctype = CDFx.GZIP_COMPRESSION
  rcparms = lonarr(CDFx.CDF_MAX_PARMS)
  rcparms(0) = 9L
  rreserve = 105L

  zvarname = "zVarA"
  zdatatype = CDFdt.CDF_INT4
  znumelems = 1L
  znumdims = 1L
  zdimsizes = lonarr(CDFx.CDF_MAX_DIMS)
  zdimsizes(0) = 5L
  zrecvary = CDFx.VARY
  zdimvarys = lonarr(CDFx.CDF_MAX_DIMS)
  zdimvarys(0) = CDFx.VARY
  zpadvalue = -999L
  zinitialrecs = 5L
  zblockingfactor = 3L
  zstype = CDFx.NO_SPARSEARRAYS
  zsparms = lonarr(CDFx.CDF_MAX_PARMS)

  status = CDFlib (CDFiif.CREATE_, CDFiir.rVAR_, rvarname, rdatatype, $
						 rnumelems, rrecvary, $
						 rdimvarys, rvarnumOut, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'4.1a')) then return

  status = CDFlib (CDFiif.PUT_, CDFiir.rVAR_PADVALUE_, rpadvalue, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'4.1b-1')) then return

  status = CDFlib (CDFiif.PUT_, CDFiir.rVAR_BLOCKINGFACTOR_, $
				  rblockingfactor, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'4.1b-2')) then return

  status = CDFlib (CDFiif.PUT_, CDFiir.rVAR_COMPRESSION_, rctype, rcparms, $
		   CDFiif.SELECT_, CDFiir.rVAR_RESERVEPERCENT_, rreserve, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'4.1b-3')) then return

  status = CDFlib (CDFiif.PUT_, CDFiir.rVAR_INITIALRECS_, rinitialrecs, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'4.1b-4')) then return

  status = CDFlib (CDFiif.CREATE_, CDFiiz.zVAR_, zvarname, zdatatype, $
						 znumelems, znumdims, $
						 zdimsizes, zrecvary, $
						 zdimvarys, zvarnumOut, $
		   CDFiif.PUT_, CDFiiz.zVAR_PADVALUE_, zpadvalue, $
				  CDFiiz.zVAR_SPARSERECORDS_, $
				     CDFx.PAD_SPARSERECORDS, $
				  CDFiiz.zVAR_SPARSEARRAYS_, zstype, zsparms, $
				  CDFiiz.zVAR_BLOCKINGFACTOR_, $
							zblockingfactor, $
				  CDFiiz.zVAR_ALLOCATEBLOCK_, 0L, $
							zinitialrecs - 1, $
				  CDFiiz.zVAR_INITIALRECS_, zinitialrecs, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'4.2')) then return

  ;----------------------------------------------------------------------------
  ; Write to variables.
  ;----------------------------------------------------------------------------

  rrecnumber = 9L
  rindices = lonarr(CDFx.CDF_MAX_DIMS)
  rindices(0) = 1L
  rindices(1) = 1L
  zrecnumber = 9L
  zindices = lonarr(CDFx.CDF_MAX_DIMS)
  zindices(0) = 1L
  rvarvalue = 10.22
  zvarvalue = 12345L

  status = CDFlib (CDFiif.SELECT_, CDFiir.rVAR_NAME_, rvarname, $
				   CDFiir.rVARs_RECNUMBER_, rrecnumber, $
				   CDFiir.rVARs_DIMINDICES_, rindices, $
		   CDFiif.PUT_, CDFiir.rVAR_DATA_, rvarvalue, $
		   CDFiif.SELECT_, CDFiiz.zVAR_RECNUMBER_, zrecnumber, $
				   CDFiiz.zVAR_DIMINDICES_, zindices, $
		   CDFiif.PUT_, CDFiiz.zVAR_DATA_, zvarvalue, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'5')) then return

  rrecnumber = 19L
  rreccount = 3L
  rrecinterval = 1L
  rindices(0) = 0L
  rindices(1) = 0L
  rcounts = lonarr(CDFx.CDF_MAX_DIMS)
  rcounts(0) = 2L
  rcounts(1) = 4L
  rintervals = lonarr(CDFx.CDF_MAX_DIMS)
  rintervals(0) = 1L
  rintervals(1) = 1L

  rbuffer = fltarr(2,4,3)
  for recnum = 0, 2 do begin
     for x1 = 0, 3 do begin
	for x0 = 0, 1 do begin
	   rbuffer(x0,x1,recnum) = 20.0 + recnum + $
				   (0.1 * (x0 + 1)) + (0.01 * (x1 + 1))
	endfor
     endfor
  endfor

  status = CDFlib (CDFiif.SELECT_, CDFiir.rVAR_, rvarnumOut, $
				   CDFiir.rVARs_RECNUMBER_, rrecnumber, $
				   CDFiir.rVARs_RECCOUNT_, rreccount, $
				   CDFiir.rVARs_RECINTERVAL_, rrecinterval, $
				   CDFiir.rVARs_DIMINDICES_, rindices, $
				   CDFiir.rVARs_DIMCOUNTS_, rcounts, $
				   CDFiir.rVARs_DIMINTERVALS_, rintervals, $
		   CDFiif.PUT_, CDFiir.rVAR_HYPERDATA_, rbuffer, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'6')) then return

  zrecnumber = 19L
  zindices(0) = 0L

  status = CDFlib (CDFiif.SELECT_, CDFiiz.zVAR_, zvarnumOut, $
				   CDFiiz.zVAR_SEQPOS_, zrecnumber, $
							zindices, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'7')) then return

  for i = 1L, 15L do begin
    status = CDFlib (CDFiif.PUT_, CDFiiz.zVAR_SEQDATA_, i, $
		     CDFiif.NULL_)
    if (BadStatus(status,id,'8')) then return
  endfor

  ;----------------------------------------------------------------------------
  ; Create attributes/entries.
  ;----------------------------------------------------------------------------

  gattrname = "gAttrA"
  gattrscope = CDFx.GLOBAL_SCOPE

  gdatatype0 = CDFdt.CDF_CHAR
  gnumelems0 = 20L
  gentryvalue0 = '12345678901234567890'

  gdatatype1 = CDFdt.CDF_EPOCH
  gnumelems1 = 1L
  gentryvalue1 = 6.0D13

  gdatatype2 = CDFdt.CDF_BYTE
  gnumelems2 = 3L
  gentryvalue2 = bytarr(3)
  gentryvalue2(0) = 1
  gentryvalue2(1) = 2
  gentryvalue2(2) = 3

  status = CDFlib (CDFiif.CREATE_, CDFiia.ATTR_, gattrname, $
						 gattrscope, $
						 gattrnumOut, $
		   CDFiif.SELECT_, CDFiie.gENTRY_, 0l, $
		   CDFiif.PUT_, CDFiie.gENTRY_DATA_, gdatatype0, $
						     gnumelems0, $
						     gentryvalue0, $
		   CDFiif.SELECT_, CDFiie.gENTRY_, 1l, $
		   CDFiif.PUT_, CDFiie.gENTRY_DATA_, gdatatype1, $
						     gnumelems1, $
						     gentryvalue1, $
		   CDFiif.SELECT_, CDFiie.gENTRY_, 2l, $
		   CDFiif.PUT_, CDFiie.gENTRY_DATA_, gdatatype2, $
						     gnumelems2, $
						     gentryvalue2, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'9')) then return

  vattrname = "vAttrA"
  vattrscope = CDFx.VARIABLE_SCOPE

  rdatatype0 = CDFdt.CDF_DOUBLE
  rnumelems0 = 1L
  rentryvalue0 = 1.2D3

  zdatatype0 = CDFdt.CDF_INT2
  znumelems0 = 1L
  zentryvalue0 = 789

  status = CDFlib (CDFiif.CREATE_, CDFiia.ATTR_, vattrname, $
						 vattrscope, $
						 vattrnumOut, $
		   CDFiif.SELECT_, CDFiie.rENTRY_, 0l, $
		   CDFiif.PUT_, CDFiie.rENTRY_DATA_, rdatatype0, $
						     rnumelems0, $
						     rentryvalue0, $
		   CDFiif.SELECT_, CDFiie.zENTRY_, 0l, $
		   CDFiif.PUT_, CDFiie.zENTRY_DATA_, zdatatype0, $
						     znumelems0, $
						     zentryvalue0, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'10')) then return

  ;----------------------------------------------------------------------------
  ; Close CDF/variables.
  ;----------------------------------------------------------------------------

  status = CDFlib (CDFiif.CLOSE_, CDFiix.CDF_, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'11')) then return

  ;----------------------------------------------------------------------------
  ; Reopen CDF.
  ;----------------------------------------------------------------------------

  status = CDFlib (CDFiif.OPEN_, CDFiix.CDF_, cdfname, id, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'12')) then return

  ;----------------------------------------------------------------------------
  ; Inquire CDF.
  ;----------------------------------------------------------------------------

  status = CDFlib (CDFiif.GET_, CDFiir.rVARs_NUMDIMS_, rnumdimsOut, $
				CDFiir.rVARs_DIMSIZES_, rdimsizesOut, $
				CDFiix.CDF_NUMATTRS_, numattrsOut, $
		   CDFiif.SELECT_, CDFiiz.zVAR_NAME_, zvarname, $
		   CDFiif.GET_, CDFiiz.zVAR_DATATYPE_, zdatatypeOut, $
				  CDFiiz.zVAR_PADVALUE_, zpadvalueOut, $
				  CDFiiz.zVAR_COMPRESSION_, zctypeOut, $
							    zcparmsOut, $
							    zcpctOut, $
				  CDFiiz.zVAR_SPARSERECORDS_, zsparseOut, $
				  CDFiiz.zVAR_SPARSEARRAYS_, zstypeOut, $
							     zsparmsOut, $
							     zspctOut, $
				  CDFiiz.zVAR_NUMRECS_, znumrecsOut, $
				  CDFiiz.zVAR_NUMallocRECS_, znumallocrecsOut,$
		   CDFiif.CONFIRM_, CDFiir.rVAR_EXISTENCE_, rvarname, $
		   CDFiif.SELECT_, CDFiia.ATTR_NAME_, gattrname, $
				   CDFiie.gENTRY_, 0l, $
		   CDFiif.GET_, CDFiie.gENTRY_DATA_, gentryvalue0Out, $
		   CDFiif.SELECT_, CDFiir.rVAR_NAME_, rvarname, $
		   CDFiif.CONFIRM_, CDFiir.rVAR_RESERVEPERCENT_, rreserveOut, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'13')) then return

  if ((rnumdimsOut ne rnumdims) or $
      (rdimsizesOut(0) ne rdimsizesOut(0)) or $
      (rdimsizesOut(1) ne rdimsizesOut(1)) or $
      (numattrsOut ne 2) or $
      (zdatatypeOut ne zdatatype) or $
      (zpadvalueOut ne zpadvalue) or $
      (zctypeOut ne CDFx.NO_COMPRESSION) or $
      (zsparseOut ne CDFx.PAD_SPARSERECORDS) or $
      (zstypeOut ne CDFx.NO_SPARSEARRAYS) or $
      (znumrecsOut ne 9L) or $
      (znumallocrecsOut ne 9L) or $
      (gentryvalue0Out ne gentryvalue0) or $
      (rreserveOut ne 0L)) then begin
    print, "Verification error <1>."
    return
  endif

  status = CDFlib (CDFiif.SELECT_, CDFiiz.zVAR_NAME_, zvarname, $
		   CDFiif.GET_, CDFiiz.zVAR_nINDEXRECORDS_, nXrecords, $
				  CDFiiz.zVAR_nINDEXENTRIES_, nXentries, $
				  CDFiiz.zVAR_nINDEXLEVELS_, nXlevels, $
				  CDFiiz.zVAR_ALLOCATEDFROM_, 15L, fromOut, $
				  CDFiiz.zVAR_ALLOCATEDTO_, 19L, toOut, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'13a')) then return

  if ((fromOut ne 19L) or $
      (toOut ne 21L)) then begin
    print, "Verification error <1a>."
    return
  endif

  status = CDFlib (CDFiif.SELECT_, CDFiia.ATTR_, vattrnumOut, $
		   CDFiif.GET_, CDFiia.ATTR_NAME_, vattrnameOut, $
				CDFiia.ATTR_MAXrENTRY_, vattrmaxrentry,$
				CDFiia.ATTR_NUMrENTRIES_, vattrnumrentries, $
				CDFiia.ATTR_MAXzENTRY_, vattrmaxzentry,$
				CDFiia.ATTR_NUMzENTRIES_, vattrnumzentries, $
		   CDFiif.SELECT_, CDFiie.rENTRY_, 0l, $
		   CDFiif.GET_, CDFiie.rENTRY_DATATYPE_, rentrydatatype0Out, $
				CDFiie.rENTRY_NUMELEMS_, rentrynumelems0Out, $
				  CDFiie.rENTRY_DATA_, rentryvalue0Out, $
		   CDFiif.SELECT_, CDFiie.zENTRY_, 0l, $
		   CDFiif.GET_, CDFiie.zENTRY_DATATYPE_, zentrydatatype0Out, $
				CDFiie.zENTRY_NUMELEMS_, zentrynumelems0Out, $
				CDFiie.zENTRY_DATA_, zentryvalue0Out, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'14')) then return

  ;----------------------------------------------------------------------------
  ; Read variable value.
  ;----------------------------------------------------------------------------

  zrecnumber = 19L
  zreccount = 2L
  zrecinterval = 2L
  zindices(0) = 0L
  zcounts = lonarr(CDFx.CDF_MAX_DIMS)
  zcounts(0) = 5L
  zintervals = lonarr(CDFx.CDF_MAX_DIMS)
  zintervals(0) = 1L

  status = CDFlib (CDFiif.SELECT_, CDFiiz.zVAR_RECNUMBER_, zrecnumber, $
				   CDFiiz.zVAR_RECCOUNT_, zreccount, $
				   CDFiiz.zVAR_RECINTERVAL_, zrecinterval, $
				   CDFiiz.zVAR_DIMINDICES_, zindices, $
				   CDFiiz.zVAR_DIMCOUNTS_, zcounts, $
				   CDFiiz.zVAR_DIMINTERVALS_, zintervals, $
		   CDFiif.GET_, CDFiiz.zVAR_HYPERDATA_, zbufferOut, $
		   CDFiif.NULL_)
  if (BadStatus(status,id,'15')) then return

  if (zbufferout(0,0) ne 1 or zbufferout(4,1) ne 15) then begin
    print, "Verification error <2>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Close CDF.
  ;----------------------------------------------------------------------------

  status = CDFlib (CDFiif.CLOSE_, CDFiix.CDF_, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'16')) then return

  ;----------------------------------------------------------------------------
  ; Reopen CDF in readonlyMode and zMode.
  ;----------------------------------------------------------------------------

  readonlymode = CDFx.READONLYon
  zmode = CDFx.zMODEon1

  status = CDFlib (CDFiif.OPEN_, CDFiix.CDF_, cdfname, id, $
		   CDFiif.SELECT_, CDFiix.CDF_READONLY_MODE_, readonlymode, $
				   CDFiix.CDF_zMODE_, zmode, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'17')) then return

  ;----------------------------------------------------------------------------
  ; Inquire CDF.
  ;----------------------------------------------------------------------------

  status = CDFlib (CDFiif.CONFIRM_, CDFiix.CDF_READONLY_MODE_, $
							readonlymodeOut, $
				    CDFiix.CDF_zMODE_, zmodeOut, $
				    CDFiix.CDF_NAME_, cdfnameOut, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'18')) then return

  if ((readonlymodeOut ne readonlymode) or $
      (zmodeOut ne zmode)) then begin
    print, "Verification error <3>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Close CDF.
  ;----------------------------------------------------------------------------

  status = CDFlib (CDFiif.CLOSE_, CDFiix.CDF_, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'19')) then return

  ;----------------------------------------------------------------------------
  ; Open/compress/close CDF.
  ;----------------------------------------------------------------------------

  aHuffParms = lonarr(CDFx.CDF_MAX_PARMS)
  aHuffParms(0) = CDFx.OPTIMAL_ENCODING_TREES
  status = CDFlib (CDFiif.OPEN_, CDFiix.CDF_, cdfname, id, $
		   CDFiif.PUT_, CDFiix.CDF_COMPRESSION_, $
						CDFx.AHUFF_COMPRESSION, $
						aHuffParms, $
		   CDFiif.CLOSE_, CDFiix.CDF_, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'20')) then return

  status = CDFlib (CDFiif.OPEN_, CDFiix.CDF_, cdfname, id, $
		   CDFiif.GET_, CDFiix.CDF_COMPRESSION_, cType, cParms, cPct, $
		   CDFiif.CLOSE_, CDFiix.CDF_, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'21')) then return
  if (cType ne CDFx.AHUFF_COMPRESSION or $
      cParms(0) ne CDFx.OPTIMAL_ENCODING_TREES) then begin
    print, "Verification error <4>."
    return
  endif

  status = CDFlib (CDFiif.GET_, CDFiix.CDF_INFO_, cdfname, cType, $
						  cParms, cSize, uSize, $
		   CDFiif.NULL_)
  if (BadStatus(status,0,'22')) then return
  if (cType ne CDFx.AHUFF_COMPRESSION or $
      cParms(0) ne CDFx.OPTIMAL_ENCODING_TREES) then begin
    print, "Verification error <5>."
    return
  endif

  ;----------------------------------------------------------------------------
  ; Display `success' message and exit.
  ;----------------------------------------------------------------------------

  print, "Test successful."
  return
end
