;------------------------------------------------------------------------------
;
;  NSSDC/CDF			Quick-Start Test for IDL I/F (EPOCH utilities).
;
;  Version 1.2, 10-Sep-96, Hughes STX.
;
;  Modification history:
;
;   V1.0   7-Nov-94, J Love	Original version.
;   V1.1   2-Feb-95, J Love	Fixed day fraction.
;   V1.1a 26-Jun-95, J Love	IDL 4.0.
;   V1.2  10-Sep-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; qstep.
;------------------------------------------------------------------------------

pro qstep

epS0true = '31-Oct-1994 12:00:00.000'
epS1true = '19941031.5000000'
epS2true = '19941031120000'
epS3true = '1994-10-31T12:00:00.000Z'

ep = parseEPOCH (epS0true)

EPOCHbreakdown, ep, year, month, day, hour, minute, second, msecond
if (year ne 1994) then begin
  print, 'Verification error <1.1>'
  return
endif
if (month ne 10) then begin
  print, 'Verification error <1.2>'
  return
endif
if (day ne 31) then begin
  print, 'Verification error <1.3>'
  return
endif
if (hour ne 12) then begin
  print, 'Verification error <1.4>'
  return
endif
if (minute ne 0) then begin
  print, 'Verification error <1.5>'
  return
endif
if (second ne 0) then begin
  print, 'Verification error <1.6>'
  return
endif
if (msecond ne 0) then begin
  print, 'Verification error <1.7>'
  return
endif

epx = computeEPOCH (year, month, day, hour, minute, second, msecond)
if (epx ne ep) then begin
  print, 'Verification error <2>'
  return
endif

encodeEPOCH, ep, epS0
if (epS0 ne epS0true) then begin
  print, 'Verification error <3>'
  return
endif

encodeEPOCH1, ep, epS1
if (epS1 ne epS1true) then begin
  print, 'Verification error <4>'
  return
endif

encodeEPOCH2, ep, epS2
if (epS2 ne epS2true) then begin
  print, 'Verification error <5>'
  return
endif

encodeEPOCH3, ep, epS3
if (epS3 ne epS3true) then begin
  print, 'Verification error <3>'
  return
endif

epx = parseEPOCH1 (epS1)
if (epx ne ep) then begin
  print, 'Verification error <2>'
  return
endif

epx = parseEPOCH2 (epS2)
if (epx ne ep) then begin
  print, 'Verification error <2>'
  return
endif

epx = parseEPOCH3 (epS3)
if (epx ne ep) then begin
  print, 'Verification error <2>'
  return
endif

print, 'Test successful.'
end
