;------------------------------------------------------------------------------
;
;  NSSDC/CDF					 IDL/CDF Interface, CDFvarPut.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-Sep-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarPut.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarPut
;
; PURPOSE:
;       `CDFvarPut' is used to write a single value to an rVariable.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarPut (id, varNum, recNum, dimIndices, value)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varNum:         LONG.  The number of the rVariable.
;       recNum:         LONG.  The record number at which to write the value.
;                       Record numbers begin at zero (0).
;       dimIndices:     LONG array.  The dimension indices at which to write
;                       the value.  Indices begin at zero (0).
;       value:          DATA TYPE DEPENDENT.  The value to be written.  The
;                       IDL data type of this IDL variable should correspond
;                       to the CDF data type of the rVariable.
;
;       All input variables must have been created/initialized before calling
;       `CDFvarGet'.
;
; OUTPUTS:
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarPut'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> indices = lonarr(2)
;       IDL> indices(0) = 5
;       IDL> indices(1) = 10
;       IDL> recNum = 4L
;       IDL> value = 6.7
;       IDL> status = CDFvarPut (id, CDFvarNum(id,'Flux'), recNum, indices, $
;                                value)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarPut failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-Sep-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarPut, CDF_id,var_num,record_num,indices,value
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfvarput, cdfid_, cdfstatus_, status, $
	       CDF_id, var_num, record_num, indices, value
return, status
end
